/**
 * Copyright (C) <year> <copyright holders>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 **/
package com.gerantech.extensions.iab
{
import com.gerantech.extensions.iab.events.IabEvent;

import flash.events.EventDispatcher;
import flash.events.StatusEvent;
import flash.external.ExtensionContext;
import flash.system.Capabilities;

/**
 *  
 * @author Mansour Djawadi
 */	
	
public class Iab extends EventDispatcher
{
//----------------------------------------
//
// Constants
//
//----------------------------------------
	// Billing response codes
	public static const BILLING_RESPONSE_RESULT_OK:int = 0;
	public static const BILLING_RESPONSE_RESULT_USER_CANCELED:int = 1;
	public static const BILLING_RESPONSE_RESULT_BILLING_UNAVAILABLE:int = 3;
	public static const BILLING_RESPONSE_RESULT_ITEM_UNAVAILABLE:int = 4;
	public static const BILLING_RESPONSE_RESULT_DEVELOPER_ERROR:int = 5;
	public static const BILLING_RESPONSE_RESULT_ERROR:int = 6;
	public static const BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED:int = 7;
	public static const BILLING_RESPONSE_RESULT_ITEM_NOT_OWNED:int = 8;
	
	// IAB Helper error codes
	public static const IABHELPER_ERROR_BASE:int = -1000;
	public static const IABHELPER_REMOTE_EXCEPTION:int = -1001;
	public static const IABHELPER_BAD_RESPONSE:int = -1002;
	public static const IABHELPER_VERIFICATION_FAILED:int = -1003;
	public static const IABHELPER_SEND_INTENT_FAILED:int = -1004;
	public static const IABHELPER_USER_CANCELLED:int = -1005;
	public static const IABHELPER_UNKNOWN_PURCHASE_RESPONSE:int = -1006;
	public static const IABHELPER_MISSING_TOKEN:int = -1007;
	public static const IABHELPER_UNKNOWN_ERROR:int = -1008;
	public static const IABHELPER_SUBSCRIPTIONS_NOT_AVAILABLE:int = -1009;
	public static const IABHELPER_INVALID_CONSUMPTION:int = -1010;
	public static const IABHELPER_NOT_INITIALIZED:int = -1011;
	public static const IABHELPER_NOT_SUPPORTED:int = -1012;
	
	// Keys for the responses from InAppBillingService
	public static const RESPONSE_CODE:String = "RESPONSE_CODE";
	public static const RESPONSE_GET_SKU_DETAILS_LIST:String = "DETAILS_LIST";
	public static const RESPONSE_BUY_INTENT:String = "BUY_INTENT";
	public static const RESPONSE_INAPP_PURCHASE_DATA:String = "INAPP_PURCHASE_DATA";
	public static const RESPONSE_INAPP_SIGNATURE:String = "INAPP_DATA_SIGNATURE";
	public static const RESPONSE_INAPP_ITEM_LIST:String = "INAPP_PURCHASE_ITEM_LIST";
	public static const RESPONSE_INAPP_PURCHASE_DATA_LIST:String = "INAPP_PURCHASE_DATA_LIST";
	public static const RESPONSE_INAPP_SIGNATURE_LIST:String = "INAPP_DATA_SIGNATURE_LIST";
	public static const INAPP_CONTINUATION_TOKEN:String = "INAPP_CONTINUATION_TOKEN";
	
	// Item types
	public static const ITEM_TYPE_INAPP:String = "inapp";
	public static const ITEM_TYPE_SUBS:String = "subs";
	
	// some fields on the getSkuDetails response bundle
	public static const GET_SKU_DETAILS_ITEM_LIST:String = "ITEM_ID_LIST";
	public static const GET_SKU_DETAILS_ITEM_TYPE_LIST:String = "ITEM_TYPE_LIST";


//----------------------------------------
//
// Variables
//
//----------------------------------------
private static var _instance:Iab;
private var extContext:ExtensionContext;

//----------------------------------------
//
// Properties
//
//----------------------------------------



//----------------------------------------
//
// Constructor
//
//----------------------------------------

/**
 * Constructor. 
 */		
public function Iab( enforcer:SingletonEnforcer )
{
	super();
	extContext = ExtensionContext.createExtensionContext( "com.gerantech.extensions.iabilling", "" );
	
	if ( !extContext )
		throw new Error( "'com.gerantech.extensions.iabilling' not found or is not supported on this platform." );
	extContext.addEventListener( StatusEvent.STATUS, onStatus );
}

public static function get instance():Iab 
{
	if ( !_instance )
		_instance = new Iab( new SingletonEnforcer() );
	return _instance;
}

//----------------------------------------
//
// Public Methods
//
//----------------------------------------

public function startSetup(base64EncodedPublicKey:String, bindURL:String, packageURL:String, debugLogging:Boolean = false):void 
{
	if( !isAndroid(IabEvent.SETUP_FINISHED) )
		return;
	extContext.call("iab", "startSetup", base64EncodedPublicKey, bindURL, packageURL, debugLogging);
}
public function queryInventory():void 
{
	if( !isAndroid(IabEvent.QUERY_INVENTORY_FINISHED) )
		return;
	extContext.call("iab", "queryInventory");
}
public function purchase(sku:String, type:String = "inapp", payload:String = ""):void 
{
	if( !isAndroid(IabEvent.PURCHASE_FINISHED) )
		return;
	extContext.call("iab", "purchase", sku, type, payload);
}
public function consume(sku:String):void 
{
	if( !isAndroid(IabEvent.CONSUME_FINISHED) )
		return;
	extContext.call("iab", "consume", sku);
}
public function getPurchase(sku:String):Purchase 
{
	if( isAndroid(IabEvent.QUERY_INVENTORY_FINISHED) )
	{
		var ret:Object = extContext.call("iab", "getPurchase", sku);
		if( ret != null )
			return new Purchase( ret as String );
	}
	return null;
}
public function getSkuDetails(sku:String):SkuDetails 
{
	if( isAndroid(IabEvent.QUERY_INVENTORY_FINISHED) )
	{
		var ret:Object = extContext.call("iab", "getSkuDetails", sku);
		if( ret != null )
			return new SkuDetails( ret as String );
	}
	return null;
}


//----------------------------------------
//
// Handlers
//
//----------------------------------------

private function onStatus( event:StatusEvent ):void 
{
	trace(event.code, event.level);
	dispatchEvent( new IabEvent( event.code, getResult(event.level)));
}

private function getResult(level:String):IabResult
{
	var res:IabResult = new IabResult(0);
	res.setJson(level);
	return res;
}



private function isAndroid(eventType:String):Boolean
{
	var ret:Boolean = Capabilities.os.substr(0,5)=="Linux";
	if( !ret )
		this.dispatchEvent(new IabEvent(eventType, new IabResult(IABHELPER_NOT_SUPPORTED, "Iab only works in android platform.")));
	return ret;
}

/**
 * Cleans up the instance of the native extension. 
 */		
public function dispose():void
{ 
	if(!isAndroid)
		return;
	extContext.dispose(); 
}
}
}
class SingletonEnforcer
{
}