/*
 * Decompiled with CFR 0.152.
 */
package com.gerantech.extensions.util;

import com.gerantech.extensions.util.IabHelper;

public class IabResult {
    int mResponse;
    String mMessage;
    String mData;

    public IabResult(int response, String message) {
        this(response, message, null);
    }

    public IabResult(int response, String message, String data) {
        this.mResponse = response;
        this.mData = data;
        this.mMessage = message == null || message.trim().length() == 0 ? IabHelper.getResponseDesc(response) : String.valueOf(message) + " (response: " + IabHelper.getResponseDesc(response) + ")";
    }

    public int getResponse() {
        return this.mResponse;
    }

    public void setData(String data) {
        this.mData = data;
    }

    public String getData() {
        return this.mData;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public boolean isSuccess() {
        return this.mResponse == 0;
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public String toString() {
        return "IabResult: " + this.getMessage();
    }

    public String toJsonString() {
        return "{\"response\":" + this.mResponse + ", \"data\":" + this.mData + ", \"message\":\"" + this.mMessage + "\"}";
    }
}

