/*
 * Decompiled with CFR 0.152.
 */
package com.gerantech.extensions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.gerantech.extensions.IabActivity;
import com.gerantech.extensions.IabExtensionContext;
import com.gerantech.extensions.util.IabHelper;
import com.gerantech.extensions.util.IabResult;
import com.gerantech.extensions.util.Inventory;
import com.gerantech.extensions.util.Purchase;
import com.gerantech.extensions.util.SkuDetails;
import org.json.JSONException;

public class Iab {
    static final int RC_REQUEST = 10001;
    public static final String TAG = "IAB";
    public IabExtensionContext aeContext;
    public Inventory inventory;
    protected static Iab _instance = null;
    private Activity purchaseActivity;
    private IabHelper mHelper;
    IabHelper.QueryInventoryFinishedListener mGotInventoryListener = new IabHelper.QueryInventoryFinishedListener(){

        @Override
        public void onQueryInventoryFinished(IabResult result, Inventory inventory) {
            if (!Iab.this.isSetup("queryInventoryFinished")) {
                return;
            }
            Iab.getInstance().inventory = inventory;
            Iab.this.dispatchResult("queryInventoryFinished", result);
        }
    };
    IabHelper.OnIabPurchaseFinishedListener mPurchaseFinishedListener = new IabHelper.OnIabPurchaseFinishedListener(){

        @Override
        public void onIabPurchaseFinished(IabResult result, Purchase purchase) {
            Log.d((String)Iab.TAG, (String)("Purchase finished: " + result + ", purchase: " + purchase));
            if (!Iab.this.isSetup("purchaseFinished")) {
                return;
            }
            if (result.isSuccess()) {
                result.setData(purchase.getOriginalJson());
                Iab.getInstance().inventory.addPurchase(purchase);
                if (!Iab.getInstance().inventory.hasDetails(purchase.getSku())) {
                    String jsonSkuDetails = "{\"productId\":\"" + purchase.getSku() + "\", \"type\":\"" + purchase.getItemType() + "\"";
                    jsonSkuDetails = String.valueOf(jsonSkuDetails) + ", \"title\":\"no title\"";
                    jsonSkuDetails = String.valueOf(jsonSkuDetails) + ", \"description\":\"no description\"";
                    jsonSkuDetails = String.valueOf(jsonSkuDetails) + ", \"price\":0}";
                    Log.i((String)Iab.TAG, (String)(String.valueOf(result.isSuccess()) + " jsonSkuDetails: " + jsonSkuDetails));
                    try {
                        Iab.getInstance().inventory.addSkuDetails(new SkuDetails(purchase.getItemType(), jsonSkuDetails));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (Iab.getInstance().purchaseActivity != null) {
                Iab.getInstance().purchaseActivity.finish();
            }
            Iab.this.dispatchResult("purchaseFinished", result);
        }
    };
    IabHelper.OnConsumeFinishedListener mConsumeFinishedListener = new IabHelper.OnConsumeFinishedListener(){

        @Override
        public void onConsumeFinished(Purchase purchase, IabResult result) {
            Log.d((String)Iab.TAG, (String)("Consumption finished. Purchase: " + purchase + ", result: " + result));
            if (!Iab.this.isSetup("consumeFinished")) {
                return;
            }
            result.setData(purchase.getOriginalJson());
            Iab.this.dispatchResult("consumeFinished", result);
        }
    };

    public void startSetup(String base64EncodedPublicKey, String bindURL, String packageURL, Boolean debugLogging) {
        if (base64EncodedPublicKey.contains("CONSTRUCT_YOUR")) {
            this.dispatchResult("setupFinished", new IabResult(5, "Please put your app's public key in MainActivity.java. See README."));
        }
        if (this.aeContext.getActivity().getPackageName().startsWith("com.example")) {
            this.dispatchResult("setupFinished", new IabResult(5, "Please change the sample's package name! See README."));
        }
        Log.d((String)TAG, (String)"Creating IAB helper.");
        this.mHelper = new IabHelper(this.aeContext.getActivity().getApplicationContext(), base64EncodedPublicKey, bindURL, packageURL);
        this.mHelper.enableDebugLogging(debugLogging);
        this.mHelper.startSetup(new IabHelper.OnIabSetupFinishedListener(){

            @Override
            public void onIabSetupFinished(IabResult result) {
                Iab.this.dispatchResult("setupFinished", result);
            }
        });
    }

    public void queryInventory() {
        if (!this.isSetup("queryInventoryFinished")) {
            return;
        }
        this.mHelper.queryInventoryAsync(this.mGotInventoryListener);
    }

    public void launchPurchaseFlow(String sku, String itemType, String payload) {
        if (!this.isSetup("purchaseFinished")) {
            return;
        }
        if (this.inventory == null) {
            this.dispatchResult("purchaseFinished", new IabResult(-1011, "inventory not found. please run 'queryInventory' method."));
            return;
        }
        Intent intent = new Intent((Context)Iab.getInstance().aeContext.getActivity(), IabActivity.class);
        Bundle mBundle = new Bundle();
        mBundle.putString("sku", sku);
        mBundle.putString("itemType", itemType);
        mBundle.putString("payload", payload);
        intent.putExtras(mBundle);
        Iab.getInstance().aeContext.getActivity().startActivity(intent);
    }

    public boolean handlePurchaseResult(int requestCode, int resultCode, Intent data) {
        return this.mHelper.handleActivityResult(requestCode, resultCode, data);
    }

    public void purchase(Activity activity, String sku, String itemType, String payload) {
        this.purchaseActivity = activity;
        this.mHelper.launchPurchaseFlow(activity, sku, itemType, 10001, this.mPurchaseFinishedListener, payload);
    }

    public void endPurchase(Activity act) {
    }

    public void consume(String sku) {
        if (!this.isSetup("consumeFinished")) {
            return;
        }
        if (this.inventory == null) {
            this.dispatchResult("consumeFinished", new IabResult(-1010, "inventory not found. please run 'queryInventory' method."));
            return;
        }
        Purchase purchase = this.inventory.getPurchase(sku);
        if (purchase == null) {
            this.dispatchResult("consumeFinished", new IabResult(-1010, "purchase not found."));
            return;
        }
        this.mHelper.consumeAsync(purchase, this.mConsumeFinishedListener);
    }

    private void dispatchResult(String type, IabResult result) {
        Log.d((String)TAG, (String)(String.valueOf(type) + "=> result: " + result));
        Iab.getInstance().aeContext.dispatchStatusEventAsync(type, result.toJsonString());
    }

    private boolean isSetup(String status) {
        if (this.mHelper == null) {
            Iab.getInstance().aeContext.dispatchStatusEventAsync(status, new IabResult(-1011, "in-app billing is not setup yet.").toJsonString());
            return false;
        }
        return true;
    }

    public static Iab getInstance() {
        if (_instance == null) {
            _instance = new Iab();
        }
        return _instance;
    }
}

