# Online Auction System

This project focuses on the design and implementation of a comprehensive database schema for managing users, items, bids, auctions, and transactions in an online auction environment. 🎉

## Project Overview

The Online Auction System is designed to facilitate seamless interactions between buyers, sellers, and admins through a well-structured database schema. Key features include:

- **User Management**: Centralized user profile management with details such as unique User_ID, Username, Password, Email, Address, preferred payment methods, and transaction history.
- **Item Management**: Detailed tracking of auction items with attributes like Item_ID, Seller_ID, Item_Name, Description, Starting_Price, Auction_End_Time, item condition, category, and images.
- **Bid Tracking**: Real-time bid tracking with unique Bid_ID, Bidder_ID, Item_ID, Bid_Amount, Bid_Time, bid status, and bid increment.
- **Auction Management**: Comprehensive auction tracking with Auction_ID, Item_ID, Auction_Start_Time, Auction_End_Time, auction status, and reserve price.
- **Transaction Recording**: Management of completed transactions with Transaction_ID, Buyer_ID, Seller_ID, Item_ID, Transaction_Amount, Transaction_Time, payment method, and transaction status.

## Tech Stack

This project leverages a variety of technologies to deliver a robust online auction system:

- **Frontend**:
  - **React.js**: For building the user interface and enhancing user experience.
  - **Tailwind-CSS**: For styling and responsive design.

- **Backend**:
  - **Node.js**: Server-side JavaScript runtime environment for building scalable network applications.
  - **Express.js**: Web application framework for Node.js to handle HTTP requests and routing.

- **Database**:
  - **PostgreSQL**: Relational SQL database management system for storing and managing data related to users, items, bids, auctions, and transactions.

- **Data Visualization**:
  - **Power BI**: For visualizing and analyzing data in real-time with interactive reports and dashboards.

- **Development Tools**:
  - **Git**: Version control system for tracking changes in source code.

## Features

- **User Profiles**: Manage and view user profiles with complete transaction history.
- **Item Listings**: View and list items for auction with detailed information.
- **Real-Time Bidding**: Track and place bids in real-time.
- **Auction Management**: Start and manage auctions with reserve prices and status updates.
- **Transaction Processing**: Record and manage transactions post-auction.

## Documentation & Setup

- For the setup instructions, please refer to the [Setup Guide](./SETUP.md).
- For contributing guidelines, please see the [Contributing Guide](./CONTRIBUTING.md).

## Demo & Documentation

Check out the following resources to better understand the project:

- **[Demo Video](https://github.com/user-attachments/assets/b93b3b77-e1bc-4d35-8c14-638d192a6f94)**: A video demonstration of the Online Auction System in action.

https://github.com/user-attachments/assets/b93b3b77-e1bc-4d35-8c14-638d192a6f94

- **[PowerPoint Presentation](https://github.com/user-attachments/files/16395925/MiniProject_PPT_Online.Auction.System_Final_.pdf)**: A presentation outlining the project details and architecture.

- **[Project Report](https://github.com/user-attachments/files/16395875/PROJECT.REPORT_FINAL.pdf)**: Comprehensive report detailing the project implementation and findings.
