#!/bin/bash

#    This file is part of PenTestKit
#    Copyright (C) 2017-2024 @maldevel
#    https://github.com/maldevel/PenTestKit
#
#    PenTestKit - Useful tools for Penetration Testing.
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    For more see the file 'LICENSE' for copying permission.


if [ $# -eq 2 ]; then
	LOGNAME="ffuf_$1"
  	LOGNAME=$(echo "$LOGNAME" | sed -r 's/[/]+/_/g' | sed -r 's/[.]+/_/g' | sed -r 's/[:]+//g')
  	LOGNAME="$LOGNAME.html"
 	ffuf -w /usr/share/seclists/Discovery/Web-Content/big.txt -H "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:121.0) Gecko/20100101 Firefox/121.0" -u $1/FUZZ -r -fc 404 -fr $2 -c -of html -o $LOGNAME
else
    echo "Please provide the target URL and the page string to ignore."
fi
