#!/bin/bash

#    This file is part of PenTestKit
#    Copyright (C) 2017-2024 @maldevel
#    https://github.com/maldevel/PenTestKit
#
#    PenTestKit - Useful tools for Penetration Testing.
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    For more see the file 'LICENSE' for copying permission.


if [[ $EUID -ne 0 ]]; then
  echo "Please run this script as root." 1>&2
  exit 1
fi

if [ $# -eq 5 ]; then
  # Suggested to start with a max rate of 60, max retries of 3, scan delay of 1s and host timeout 60m.
  nmap -sU -n -Pn -vv --max-rate $1 --max-retries $2 --scan-delay $3 --host-timeout $4 --top-ports 1000 --reason --open -oA udp_ports_top1000_$5 $5
else
  echo "Please provide the max rate, max retries, scan delay, host timeout and the target IP address or an IP range."
fi
