#!/bin/bash

#    This file is part of PenTestKit
#    Copyright (C) 2017-2024 @maldevel
#    https://github.com/maldevel/PenTestKit
#
#    PenTestKit - Useful tools for Penetration Testing.
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    For more see the file 'LICENSE' for copying permission.


if [[ $EUID -ne 0 ]]; then
  echo "For better results, please run this script as root." 1>&2
  exit 1
fi

if [ $# -eq 1 ]; then
  LOGNAME="tcp_livehosts_known_internet_ports_$1"
  LOGNAME=$(echo "$LOGNAME" | sed -r 's/[/]+/_/g' | sed -r 's/[.]+/_/g')
  LOGNAME2="$LOGNAME.txt"
  nmap -vv -n -Pn -sS --reason --open -T4 -p20,21,22,23,25,53,67,68,69,80,88,110,119,123,135,137,138,139,143,161,162,179,194,263,389,443,445,465,500,514,541,587,902,993,995,1433,1434,1521,1700,1701,1723,1900,1935,2077,2078,2082,2083,2086,2087,2089,2091,2095,2096,3268,3306,3389,3478,3479,4353,4444,5000,5060,5061,5432,8080,8443,8447,8880,18191,18192,18210,27017 -oA $LOGNAME $1 | grep -w 'report' | grep -v 'host down' | sed 's/Nmap scan report for //' | sort -u -n -t . -k 1,1 -k 2,2 -k 3,3 -k 4,4 | tee $LOGNAME2
else
    echo "Please provide the target IP range."
fi
