#!/bin/bash

#    This file is part of PenTestKit
#    Copyright (C) 2017-2021 @maldevel
#    https://github.com/maldevel/PenTestKit
#
#    PenTestKit - Useful tools for Penetration Testing.
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    For more see the file 'LICENSE' for copying permission.


if [ $# -eq 2 ]; then

  echo "#!/bin/bash"
  echo

  echo "if [[ \$EUID -ne 0 ]]; then"
  echo "'Please run this script as root.' 1>&2"
  echo "exit 1"
  echo "fi"
  echo

  cat $1/*.gnmap|grep "Ports:"| while read -r line ; do
    host=`echo "$line"|cut -d$'\t' -f1|cut -d' ' -f2`
    ports=`echo "$line"|cut -d$'\t' -f2|sed 's/Ports: //'`

  IFS=","
  space=","
  hostports=""

  for port in $ports; do
    openport=$(expr match "$port" '\(.*\(open\|open|filtered\)/\(tcp\|udp\).*\)')
    if [ -n "$openport" ]; then
      hostports=$hostports$(echo $openport|sed 's|/| |g'|sed -n -e 's/open.*//p'|sed 's/ *//g')$space
    fi
  done

    if [ -n "$hostports" ]; then
      echo "nmap -sS -vv -n -A --osscan-guess --version-all -Pn -T4 -p$hostports$2 -oA tcp_services_$host $host &"
    fi
  done
  echo "wait"
  echo

else
  echo "Please provide a directory path and a random closed port for all hosts."
fi
