#! python

#    This file is part of PenTestKit
#    Copyright (C) 2017-2023 @maldevel
#    https://github.com/maldevel/PenTestKit
#
#    PenTestKit - Useful tools for Penetration Testing.
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    For more see the file 'LICENSE' for copying permission.

import argparse
import sys
import os
import ipaddress 
import requests

################################################################################################

def validate_ip_network(address):
    try:
        ip = ipaddress.ip_network(address)
        return True
    except ValueError:
        return False

def get_ip_network_hosts(address):
	try:
		hostsList = list(ipaddress.ip_network(address).hosts())
		return hostsList
	except ValueError:
		return False

################################################################################################

parser = argparse.ArgumentParser('Extract country origin from a list of subnets.')
parser.add_argument('-l', '--list', help="Subnets list. Please place each subnet in a new line.")
args = parser.parse_args()


if args.list is None:
	sys.exit("Please provide a text file containing a list of subnets. Please place each subnet in a new line.")

if not os.path.isfile(args.list):
	sys.exit("Please provide an existing text file.")

################################################################################################

with open(args.list, newline='') as listfile:
	subnets = listfile.readlines()
	for subnet in subnets:
		sub_net = subnet.strip()
		if validate_ip_network(sub_net):
			hosts = get_ip_network_hosts(sub_net)
			print("Subnet: {}.".format(sub_net))
			print("Hosts: from {} to {}.".format(hosts[0], hosts[-1]))

			requestUrl = "https://get.geojs.io/v1/ip/country/{}.json".format(hosts[0])
			r = requests.get(requestUrl, headers={'Accept': 'application/json'})
			print(f"Country: {r.json()['country']}")

			print()

################################################################################################

