#!/bin/bash

#    This file is part of PenTestKit
#    Copyright (C) 2017-2023 @maldevel @servomekanism
#    https://github.com/maldevel/PenTestKit
#
#    PenTestKit - Useful tools for Penetration Testing.
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    For more see the file 'LICENSE' for copying permission.
# 
#    Assuming default password policy AD rules (7 or more chars, one 
#    uppercase, one number), we can use the following script and extract
#    such passwords from the rockyou and create a new list

file="/tmp/test/rockyou.txt"
while IFS= read -r s
do
    if [[ ${#s} -ge 7 && "$s" == *[A-Z]* && "$s" == *[a-z]* && "$s" == *[0-9]* ]]; then
        echo $s >> new-password-list.txt
    fi
done < "$file"
