# space-as-scale

repository for evolving the concept of space as scale, instead of as distance

## Space as Distance is the Wrong Abstraction

The concept of space evolved through millennia of `construction` and `movement`.

To do construction work, we measure:

- the `distance` between objects or points
- the `area` of a surface
- the `size`, or `volume`, of an object
- the `height` of an object, point or surface
- lengths and heights involved in pivot devices
- strength of rope based on area of cross-section
- etc

The need to understand physical bodies in `motion`, both celestial and earthly, led to concepts like:

- speed
- acceleration
- force
- pressure
- kinetic and potential energy
- power
  
all require measuring distance in a varying number of dimensions in space.

Newton started with that space as a given, as the absolute medium through which everything exists and happens: `an arena we measure as distance`.

Therefore, Classical Physics built its structure of laws and rules around a space which consists of measured, or measurable, distances, through which forces act, and energies are exchanged.

However, that space does `nothing`. It's just there as something `we` measure. It's `inert`. It doesn't **`do`** anything. This explains why forces were introduced to `act` in that space, imparting energy, and effecting change -- i.e. `causation`.

But ...

There is a causal exchange between `big` and `small` that is not captured by measurement of normal linear distance, but by measuring the `scale` distance between them, i.e. their `relative` size. Across a wide range of phenomena, from super galaxy clusters and planetary nebulae, to plant and animal organ shapes and growth patterns, to DNA molecules and atomic orbitals: there looks to be quite a thread between environment and constituent part. The larger engulfing and enfolding the smaller. Each shaping the other beneath and above in the hierarchy.

The questions I have are about:

- How do the small and the large interact and exchange causation?
- What does such an interaction look like?
- What characteristics does it have?
- How can it be described?
- How do we study this kind of interaction?
- How do we study a hierarchy in Physics?

If our questions are not about construction and motion, but about `growth` and `contraction`, we should not have to contend with that same concept of space -- i.e. that which is measured in linear distance: **`it would be the wrong abstraction`**.

If we build a Physics from a space that mediates causation between large and small -- i.e. describes how things at different scales grow, relate, and change together:

- what dynamics do we arrive at?
- what would that dynamics be capable of describing?
- what concepts would we find, parallel to speed, acceleration, force, pressure, energy and power?
- what would they mean?
- what other unknowns, in addition to the ones above, would we find?

We can start by drawing that space, and annotating it with what we know:

![alt text][scale-01]

[scale-01]: ./images/scale-02.png "scale and relative distance - base 2 and 10"

<div style="text-align: center; margin: -25px 0px 25px">fig (1) - scale and relative distance</div>

where a unit step in Scale in the positive direction corresponds to multiplying the associated dimension (here distance) with the base value (i.e. becoming exponentially larger). A unit step in the negative direction corresponds to dividing the value by the base (i.e. becoming exponentially smaller).

fig (1) shows:

![alt text][scale-02]

[scale-02]: ./images/distance-base-^s.png "scale and relative distance - base 2 and 10"

where `s` is the scale value.

If I want to describe an object in this space, I describe its hierarchic structure. The object itself is always sitting at point 0, surrounded by its immediate scale neighborhood: the larger environment immediately surrounding it, and its smaller components.

The idea here is that any time an observer wants to describe something, they adjust the scale so what they're describing is at point 0 (size 1 no matter what base is used).

In other words: our description centers the scale around its descriptor. For example, describing a house starts where the house is (its larger environment, the street, the neighborhood, etc), its rooms, and their contents (its smaller and smaller dimensions).

At this point we may find Alice's pills to be quite handy:

```one pill makes you larger, and one pill makes you small```

.. and here is the kicker:

```and the ones that mother gives you, don't do anything at all```

Actually, those pills may restore you to your `normal` size, since your mother is like a reference point in scale land.

So, let's recap what this means:

To describe an object, take a pill that makes you its size, and you become, together with what is being described, at point 0 in scale. Take a step to the right, and that multiplies your size by the base you chose for the dimension you're describing. A step to the left is the reverse, and you become smaller by the base value.

This insistence, that the observer describe an object from its own scale's point of view, reproduces the subjective nature of observation and description. A description is always from the point of view of a specific scale.

Now we can derive rates of change, and see what we get.