# How to Contribute #
We'd love to accept your patches and contributions to this project. We are currently in the process of defining our development roadmap and won't be actively reviewing PRs for a little while. We will update this doc once that changes, thank you for your patience!

# Style Guide #

We adhere to the [JUCE coding standards](https://juce.com/discover/stories/coding-standards) with a few deviations in favor of the [Google C++ style guide](https://google.github.io/styleguide/cppguide.html) as listed below

* [Constant Names](https://google.github.io/styleguide/cppguide.html#Constant_Names)
* [Enumerator Names](https://google.github.io/styleguide/cppguide.html#Enumerator_Names)

All new code should adhere to this guide to ensure a consistent style and make the code more readable. You can run the `format-code.sh` script to automatically format the source files with [clang-format](https://clang.llvm.org/docs/ClangFormat.html).

# Code Reviews #

All submissions, including submissions by project members, require review. We use GitHub pull requests for this purpose. Consult GitHub Help for more information on using pull requests.

# Getting Started #

If you're looking for a way to contribute, but not sure where to start, you could:

* Update the [verified builds doc](docs/verified-builds.md) if the plugins work on your machine and DAW.
* Add some documentation to an existing function.
* Add a missing test to improve coverage.
* Respond to a bug or feature request in the github issues.

# Contributor License Agreement #

Contributions to this project must be accompanied by a Contributor License Agreement. You (or your employer) retain the copyright to your contribution; this simply gives us permission to use and redistribute your contributions as part of the project. Head over to https://cla.developers.google.com/ to see your current agreements on file or to sign a new one.

You generally only need to submit a CLA once, so if you've already submitted one (even if it was for a different project), you probably don't need to do it again.

# Community Guidelines #

This project follows Google's Open Source Community Guidelines.