// This file was automatically @generated by gentypescript

type apiSchemaCollection = {
  "GET /api/ping": {
    Query: undefined
    Request: undefined
    Response: {
      message: string;
    } | { error: { message: string } }
  };
  "GET /api/tasks": {
    Query: undefined
    Request: undefined
    Response: {
      tasks: {
        id: string;
        name: string;
        description: string;
        status: string;
        created_at: string;
      }[];
    } | { error: { message: string } }
  };
  "POST /api/tasks": {
    Query: undefined
    Request: {
      task: {
        name: string;
        description?: string;
      };
    }
    Response: {
      task: {
        id: string;
        name: string;
        description: string;
        status: string;
        created_at: string;
      };
    } | { error: { message: string } }
  };
  "GET /api/tasks/{id}": {
    Query: undefined
    Request: undefined
    Response: {
      task: {
        id: string;
        name: string;
        description: string;
        status: string;
        created_at: string;
      };
    } | { error: { message: string } }
  };
  "PUT /api/tasks/{id}": {
    Query: undefined
    Request: {
      task?: {
        name?: string;
        description?: string;
        status?: string;
      };
    }
    Response: {
      task: {
        id: string;
        name: string;
        description: string;
        status: string;
        created_at: string;
      };
    } | { error: { message: string } }
  };
  "DELETE /api/tasks/{id}": {
    Query: undefined
    Request: undefined
    Response: {
      status: string;
    } | { error: { message: string } }
  };
}

export const isErrorResponse = (response: unknown): response is { error: { message: string } } => {
  return !!((response as { error: unknown })?.error)
}

type method = keyof apiSchemaCollection extends `${infer M} ${string}` ? M : never;
type methodPathsByMethod<M extends method> = Extract<keyof apiSchemaCollection, `${M} ${string}`>
type pathByMethod<MP extends string> = MP extends `${method} ${infer P}` ? P : never
type pathsByMethod<M extends method> = pathByMethod<methodPathsByMethod<M>>

const hasApiRequest = <PM extends keyof apiSchemaCollection>(args: unknown): args is { data: apiSchemaCollection[PM]["Request"] } => {
  return !!(args as { data: unknown })?.data
}

const hasApiQuery = <PM extends keyof apiSchemaCollection>(args: unknown): args is { query: apiSchemaCollection[PM]["Query"] } => {
  return !!(args as { query: unknown })?.query
}
const apiPathBuilder = {
    "/api/tasks/{id}": (args: {id: string}) => `/api/tasks/${args.id}`,
} as const

const hasApiPathBuilder = (path: string): path is keyof typeof apiPathBuilder => path in apiPathBuilder
type apiPathBuilderArgs<K extends keyof apiSchemaCollection> = K extends `${method} ${infer P}` ? (P extends keyof typeof apiPathBuilder ? Parameters<typeof apiPathBuilder[P]>[0] : never) : never

const hasApiPathArgs = <PM extends keyof apiSchemaCollection>(args: unknown): args is { pathArgs: apiPathBuilderArgs<PM> } => {
  return !!(args as { pathArgs: unknown })?.pathArgs
}

type pathCallArgs<PM extends keyof apiSchemaCollection> =
  apiSchemaCollection[PM]["Request"] extends undefined
    ? // if Request is undefined
      apiSchemaCollection[PM]["Query"] extends undefined
      ? // if Query is undefined
        apiPathBuilderArgs<PM> extends never
        ? Record<string, never>
        : { pathArgs: apiPathBuilderArgs<PM> }
      : // if Query is defined
        apiPathBuilderArgs<PM> extends never
        ? { query: apiSchemaCollection[PM]["Query"] }
        : {
            query: apiSchemaCollection[PM]["Query"];
            pathArgs: apiPathBuilderArgs<PM>;
          }
    : // if Request is defined
      apiSchemaCollection[PM]["Query"] extends undefined
      ? // if Query is undefined
        apiPathBuilderArgs<PM> extends never
        ? { data: apiSchemaCollection[PM]["Request"] }
        : {
            data: apiSchemaCollection[PM]["Request"];
            pathArgs: apiPathBuilderArgs<PM>;
          }
      : // if Query is defined
        apiPathBuilderArgs<PM> extends never
        ? {
            data: apiSchemaCollection[PM]["Request"];
            query: apiSchemaCollection[PM]["Query"];
          }
        : {
            data: apiSchemaCollection[PM]["Request"];
            query: apiSchemaCollection[PM]["Query"];
            pathArgs: apiPathBuilderArgs<PM>;
          };

type client = {
  get: <P extends pathsByMethod<"GET">>(path: P, args: pathCallArgs<`GET ${P}`>) => Promise<apiSchemaCollection[`GET ${P}`]["Response"]>
  post: <P extends pathsByMethod<"POST">>(path: P, args: pathCallArgs<`POST ${P}`>) => Promise<apiSchemaCollection[`POST ${P}`]["Response"]>
  put: <P extends pathsByMethod<"PUT">>(path: P, args: pathCallArgs<`PUT ${P}`>) => Promise<apiSchemaCollection[`PUT ${P}`]["Response"]>
  delete: <P extends pathsByMethod<"DELETE">>(path: P, args: pathCallArgs<`DELETE ${P}`>) => Promise<apiSchemaCollection[`DELETE ${P}`]["Response"]>
}

export const newClient = (baseURL = ""): client => {
  const fetchByPath = async <PM extends keyof apiSchemaCollection>(method: method, path: string, args: pathCallArgs<PM>) => {
    const builtPath = hasApiPathBuilder(path) && hasApiPathArgs(args) ? apiPathBuilder[path](args.pathArgs) : path
    const query = hasApiQuery(args) ? `?${new URLSearchParams(args.query).toString()}` : ""
    const body = hasApiRequest(args) ? JSON.stringify(args.data) : undefined
    const response = await fetch(baseURL + builtPath + query, {
      method,
      headers: {
        "Content-Type": "application/json",
      },
      body,
    })

    if (!response.ok) {
      throw new Error(response.statusText)
    }
    return response.json() as Promise<apiSchemaCollection[PM]["Response"]>
  }
  const get = async <P extends pathsByMethod<"GET">>(path: P, args: pathCallArgs<`GET ${P}`>) => await fetchByPath("GET", path, args)
  const post = async <P extends pathsByMethod<"POST">>(path: P, args: pathCallArgs<`POST ${P}`>) => await fetchByPath("POST", path, args)
  const put = async <P extends pathsByMethod<"PUT">>(path: P, args: pathCallArgs<`PUT ${P}`>) => await fetchByPath("PUT", path, args)
  const _delete = async <P extends pathsByMethod<"DELETE">>(path: P, args: pathCallArgs<`DELETE ${P}`>) => await fetchByPath("DELETE", path, args)

  return {
    get,
    post,
    put,
    delete: _delete,
  }
}
