﻿using System.Collections.Generic;

namespace P1ReaderApp.Tests
{
    public static class TestP1Messages
    {
        public static List<string> DSRM40Telegram { get; } = new List<string>
        {
            @"/ISk5\2MT382-1 000",
            "1-3:0.2.8(40)",
            "0-0:1.0.0(101209113020W)",
            "0-0:96.1.1(4B384547303034303436333935353037)",
            "1-0:1.8.1(123457.789*kWh)",
            "1-0:1.8.2(123458.789*kWh)",
            "1-0:2.8.1(123459.789*kWh)",
            "1-0:2.8.2(123460.789*kWh)",
            "0-0:96.14.0(0002)",
            "1-0:1.7.0(01.193*kW)",
            "1-0:2.7.0(00.001*kW)",
            "0-0:17.0.0(016.1*kW)",
            "0-0:96.3.10(1)",
            "0-0:96.7.21(00004)",
            "0-0:96.7.9(00002)",
            "1-0:99:97.0(2)(0:96.7.1 9)(101208152415W)(0000000240*s)(101208151004W)(00000000301*s)",
            "1-0:32.32.0(00002)",
            "1-0:52.32.0(00001)",
            "1-0:72:32.0(00000)",
            "1-0:32.36.0(00000)",
            "1-0:52.36.0(00003)",
            "1-0:72.36.0(00000)",
            "0-0:96.13.1(3031203631203831)",
            "0-0:96.13.0(303132333435363738393A3B3C3D3E3F303132333435363738393A3B3C3D3E3F303132333435363738393A3B",
            "3C3D3E3F303132333435363738393A3B3C3D3E3F303132333435363738393A3B3C3D3E3F)",
            "0-1:24.1.0(03)",
            "0-1:96.1.0(3232323241424344313233343536373839)",
            "0-1:24.2.1(101209110000W)(12785.123*m3)",
            "0-1:24.4.0(1)",
            "!522B"
        };

        public static List<string> ESMR50ISKRAAM550 { get; } = new List<string>
        {
            @"/ISK5\2M550T-1011",
            " ",
            "1-3:0.2.8(50)",
            "0-0:1.0.0(181106140429W)",
            "0-0:96.1.1(4530303334303036383130353136343136)",
            "1-0:1.8.1(003808.351*kWh)",
            "1-0:1.8.2(002948.827*kWh)",
            "1-0:2.8.1(001285.951*kWh)",
            "1-0:2.8.2(002876.514*kWh)",
            "0-0:96.14.0(0002)",
            "1-0:1.7.0(00.001*kW)",
            "1-0:2.7.0(00.498*kW)",
            "0-0:96.7.21(00006)",
            "0-0:96.7.9(00003)",
            "1-0:99.97.0(1)(0-0:96.7.19)(180529135630S)(0000002451*s)",
            "1-0:32.32.0(00003)",
            "1-0:52.32.0(00002)",
            "1-0:72.32.0(00002)",
            "1-0:32.36.0(00001)",
            "1-0:52.36.0(00001)",
            "1-0:72.36.0(00001)",
            "0-0:96.13.0()",
            "1-0:32.7.0(236.0*V)",
            "1-0:52.7.0(232.6*V)",
            "1-0:72.7.0(235.1*V)",
            "1-0:31.7.0(002*A)",
            "1-0:51.7.0(005*A)",
            "1-0:71.7.0(009*A)",
            "1-0:21.7.0(00.001*kW)",
            "1-0:41.7.0(00.033*kW)",
            "1-0:61.7.0(00.132*kW)",
            "1-0:22.7.0(00.676*kW)",
            "1-0:42.7.0(00.002*kW)",
            "1-0:62.7.0(00.003*kW)",
            "0-1:24.1.0(003)",
            "0-1:96.1.0(4730303339303031373030343630313137)",
            "0-1:24.2.1(181106140010W)(01569.646*m3)",
            "!1F28"
        };

        public static List<string> KaifaE0003Telegram { get; } = new List<string>
        {
            "KFM5KAIFA-METER",
            " ",
            "1-3:0.2.8(42)",
            "0-0:1.0.0(180306123056W)",
            "0-0:96.1.1(4530303033303030303032313234383133)",
            "1-0:1.8.1(004726.494*kWh)",
            "1-0:1.8.2(004844.281*kWh)",
            "1-0:2.8.1(003284.320*kWh)",
            "1-0:2.8.2(007764.691*kWh)",
            "0-0:96.14.0(0002)",
            "1-0:1.7.0(00.001*kW)",
            "1-0:2.7.0(01.869*kW)",
            "0-0:96.7.21(00013)",
            "0-0:96.7.9(00007)",
            "1-0:99.97.0(1)(0-0:96.7.19)(000101000024W)(2147483647*s)",
            "1-0:32.32.0(00000)",
            "1-0:52.32.0(00000)",
            "1-0:72.32.0(00000)",
            "1-0:32.36.0(00000)",
            "1-0:52.36.0(00000)",
            "1-0:72.36.0(00000)",
            "0-0:96.13.1()",
            "0-0:96.13.0()",
            "1-0:31.7.0(003*A)",
            "1-0:51.7.0(004*A)",
            "1-0:71.7.0(002*A)",
            "1-0:21.7.0(00.001*kW)",
            "1-0:22.7.0(00.688*kW)",
            "1-0:41.7.0(00.003*kW)",
            "1-0:42.7.0(00.778*kW)",
            "1-0:61.7.0(00.002*kW)",
            "1-0:62.7.0(00.403*kW)",
            "0-1:24.1.0(003)",
            "0-1:96.1.0(4730303136353631323033353830313133)",
            "0-1:24.2.1(180306120000W)(05359.919*m3)",
            "!A737"
        };

        public static List<string> LandisGyrE350ZCF1001FaseKleinverbruik { get; } = new List<string>
        {
            "/XMX5LGBBFG10",
            " ",
            "1-3:0.2.8(42)",
            "0-0:1.0.0(170108161107W)",
            "0-0:96.1.1(4530303331303033303031363939353135)",
            "1-0:1.8.1(002074.842*kWh)",
            "1-0:1.8.2(000881.383*kWh)",
            "1-0:2.8.1(000010.981*kWh)",
            "1-0:2.8.2(000028.031*kWh)",
            "0-0:96.14.0(0001)",
            "1-0:1.7.0(00.494*kW)",
            "1-0:2.7.0(00.001*kW)",
            "0-0:96.7.21(00004)",
            "0-0:96.7.9(00003)",
            "1-0:99.97.0(3)(0-0:96.7.19)(160315184219W)(0000000310*s)(160207164837W)(0000000981*s)(151118085623W)(0000502496*s)",
            "1-0:32.32.0(00000)",
            "1-0:32.36.0(00000)",
            "0-0:96.13.1()",
            "0-0:96.13.0()",
            "1-0:31.7.0(003*A)",
            "1-0:21.7.0(00.494*kW)",
            "1-0:22.7.0(00.001*kW)",
            "0-1:24.1.0(003)",
            "0-1:96.1.0(4730303139333430323231313938343135)",
            "0-1:24.2.1(170108160000W)(01234.000*m3)",
            "!D3B0"
        };

        public static List<string> MessageVariant1 { get; } = new List<string>
        {
            "/HeaderInformationManufacturerSpecific",
            "",
            "1-3:0.2.8(42)",
            "0-0:1.0.0(200118210549W)",
            "0-0:96.1.1(5179164565876186628967151365498132)",
            "1-0:1.8.1(009532.622*kWh)",
            "1-0:2.8.1(000507.529*kWh)",
            "1-0:1.8.2(005254.129*kWh)",
            "1-0:2.8.2(001416.610*kWh)",
            "0-0:96.14.0(0001)",
            "1-0:1.7.0(00.484*kW)",
            "1-0:2.7.0(00.005*kW)",
            "0-0:96.7.21(00012)",
            "0-0:96.7.9(00006)",
            "1-0:99.97.0(6)(0-0:96.7.19)(180823091614S)(0000004073*s)(150925170704S)(0000001050*s)(150719174858S)(0000000960*s)(150716133102S)(0000000797*s)(150611105643S)(0000000218*s)(150608142553S)(0000011302*s)",
            "1-0:32.32.0(00004)",
            "1-0:52.32.0(00001)",
            "1-0:72.32.0(00000)",
            "1-0:32.36.0(00000)",
            "1-0:52.36.0(00000)",
            "1-0:72.36.0(00000)",
            "0-0:96.13.1()",
            "0-0:96.13.0()",
            "1-0:31.7.0(003*A)",
            "1-0:51.7.0(004*A)",
            "1-0:71.7.0(010*A)",
            "1-0:21.7.0(00.396*kW)",
            "1-0:41.7.0(00.078*kW)",
            "1-0:61.7.0(00.009*kW)",
            "1-0:22.7.0(00.001*kW)",
            "1-0:42.7.0(00.002*kW)",
            "1-0:62.7.0(00.003*kW)",
            "0-1:24.1.0(003)",
            "0-1:96.1.0(6584951605374551602371563024516561)",
            "0-1:24.2.1(200118210000W)(04194.356*m3)",
            "!2C58"
        };

        public static List<string> SagemcomT210DESMR53Fase { get; } = new List<string>
        {
            @"/Ene5\T210-D ESMR5.0",
            " ",
            "1-3:0.2.8(50)",
            "0-0:1.0.0(180108202537W)",
            "0-0:96.1.1(345083459863498657345968)",
            "1-0:1.8.1(000000.855*kWh)",
            "1-0:1.8.2(000000.693*kWh)",
            "1-0:2.8.1(000000.084*kWh)",
            "1-0:2.8.2(000000.000*kWh)",
            "0-0:96.14.0(0002)",
            "1-0:1.7.0(00.134*kW)",
            "1-0:2.7.0(00.001*kW)",
            "0-0:96.7.21(00008)",
            "0-0:96.7.9(00004)",
            "1-0:99.97.0(1)(0-0:96.7.19)(171024204625S)(0000000305*s)",
            "1-0:32.32.0(00003)",
            "1-0:52.32.0(00003)",
            "1-0:72.32.0(00002)",
            "1-0:32.36.0(00000)",
            "1-0:52.36.0(00000)",
            "1-0:72.36.0(00000)",
            "0-0:96.13.0()",
            "1-0:32.7.0(229.0*V)",
            "1-0:52.7.0(226.0*V)",
            "1-0:72.7.0(229.0*V)",
            "1-0:31.7.0(001*A)",
            "1-0:51.7.0(002*A)",
            "1-0:71.7.0(003*A)",
            "1-0:21.7.0(00.094*kW)",
            "1-0:41.7.0(00.040*kW)",
            "1-0:61.7.0(00.003*kW)",
            "1-0:22.7.0(00.001*kW)",
            "1-0:42.7.0(00.002*kW)",
            "1-0:62.7.0(00.003*kW)",
            "0-1:24.1.0(003)",
            "0-1:96.1.0(345083459863498657345969)",
            "0-1:24.2.1(180108205500W)(00001.290*m3)",
            "!B055"
        };
    }
}