/* A.T.O.M. - A modern tool for high school education
 * Copyright (C) 2023  Michael A. DiPaolo
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const { model, Schema } = require('mongoose');
const ObjectId = Schema.Types.ObjectId;

const questionSchema = new Schema({
	qNum: { type: String, unique: true },
	sa: [{ type: ObjectId, ref: 'Skill Assessment' }],

	directions: String,
	img: String,
	text: String,
	choices: {
		a: String,
		b: String,
		c: String,
		d: String,
	},
	ans: String,
	tags: Array,
	source: String,
	sec: String,

	tot_atmp: { type: Number, default: 0 },
	atmp_by: [{ type: ObjectId, ref: 'Student' }],
	avg_ef: Number,
	avg_sec: Number,
	med_sec: Number,
});

module.exports = model('Question', questionSchema, 'questions');