/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2013 Semtech

Description: contains all hardware driver

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
 /******************************************************************************
  * @file    IIC.h
  * @author  MCD Application Team
  * @version V1.1.2
  * @date    01-June-2017
  * @brief   contains all hardware driver
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2017 STMicroelectronics International N.V. 
  * All rights reserved.</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without 
  * modification, are permitted, provided that the following conditions are met:
  *
  * 1. Redistribution of source code must retain the above copyright notice, 
  *    this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright notice,
  *    this list of conditions and the following disclaimer in the documentation
  *    and/or other materials provided with the distribution.
  * 3. Neither the name of STMicroelectronics nor the names of other 
  *    contributors to this software may be used to endorse or promote products 
  *    derived from this software without specific written permission.
  * 4. This software, including modifications and/or derivative works of this 
  *    software, must execute solely and exclusively on microcontroller or
  *    microprocessor devices manufactured by or for STMicroelectronics.
  * 5. Redistribution and use of this software other than as permitted under 
  *    this license is void and will automatically terminate your rights under 
  *    this license. 
  *
  * THIS SOFTWARE IS PROVIDED BY STMICROELECTRONICS AND CONTRIBUTORS "AS IS" 
  * AND ANY EXPRESS, IMPLIED OR STATUTORY WARRANTIES, INCLUDING, BUT NOT 
  * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
  * PARTICULAR PURPOSE AND NON-INFRINGEMENT OF THIRD PARTY INTELLECTUAL PROPERTY
  * RIGHTS ARE DISCLAIMED TO THE FULLEST EXTENT PERMITTED BY LAW. IN NO EVENT 
  * SHALL STMICROELECTRONICS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
  * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
  * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
  * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MPU9250_H__
#define __MPU9250_H__

#ifdef __cplusplus
 extern "C" {
#endif
/* Includes ------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/

/* Exported constants --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/
/* Exported macros -----------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */ 
// See also MPU-9250 Register Map and Descriptions, Revision 4.0, RM-MPU-9250A-00, Rev. 1.4, 9/9/2013 for registers not listed in 
// above document; the MPU9250 and MPU9150 are virtually identical but the latter has a different register map
//
#define IMU_SAMPLE_RATE 			200.0f
#define IMU_FILTER_CUTOFF_FREQ	30.0f
	 
#define MPU9250_ADDR            0X68    //MPU6500IICַ
#define MPU6500_ID1				0X71  	//MPU6500ID1
#define MPU6500_ID2				0X73  	//MPU6500ID2

//MPU9250ڲװһAK8963,ַID:
#define AK8963_ADDR				0X0C	//AK8963I2Cַ
#define AK8963_ID				0X48	//AK8963ID


//AK8963ڲĴ
#define MAG_WIA					0x00	//AK8963IDĴַ
#define MAG_CNTL1          	  	0X0A    
#define MAG_CNTL2            	0X0B

#define MAG_XOUT_L				0X03	
#define MAG_XOUT_H				0X04
#define MAG_YOUT_L				0X05
#define MAG_YOUT_H				0X06
#define MAG_ZOUT_L				0X07
#define MAG_ZOUT_H				0X08

//MPU6500ڲĴ
#define MPU_SELF_TESTX_REG		0X0D	//ԼĴX
#define MPU_SELF_TESTY_REG		0X0E	//ԼĴY
#define MPU_SELF_TESTZ_REG		0X0F	//ԼĴZ
#define MPU_SELF_TESTA_REG		0X10	//ԼĴA
#define MPU_SAMPLE_RATE_REG		0X19	//ƵʷƵ
#define MPU_CFG_REG				0X1A	//üĴ
#define MPU_GYRO_CFG_REG		0X1B	//üĴ
#define MPU_ACCEL_CFG_REG		0X1C	//ٶȼüĴ
#define MPU_MOTION_DET_REG		0X1F	//˶ֵⷧüĴ
#define MPU_FIFO_EN_REG			0X23	//FIFOʹܼĴ
#define MPU_I2CMST_CTRL_REG		0X24	//IICƼĴ
#define MPU_I2CSLV0_ADDR_REG	0X25	//IICӻ0ַĴ
#define MPU_I2CSLV0_REG			0X26	//IICӻ0ݵַĴ
#define MPU_I2CSLV0_CTRL_REG	0X27	//IICӻ0ƼĴ
#define MPU_I2CSLV1_ADDR_REG	0X28	//IICӻ1ַĴ
#define MPU_I2CSLV1_REG			0X29	//IICӻ1ݵַĴ
#define MPU_I2CSLV1_CTRL_REG	0X2A	//IICӻ1ƼĴ
#define MPU_I2CSLV2_ADDR_REG	0X2B	//IICӻ2ַĴ
#define MPU_I2CSLV2_REG			0X2C	//IICӻ2ݵַĴ
#define MPU_I2CSLV2_CTRL_REG	0X2D	//IICӻ2ƼĴ
#define MPU_I2CSLV3_ADDR_REG	0X2E	//IICӻ3ַĴ
#define MPU_I2CSLV3_REG			0X2F	//IICӻ3ݵַĴ
#define MPU_I2CSLV3_CTRL_REG	0X30	//IICӻ3ƼĴ
#define MPU_I2CSLV4_ADDR_REG	0X31	//IICӻ4ַĴ
#define MPU_I2CSLV4_REG			0X32	//IICӻ4ݵַĴ
#define MPU_I2CSLV4_DO_REG		0X33	//IICӻ4дݼĴ
#define MPU_I2CSLV4_CTRL_REG	0X34	//IICӻ4ƼĴ
#define MPU_I2CSLV4_DI_REG		0X35	//IICӻ4ݼĴ

#define MPU_I2CMST_STA_REG		0X36	//IIC״̬Ĵ
#define MPU_INTBP_CFG_REG		0X37	//ж/·üĴ
#define MPU_INT_EN_REG			0X38	//жʹܼĴ
#define MPU_INT_STA_REG			0X3A	//ж״̬Ĵ

#define MPU_ACCEL_XOUTH_REG		0X3B	//ٶֵ,X8λĴ
#define MPU_ACCEL_XOUTL_REG		0X3C	//ٶֵ,X8λĴ
#define MPU_ACCEL_YOUTH_REG		0X3D	//ٶֵ,Y8λĴ
#define MPU_ACCEL_YOUTL_REG		0X3E	//ٶֵ,Y8λĴ
#define MPU_ACCEL_ZOUTH_REG		0X3F	//ٶֵ,Z8λĴ
#define MPU_ACCEL_ZOUTL_REG		0X40	//ٶֵ,Z8λĴ

#define MPU_TEMP_OUTH_REG		0X41	//¶ֵ߰λĴ
#define MPU_TEMP_OUTL_REG		0X42	//¶ֵ8λĴ

#define MPU_GYRO_XOUTH_REG		0X43	//ֵ,X8λĴ
#define MPU_GYRO_XOUTL_REG		0X44	//ֵ,X8λĴ
#define MPU_GYRO_YOUTH_REG		0X45	//ֵ,Y8λĴ
#define MPU_GYRO_YOUTL_REG		0X46	//ֵ,Y8λĴ
#define MPU_GYRO_ZOUTH_REG		0X47	//ֵ,Z8λĴ
#define MPU_GYRO_ZOUTL_REG		0X48	//ֵ,Z8λĴ

#define MPU_I2CSLV0_DO_REG		0X63	//IICӻ0ݼĴ
#define MPU_I2CSLV1_DO_REG		0X64	//IICӻ1ݼĴ
#define MPU_I2CSLV2_DO_REG		0X65	//IICӻ2ݼĴ
#define MPU_I2CSLV3_DO_REG		0X66	//IICӻ3ݼĴ

#define MPU_I2CMST_DELAY_REG	0X67	//IICʱĴ
#define MPU_SIGPATH_RST_REG		0X68	//źͨλĴ
#define MPU_MDETECT_CTRL_REG	0X69	//˶ƼĴ
#define MPU_USER_CTRL_REG		0X6A	//ûƼĴ
#define MPU_PWR_MGMT1_REG		0X6B	//ԴĴ1
#define MPU_PWR_MGMT2_REG		0X6C	//ԴĴ2 
#define MPU_FIFO_CNTH_REG		0X72	//FIFOĴ߰λ
#define MPU_FIFO_CNTL_REG		0X73	//FIFOĴͰλ
#define MPU_FIFO_RW_REG			0X74	//FIFOдĴ
#define MPU_DEVICE_ID_REG		0X75	//IDĴ

#define gryo_scale   	(4000.0/65536.0*3.14159/180.0)			//
#define accel_scale 	(16.0/65536.0)												//Gλ
#define mag_scale 	  (9600.0/16384.0/100.0)							//˹λ

uint8_t MPU_Init(void);
uint8_t MPU_WaitForReady(uint8_t devaddr);
uint8_t MPU_Write_Byte(uint8_t devaddr,uint8_t reg,uint8_t data);
uint8_t MPU_Read_Byte(uint8_t devaddr,uint8_t reg);
uint8_t MPU_Set_Gyro_Fsr(uint8_t fsr);
uint8_t MPU_Set_Accel_Fsr(uint8_t fsr);
uint8_t MPU_Set_Rate(uint16_t rate);
uint8_t MPU_Write_Len(uint8_t addr,uint8_t reg,uint8_t len,uint8_t *buf);
uint8_t MPU_Read_Len(uint8_t addr,uint8_t reg,uint8_t len,uint8_t *buf);
short MPU_Get_Temperature(void);
uint8_t MPU_Get_Gyroscope(short *gx,short *gy,short *gz);
uint8_t MPU_Get_Accelerometer(short *ax,short *ay,short *az);
uint8_t MPU_Get_Magnetometer(short *mx,short *my,short *mz);

uint8_t MPU_Get_Gyro(short *igx,short *igy,short *igz,float *gx,float *gy,float *gz);
uint8_t MPU_Get_Accel(short *iax,short *iay,short *iaz,float *ax,float *ay,float *az);
uint8_t MPU_Get_Mag(short *imx,short *imy,short *imz,float *mx,float *my,float *mz);
void calibrate1(void);
void calibrate2(void);	 
void get_calibrated_data(void);
#ifdef __cplusplus
}
#endif

#endif /* __MPU9250_H__ */
/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
