#ifndef __GPS_H_
#define __GPS_H_

#include <string.h>
#include <stdlib.h> 
#include <math.h>  
#include <stdio.h>  
#include "stm32l072xx.h"
#include "stm32l0xx_hal.h"
#include "stm32l0xx_nucleo.h"

#include "bsp_usart2.h"

#ifndef NULL
#define NULL    ((void *)0)
#endif


#define GPS_STANDBY_H()  HAL_GPIO_WritePin(GPIOB, GPIO_PIN_8, GPIO_PIN_SET)
#define GPS_STANDBY_L()  HAL_GPIO_WritePin(GPIOB, GPIO_PIN_8, GPIO_PIN_RESET)

#define GPS_RESET_ON()  HAL_GPIO_WritePin(GPIOB, GPIO_PIN_2, GPIO_PIN_RESET)
#define GPS_RESET_OFF()  HAL_GPIO_WritePin(GPIOB, GPIO_PIN_2, GPIO_PIN_SET)

#define GPS_POWER_ON()  HAL_GPIO_WritePin(GPIOA, GPIO_PIN_8, GPIO_PIN_SET)
#define GPS_POWER_OFF()  HAL_GPIO_WritePin(GPIOA, GPIO_PIN_8, GPIO_PIN_RESET)

typedef unsigned char  INT8U; // ޷8λͱ // 
typedef signed char    INT8S; // з8λͱ // 
typedef unsigned short INT16U; // ޷16λͱ // 
typedef signed short   INT16S; // з16λͱ // 
typedef unsigned int   INT32U; // ޷32λͱ // 
typedef signed int     INT32S; // з32λͱ // 
typedef float          FP32; // ȸ(32λ) // 
typedef double         FP64; // ˫ȸ(64λ) //  
//#define   BOOL     bool
 
typedef	struct 
	{ 
		int satid;      // 
		int elevation;  //ǣ00 - 90
		int azimuth;    //Ƿλǣ00 - 359
		int snr;        //ȣ0099dbHz 
	} SatelliteInfo; 

typedef  struct{

    char isvalid;
    int hh,mm,ss,ms;

    int DD, MM, YY;
    FP32 latitude;
    uint8_t latNS;    
    FP32 longitude;
    uint8_t   lgtEW;
    FP32 speed;       //ٶȣGPSλ ڣKnots ѾתλKM/H
    FP32 direction;   //λǣ 汱Ϊο
    
	  FP32  flag;
	
    FP32  altitude;     //θ߶
    uint8_t altitudeunit;       //ελ

    uint8_t  FixMode;     //GPS״̬0=δλ1=ǲֶλ2=ֶλ3=ЧPPS6=ڹ
    uint8_t GSA_mode1;//λģʽA=Զֶ2D/3DM=ֶ2D/3D 
    uint8_t GSA_mode2;//λͣ1=δλ2=2Dλ3=3Dλ 

    FP32 PDOP;          //ۺλþ
    FP32 HDOP;          //ˮƽ
    FP32 VDOP;          //ֱ 
    uint32_t  ageOfDiff;//ʱ䣨һνյźſʼǲֶλΪգ 
    uint16_t  diffStationID;//վID0000 - 1023ǰλ0ǲֶλΪգ
     
    uint8_t usedsat[12];//
    uint8_t  usedsatnum;  //ʹõ00 - 12
    uint8_t allsatnum;  //ǰɼ00 - 12
   SatelliteInfo satinfo[38];
     }GPSINFO;




extern  GPSINFO  gps; 

  
extern void GPS_init(void);
extern  uint8_t   GPS_parse(char *buf); 
extern void  GPS_usart(uint8_t buffer);  
extern  uint8_t GPS_INFO_update(void);
extern _Bool GPS_Run(void);
extern void Sony_GNSS_Start(void);
extern void GPS_Stop(void); 
extern void GPS_FirmwareUpdate(void);
extern void GPS_DegreeToDMS(FP32 deg,int *d,int *m,FP32 *s)   ;
extern void GPS_INPUT(void);
extern void POWER_ON(void);
extern void POWER_OFF(void); 
extern void GPS_doinit(void);
//	BOOL OpenDevice(TCHAR *strPort,int nBaudRate); 
//	void CloseDevice(); 
extern  _Bool GPS_IsRunning(void); 
/*	BOOL Run(); 
	void Stop(); 
	
 
	BOOL IsLocationValid(); 
	FP32 GetTimestamp(); 
	FP32 GetLongitude(); 
	FP32 GetLatitude(); 
	FP32 GetHeight(); 
	char GetHeightUnit(); 
	FP32 GetVelocity(); 
	FP32 GetDirection(); 
	int GetSatNum(); 
	FP32 GetError(); 
 
  */



#endif   //__GPS_H_
