initSidebarItems({"constant":[["NULL","Declare a `NULL` pointer that will be passed to C functions"]],"enum":[["StrnRep","Either a byte string or a string pointer"]],"fn":[["rust_sysinit","Initialise the Mynewt system.  Start the Mynewt drivers and libraries.  Equivalent to `sysinit()` macro in C. C API: `void rust_sysinit()`"],["sysinit","Initialise the Mynewt system.  Start the Mynewt drivers and libraries.  Equivalent to `sysinit()` macro in C."]],"macro":[["coap","Macro to compose a CoAP payload with JSON or CBOR encoding. First parameter is `@none`, `@json`, `@cbor` or `@cbormin`, to indicate no encoding (testing), JSON encoding, CBOR encoding for thethings.io or CBOR minimal key-value encoding. JSON and CBOR encoding looks like: `{ values: [{key:..., value:...}, ...] }`. CBOR Minimal encoding looks like: `{ key: value, ... }`. Second parameter is the JSON message to be transmitted. Adapted from the `json!()` macro: https://docs.serde.rs/src/serde_json/macros.rs.html"],["coap_array","Compose an array under `object`, named as `key` (e.g. `values`).  Add `children` as array elements."],["coap_item","Append an array item under the current object item.  Add `children0` as the array items. `{ <array0>: [ ..., { <children0> } ] }`"],["coap_item_int","Append a (key + int value) item to the array named `array`: `{ <array>: [ ..., {\"key\": <key0>, \"value\": <value0>} ], ... }`"],["coap_item_int_val","Create a new Item object in the parent array and set the Sensor Value's key/value (integer)."],["coap_item_str","Append a (`key` + `val` string value) item to the array named `parent`: `{ <parent>: [ ..., {\"key\": <key>, \"value\": <val>} ] }`"],["coap_root","Compose the payload root."],["coap_set_int_val","Given an object parent and an integer Sensor Value `val`, set the `val`'s key/value in the object."],["d","Macro to dump all tokens received as a literal string, e.g. `d!(a b c)` returns `\"a b c\"`"],["fill_zero","Return a const struct that has all fields set to 0. Used for initialising static mutable structs like `os_task`.  `fill_zero!(os_task)` expands to  `unsafe {  ::core::mem::transmute:: <   [ \tu8;  \t::core::mem::size_of::<os_task>()   ],    os_task > (   [ \t0;  \t::core::mem::size_of::<os_task>()   ] )  } `"],["json_rep_close_array","End the child array and resume writing the parent object. `{a:b, key:[... --> {a:b, key:[...]`"],["json_rep_object_array_end_item","End an array item, assumed to be an object. `[... --> [...,`"],["json_rep_object_array_start_item","Assume we have called `set_array`.  Start an array item, assumed to be an object. `[... --> [...,`"],["json_rep_set_array","Assume we are writing an object now.  Write the key name and start a child array. `{a:b --> {a:b, key:[`"],["json_rep_set_int","Encode an int value into the current JSON encoding value `coap_json_value`"],["json_rep_set_text_string","Encode a text value into the current JSON encoding value `coap_json_value`"],["nx","Macro to display the token being parsed and the remaining tokens"],["oc_rep_close_array","End the child array and resume writing the parent object. `{a:b, key:[... --> {a:b, key:[...]`"],["oc_rep_end_array",""],["oc_rep_end_object",""],["oc_rep_end_root_object",""],["oc_rep_object_array_end_item","End an array item, assumed to be an object. `[... --> [...,`"],["oc_rep_object_array_start_item","Assume we have called `set_array`.  Start an array item, assumed to be an object. `[... --> [...,`"],["oc_rep_set_array","Assume we are writing an object now.  Write the key name and start a child array. `{a:b --> {a:b, key:[`"],["oc_rep_set_int","Encode an int value "],["oc_rep_set_text_string","Encode a text value "],["oc_rep_start_array",""],["oc_rep_start_object",""],["oc_rep_start_root_object",""],["parse","Parse the JSON code in the parameter and compose the CoAP payload. This macro takes these parameters: - Encoding: `@json`, `@cbor` or `@none` - State: Current parsing state (`@object`, `@array` or omitted) - Context: JSON or CBOR parsing context (`JsonContext` or `CborContext`) - Remaining tokens to be parsed - Remaining tokens again, for error display"],["parse_vector","TODO: Parse the vector e.g. array items"],["stringify_null","Macro that takes an identifier and returns a `[u8]` containing the identifier, terminated by 0. Used to convert an identifier to a C null-terminated string."],["unexpected_token","Show an unexpected token error"]],"mod":[["encoding","Mynewt Encoding API for Rust"],["hw","Mynewt Hardware API for Rust"],["kernel","Mynewt Kernel API for Rust"],["libs","Mynewt Custom API for Rust"],["result","Return type and error codes for Mynewt API"],["sys","Mynewt System API for Rust"],["util","Mynewt Utility Macros for Rust"]],"struct":[["Strn","Represents a null-terminated string, suitable for passing to Mynewt APIs as `* const char`. The string could be a null-terminated byte string created in Rust, or a pointer to a null-terminated string returned by C. Pointer may be null."]],"type":[["Out","Declare a pointer that will be used by C functions to return a value"],["Ptr","Declare a `void *` pointer that will be passed to C functions"]]});