window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "mathgenerator", "modulename": "mathgenerator", "kind": "module", "doc": "<h1 id=\"mathgenerator\">mathgenerator</h1>\n\n<p>A math problem generator, created for the purpose of giving teachers and students the means to easily get access to random math exercises to suit their needs.</p>\n\n<p>To try out generators, go to <a href=\"https://mathgenerator-demo.netlify.app\">https://mathgenerator-demo.netlify.app</a></p>\n\n<p>See <a href=\"https://github.com/lukew3/mathgenerator/blob/main/CONTRIBUTING.md\">CONTRIBUTING.md</a> for information about how to contribute.</p>\n\n<h2 id=\"table-of-contents\">Table of Contents</h2>\n\n<ul>\n<li><a href=\"#installation\">Installation</a></li>\n<li><a href=\"#usage\">Usage</a></li>\n<li><a href=\"#documentation\">Documentation</a></li>\n</ul>\n\n<h2 id=\"installation\">Installation</h2>\n\n<p>The project can be install via pip</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>pip<span class=\"w\"> </span>install<span class=\"w\"> </span>mathgenerator\n</code></pre>\n</div>\n\n<h2 id=\"usage\">Usage</h2>\n\n<p>Here is an example of how you would generate an addition problem:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">mathgenerator</span>\n\n<span class=\"c1\">#generate an addition problem</span>\n<span class=\"n\">problem</span><span class=\"p\">,</span> <span class=\"n\">solution</span> <span class=\"o\">=</span> <span class=\"n\">mathgenerator</span><span class=\"o\">.</span><span class=\"n\">addition</span><span class=\"p\">()</span>\n\n<span class=\"c1\">#another way to generate an addition problem using genById()</span>\n<span class=\"n\">problem</span><span class=\"p\">,</span> <span class=\"n\">solution</span> <span class=\"o\">=</span> <span class=\"n\">mathgenerator</span><span class=\"o\">.</span><span class=\"n\">genById</span><span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>You may prefer to use <code>import mathgenerator as mg</code> and run functions like <code>mg.addition()</code> so that you don't have to type as much.\n<!--</p>\n\n<h3 id=\"creating-a-worksheet\">Creating a worksheet</h3>\n\n<p>If you wish to create a worksheet, you can use the <a href=\"https://github.com/lukew3/worksheetgen\">worksheetgen</a> package. Install this with <code>pip install worksheetgen</code>. Here is an example of how a worksheet would be generated.</p>\n\n<pre><code>from mathgenerator import mathgen\nfrom worksheetgen.wg import Worksheet\n\nws = Worksheet(\"Worksheet title\")\nwith ws.section('Section 1', description='These are instructions')\n    # Writes 10 problems generated with id 1, [0] at the end specifies to take problem, and not solution.\n    for _ in range(10):\n        ws.add_problem(mathgen.genById(1)[0])\nws.write_pdf()\n</code></pre>\n\n<p>This creates the pdf <code>ws.pdf</code> in your current directory\n-->\nProblem/solution pairs are generated with either:</p>\n\n<ul>\n<li><code>mathgenerator.&lt;generator_name&gt;()</code> - generates a problem, solution set from the given generator name.</li>\n<li><code>mathgenerator.genById(id)</code> - generates a problem, solution set with generator id provided by the <code>id</code> parameter</li>\n</ul>\n\n<p><!--</p>\n\n<h4 id=\"format-kwarg\"><code>format</code> kwarg</h4>\n\n<ul>\n<li>Pass <code>format=latex</code> to return problem and solution set as latex. If latex is not available for that generator, the problem will return the string \"Latex unavailable\"</li>\n<li>Pass <code>format=raw</code> to return just the raw data for each generator. An array of each variable necessary to the generator is returned.</li>\n<li>If you don't pass a value to the format kwarg, the generator will return a problem and answer in asciimath format.\n-->\nYou can also use <code>getGenList()</code> to return a list of all generators included in the library in the format:</li>\n</ul>\n\n<pre><code>[funcname, subjectname]\n</code></pre>\n\n<h2 id=\"documentation\">Documentation</h2>\n\n<p>Documentation can be found at <a href=\"https://lukew3.github.io/mathgenerator\">https://lukew3.github.io/mathgenerator</a></p>\n"}, {"fullname": "mathgenerator.get_gen_list", "modulename": "mathgenerator", "qualname": "get_gen_list", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.gen_by_id", "modulename": "mathgenerator", "qualname": "gen_by_id", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"nb\">id</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.getGenList", "modulename": "mathgenerator", "qualname": "getGenList", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.genById", "modulename": "mathgenerator", "qualname": "genById", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"nb\">id</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra", "modulename": "mathgenerator.algebra", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "mathgenerator.algebra.basic_algebra", "modulename": "mathgenerator.algebra", "qualname": "basic_algebra", "kind": "function", "doc": "<p>Basic Algebra</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$1x + 5 = 5$</td>\n  <td>$0$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_variable</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.combine_like_terms", "modulename": "mathgenerator.algebra", "qualname": "combine_like_terms", "kind": "function", "doc": "<p>Combine Like Terms</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$6x^{9} + 3x^{2} + 5x^{19} + 3x^{17}$</td>\n  <td>$3x^{2} + 6x^{9} + 3x^{17} + 5x^{19}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_coef</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">max_exp</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_terms</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.complex_quadratic", "modulename": "mathgenerator.algebra", "qualname": "complex_quadratic", "kind": "function", "doc": "<p>Complex Quadratic Equation</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find the roots of given Quadratic Equation $x^2 + 8x + 8 = 0$</td>\n  <td>$((-1.172, -6.828)) = (\\frac{-8 + \\sqrt{32}}{2}, (\\frac{-8 - \\sqrt{32}}{2})$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">prob_type</span><span class=\"o\">=</span><span class=\"mi\">0</span>, </span><span class=\"param\"><span class=\"n\">max_range</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.compound_interest", "modulename": "mathgenerator.algebra", "qualname": "compound_interest", "kind": "function", "doc": "<p>Compound Interest</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Compound interest for a principle amount of $2679$ dollars, $9$% rate of interest and for a time period of $3$ years is $=$</td>\n  <td>$3469.38$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_principle</span><span class=\"o\">=</span><span class=\"mi\">10000</span>, </span><span class=\"param\"><span class=\"n\">max_rate</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">max_time</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.distance_two_points", "modulename": "mathgenerator.algebra", "qualname": "distance_two_points", "kind": "function", "doc": "<p>Distance between 2 points</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find the distance between $(-19, -6)$ and $(15, -16)$</td>\n  <td>$\\sqrt{1256}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_val_xy</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">min_val_xy</span><span class=\"o\">=-</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.expanding", "modulename": "mathgenerator.algebra", "qualname": "expanding", "kind": "function", "doc": "<p>Expanding Factored Binomial</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$(x-6)(-3x-3)$</td>\n  <td>$x^2+18x+18$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">range_x1</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">range_x2</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">range_a</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">range_b</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.factoring", "modulename": "mathgenerator.algebra", "qualname": "factoring", "kind": "function", "doc": "<p>Factoring Quadratic\nGiven a quadratic equation in the form x^2 + bx + c, factor it into it's roots (x - x1)(x -x2)</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$x^2+2x-24$</td>\n  <td>$(x-4)(x+6)$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">range_x1</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">range_x2</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.int_matrix_22_determinant", "modulename": "mathgenerator.algebra", "qualname": "int_matrix_22_determinant", "kind": "function", "doc": "<p>Determinant to 2x2 Matrix</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$\\det \\begin{bmatrix} 88 &amp; 40 \\\\ 9 &amp; 91 \\end{bmatrix}= $</td>\n  <td>$7648$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_matrix_val</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.intersection_of_two_lines", "modulename": "mathgenerator.algebra", "qualname": "intersection_of_two_lines", "kind": "function", "doc": "<p>Intersection of two lines</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find the point of intersection of the two lines: $y = \\frac{-2}{6}x + 3$ and $y = \\frac{3}{6}x - 8$</td>\n  <td>$(\\frac{66}{5}, \\frac{-7}{5})$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">min_m</span><span class=\"o\">=-</span><span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">max_m</span><span class=\"o\">=</span><span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">min_b</span><span class=\"o\">=-</span><span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">max_b</span><span class=\"o\">=</span><span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">min_denominator</span><span class=\"o\">=</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">max_denominator</span><span class=\"o\">=</span><span class=\"mi\">6</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.invert_matrix", "modulename": "mathgenerator.algebra", "qualname": "invert_matrix", "kind": "function", "doc": "<p>Invert Matrix</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Inverse of Matrix $\\begin{bmatrix} 4 &amp; 1 &amp; 4 \\\\ 5 &amp; 1 &amp; 5 \\\\ 12 &amp; 3 &amp; 13 \\end{bmatrix}$ is:</td>\n  <td>$\\begin{bmatrix} 2 &amp; 1 &amp; -1 \\\\ 5 &amp; -4 &amp; 0 \\\\ -3 &amp; 0 &amp; 1 \\end{bmatrix}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">square_matrix_dimension</span><span class=\"o\">=</span><span class=\"mi\">3</span>,</span><span class=\"param\">\t<span class=\"n\">max_matrix_element</span><span class=\"o\">=</span><span class=\"mi\">99</span>,</span><span class=\"param\">\t<span class=\"n\">only_integer_elements_in_inverted_matrixe</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.linear_equations", "modulename": "mathgenerator.algebra", "qualname": "linear_equations", "kind": "function", "doc": "<p>Linear Equations</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Given the equations $10x + -20y = 310$ and $-16x + -17y = 141$, solve for $x$ and $y$</td>\n  <td>$x = 5$, $y = -13$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">n</span><span class=\"o\">=</span><span class=\"mi\">2</span>, </span><span class=\"param\"><span class=\"n\">var_range</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">coeff_range</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.line_equation_from_2_points", "modulename": "mathgenerator.algebra", "qualname": "line_equation_from_2_points", "kind": "function", "doc": "<p>Equation of Line from Two Points</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find the equation of the line passing through the points $(-19,-8)$ and $(-2,0)$.</td>\n  <td>$y=\\frac{8}{17}x+\\frac{16}{17}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.log", "modulename": "mathgenerator.algebra", "qualname": "log", "kind": "function", "doc": "<p>Logarithm</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$log_{3}(243)=$</td>\n  <td>$5$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_base</span><span class=\"o\">=</span><span class=\"mi\">3</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">8</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.matrix_multiplication", "modulename": "mathgenerator.algebra", "qualname": "matrix_multiplication", "kind": "function", "doc": "<p>Multiply Two Matrices</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Multiply $\\begin{bmatrix} 15 &amp; 72 \\\\ 64 &amp; -20 \\\\ 18 &amp; 59 \\\\ -21 &amp; -55 \\\\ 20 &amp; -12 \\\\ -75 &amp; -42 \\\\ 47 &amp; 89 \\\\ -53 &amp; 27 \\\\ -56 &amp; 44 \\end{bmatrix}$ and $\\begin{bmatrix} 49 &amp; -2 &amp; 68 &amp; -28 \\\\ 49 &amp; 6 &amp; 83 &amp; 42 \\end{bmatrix}$</td>\n  <td>$\\begin{bmatrix} 4263 &amp; 402 &amp; 6996 &amp; 2604 \\\\ 2156 &amp; -248 &amp; 2692 &amp; -2632 \\\\ 3773 &amp; 318 &amp; 6121 &amp; 1974 \\\\ -3724 &amp; -288 &amp; -5993 &amp; -1722 \\\\ 392 &amp; -112 &amp; 364 &amp; -1064 \\\\ -5733 &amp; -102 &amp; -8586 &amp; 336 \\\\ 6664 &amp; 440 &amp; 10583 &amp; 2422 \\\\ -1274 &amp; 268 &amp; -1363 &amp; 2618 \\\\ -588 &amp; 376 &amp; -156 &amp; 3416 \\end{bmatrix}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">max_dim</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.midpoint_of_two_points", "modulename": "mathgenerator.algebra", "qualname": "midpoint_of_two_points", "kind": "function", "doc": "<p>Midpoint of two points</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>The midpoint of $(-8,10)$ and $(18,0) = $</td>\n  <td>$(5.0,5.0)$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_value</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.multiply_complex_numbers", "modulename": "mathgenerator.algebra", "qualname": "multiply_complex_numbers", "kind": "function", "doc": "<p>Multiplication of 2 complex numbers</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$(14+18j) * (14+15j) = $</td>\n  <td>$(-74+462j)$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_real_imaginary_num</span><span class=\"o\">=-</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_real_imaginary_num</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.multiply_int_to_22_matrix", "modulename": "mathgenerator.algebra", "qualname": "multiply_int_to_22_matrix", "kind": "function", "doc": "<p>Multiply Integer to 2x2 Matrix</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$5 * \\begin{bmatrix} 1 &amp; 0 \\\\ 2 &amp; 9 \\end{bmatrix} =$</td>\n  <td>$\\begin{bmatrix} 5 &amp; 0 \\\\ 10 &amp; 45 \\end{bmatrix}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_matrix_val</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">max_res</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.quadratic_equation", "modulename": "mathgenerator.algebra", "qualname": "quadratic_equation", "kind": "function", "doc": "<p>Quadratic Equation</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>What are the zeros of the quadratic equation $22x^2+137x+25=0$</td>\n  <td>${-0.19, -6.04}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.simple_interest", "modulename": "mathgenerator.algebra", "qualname": "simple_interest", "kind": "function", "doc": "<p>Simple Interest</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Simple interest for a principle amount of $7217$ dollars, $3$% rate of interest and for a time period of $10$ years is $=$</td>\n  <td>$2165.1$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_principle</span><span class=\"o\">=</span><span class=\"mi\">10000</span>, </span><span class=\"param\"><span class=\"n\">max_rate</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">max_time</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.system_of_equations", "modulename": "mathgenerator.algebra", "qualname": "system_of_equations", "kind": "function", "doc": "<p>Solve a System of Equations in R^2</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Given $-x + 5y = -28$ and $9x + 2y = 64$, solve for $x$ and $y$.</td>\n  <td>$x = 8$, $y = -4$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">range_x</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">range_y</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">coeff_mult_range</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.vector_cross", "modulename": "mathgenerator.algebra", "qualname": "vector_cross", "kind": "function", "doc": "<p>Cross product of 2 vectors</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$[-1, -4, 10] \\times [-11, 1, -16] = $</td>\n  <td>$[54, -126, -45]$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_val</span><span class=\"o\">=-</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.vector_dot", "modulename": "mathgenerator.algebra", "qualname": "vector_dot", "kind": "function", "doc": "<p>Dot product of 2 vectors</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$[12, -9, -8]\\cdot[-9, 8, 1]=$</td>\n  <td>$-188$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_val</span><span class=\"o\">=-</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.algebra.orthogonal_projection", "modulename": "mathgenerator.algebra", "qualname": "orthogonal_projection", "kind": "function", "doc": "<p>Orthogonal Projection</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find the orthogonal projection of $[2, 3]$ onto $[4, -7]$</td>\n  <td>$[\\frac{-4}{5}, \\frac{7}{5}]$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_val</span><span class=\"o\">=-</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math", "modulename": "mathgenerator.basic_math", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "mathgenerator.basic_math.absolute_difference", "modulename": "mathgenerator.basic_math", "qualname": "absolute_difference", "kind": "function", "doc": "<p>Absolute difference between two numbers</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$|22-34|=$</td>\n  <td>$12$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_a</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">max_b</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.addition", "modulename": "mathgenerator.basic_math", "qualname": "addition", "kind": "function", "doc": "<p>Addition of two numbers</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$22+34=$</td>\n  <td>$56$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_sum</span><span class=\"o\">=</span><span class=\"mi\">99</span>, </span><span class=\"param\"><span class=\"n\">max_addend</span><span class=\"o\">=</span><span class=\"mi\">50</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.compare_fractions", "modulename": "mathgenerator.basic_math", "qualname": "compare_fractions", "kind": "function", "doc": "<p>Compare Fractions</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Which symbol represents the comparison between $\\frac{1}{2}$ and $\\frac{3}{4}$?</td>\n  <td>$&gt;$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.cube_root", "modulename": "mathgenerator.basic_math", "qualname": "cube_root", "kind": "function", "doc": "<p>Cube Root</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>What is the cube root of: $\\sqrt[3]{125}=$ to 2 decimal places?</td>\n  <td>$5$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_no</span><span class=\"o\">=</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">max_no</span><span class=\"o\">=</span><span class=\"mi\">1000</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.divide_fractions", "modulename": "mathgenerator.basic_math", "qualname": "divide_fractions", "kind": "function", "doc": "<p>Divide Fractions</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$\\frac{7}{9}\\div\\frac{4}{1}=$</td>\n  <td>$\\frac{7}{36}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.division", "modulename": "mathgenerator.basic_math", "qualname": "division", "kind": "function", "doc": "<p>Division</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$216\\div24=$</td>\n  <td>$9$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_a</span><span class=\"o\">=</span><span class=\"mi\">25</span>, </span><span class=\"param\"><span class=\"n\">max_b</span><span class=\"o\">=</span><span class=\"mi\">25</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.exponentiation", "modulename": "mathgenerator.basic_math", "qualname": "exponentiation", "kind": "function", "doc": "<p>Exponentiation</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$9^{5}=$</td>\n  <td>$8$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_base</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_expo</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.factorial", "modulename": "mathgenerator.basic_math", "qualname": "factorial", "kind": "function", "doc": "<p>Factorial</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$4! =$</td>\n  <td>$24$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_input</span><span class=\"o\">=</span><span class=\"mi\">6</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.fraction_multiplication", "modulename": "mathgenerator.basic_math", "qualname": "fraction_multiplication", "kind": "function", "doc": "<p>Fraction Multiplication</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$\\frac{3}{10}\\cdot\\frac{6}{7}=$</td>\n  <td>$\\frac{9}{35}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.fraction_to_decimal", "modulename": "mathgenerator.basic_math", "qualname": "fraction_to_decimal", "kind": "function", "doc": "<p>Fraction to Decimal</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$83\\div80=$</td>\n  <td>$1.04$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_res</span><span class=\"o\">=</span><span class=\"mi\">99</span>, </span><span class=\"param\"><span class=\"n\">max_divid</span><span class=\"o\">=</span><span class=\"mi\">99</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.greatest_common_divisor", "modulename": "mathgenerator.basic_math", "qualname": "greatest_common_divisor", "kind": "function", "doc": "<p>Greatest Common Divisor of N Numbers ( GCD / HCF )</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$GCD(488075608, 75348096)=$</td>\n  <td>$8$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">numbers_count</span><span class=\"o\">=</span><span class=\"mi\">2</span>, </span><span class=\"param\"><span class=\"n\">max_num</span><span class=\"o\">=</span><span class=\"mi\">1000</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.is_composite", "modulename": "mathgenerator.basic_math", "qualname": "is_composite", "kind": "function", "doc": "<p>Is Composite</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Is $171$ composite?</td>\n  <td>Yes</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_num</span><span class=\"o\">=</span><span class=\"mi\">250</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.is_prime", "modulename": "mathgenerator.basic_math", "qualname": "is_prime", "kind": "function", "doc": "<p>Is Prime</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Is $37$ prime?</td>\n  <td>Yes</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_num</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.multiplication", "modulename": "mathgenerator.basic_math", "qualname": "multiplication", "kind": "function", "doc": "<p>Multiplication</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$10\\cdot9=$</td>\n  <td>$90$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_multi</span><span class=\"o\">=</span><span class=\"mi\">12</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.percentage", "modulename": "mathgenerator.basic_math", "qualname": "percentage", "kind": "function", "doc": "<p>Percentage of a number</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>What is $45$% of $39$?</td>\n  <td>$17.55$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_value</span><span class=\"o\">=</span><span class=\"mi\">99</span>, </span><span class=\"param\"><span class=\"n\">max_percentage</span><span class=\"o\">=</span><span class=\"mi\">99</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.percentage_difference", "modulename": "mathgenerator.basic_math", "qualname": "percentage_difference", "kind": "function", "doc": "<p>Percentage difference between two numbers</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>What is the percentage difference between $2$ and $10$?</td>\n  <td>$133.33$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_value</span><span class=\"o\">=</span><span class=\"mi\">200</span>, </span><span class=\"param\"><span class=\"n\">min_value</span><span class=\"o\">=</span><span class=\"mi\">0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.percentage_error", "modulename": "mathgenerator.basic_math", "qualname": "percentage_error", "kind": "function", "doc": "<p>Percentage error</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find the percentage error when observed value equals $32$ and exact value equals $81$.</td>\n  <td>$60.49$%</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_value</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">min_value</span><span class=\"o\">=-</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.power_of_powers", "modulename": "mathgenerator.basic_math", "qualname": "power_of_powers", "kind": "function", "doc": "<p>Power of Powers</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Simplify $18^{10^{8}}$</td>\n  <td>$18^{80}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_base</span><span class=\"o\">=</span><span class=\"mi\">50</span>, </span><span class=\"param\"><span class=\"n\">max_power</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.square", "modulename": "mathgenerator.basic_math", "qualname": "square", "kind": "function", "doc": "<p>Square</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$17^2=$</td>\n  <td>$289$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_square_num</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.square_root", "modulename": "mathgenerator.basic_math", "qualname": "square_root", "kind": "function", "doc": "<p>Square Root</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$\\sqrt{64}=$</td>\n  <td>$8$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_no</span><span class=\"o\">=</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">max_no</span><span class=\"o\">=</span><span class=\"mi\">12</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.simplify_square_root", "modulename": "mathgenerator.basic_math", "qualname": "simplify_square_root", "kind": "function", "doc": "<p>Simplify Square Root</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$\\sqrt{63}$</td>\n  <td>$3\\sqrt{7}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_variable</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.basic_math.subtraction", "modulename": "mathgenerator.basic_math", "qualname": "subtraction", "kind": "function", "doc": "<p>Subtraction of two numbers</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$54-22=$</td>\n  <td>$32$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_minuend</span><span class=\"o\">=</span><span class=\"mi\">99</span>, </span><span class=\"param\"><span class=\"n\">max_diff</span><span class=\"o\">=</span><span class=\"mi\">99</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.calculus", "modulename": "mathgenerator.calculus", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "mathgenerator.calculus.definite_integral", "modulename": "mathgenerator.calculus", "qualname": "definite_integral", "kind": "function", "doc": "<p>Definite Integral of Quadratic Equation</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>The definite integral within limits $0$ to $1$ of the equation $28x^2 + 32x + 66 = $</td>\n  <td>$91.33$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_coef</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.calculus.power_rule_differentiation", "modulename": "mathgenerator.calculus", "qualname": "power_rule_differentiation", "kind": "function", "doc": "<p>Power Rule Differentiation</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Differentiate $1x^{5} + 4x^{7} + 4x^{4}$</td>\n  <td>$5x^{4} + 28x^{6} + 16x^{3}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_coef</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">max_exp</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">max_terms</span><span class=\"o\">=</span><span class=\"mi\">5</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.calculus.power_rule_integration", "modulename": "mathgenerator.calculus", "qualname": "power_rule_integration", "kind": "function", "doc": "<p>Power Rule Integration</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Integrate $9x^{6} + 2x^{6} + 4x^{3}$</td>\n  <td>$\\frac{9}{6}x^{7} + \\frac{2}{6}x^{7} + \\frac{4}{3}x^{4} + C$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_coef</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">max_exp</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">max_terms</span><span class=\"o\">=</span><span class=\"mi\">5</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.calculus.stationary_points", "modulename": "mathgenerator.calculus", "qualname": "stationary_points", "kind": "function", "doc": "<p>Stationary Points</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$f(x)=6x^3 + 6x^2 + x + 8$</td>\n  <td>${- \\frac{1}{3} - \\frac{\\sqrt{2}}{6}, - \\frac{1}{3} + \\frac{\\sqrt{2}}{6}}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_exp</span><span class=\"o\">=</span><span class=\"mi\">3</span>, </span><span class=\"param\"><span class=\"n\">max_coef</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.calculus.trig_differentiation", "modulename": "mathgenerator.calculus", "qualname": "trig_differentiation", "kind": "function", "doc": "<p>Trigonometric Differentiation</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$\\frac{d}{dx}(\\csc)=$</td>\n  <td>$-\\csc \\cdot \\cot$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science", "modulename": "mathgenerator.computer_science", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "mathgenerator.computer_science.bcd_to_decimal", "modulename": "mathgenerator.computer_science", "qualname": "bcd_to_decimal", "kind": "function", "doc": "<p>Binary Coded Decimal to Integer</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Integer of Binary Coded Decimal $4 =$</td>\n  <td>$17801$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_number</span><span class=\"o\">=</span><span class=\"mi\">10000</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science.binary_2s_complement", "modulename": "mathgenerator.computer_science", "qualname": "binary_2s_complement", "kind": "function", "doc": "<p>Binary 2's Complement</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>2's complement of $1011 = $</td>\n  <td>$101$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">maxDigits</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science.binary_complement_1s", "modulename": "mathgenerator.computer_science", "qualname": "binary_complement_1s", "kind": "function", "doc": "<p>Binary Complement 1s</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$1111001 = $</td>\n  <td>$0000110$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">maxDigits</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science.binary_to_decimal", "modulename": "mathgenerator.computer_science", "qualname": "binary_to_decimal", "kind": "function", "doc": "<p>Binary to Decimal</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$000110$</td>\n  <td>$6$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_dig</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science.binary_to_hex", "modulename": "mathgenerator.computer_science", "qualname": "binary_to_hex", "kind": "function", "doc": "<p>Binary to Hexidecimal</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$010101$</td>\n  <td>$0x15$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_dig</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science.decimal_to_bcd", "modulename": "mathgenerator.computer_science", "qualname": "decimal_to_bcd", "kind": "function", "doc": "<p>Decimal to Binary Coded Decimal</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>BCD of Decimal Number $6575 = $</td>\n  <td>$191015$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_number</span><span class=\"o\">=</span><span class=\"mi\">10000</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science.decimal_to_binary", "modulename": "mathgenerator.computer_science", "qualname": "decimal_to_binary", "kind": "function", "doc": "<p>Decimal to Binary</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Binary of $4 = $</td>\n  <td>$100$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_dec</span><span class=\"o\">=</span><span class=\"mi\">99</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science.decimal_to_hexadeci", "modulename": "mathgenerator.computer_science", "qualname": "decimal_to_hexadeci", "kind": "function", "doc": "<p>Decimal to Hexadecimal</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Hexadecimal of $410 = $</td>\n  <td>$0x19a$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_dec</span><span class=\"o\">=</span><span class=\"mi\">1000</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science.decimal_to_octal", "modulename": "mathgenerator.computer_science", "qualname": "decimal_to_octal", "kind": "function", "doc": "<p>Decimal to Octal</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>The decimal number $3698$ in octal is:</td>\n  <td>$0o7162$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_decimal</span><span class=\"o\">=</span><span class=\"mi\">4096</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science.fibonacci_series", "modulename": "mathgenerator.computer_science", "qualname": "fibonacci_series", "kind": "function", "doc": "<p>Fibonacci Series</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>The Fibonacci Series of the first ${n}$ numbers is ?</td>\n  <td>$0, 1, 1, 2, 3, 5, 8, 13, 21$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_no</span><span class=\"o\">=</span><span class=\"mi\">1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science.modulo_division", "modulename": "mathgenerator.computer_science", "qualname": "modulo_division", "kind": "function", "doc": "<p>Modulo Division</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$43$ % $33 = $</td>\n  <td>$10$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_res</span><span class=\"o\">=</span><span class=\"mi\">99</span>, </span><span class=\"param\"><span class=\"n\">max_modulo</span><span class=\"o\">=</span><span class=\"mi\">99</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.computer_science.nth_fibonacci_number", "modulename": "mathgenerator.computer_science", "qualname": "nth_fibonacci_number", "kind": "function", "doc": "<p>nth Fibonacci number</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>What is the 85th Fibonacci number?</td>\n  <td>$259695496911123328$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_n</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry", "modulename": "mathgenerator.geometry", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "mathgenerator.geometry.angle_btw_vectors", "modulename": "mathgenerator.geometry", "qualname": "angle_btw_vectors", "kind": "function", "doc": "<p>Angle between 2 vectors</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>angle between the vectors $[363.84, 195.54, 997.08, 39.26, 60.14, 722.7, 888.57, 713.15, 436.22, 712.23, 349.23, 595.91, 191.8, 824.58, 861.56, 122.73, 815.14, 700.68, 506.5]$ and $[760.85, 934.67, 513.37, 796.93, 809.97, 423.54, 162.69, 758.96, 133.42, 478.14, 771.84, 824.88, 483.07, 134.41, 954.41, 893.42, 191.01, 453.97, 648.59]$ is:</td>\n  <td>$0.81$ radians</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_elt_amt</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.angle_regular_polygon", "modulename": "mathgenerator.geometry", "qualname": "angle_regular_polygon", "kind": "function", "doc": "<p>Angle of a Regular Polygon</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find the angle of a regular polygon with $8$ sides</td>\n  <td>$135.0$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_val</span><span class=\"o\">=</span><span class=\"mi\">3</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.arc_length", "modulename": "mathgenerator.geometry", "qualname": "arc_length", "kind": "function", "doc": "<p>Arc length of Angle</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Given radius, $44$ and angle, $184$. Find the arc length of the angle.</td>\n  <td>Arc length of the angle $= 141.30186$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">49</span>, </span><span class=\"param\"><span class=\"n\">max_angle</span><span class=\"o\">=</span><span class=\"mi\">359</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.area_of_circle", "modulename": "mathgenerator.geometry", "qualname": "area_of_circle", "kind": "function", "doc": "<p>Area of Circle</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Area of circle with radius $29=$</td>\n  <td>$2642.08$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.area_of_circle_given_center_and_point", "modulename": "mathgenerator.geometry", "qualname": "area_of_circle_given_center_and_point", "kind": "function", "doc": "<p>Area of Circle given center and a point on circle</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Area of circle with center $(7,-6)$ and passing through $(1.0, -6.0)$ is</td>\n  <td>$113.1$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_coordinate</span><span class=\"o\">=</span><span class=\"mi\">10</span>, </span><span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.area_of_triangle", "modulename": "mathgenerator.geometry", "qualname": "area_of_triangle", "kind": "function", "doc": "<p>Area of Triangle</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Area of triangle with side lengths: $8, 1, 8 = $</td>\n  <td>$3.99$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_a</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_b</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.basic_trigonometry", "modulename": "mathgenerator.geometry", "qualname": "basic_trigonometry", "kind": "function", "doc": "<p>Trigonometric Values</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$\\sin(30) = $</td>\n  <td>$\\frac{1}{2}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">angles</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">30</span><span class=\"p\">,</span> <span class=\"mi\">45</span><span class=\"p\">,</span> <span class=\"mi\">60</span><span class=\"p\">,</span> <span class=\"mi\">90</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">functions</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s1\">&#39;sin&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cos&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tan&#39;</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.circumference", "modulename": "mathgenerator.geometry", "qualname": "circumference", "kind": "function", "doc": "<p>Circumference of Circle</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Circumference of circle with radius $56 = $</td>\n  <td>$351.86$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.complementary_and_supplementary_angle", "modulename": "mathgenerator.geometry", "qualname": "complementary_and_supplementary_angle", "kind": "function", "doc": "<p>Complementary and Supplementary Angle</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>The complementary angle of $15 =$</td>\n  <td>$75$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_supp</span><span class=\"o\">=</span><span class=\"mi\">180</span>, </span><span class=\"param\"><span class=\"n\">max_comp</span><span class=\"o\">=</span><span class=\"mi\">90</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.curved_surface_area_cylinder", "modulename": "mathgenerator.geometry", "qualname": "curved_surface_area_cylinder", "kind": "function", "doc": "<p>Curved surface area of a cylinder</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>What is the curved surface area of a cylinder of radius, $44$ and height, $92$?</td>\n  <td>$25434.33$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">49</span>, </span><span class=\"param\"><span class=\"n\">max_height</span><span class=\"o\">=</span><span class=\"mi\">99</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.degree_to_rad", "modulename": "mathgenerator.geometry", "qualname": "degree_to_rad", "kind": "function", "doc": "<p>Degrees to Radians</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Angle $113$ degrees in radians is:</td>\n  <td>$1.97$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_deg</span><span class=\"o\">=</span><span class=\"mi\">360</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.equation_of_line_from_two_points", "modulename": "mathgenerator.geometry", "qualname": "equation_of_line_from_two_points", "kind": "function", "doc": "<p>Equation of line from two points</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>What is the equation of the line between points $(13,9)$ and $(6,-19)$ in slope-intercept form?</td>\n  <td>$y = 4x -43$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_coordinate</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">min_coordinate</span><span class=\"o\">=-</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.fourth_angle_of_quadrilateral", "modulename": "mathgenerator.geometry", "qualname": "fourth_angle_of_quadrilateral", "kind": "function", "doc": "<p>Fourth Angle of Quadrilateral</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Fourth angle of quadrilateral with angles $162 , 43, 78 =$</td>\n  <td>$77$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_angle</span><span class=\"o\">=</span><span class=\"mi\">180</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.perimeter_of_polygons", "modulename": "mathgenerator.geometry", "qualname": "perimeter_of_polygons", "kind": "function", "doc": "<p>Perimeter of Polygons</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>The perimeter of a $4$ sided polygon with lengths of $30, 105, 78, 106$cm is:</td>\n  <td>$319$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_sides</span><span class=\"o\">=</span><span class=\"mi\">12</span>, </span><span class=\"param\"><span class=\"n\">max_length</span><span class=\"o\">=</span><span class=\"mi\">120</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.pythagorean_theorem", "modulename": "mathgenerator.geometry", "qualname": "pythagorean_theorem", "kind": "function", "doc": "<p>Pythagorean Theorem</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>What is the hypotenuse of a right triangle given the other two sides have lengths $9$ and $10$?</td>\n  <td>$13.45$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_length</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.radian_to_deg", "modulename": "mathgenerator.geometry", "qualname": "radian_to_deg", "kind": "function", "doc": "<p>Radians to Degrees</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_rad</span><span class=\"o\">=</span><span class=\"mf\">6.28</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.sector_area", "modulename": "mathgenerator.geometry", "qualname": "sector_area", "kind": "function", "doc": "<p>Area of a Sector</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>What is the area of a sector with radius $42$ and angle $83$ degrees?</td>\n  <td>$1277.69$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">49</span>, </span><span class=\"param\"><span class=\"n\">max_angle</span><span class=\"o\">=</span><span class=\"mi\">359</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.sum_of_polygon_angles", "modulename": "mathgenerator.geometry", "qualname": "sum_of_polygon_angles", "kind": "function", "doc": "<p>Sum of Angles of Polygon</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>What is the sum of interior angles of a polygon with $8$ sides?</td>\n  <td>$1080$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_sides</span><span class=\"o\">=</span><span class=\"mi\">12</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.surface_area_cone", "modulename": "mathgenerator.geometry", "qualname": "surface_area_cone", "kind": "function", "doc": "<p>Surface area of a cone</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Surface area of cone with height $= 26m$ and radius $= 6m$ is</td>\n  <td>$616 m^2$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_height</span><span class=\"o\">=</span><span class=\"mi\">50</span>, </span><span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.surface_area_cube", "modulename": "mathgenerator.geometry", "qualname": "surface_area_cube", "kind": "function", "doc": "<p>Surface area of a cube</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Surface area of cube with side $= 6m$ is</td>\n  <td>$216 m^2$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_side</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.surface_area_cuboid", "modulename": "mathgenerator.geometry", "qualname": "surface_area_cuboid", "kind": "function", "doc": "<p>Surface area of a cuboid</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Surface area of cuboid with sides of lengths: $11m, 20m, 8m$ is</td>\n  <td>$936 m^2$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_side</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.surface_area_cylinder", "modulename": "mathgenerator.geometry", "qualname": "surface_area_cylinder", "kind": "function", "doc": "<p>Surface area of a cylinder</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Surface area of cylinder with height $= 26m$ and radius $= 15m$ is</td>\n  <td>$3864 m^2$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_height</span><span class=\"o\">=</span><span class=\"mi\">50</span>, </span><span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.surface_area_pyramid", "modulename": "mathgenerator.geometry", "qualname": "surface_area_pyramid", "kind": "function", "doc": "<p>Surface area of a pyramid</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Surface area of pyramid with base length $= 30m$, base width $= 40m$, and height $= 25m$ is</td>\n  <td>$2400 m^2$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.surface_area_sphere", "modulename": "mathgenerator.geometry", "qualname": "surface_area_sphere", "kind": "function", "doc": "<p>Surface area of a sphere</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Surface area of a sphere with radius $= 8m$ is</td>\n  <td>$804.25 m^2$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_side</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.third_angle_of_triangle", "modulename": "mathgenerator.geometry", "qualname": "third_angle_of_triangle", "kind": "function", "doc": "<p>Third Angle of Triangle</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Third angle of triangle with angles $10$ and $22 =$</td>\n  <td>$148$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_angle</span><span class=\"o\">=</span><span class=\"mi\">89</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.valid_triangle", "modulename": "mathgenerator.geometry", "qualname": "valid_triangle", "kind": "function", "doc": "<p>Valid Triangle</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Does triangel with sides $10, 31$ and $14$ exist?</td>\n  <td>No</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_side_length</span><span class=\"o\">=</span><span class=\"mi\">50</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.volume_cone", "modulename": "mathgenerator.geometry", "qualname": "volume_cone", "kind": "function", "doc": "<p>Volume of a cone</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Volume of cone with height $= 44m$ and radius $= 11m$ is</td>\n  <td>$5575 m^3$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_height</span><span class=\"o\">=</span><span class=\"mi\">50</span>, </span><span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.volume_cube", "modulename": "mathgenerator.geometry", "qualname": "volume_cube", "kind": "function", "doc": "<p>Volume of a cube</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Volume of a cube with a side length of $19m$ is</td>\n  <td>$6859 m^3$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_side</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.volume_cuboid", "modulename": "mathgenerator.geometry", "qualname": "volume_cuboid", "kind": "function", "doc": "<p>Volume of a cuboid</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Volume of cuboid with sides = $17m, 11m, 13m$ is</td>\n  <td>$2431 m^3$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_side</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.volume_cylinder", "modulename": "mathgenerator.geometry", "qualname": "volume_cylinder", "kind": "function", "doc": "<p>Volume of a cylinder</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Volume of cylinder with height $= 3m$ and radius $= 10m$ is</td>\n  <td>$942 m^3$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_height</span><span class=\"o\">=</span><span class=\"mi\">50</span>, </span><span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.volume_cone_frustum", "modulename": "mathgenerator.geometry", "qualname": "volume_cone_frustum", "kind": "function", "doc": "<p>Volume of the frustum of a cone</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Volume of frustum with height $= 30m$ and $r1 = 20m$ is and $r2 = 8m$ is</td>\n  <td>$19603.54 m^3$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_r1</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_r2</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_height</span><span class=\"o\">=</span><span class=\"mi\">50</span>, </span><span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.volume_hemisphere", "modulename": "mathgenerator.geometry", "qualname": "volume_hemisphere", "kind": "function", "doc": "<p>Volume of a hemisphere</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Volume of hemisphere with radius $32m =$</td>\n  <td>$68629.14 m^3$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.volume_pyramid", "modulename": "mathgenerator.geometry", "qualname": "volume_pyramid", "kind": "function", "doc": "<p>Volume of a pyramid</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Volume of pyramid with base length $= 7 m$, base width $= 18 m$ and height $= 42 m$ is</td>\n  <td>$1764.0 m^3$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_length</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_width</span><span class=\"o\">=</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_height</span><span class=\"o\">=</span><span class=\"mi\">50</span>, </span><span class=\"param\"><span class=\"n\">unit</span><span class=\"o\">=</span><span class=\"s1\">&#39;m&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.geometry.volume_sphere", "modulename": "mathgenerator.geometry", "qualname": "volume_sphere", "kind": "function", "doc": "<p>Volume of a sphere</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Volume of sphere with radius $30 m = $</td>\n  <td>$113097.36 m^3$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_radius</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc", "modulename": "mathgenerator.misc", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "mathgenerator.misc.arithmetic_progression_sum", "modulename": "mathgenerator.misc", "qualname": "arithmetic_progression_sum", "kind": "function", "doc": "<p>Arithmetic Progression Sum</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find the sum of first $44$ terms of the AP series: $49, 145, 241 ... $</td>\n  <td>$92972.0$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_d</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">max_a</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">max_n</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.arithmetic_progression_term", "modulename": "mathgenerator.misc", "qualname": "arithmetic_progression_term", "kind": "function", "doc": "<p>Arithmetic Progression Term</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find term number $12$ of the AP series: $-54, 24, 102 ... $</td>\n  <td>$804$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_d</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">max_a</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">max_n</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.base_conversion", "modulename": "mathgenerator.misc", "qualname": "base_conversion", "kind": "function", "doc": "<p>Base Conversion</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Convert $45204$ from base $10$ to base $4$</td>\n  <td>$23002110$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_num</span><span class=\"o\">=</span><span class=\"mi\">60000</span>, </span><span class=\"param\"><span class=\"n\">max_base</span><span class=\"o\">=</span><span class=\"mi\">16</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.binomial_distribution", "modulename": "mathgenerator.misc", "qualname": "binomial_distribution", "kind": "function", "doc": "<p>Binomial distribution</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>A manufacturer of metal pistons finds that, on average, $30.56$% of the pistons they manufacture are rejected because they are incorrectly sized. What is the probability that a batch of $20$ pistons will contain no more than $2$ rejected pistons?</td>\n  <td>$3.17$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.celsius_to_fahrenheit", "modulename": "mathgenerator.misc", "qualname": "celsius_to_fahrenheit", "kind": "function", "doc": "<p>Celsius to Fahrenheit</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Convert $-46$ degrees Celsius to degrees Fahrenheit</td>\n  <td>$-50.8$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_temp</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.common_factors", "modulename": "mathgenerator.misc", "qualname": "common_factors", "kind": "function", "doc": "<p>Common Factors</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Common Factors of $100$ and $44 = $</td>\n  <td>$[1, 2, 4]$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.complex_to_polar", "modulename": "mathgenerator.misc", "qualname": "complex_to_polar", "kind": "function", "doc": "<p>Complex to polar form</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>$19.42(-19.0\\theta + i-4.0\\theta)$</td>\n  <td>$-2.93$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_real_imaginary_num</span><span class=\"o\">=-</span><span class=\"mi\">20</span>, </span><span class=\"param\"><span class=\"n\">max_real_imaginary_num</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.decimal_to_roman_numerals", "modulename": "mathgenerator.misc", "qualname": "decimal_to_roman_numerals", "kind": "function", "doc": "<p>Decimal to Roman Numerals</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>The number $92$ in roman numerals is:</td>\n  <td>$XCII$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_decimal</span><span class=\"o\">=</span><span class=\"mi\">4000</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.euclidian_norm", "modulename": "mathgenerator.misc", "qualname": "euclidian_norm", "kind": "function", "doc": "<p>Euclidian norm or L2 norm of a vector</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Euclidian norm or L2 norm of the vector $[659.9225071540442, 243.40887829281564, 128.79950053874424, 263.19226900031344]$ is:</td>\n  <td>$761.97$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">maxEltAmt</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.factors", "modulename": "mathgenerator.misc", "qualname": "factors", "kind": "function", "doc": "<p>Factors of a number</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Factors of $176 = $</td>\n  <td>$[1, 2, 4, 8, 11, 16, 22, 44, 88, 176]$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">1000</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.geometric_mean", "modulename": "mathgenerator.misc", "qualname": "geometric_mean", "kind": "function", "doc": "<p>Geometric Mean of N Numbers</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Geometric mean of $3$ numbers $[72, 21, 87] = $</td>\n  <td>$50.86$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_value</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">max_count</span><span class=\"o\">=</span><span class=\"mi\">4</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.geometric_progression", "modulename": "mathgenerator.misc", "qualname": "geometric_progression", "kind": "function", "doc": "<p>Geometric Progression</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>For the given GP $[11, 44, 176, 704, 2816, 11264]$. Find the value of a common ratio, 7th term value, sum upto 10th term</td>\n  <td>The value of a is $11$, common ratio is $4$ , 7th term is $45056$, sum upto 10th term is $3844775.0$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">number_values</span><span class=\"o\">=</span><span class=\"mi\">6</span>, </span><span class=\"param\"><span class=\"n\">min_value</span><span class=\"o\">=</span><span class=\"mi\">2</span>, </span><span class=\"param\"><span class=\"n\">max_value</span><span class=\"o\">=</span><span class=\"mi\">12</span>, </span><span class=\"param\"><span class=\"n\">n_term</span><span class=\"o\">=</span><span class=\"mi\">7</span>, </span><span class=\"param\"><span class=\"n\">sum_term</span><span class=\"o\">=</span><span class=\"mi\">5</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.harmonic_mean", "modulename": "mathgenerator.misc", "qualname": "harmonic_mean", "kind": "function", "doc": "<p>Harmonic Mean of N Numbers</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Harmonic mean of $4$ numbers $52, 56, 25, 57 = $</td>\n  <td>$602.33$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_value</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">max_count</span><span class=\"o\">=</span><span class=\"mi\">4</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.is_leap_year", "modulename": "mathgenerator.misc", "qualname": "is_leap_year", "kind": "function", "doc": "<p>Is Leap Year or Not</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Is $2000$ a leap year?</td>\n  <td>$2000$ is a leap year</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">minNumber</span><span class=\"o\">=</span><span class=\"mi\">1900</span>, </span><span class=\"param\"><span class=\"n\">max_number</span><span class=\"o\">=</span><span class=\"mi\">2099</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.lcm", "modulename": "mathgenerator.misc", "qualname": "lcm", "kind": "function", "doc": "<p>LCM (Least Common Multiple)</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>LCM of $3$ and $18 = $</td>\n  <td>$18$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.minutes_to_hours", "modulename": "mathgenerator.misc", "qualname": "minutes_to_hours", "kind": "function", "doc": "<p>Convert minutes to hours and minutes</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Convert $836$ minutes to hours &amp; minutes</td>\n  <td>$13$ hours and $56$ minutes</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_minutes</span><span class=\"o\">=</span><span class=\"mi\">999</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.prime_factors", "modulename": "mathgenerator.misc", "qualname": "prime_factors", "kind": "function", "doc": "<p>Prime Factors</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find prime factors of $30$</td>\n  <td>$2, 3, 5$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_val</span><span class=\"o\">=</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">200</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.product_of_scientific_notations", "modulename": "mathgenerator.misc", "qualname": "product_of_scientific_notations", "kind": "function", "doc": "<p>Product of scientific notations</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Product of scientific notations $5.11 \\times 10^{67}$ and $3.64 \\times 10^{-59} = $</td>\n  <td>$1.86 \\times 10^{9}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_exp_val</span><span class=\"o\">=-</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">max_exp_val</span><span class=\"o\">=</span><span class=\"mi\">100</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.profit_loss_percent", "modulename": "mathgenerator.misc", "qualname": "profit_loss_percent", "kind": "function", "doc": "<p>Profit or Loss Percent</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Loss percent when $CP = 751$ and $SP = 290$ is:</td>\n  <td>$61.38$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_cp</span><span class=\"o\">=</span><span class=\"mi\">1000</span>, </span><span class=\"param\"><span class=\"n\">max_sp</span><span class=\"o\">=</span><span class=\"mi\">1000</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.quotient_of_power_same_base", "modulename": "mathgenerator.misc", "qualname": "quotient_of_power_same_base", "kind": "function", "doc": "<p>Quotient of Powers with Same Base</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>The Quotient of $5^{6}$ and $5^{8} = 5^{6-8} = 5^{-2}$</td>\n  <td>$0.04$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_base</span><span class=\"o\">=</span><span class=\"mi\">50</span>, </span><span class=\"param\"><span class=\"n\">max_power</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.quotient_of_power_same_power", "modulename": "mathgenerator.misc", "qualname": "quotient_of_power_same_power", "kind": "function", "doc": "<p>Quotient of Powers with Same Power</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>The quotient of $19^{8}$ and $10^{8} = (19/10)^8 = 1.9^{8}$</td>\n  <td>$169.84$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_base</span><span class=\"o\">=</span><span class=\"mi\">50</span>, </span><span class=\"param\"><span class=\"n\">max_power</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.set_operation", "modulename": "mathgenerator.misc", "qualname": "set_operation", "kind": "function", "doc": "<p>Union, Intersection, Difference of Two Sets</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Given the two sets $a={1, 2, 4, 5}$, $b={8, 1, 2}$. Find the Union, intersection, $a-b$, $b-a$, and symmetric difference</td>\n  <td>Union is ${1, 2, 4, 5, 8}$. Intersection is ${1, 2}$, $a-b$ is ${4, 5}$, $b-a$ is ${8}$. Symmetric difference is ${4, 5, 8}$.</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">min_size</span><span class=\"o\">=</span><span class=\"mi\">3</span>, </span><span class=\"param\"><span class=\"n\">max_size</span><span class=\"o\">=</span><span class=\"mi\">7</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.signum_function", "modulename": "mathgenerator.misc", "qualname": "signum_function", "kind": "function", "doc": "<p>Signum Function</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Signum of $-229$ is =</td>\n  <td>$-1$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"nb\">min</span><span class=\"o\">=-</span><span class=\"mi\">999</span>, </span><span class=\"param\"><span class=\"nb\">max</span><span class=\"o\">=</span><span class=\"mi\">999</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.misc.surds_comparison", "modulename": "mathgenerator.misc", "qualname": "surds_comparison", "kind": "function", "doc": "<p>Comparing Surds</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Fill in the blanks $42^{\\frac{1}{2}}$ _ $45^{\\frac{1}{5}}$</td>\n  <td>$&gt;$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_value</span><span class=\"o\">=</span><span class=\"mi\">100</span>, </span><span class=\"param\"><span class=\"n\">max_root</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.statistics", "modulename": "mathgenerator.statistics", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "mathgenerator.statistics.combinations", "modulename": "mathgenerator.statistics", "qualname": "combinations", "kind": "function", "doc": "<p>Combinations of Objects</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find the number of combinations from $19$ objects picked $6$ at a time.</td>\n  <td>$27132$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_lengthgth</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.statistics.conditional_probability", "modulename": "mathgenerator.statistics", "qualname": "conditional_probability", "kind": "function", "doc": "<p>Conditional Probability</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Someone tested positive for a nasty disease which only $1.18$% of the population have. Test sensitivity (true positive) is equal to $SN=98.73$% whereas test specificity (true negative) $SP=99.99$%. What is the probability that this guy really has that disease?</td>\n  <td>$99.16$%</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.statistics.confidence_interval", "modulename": "mathgenerator.statistics", "qualname": "confidence_interval", "kind": "function", "doc": "<p>Confidence interval For sample S</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>The confidence interval for sample $[234, 223, 210, 203, 258, 299, 281, 208, 278, 252, 295, 245, 280, 235, 219, 297, 214, 267, 212, 256, 232, 221]$ with $99$% confidence is</td>\n  <td>$(263.31, 229.33)$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.statistics.data_summary", "modulename": "mathgenerator.statistics", "qualname": "data_summary", "kind": "function", "doc": "<p>Mean, Standard Deviation and Variance</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Find the mean,standard deviation and variance for the data $9, 29, 46, 27, 46, 15, 10, 44, 19, 33, 38, 7, 34, 28, 8$</td>\n  <td>The Mean is $26.2$, Standard Deviation is $186.29$, Variance is $13.65$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">number_values</span><span class=\"o\">=</span><span class=\"mi\">15</span>, </span><span class=\"param\"><span class=\"n\">min_val</span><span class=\"o\">=</span><span class=\"mi\">5</span>, </span><span class=\"param\"><span class=\"n\">max_val</span><span class=\"o\">=</span><span class=\"mi\">50</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.statistics.dice_sum_probability", "modulename": "mathgenerator.statistics", "qualname": "dice_sum_probability", "kind": "function", "doc": "<p>Probability of a certain sum appearing on faces of dice</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>If $2$ dice are rolled at the same time, the probability of getting a sum of $5 =$</td>\n  <td>$\\frac{4}{36}$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_dice</span><span class=\"o\">=</span><span class=\"mi\">3</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.statistics.mean_median", "modulename": "mathgenerator.statistics", "qualname": "mean_median", "kind": "function", "doc": "<p>Mean and Median</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Given the series of numbers $[4, 19, 21, 22, 43, 44, 60, 81, 87, 92]$. Find the arithmatic mean and median of the series</td>\n  <td>Arithmetic mean of the series is $47.3$ and arithmetic median of this series is $43.5$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_length</span><span class=\"o\">=</span><span class=\"mi\">10</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "mathgenerator.statistics.permutation", "modulename": "mathgenerator.statistics", "qualname": "permutation", "kind": "function", "doc": "<p>Permutations</p>\n\n<table>\n<thead>\n<tr>\n  <th>Ex. Problem</th>\n  <th>Ex. Solution</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>Number of Permutations from $18$ objects picked $5$ at a time is:</td>\n  <td>$1028160$</td>\n</tr>\n</tbody>\n</table>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">max_lengthgth</span><span class=\"o\">=</span><span class=\"mi\">20</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();