<?php
/**
 * This file is part of http://github.com/LukeBeer/BroadworksOCIP
 * 
 * (c) 2013-2015 Luke Berezynskyj <eat.lemons@gmail.com>
 */

namespace BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\Services\OCISchemaServiceInstantConferencing; 

use BroadworksOCIP\Builder\Types\TableType;
use BroadworksOCIP\Builder\Types\ComplexInterface;
use BroadworksOCIP\Builder\Types\ComplexType;
use BroadworksOCIP\Response\ResponseOutput;
use BroadworksOCIP\Client\Client;


/**
 * Response to the UserInstantConferencingGetConferenceRecordingListRequest.
 *         Contains a table with column headings:
 *         "Bridge Service User Id", "Bridge Name", "Recording Id",
 *         "Owner User Id", "Owner Last Name", "Owner First Name", "Owner Hiragana Last Name", "Owner Hiragana First Name",
 *         "Title", "Start Date", "Start Time", and "Duration".
 */
class UserInstantConferencingGetConferenceRecordingListResponse extends ComplexType implements ComplexInterface
{
    public    $elementName = 'UserInstantConferencingGetConferenceRecordingListResponse';
    protected $conferenceRecordingTable;

    /**
     * @return \BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\Services\OCISchemaServiceInstantConferencing\UserInstantConferencingGetConferenceRecordingListResponse $response
     */
    public function get(Client $client, $responseOutput = ResponseOutput::STD)
    {
        return $this->send($client, $responseOutput);
    }

    /**
     * 
     */
    public function setConferenceRecordingTable(TableType $conferenceRecordingTable = null)
    {
        $this->conferenceRecordingTable = $conferenceRecordingTable;
        $this->conferenceRecordingTable->setElementName('conferenceRecordingTable');
        return $this;
    }

    /**
     * 
     * @return TableType
     */
    public function getConferenceRecordingTable()
    {
        return $this->conferenceRecordingTable;
    }
}
