<?php
/**
 * This file is part of http://github.com/LukeBeer/BroadworksOCIP
 * 
 * (c) 2013-2015 Luke Berezynskyj <eat.lemons@gmail.com>
 */

namespace BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\Services\OCISchemaServiceCallRecording; 

use BroadworksOCIP\Builder\Types\SimpleType;
use BroadworksOCIP\Builder\Restrictions\Enumeration;


/**
 * Media Stream Type.  Subscriber's media is sent separately from the media generated by the called/calling parties when "Dual" is selected while "Single" is a single media stream that contains all media.
 */
class MediaStream extends SimpleType
{
    public $elementName = "MediaStream";
    public function __construct($value) {
        $this->setElementValue($value);
        $this->addRestriction(new Enumeration([
            'Dual',
            'Single'
        ]));
    }
}
