<?php
/**
 * This file is part of http://github.com/LukeBeer/BroadworksOCIP
 * 
 * (c) 2013-2015 Luke Berezynskyj <eat.lemons@gmail.com>
 */

namespace BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\Services\OCISchemaServiceAttendantConsole; 

use BroadworksOCIP\Builder\Types\SimpleType;
use BroadworksOCIP\Builder\Restrictions\Enumeration;


/**
 * Attendant Console Display Columns.
 */
class AttendantConsoleDisplayColumn extends SimpleType
{
    public $elementName = "AttendantConsoleDisplayColumn";
    public function __construct($value) {
        $this->setElementValue($value);
        $this->addRestriction(new Enumeration([
            'Action',
            'Department',
            'Email',
            'Extension',
            'Mobile',
            'Name',
            'Phone Number',
            'Pager',
            'Status',
            'Title'
        ]));
    }
}
