<?php
/**
 * This file is part of http://github.com/LukeBeer/BroadworksOCIP
 * 
 * (c) 2013-2015 Luke Berezynskyj <eat.lemons@gmail.com>
 */

namespace BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\OCISchemaUser; 

use BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\OCISchemaDataTypes\UserId;
use BroadworksOCIP\Builder\Types\ComplexInterface;
use BroadworksOCIP\Builder\Types\ComplexType;
use BroadworksOCIP\Response\ResponseOutput;
use BroadworksOCIP\Client\Client;


/**
 * Modify the user id of a real or virtual user.
 *         The response is either a SuccessResponse or an ErrorResponse.
 */
class UserModifyUserIdRequest extends ComplexType implements ComplexInterface
{
    public    $elementName = 'UserModifyUserIdRequest';
    protected $userId;
    protected $newUserId;

    public function __construct(
         $userId = '',
         $newUserId = ''
    ) {
        $this->setUserId($userId);
        $this->setNewUserId($newUserId);
    }

    /**
     * @return mixed $response
     */
    public function get(Client $client, $responseOutput = ResponseOutput::STD)
    {
        return $this->send($client, $responseOutput);
    }

    /**
     * 
     */
    public function setUserId($userId = null)
    {
        $this->userId = ($userId InstanceOf UserId)
             ? $userId
             : new UserId($userId);
        $this->userId->setElementName('userId');
        return $this;
    }

    /**
     * 
     * @return UserId $userId
     */
    public function getUserId()
    {
        return ($this->userId)
            ? $this->userId->getElementValue()
            : null;
    }

    /**
     * 
     */
    public function setNewUserId($newUserId = null)
    {
        $this->newUserId = ($newUserId InstanceOf UserId)
             ? $newUserId
             : new UserId($newUserId);
        $this->newUserId->setElementName('newUserId');
        return $this;
    }

    /**
     * 
     * @return UserId $newUserId
     */
    public function getNewUserId()
    {
        return ($this->newUserId)
            ? $this->newUserId->getElementValue()
            : null;
    }
}
