<?php
/**
 * This file is part of http://github.com/LukeBeer/BroadworksOCIP
 * 
 * (c) 2013-2015 Luke Berezynskyj <eat.lemons@gmail.com>
 */

namespace BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\OCISchemaSystem; 

use BroadworksOCIP\Builder\Types\TableType;
use BroadworksOCIP\Builder\Types\ComplexInterface;
use BroadworksOCIP\Builder\Types\ComplexType;
use BroadworksOCIP\Response\ResponseOutput;
use BroadworksOCIP\Client\Client;


/**
 * Response to SystemSIPGetContentTypeListRequest.
 *         Returns a 2 column table with column headings:
 *           "Content Type" and "Supported Interface".
 */
class SystemSIPGetContentTypeListResponse extends ComplexType implements ComplexInterface
{
    public    $elementName = 'SystemSIPGetContentTypeListResponse';
    protected $contentTypeTable;

    /**
     * @return \BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\OCISchemaSystem\SystemSIPGetContentTypeListResponse $response
     */
    public function get(Client $client, $responseOutput = ResponseOutput::STD)
    {
        return $this->send($client, $responseOutput);
    }

    /**
     * 
     */
    public function setContentTypeTable(TableType $contentTypeTable = null)
    {
        $this->contentTypeTable = $contentTypeTable;
        $this->contentTypeTable->setElementName('contentTypeTable');
        return $this;
    }

    /**
     * 
     * @return TableType
     */
    public function getContentTypeTable()
    {
        return $this->contentTypeTable;
    }
}
