<?php
/**
 * This file is part of http://github.com/LukeBeer/BroadworksOCIP
 * 
 * (c) 2013-2015 Luke Berezynskyj <eat.lemons@gmail.com>
 */

namespace BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\OCISchemaEnterprise; 

use BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\OCISchemaDataTypes\PhoneListEntry;
use BroadworksOCIP\Builder\Types\ComplexInterface;
use BroadworksOCIP\Builder\Types\ComplexType;
use BroadworksOCIP\Response\ResponseOutput;
use BroadworksOCIP\Client\Client;


/**
 * Response to the EnterpriseCommonPhoneListGetListRequest.
 *         The response contains the enterprise's common phone list.
 */
class EnterpriseCommonPhoneListGetListResponse extends ComplexType implements ComplexInterface
{
    public    $elementName = 'EnterpriseCommonPhoneListGetListResponse';
    protected $entry;

    /**
     * @return \BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\OCISchemaEnterprise\EnterpriseCommonPhoneListGetListResponse $response
     */
    public function get(Client $client, $responseOutput = ResponseOutput::STD)
    {
        return $this->send($client, $responseOutput);
    }

    /**
     * 
     */
    public function setEntry(PhoneListEntry $entry = null)
    {
        $this->entry = ($entry InstanceOf PhoneListEntry)
             ? $entry
             : new PhoneListEntry($entry);
        $this->entry->setElementName('entry');
        return $this;
    }

    /**
     * 
     * @return PhoneListEntry $entry
     */
    public function getEntry()
    {
        return $this->entry;
    }
}
