<?php
/**
 * This file is part of http://github.com/LukeBeer/BroadworksOCIP
 * 
 * (c) 2013-2015 Luke Berezynskyj <eat.lemons@gmail.com>
 */

namespace BroadworksOCIP\api\Rel_17_sp4_1_197_OCISchemaAS\OCISchemaDataTypes; 

use BroadworksOCIP\Builder\Types\SimpleType;
use BroadworksOCIP\Builder\Restrictions\MinLength;
use BroadworksOCIP\Builder\Restrictions\MaxLength;


/**
 * Ha1 Complement of a Http Digest Authentication.
 */
class DigestHa1Complement extends SimpleType
{
    public $elementName = "DigestHa1Complement";
    public function __construct($value) {
        $this->setElementValue($value);
        $this->addRestriction(new MinLength("32"));
        $this->addRestriction(new MaxLength("256"));
    }
}
