<div align="center">

# Panel Colorizer

[![AUR version](https://img.shields.io/aur/version/plasma6-applets-panel-colorizer?logo=archlinux&labelColor=2d333b&color=1f425f)](https://aur.archlinux.org/packages/plasma6-applets-panel-colorizer)
[![Dynamic JSON Badge](https://img.shields.io/badge/dynamic/json?url=https%3A%2F%2Fraw.githubusercontent.com%2Fluisbocanegra%2Fplasma-panel-colorizer%2Fmain%2Fpackage%2Fmetadata.json&query=KPlugin.Version&color=1f425f&labelColor=2d333b&logo=kde&label=KDE%20Store)](https://store.kde.org/p/2130967) [![nixpkgs unstable package](https://repology.org/badge/version-for-repo/nix_unstable/plasma-panel-colorizer.svg)](https://repology.org/project/plasma-panel-colorizer/versions)

Fully-featured widget to bring Latte-Dock and WM status bar customization features to the default Plasma panel.

![panel](screenshots/panel.png)

</div>

## Demo

[![Demo](https://img.shields.io/badge/watch%20on%20youtube-demo?logo=youtube&logoColor=white&labelColor=%23c30000&color=%23222222
)](https://www.youtube.com/watch?v=0QLyEexa9Y4)

<details>
    <summary>Screenshots</summary>

![tooltip](screenshots/settings.png)

</details>

## Features

<details>
    <summary>Expand</summary>

### Presets

* [Built-in presets](https://github.com/luisbocanegra/plasma-panel-colorizer/tree/main/package/contents/ui/presets)
* Create your own presets
* Preset auto-loading
  * Floating panel
  * Maximized window shown
  * Window touching panel

### Panel/Widget/System Tray elements

* Color modes
  * Static
  * ~~Animated~~ removed in v1.0.0, might re-implement in a future version
* Background / Icons and text color
  * Custom
  * System
  * Custom list
  * Random
  * Follow parent background
* Shape
  * Spacing between widgets
  * Radius
  * Margins
  * Border
  * Shadow
* Blur behind (requires building and installing the C++ plugin)

### Force Text/Icon color

* Force color to icons that don't follow the theme color for specific widgets
  * Mask for symbolic icons
  * Effect for colorful icons
* Periodic color refresh for widgets that reset colors when they update (e.g Global Menu)
* Recolor applications System Tray icons

### Panel background

* Remove native panel background (transparent)
* Native panel background opacity
* Simulate an always floating panel

### Unified background

* Join one or more widgets to make them visually connected

### Configuration overrides

Overrides let you give a completely different configuration to one or more widgets

* Preset overrides (saved in the current preset)
* User overrides (sour own overrides that apply over the preset configuration and overrides)

</details>

## Installing

> [!IMPORTANT]
> This widget makes temporary changes to internal parts to the panel that aren't meant to be changed externally.
>
> Make sure you're using the latest version of the widget and Plasma to avoid compatibility issues.
>
> If you found a bug while using Panel Colorizer please report it [here](https://github.com/luisbocanegra/plasma-panel-colorizer/issues?q=sort%3Aupdated-desc+is%3Aissue+is%3Aopen) first, only report it to KDE after we conclude is a upstream issue or you removed the widget and can still reproduce the problem.

### KDE Store

1. **Right click on the Panel** > **Add or manage widgets** > **Add new...** > **Download new...**
2. **Search** for "**Panel Colorizer**", install and add it to a Panel.

* ~~[Plasma 5](https://store.kde.org/p/2131149) version v0.2.0~~ **[No longer maintained](https://github.com/luisbocanegra/plasma-panel-colorizer/issues/10)**

* [Plasma 6](https://store.kde.org/p/2130967)

### Manually

1. Install these dependencies or the equivalents for your distribution

   * Arch

      ```txt
      git gcc cmake extra-cmake-modules libplasma spectacle
      ```

   * Fedora

      ```txt
      git gcc-c++ cmake extra-cmake-modules libplasma-devel spectacle
      ```

    Spectacle is optional, will be used to create preset previews

2. Clone and install

      ```sh
      git clone https://github.com/luisbocanegra/plasma-panel-colorizer
      cd plasma-panel-colorizer
      ```

   * Install widget + plugin

    ```sh
    ./install.sh
    ```

   * Install only the plugin if you already have the widget

   ```sh
   ./install-plugin.sh
   ```

### Arch Linux

[aur/plasma6-applets-panel-colorizer](https://aur.archlinux.org/packages/plasma6-applets-panel-colorizer) use your preferred AUR helper e.g:

```sh
yay -S plasma6-applets-panel-colorizer
```

### Nix package

For those using NixOS or the Nix package manager, a Nix package is available in nixpkgs-unstable.

To install the widget use one of these methods:

* NixOS

  ```nix
  environment.systemPackages = with pkgs; [
    plasma-panel-colorizer
  ];
  ```

* [Home-manager](https://github.com/nix-community/home-manager)

  ```nix
  home.packages = with pkgs; [
    plasma-panel-colorizer
  ];
  ```

* [Plasma-manager](https://github.com/nix-community/plasma-manager): If the widget gets added to a panel it will automatically be installed

* Other distros using Nix package manager

  ```sh
  # without flakes:
  nix-env -iA nixpkgs.plasma-panel-colorizer
  # with flakes:
  nix profile install nixpkgs#plasma-panel-colorizer
  ```

## How to use

1. Put the widget on any of your panels
2. Go to the widget settings to change the current panel appearance (right click > Configure...)
3. Widget can set to only show in panel **Edit Mode** (right click > Hide widget or from the widget settings)

## Adding or improving the built-in presets

Instructions to add new presets or improve the existing ones are [here](https://github.com/luisbocanegra/plasma-panel-colorizer/blob/main/package/contents/ui/presets/README.md)

## FAQ

### Are changes permanent?

Changes to the panel are not permanent and can be removed by disabling or removing the widget

### Updated to v1.0.0, where are my presets?

The location where they are stored has changed, the new locations are:

* Presets: `/home/$USER/.config/panel-colorizer/presets/`
* User overrides: `/home/$USER/.config/panel-colorizer/overrides.json`
* Text and icon options: `/home/$USER/.config/panel-colorizer/forceForegroundColor.json`

**The format of the presets has changed, presets from previous version will need to be recreated manually**

### How to restore the default appearance?

* Click on the widget to disable/enable
* Or **Widget Settings** > **Top left** > **Enabled** checkbox
* Or removing the widget from the panel and restarting Plasma/logging out.

**If you are troubleshooting an issue please do the third option and read the notice about reporting bugs at the start of [Install](https://github.com/luisbocanegra/plasma-panel-colorizer?tab=readme-ov-file#installing) section**

### How does it work?

This widget works by inject/managing the background and colors of other widgets and the panel where it is placed.

**Technical**

Backgrounds are drawn by creating rectangle areas bellow widgets/panel, text and icons repaint is done by editing some elements color property and overwriting `Kirigami.Theme.<something>Color` colors for others, while this works for most widgets, there are some that won't because they draw text and icons differently to what this project matches, if you find a widget that doesn't get colors let me know [here](https://github.com/luisbocanegra/plasma-panel-colorizer/issues/12) and I will try supporting it.

**Performance**

I tried to optimize it so CPU usage only increases around 0.5-1% on my computer, but usage could vary depending on your System or how many widgets are in your panels.

### Can this widget change the appearance of other parts of Plasma (e.g Desktop view, widget popups/tooltips, overview)

Only the panel for now, the Desktop widgets might be possible, for the others haven't looked into but most likely not.

## Bug reporting / Feature requests / Contributing

Please read the [Contributing guidelines in this repository](https://github.com/luisbocanegra/plasma-panel-colorizer/blob/main/CONTRIBUTING.md)

## Support the development

* If you like the project please consider donating/sponsoring this and [my other open source work](https://github.com/luisbocanegra?tab=repositories&q=&type=source&language=&sort=stargazers)

  [![GitHub Sponsors](https://img.shields.io/badge/GitHub_Sponsors-supporter?logo=githubsponsors&color=%2329313C)](https://github.com/sponsors/luisbocanegra) [![Ko-fi](https://img.shields.io/badge/Ko--fi-supporter?logo=ko-fi&logoColor=%23ffffff&color=%23467BEB)](https://ko-fi.com/luisbocanegra) [!["Buy Me A Coffee"](https://img.shields.io/badge/Buy%20me%20a%20coffe-supporter?logo=buymeacoffee&logoColor=%23282828&color=%23FF803F)](https://www.buymeacoffee.com/luisbocanegra) [![Liberapay](https://img.shields.io/badge/Liberapay-supporter?logo=liberapay&logoColor=%23282828&color=%23F6C814)](https://liberapay.com/luisbocanegra/) [![PayPal](https://img.shields.io/badge/PayPal-supporter?logo=paypal&logoColor=%23ffffff&color=%23003087)](https://www.paypal.com/donate/?hosted_button_id=Y5TMH3Z4YZRDA)

* [Give it a star on GitHub](https://github.com/luisbocanegra/plasma-panel-colorizer)
* Rate / leave review in the [KDE Store](https://store.kde.org/p/2130967)

## Acknowledgements

* [Search the actual gridLayout of the panel from Plasma panel spacer](https://invent.kde.org/plasma/plasma-workspace/-/blob/Plasma/5.27/applets/panelspacer/package/contents/ui/main.qml?ref_type=heads#L37) code that inspired this project.
* [Google LLC. / Pictogrammers](https://pictogrammers.com/library/mdi/) assets used for panel icon.
* [sanjay-kr-commit/panelTransparencyToggleForPlasma6](https://github.com/sanjay-kr-commit/panelTransparencyToggleForPlasma6) / [psifidotos/paneltransparencybutton](https://github.com/psifidotos/paneltransparencybutton) for the implementation of panel transparency
