export function IconGlobe() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      strokeWidth=".6"
      stroke="currentColor">
      <path
        d="M16 30C23.732 30 30 23.732 30 16C30 8.26801 23.732 2 16 2C8.26801 2 2 8.26801 2 16C2 23.732 8.26801 30 16 30ZM16 4C17.0317 4 18.283 4.94804 19.3347 7.22667C19.7084 8.03639 20.0331 8.9697 20.2941 10H11.7059C11.9669 8.9697 12.2916 8.03639 12.6653 7.22667C13.717 4.94804 14.9683 4 16 4ZM10.8494 6.38855C10.36 7.44883 9.95424 8.66735 9.64867 10H5.60539C6.97928 7.62495 9.1438 5.76448 11.7391 4.77849C11.4088 5.27683 11.1118 5.81994 10.8494 6.38855ZM9.27878 12C9.0968 13.2705 9 14.6141 9 16C9 17.3859 9.0968 18.7295 9.27878 20H4.68282C4.24062 18.7489 4 17.4025 4 16C4 14.5975 4.24062 13.2511 4.68282 12H9.27878ZM9.64867 22C9.95424 23.3327 10.36 24.5512 10.8494 25.6114C11.1118 26.1801 11.4088 26.7232 11.7391 27.2215C9.1438 26.2355 6.97928 24.375 5.60539 22H9.64867ZM11.7059 22H20.2941C20.0331 23.0303 19.7084 23.9636 19.3347 24.7733C18.283 27.052 17.0317 28 16 28C14.9683 28 13.717 27.052 12.6653 24.7733C12.2916 23.9636 11.9669 23.0303 11.7059 22ZM20.6991 20H11.3009C11.1068 18.7518 11 17.4068 11 16C11 14.5932 11.1068 13.2482 11.3009 12H20.6991C20.8932 13.2482 21 14.5932 21 16C21 17.4068 20.8932 18.7518 20.6991 20ZM22.3513 22H26.3946C25.0207 24.375 22.8562 26.2355 20.2609 27.2215C20.5912 26.7232 20.8882 26.1801 21.1506 25.6114C21.64 24.5512 22.0458 23.3327 22.3513 22ZM27.3172 20H22.7212C22.9032 18.7295 23 17.3859 23 16C23 14.6141 22.9032 13.2705 22.7212 12H27.3172C27.7594 13.2511 28 14.5975 28 16C28 17.4025 27.7594 18.7489 27.3172 20ZM20.2609 4.77849C22.8562 5.76448 25.0207 7.62495 26.3946 10H22.3513C22.0458 8.66735 21.64 7.44883 21.1506 6.38855C20.8882 5.81994 20.5912 5.27683 20.2609 4.77849Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconImage() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth=".8"
      stroke="currentColor">
      <path
        d="M18 11C18 9.067 19.567 7.5 21.5 7.5C23.433 7.5 25 9.067 25 11C25 12.933 23.433 14.5 21.5 14.5C19.567 14.5 18 12.933 18 11ZM21.5 9.5C20.6716 9.5 20 10.1716 20 11C20 11.8284 20.6716 12.5 21.5 12.5C22.3284 12.5 23 11.8284 23 11C23 10.1716 22.3284 9.5 21.5 9.5ZM3 7.5C3 5.01472 5.01472 3 7.5 3H24.5C26.9853 3 29 5.01472 29 7.5V24.5C29 26.9853 26.9853 29 24.5 29H7.5C5.01472 29 3 26.9853 3 24.5V7.5ZM7.5 5C6.11929 5 5 6.11929 5 7.5V24.5C5 24.7891 5.04909 25.0668 5.13938 25.3252L14.2323 16.2322C15.2086 15.2559 16.7915 15.2559 17.7678 16.2322L26.8607 25.325C26.9509 25.0667 27 24.7891 27 24.5V7.5C27 6.11929 25.8807 5 24.5 5H7.5ZM25.4994 26.7922L16.3536 17.6464C16.1584 17.4512 15.8418 17.4512 15.6465 17.6464L6.50069 26.7923C6.80674 26.9259 7.14471 27 7.5 27H24.5C24.8553 27 25.1933 26.9259 25.4994 26.7922Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconVideo() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth=".8"
      stroke="currentColor">
      <path
        d="M6.5 4C4.01472 4 2 6.01472 2 8.5V23.5C2 25.9853 4.01472 28 6.5 28H25.5C27.9853 28 30 25.9853 30 23.5V8.5C30 6.01472 27.9853 4 25.5 4H6.5ZM4 8.5C4 7.11929 5.11929 6 6.5 6H25.5C26.8807 6 28 7.11929 28 8.5V23.5C28 24.8807 26.8807 26 25.5 26H6.5C5.11929 26 4 24.8807 4 23.5V8.5ZM12 12.0012V19.9986C12 20.7535 12.8045 21.2362 13.4706 20.8809L20.9675 16.8822C21.6734 16.5058 21.6734 15.4941 20.9675 15.1176L13.4706 11.1189C12.8045 10.7636 12 11.2463 12 12.0012Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconMusic() {
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth=".7"
      stroke="currentColor">
      <path
        d="M19.6977 2.14829C19.8879 2.28981 20 2.51293 20 2.75001V16.25C20 16.2767 19.9986 16.303 19.9959 16.329C19.9986 16.3856 20 16.4427 20 16.5C20 18.433 18.433 20 16.5 20C14.567 20 13 18.433 13 16.5C13 14.567 14.567 13 16.5 13C17.2436 13 17.9331 13.2319 18.5 13.6273V7.75803L10 10.308V18.25C10 18.2766 9.99861 18.303 9.99589 18.3289C9.99862 18.3856 10 18.4426 10 18.5C10 20.433 8.433 22 6.5 22C4.567 22 3 20.433 3 18.5C3 16.567 4.567 15 6.5 15C7.24362 15 7.93308 15.2319 8.5 15.6273V5.75001C8.5 5.4188 8.71725 5.12681 9.03449 5.03164L19.0345 2.03164C19.2616 1.96351 19.5075 2.00677 19.6977 2.14829ZM10 8.74198L18.5 6.19198V3.75803L10 6.30803V8.74198ZM6.5 16.5C5.39543 16.5 4.5 17.3954 4.5 18.5C4.5 19.6046 5.39543 20.5 6.5 20.5C7.60457 20.5 8.5 19.6046 8.5 18.5C8.5 17.3954 7.60457 16.5 6.5 16.5ZM14.5 16.5C14.5 17.6046 15.3954 18.5 16.5 18.5C17.6046 18.5 18.5 17.6046 18.5 16.5C18.5 15.3954 17.6046 14.5 16.5 14.5C15.3954 14.5 14.5 15.3954 14.5 16.5Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconPeople() {
  return (
    <svg
      width="24"
      height="24"
      fill="none"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth=".9"
      stroke="currentColor">
      <path
        d="M17.754 14a2.249 2.249 0 0 1 2.25 2.249v.575c0 .894-.32 1.76-.902 2.438-1.57 1.834-3.957 2.739-7.102 2.739-3.146 0-5.532-.905-7.098-2.74a3.75 3.75 0 0 1-.898-2.435v-.577a2.249 2.249 0 0 1 2.249-2.25h11.501Zm0 1.5H6.253a.749.749 0 0 0-.75.749v.577c0 .536.192 1.054.54 1.461 1.253 1.468 3.219 2.214 5.957 2.214s4.706-.746 5.962-2.214a2.25 2.25 0 0 0 .541-1.463v-.575a.749.749 0 0 0-.749-.75ZM12 2.004a5 5 0 1 1 0 10 5 5 0 0 1 0-10Zm0 1.5a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconSparkle() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1"
      stroke="currentColor">
      <path
        d="M3.39466 13.208C3.6481 13.5582 4.00441 13.8206 4.41394 13.9585L6.81453 14.7397C7.38197 14.9298 7.89731 15.2497 8.31969 15.6739C8.43382 15.7869 8.54054 15.9072 8.63916 16.034C8.90545 16.3777 9.11091 16.7645 9.24663 17.1776L10.0386 19.6088C10.1802 20.0157 10.4451 20.3683 10.7963 20.6176C11.1475 20.8669 11.5676 21.0006 11.9982 21C12.4303 21.0018 12.852 20.8679 13.2041 20.6173C13.5568 20.3568 13.8239 19.9971 13.9713 19.584L14.752 17.1821C14.9416 16.6158 15.2596 16.1011 15.6812 15.6784C16.101 15.2575 16.6134 14.9406 17.1774 14.7532L19.6207 13.9585C20.0239 13.8147 20.3728 13.5497 20.6196 13.1999C20.8671 12.8501 21 12.432 21 12.0034C21 11.5748 20.8671 11.1568 20.6196 10.807C20.353 10.4347 19.9735 10.1585 19.5375 10.0191L17.1324 9.24021C16.5664 9.05314 16.0519 8.7363 15.63 8.31497C15.2081 7.89364 14.8905 7.37948 14.7025 6.81351L13.9083 4.37332C13.766 3.96981 13.5018 3.62054 13.1524 3.37383C12.7994 3.13037 12.3808 3 11.9521 3C11.5234 3 11.1048 3.13037 10.7518 3.37383C10.3924 3.62703 10.1229 3.98814 9.98233 4.40483L9.18363 6.85854C8.99531 7.40796 8.68518 7.90761 8.27645 8.32007C7.86773 8.73253 7.37102 9.0471 6.82354 9.24021L4.38469 10.0303C3.97726 10.1744 3.6249 10.4421 3.3767 10.796C3.1285 11.1499 2.99684 11.5725 3.00006 12.0049C3.00328 12.4372 3.14122 12.8578 3.39466 13.208ZM12.0065 19L11.9954 19C11.9807 19 11.9662 18.9954 11.954 18.9868C11.9435 18.9793 11.9351 18.9691 11.9297 18.9571L11.1483 16.5582L11.1467 16.5534C10.9397 15.9233 10.6263 15.3333 10.2201 14.8091L10.2179 14.8062C10.0678 14.6133 9.90555 14.4301 9.73205 14.2578C9.09132 13.6159 8.31015 13.1316 7.45012 12.8433L7.44176 12.8405L5.04937 12.0621C5.03571 12.0568 5.02369 12.0476 5.01487 12.0354C5.00538 12.0223 5.00012 12.0064 5 11.99C4.99988 11.9735 5.00489 11.9576 5.0142 11.9443C5.02181 11.9334 5.03195 11.9249 5.04354 11.9192L7.46448 11.1349L7.4888 11.1263C8.32101 10.8328 9.07594 10.3547 9.69709 9.72784C10.3182 9.10102 10.7895 8.34177 11.0756 7.50702L11.0806 7.49234L11.8786 5.04096C11.8826 5.03067 11.8889 5.02158 11.8968 5.01431C11.9137 5.00493 11.9328 5 11.9521 5C11.9709 5 11.9895 5.00469 12.0061 5.01364C12.0115 5.01884 12.0161 5.02501 12.0194 5.0319L12.8007 7.4325L12.8045 7.44404C13.0907 8.30565 13.5743 9.08851 14.2167 9.7301C14.8592 10.3717 15.6426 10.8543 16.5047 11.1392L18.9213 11.9218L18.9285 11.9241C18.9525 11.9318 18.9738 11.9464 18.9897 11.9663C18.9964 11.9774 19 11.9902 19 12.0034C19 12.0184 18.9954 12.0329 18.9869 12.0449L18.9856 12.0467C18.9781 12.0573 18.9683 12.0657 18.957 12.0713L16.5588 12.8512L16.5465 12.8553C15.6864 13.1412 14.9052 13.6243 14.2651 14.266C13.6254 14.9074 13.1429 15.6883 12.8554 16.5473L12.8527 16.5556L12.0828 18.9243C12.0712 18.951 12.0543 18.9749 12.0331 18.9944C12.0247 18.9981 12.0156 19 12.0065 19ZM25.6533 19.8412C25.7682 20.1833 25.9611 20.4939 26.2168 20.7487C26.4725 21.0035 26.7839 21.1953 27.1265 21.3091L28.7816 21.8483C29.0432 21.9296 29.2818 22.0717 29.4778 22.2631C29.6738 22.4544 29.8217 22.6894 29.9092 22.9489C29.9967 23.2083 30.0214 23.4848 29.9813 23.7557C29.9413 24.0265 29.8375 24.284 29.6785 24.5071C29.4693 24.8016 29.1731 25.0234 28.8315 25.1414L27.159 25.687C26.8154 25.7989 26.5034 25.9912 26.2491 26.2478C25.9938 26.5044 25.801 26.8163 25.6858 27.1593L25.1485 28.8092C25.0283 29.1589 24.8009 29.4619 24.4986 29.6752C24.2085 29.8833 23.8613 29.9967 23.5042 30C23.1434 29.9998 22.7914 29.8878 22.4968 29.6796C22.204 29.4718 21.9829 29.1783 21.8642 28.8395L21.3161 27.1637C21.2049 26.8192 21.0133 26.506 20.7572 26.25C20.5 25.9939 20.1871 25.8005 19.843 25.6849L18.19 25.1501C17.8396 25.0307 17.5362 24.8033 17.3234 24.5006C17.1667 24.2815 17.0632 24.029 17.0212 23.7631C16.9792 23.4971 16.9998 23.225 17.0814 22.9684C17.163 22.7118 17.3033 22.4777 17.4912 22.2848C17.6792 22.0918 17.9095 21.9454 18.164 21.8569L19.8451 21.3091C20.1786 21.1918 20.4809 21 20.729 20.7484C20.9807 20.4914 21.1704 20.1803 21.2836 19.839L21.8187 18.1892C21.9039 17.9313 22.0486 17.6971 22.241 17.5054C22.4334 17.3137 22.6683 17.1698 22.9266 17.0856C23.1849 17.0013 23.4594 16.9789 23.7279 17.0201C23.9965 17.0614 24.2516 17.1652 24.4726 17.3231C24.7676 17.5302 24.9897 17.8249 25.1074 18.1654L25.6533 19.8412ZM26.4959 23.2072C25.8592 22.9957 25.2804 22.639 24.8051 22.1654C24.3298 21.6918 23.9711 21.1141 23.7574 20.478L23.7545 20.4694L23.4675 19.5884L23.1819 20.4689C22.9728 21.0991 22.6226 21.6732 22.1581 22.1476L22.1532 22.1526C21.6915 22.6208 21.1291 22.9776 20.5089 23.1958L20.4869 23.2035L19.582 23.4984L20.4693 23.7854L20.4799 23.789C21.1154 24.0025 21.6932 24.3596 22.1683 24.8327L22.171 24.8354C22.6503 25.3144 23.0092 25.9003 23.218 26.545L23.2194 26.5492L23.5009 27.4098L23.787 26.5313L23.7899 26.5226C24.0028 25.8888 24.3587 25.3126 24.8299 24.8386C25.3078 24.3568 25.8936 23.9959 26.5387 23.7857L27.4047 23.5032L26.4959 23.2072Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconSettings() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      strokeWidth=".3"
      stroke="currentColor"
      viewBox="0 0 24 24">
      <path
        fill="currentColor"
        fillRule="evenodd"
        d="M11.568 3.5a1 1 0 0 0-.863.494l-.811 1.381A3 3 0 0 1 7.33 6.856l-1.596.013a1 1 0 0 0-.858.501l-.44.761a1 1 0 0 0-.003.992l.792 1.4a3 3 0 0 1 0 2.954l-.792 1.4a1 1 0 0 0 .004.992l.439.76a1 1 0 0 0 .858.502l1.596.013a3 3 0 0 1 2.564 1.48l.811 1.382a1 1 0 0 0 .863.494h.87a1 1 0 0 0 .862-.494l.812-1.381a3 3 0 0 1 2.563-1.481l1.596-.013a1 1 0 0 0 .859-.501l.439-.761a1 1 0 0 0 .004-.992l-.793-1.4a3 3 0 0 1 0-2.953l.793-1.401a1 1 0 0 0-.004-.992l-.439-.76a1 1 0 0 0-.859-.502l-1.596-.013a3 3 0 0 1-2.563-1.48L13.3 3.993a1 1 0 0 0-.862-.494zM8.98 2.981A3 3 0 0 1 11.568 1.5h.87a3 3 0 0 1 2.588 1.481l.81 1.382a1 1 0 0 0 .855.494l1.597.013a3 3 0 0 1 2.575 1.502l.44.76a3 3 0 0 1 .011 2.975l-.792 1.4a1 1 0 0 0 0 .985l.792 1.401a3 3 0 0 1-.012 2.974l-.439.761a3 3 0 0 1-2.575 1.503l-1.597.012a1 1 0 0 0-.854.494l-.811 1.382a3 3 0 0 1-2.588 1.481h-.87a3 3 0 0 1-2.588-1.481l-.811-1.382a1 1 0 0 0-.855-.494l-1.596-.012a3 3 0 0 1-2.576-1.503l-.439-.76a3 3 0 0 1-.012-2.975l.793-1.4a1 1 0 0 0 0-.985l-.793-1.4a3 3 0 0 1 .012-2.975l.44-.761A3 3 0 0 1 5.717 4.87l1.596-.013a1 1 0 0 0 .855-.494z"
        clipRule="evenodd"></path>
      <path
        fill="currentColor"
        fillRule="evenodd"
        d="M12.003 10.5a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3M8.502 12a3.5 3.5 0 1 1 7 .001 3.5 3.5 0 0 1-7-.001"
        clipRule="evenodd"></path>
    </svg>
  )
}
export function IconLocation() {
  return (
    <svg
      width="28"
      height="28"
      viewBox="0 0 28 28"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1.2"
      stroke="currentColor">
      <path
        d="M14 2.25C19.3848 2.25 23.75 6.61522 23.75 12C23.75 16.1196 20.8554 20.6093 15.1402 25.5179C14.4844 26.0811 13.5156 26.0811 12.8572 25.5156L12.4794 25.1881C7.01712 20.4089 4.25 16.0278 4.25 12C4.25 6.61522 8.61522 2.25 14 2.25ZM14 3.75C9.44365 3.75 5.75 7.44365 5.75 12C5.75 15.5021 8.2984 19.5368 13.4645 24.057L13.8371 24.3799C13.9308 24.4604 14.0692 24.4604 14.1629 24.3799C19.5789 19.7283 22.25 15.5853 22.25 12C22.25 7.44365 18.5563 3.75 14 3.75ZM14 8.25C16.0711 8.25 17.75 9.92893 17.75 12C17.75 14.0711 16.0711 15.75 14 15.75C11.9289 15.75 10.25 14.0711 10.25 12C10.25 9.92893 11.9289 8.25 14 8.25ZM14 9.75C12.7574 9.75 11.75 10.7574 11.75 12C11.75 13.2426 12.7574 14.25 14 14.25C15.2426 14.25 16.25 13.2426 16.25 12C16.25 10.7574 15.2426 9.75 14 9.75Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconSend() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      xmlns="http://www.w3.org/2000/svg">
      <path
        fill="currentColor"
        d="m 14.619135,3.585383 a 2.0003082,2.0003082 0 0 1 2.828081,0 l 9.000512,9.000508 a 2.0003082,2.0003082 0 0 1 -2.828082,2.828086 L 18.033486,9.8278111 V 27.001059 a 2.0003084,2.0003084 0 0 1 -4.000616,0 V 9.8278111 L 8.4467091,15.413977 A 2.0003082,2.0003082 0 1 1 5.6186244,12.585891 Z"
      />
    </svg>
  )
}
export function IconCart() {
  return (
    <svg fill="none" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
      <g transform="translate(0,-1.0000014)">
        <path
          stroke="currentColor"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth="2.31579px"
          d="M 2.7368404,20.526319 V 7.7894746 H 21.26316 V 20.526319 a 2.3157899,2.3157899 0 0 1 -2.31579,2.315789 H 5.0526302 A 2.3157899,2.3157899 0 0 1 2.7368404,20.526319"
          fill="none"
          id="path1"
        />
        <path
          stroke="currentColor"
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth="2.31579px"
          d="M 8.5263153,11.26316 V 6.6315796 A 3.4736848,3.4736848 0 0 1 12,3.1578948 v 0 a 3.4736848,3.4736848 0 0 1 3.473685,3.4736848 V 11.26316"
          fill="none"
        />
      </g>
    </svg>
  )
}
export function IconCode() {
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth=".8"
      stroke="currentColor">
      <path
        d="M8.06562 18.9434L14.5656 4.44339C14.7351 4.06542 15.1788 3.89637 15.5568 4.0658C15.9033 4.22112 16.0742 4.60695 15.9698 4.96131L15.9344 5.05698L9.43438 19.557C9.26495 19.935 8.82118 20.104 8.44321 19.9346C8.09673 19.7793 7.92581 19.3934 8.03024 19.0391L8.06562 18.9434L14.5656 4.44339L8.06562 18.9434ZM2.21967 11.4699L6.46967 7.21986C6.76256 6.92696 7.23744 6.92696 7.53033 7.21986C7.7966 7.48612 7.8208 7.90279 7.60295 8.1964L7.53033 8.28052L3.81066 12.0002L7.53033 15.7199C7.82322 16.0127 7.82322 16.4876 7.53033 16.7805C7.26406 17.0468 6.8474 17.071 6.55379 16.8531L6.46967 16.7805L2.21967 12.5305C1.9534 12.2642 1.9292 11.8476 2.14705 11.554L2.21967 11.4699L6.46967 7.21986L2.21967 11.4699ZM16.4697 7.21986C16.7359 6.95359 17.1526 6.92938 17.4462 7.14724L17.5303 7.21986L21.7803 11.4699C22.0466 11.7361 22.0708 12.1528 21.8529 12.4464L21.7803 12.5305L17.5303 16.7805C17.2374 17.0734 16.7626 17.0734 16.4697 16.7805C16.2034 16.5142 16.1792 16.0976 16.3971 15.804L16.4697 15.7199L20.1893 12.0002L16.4697 8.28052C16.1768 7.98762 16.1768 7.51275 16.4697 7.21986Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconShield() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1.7"
      stroke="currentColor">
      <path
        d="M15.4453 2.16795C15.7812 1.94402 16.2188 1.94402 16.5547 2.16795C19.4707 4.11195 23.3149 6.0265 28.0995 6.50496C28.6107 6.55608 29 6.98625 29 7.5V16C29 19.8796 26.8761 23.1691 24.2989 25.5462C21.7274 27.9179 18.5623 29.517 16.1843 29.9629L16 29.9974L15.8157 29.9629C13.4377 29.517 10.2726 27.9179 7.70115 25.5462C5.12389 23.1691 3 19.8796 3 16V7.5C3 6.98625 3.38929 6.55608 3.9005 6.50496C8.68509 6.0265 12.5293 4.11195 15.4453 2.16795ZM5 8.38831V16C5 19.1204 6.71495 21.9157 9.05712 24.076C11.3319 26.1742 14.0638 27.5451 16 27.9601C17.9362 27.5451 20.6681 26.1742 22.9429 24.076C25.285 21.9157 27 19.1204 27 16V8.38831C22.5038 7.7717 18.8344 6.00808 16 4.19443C13.1656 6.00808 9.49618 7.7717 5 8.38831Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconMic() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 32 32"
      fill="currentColor">
      <path
        d="m16,20.21c2.8,0,5.05-2.26,5.05-5.05V5.05c0-2.8-2.26-5.05-5.05-5.05s-5.05,2.26-5.05,5.05v10.11c0,2.8,2.26,5.05,5.05,5.05Zm-1.68-15.16c0-.93.76-1.68,1.68-1.68s1.68.76,1.68,1.68v10.11c0,.94-.74,1.68-1.68,1.68s-1.68-.76-1.68-1.68V5.05Zm11.94,10.11h0c.87,0,1.54.78,1.41,1.64-.77,4.99-4.99,8.93-9.98,9.68v4.1c0,.79-.64,1.43-1.43,1.43h-.51c-.79,0-1.43-.64-1.43-1.43v-4.1c-4.99-.75-9.21-4.69-9.98-9.68-.13-.86.54-1.64,1.41-1.64h0c.71,0,1.31.53,1.41,1.23.63,4.39,4.58,7.36,8.84,7.36s8.21-2.97,8.84-7.36c.1-.7.7-1.23,1.41-1.23Z"
        stroke="currentColor"
        strokeWidth=".2"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  )
}
export function IconTrending() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      strokeWidth="2.5"
      strokeLinecap="round"
      strokeLinejoin="round">
      <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
      <polyline points="17 6 23 6 23 12"></polyline>
    </svg>
  )
}
export function IconBook() {
  return (
    <svg
      fill="currentColor"
      viewBox="0 0 26 26"
      xmlns="http://www.w3.org/2000/svg">
      <path
        fill="currentColor"
        stroke="currentColor"
        fillRule="evenodd"
        clipRule="evenodd"
        strokeWidth=".2"
        d="m 13.49007,4.4716995 a 1.0820024,1.0820024 0 0 0 -0.98354,0 L 2.1647506,9.7486257 1.1801284,7.8204971 11.524072,2.5435712 a 3.2460074,3.2460074 0 0 1 2.949538,0 l 10.343944,5.2769259 a 2.1423648,2.1423648 0 0 1 1.165317,2.1856459 v 6.253973 a 1.082003,1.082003 0 1 1 -2.164006,0 v -4.094297 l -2.199711,1.076592 v 4.429718 a 3.2460074,3.2460074 0 0 1 -1.7074,2.85865 l -5.374306,2.892193 a 3.2460074,3.2460074 0 0 1 -3.077215,0 L 6.0859275,20.530779 A 3.2460074,3.2460074 0 0 1 4.3785276,17.672129 V 13.242411 L 1.2115065,11.691902 C -0.38985714,10.90745 -0.40716918,8.6309169 1.1801284,7.8204971 L 2.1647506,9.7486257 12.52276,14.822135 a 1.0820024,1.0820024 0 0 0 0.952162,0 L 23.818865,9.7562002 V 9.7410552 Z M 6.5436145,14.302774 v 3.369355 a 1.0820024,1.0820024 0 0 0 0.5680513,0.952163 l 5.3743062,2.893274 a 1.0820024,1.0820024 0 0 0 1.025738,0 l 5.374306,-2.892192 a 1.0820024,1.0820024 0 0 0 0.569134,-0.952163 v -3.371519 l -5.028065,2.462638 a 3.2460074,3.2460074 0 0 1 -2.856487,0 z"
      />
    </svg>
  )
}
export function IconBriefcase() {
  return (
    <svg
      viewBox="0 0 24 24"
      width="24"
      height="24"
      stroke="currentColor"
      strokeWidth="2.1"
      fill="none"
      strokeLinecap="round"
      strokeLinejoin="round">
      <rect x="2" y="7" width="20" height="14" rx="2" ry="2"></rect>
      <path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"></path>
    </svg>
  )
}
export const IconGames = () => (
  <svg
    width="24"
    height="24"
    fill="currentColor"
    strokeWidth=".6"
    stroke="currentColor"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg">
    <path d="M14.998 5a7 7 0 0 1 .24 13.996l-.24.004H9.002a7 7 0 0 1-.24-13.996L9.001 5h5.996Zm0 1.5H9.002a5.5 5.5 0 0 0-.221 10.996l.221.004h5.996a5.5 5.5 0 0 0 .221-10.996l-.221-.004ZM8 9a.75.75 0 0 1 .75.75v1.498h1.5a.75.75 0 0 1 0 1.5h-1.5v1.502a.75.75 0 0 1-1.5 0v-1.502h-1.5a.75.75 0 1 1 0-1.5h1.5V9.75A.75.75 0 0 1 8 9Zm6.75 3.5a1.25 1.25 0 1 1 0 2.5 1.25 1.25 0 0 1 0-2.5Zm2-3.5a1.25 1.25 0 1 1 0 2.5 1.25 1.25 0 0 1 0-2.5Z" />
  </svg>
)
export function IconNews() {
  return (
    <svg
      width="28"
      height="28"
      viewBox="0 0 28 28"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1"
      stroke="currentColor">
      <path
        d="M22.75 24H5.25C3.51697 24 2.10075 22.6435 2.00514 20.9344L2 20.75V6.25C2 5.05914 2.92516 4.08436 4.09595 4.00519L4.25 4H19.75C20.9409 4 21.9156 4.92516 21.9948 6.09595L22 6.25V7H23.75C24.9409 7 25.9156 7.92516 25.9948 9.09595L26 9.25V20.75C26 22.483 24.6435 23.8992 22.9344 23.9949L22.75 24H5.25H22.75ZM5.25 22.5H22.75C23.6682 22.5 24.4212 21.7929 24.4942 20.8935L24.5 20.75V9.25C24.5 8.8703 24.2178 8.55651 23.8518 8.50685L23.75 8.5H22V19.25C22 19.6297 21.7178 19.9435 21.3518 19.9932L21.25 20C20.8703 20 20.5565 19.7178 20.5068 19.3518L20.5 19.25V6.25C20.5 5.8703 20.2178 5.55651 19.8518 5.50685L19.75 5.5H4.25C3.8703 5.5 3.55651 5.78215 3.50685 6.14823L3.5 6.25V20.75C3.5 21.6682 4.20711 22.4212 5.10647 22.4942L5.25 22.5H22.75H5.25ZM10.2465 13.0035C10.9369 13.0035 11.4965 13.5631 11.4965 14.2535V17.75C11.4965 18.4404 10.9369 19 10.2465 19H6.75C6.05964 19 5.5 18.4404 5.5 17.75V14.2535C5.5 13.5631 6.05964 13.0035 6.75 13.0035H10.2465ZM14.25 17.5H17.7462C18.1604 17.5 18.4962 17.8358 18.4962 18.25C18.4962 18.6297 18.214 18.9435 17.848 18.9932L17.7462 19H14.25C13.8358 19 13.5 18.6642 13.5 18.25C13.5 17.8703 13.7822 17.5565 14.1482 17.5068L14.25 17.5H17.7462H14.25ZM9.99653 14.5035H7V17.5H9.99653V14.5035ZM14.25 13.0035H17.7462C18.1604 13.0035 18.4962 13.3393 18.4962 13.7535C18.4962 14.1332 18.214 14.447 17.848 14.4966L17.7462 14.5035H14.25C13.8358 14.5035 13.5 14.1677 13.5 13.7535C13.5 13.3738 13.7822 13.06 14.1482 13.0103L14.25 13.0035H17.7462H14.25ZM6.2464 8.49666H17.7462C18.1604 8.49666 18.4962 8.83244 18.4962 9.24666C18.4962 9.62635 18.214 9.94015 17.848 9.98981L17.7462 9.99666H6.2464C5.83218 9.99666 5.4964 9.66087 5.4964 9.24666C5.4964 8.86696 5.77855 8.55317 6.14463 8.5035L6.2464 8.49666H17.7462H6.2464Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconBank() {
  return (
    <svg
      width="28"
      height="28"
      viewBox="0 0 28 28"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth=".8"
      stroke="currentColor">
      <path
        d="M14.002 9C14.8304 9 15.502 8.32843 15.502 7.5C15.502 6.67157 14.8304 6 14.002 6C13.1735 6 12.502 6.67157 12.502 7.5C12.502 8.32843 13.1735 9 14.002 9ZM14.8923 2.29472C14.363 1.90437 13.6411 1.90436 13.1118 2.2947L3.61264 9.29954C2.4475 10.1587 3.05521 12.0068 4.50289 12.0068H5.00195V19.2491C3.82748 19.7389 3.00195 20.898 3.00195 22.25V23.75C3.00195 24.1642 3.33774 24.5 3.75195 24.5H24.252C24.6662 24.5 25.002 24.1642 25.002 23.75V22.25C25.002 20.898 24.1764 19.7389 23.002 19.2491V12.0068H23.5008C24.9484 12.0068 25.5561 10.1588 24.391 9.29956L14.8923 2.29472ZM6.50195 19V12.0068H9.00195V19H6.50195ZM21.502 12.0068V19H19.002V12.0068H21.502ZM17.502 12.0068V19H14.752V12.0068H17.502ZM13.252 12.0068V19H10.502V12.0068H13.252ZM4.50289 10.5068L14.002 3.50195L23.5008 10.5068H4.50289ZM4.50195 22.25C4.50195 21.2835 5.28545 20.5 6.25195 20.5H21.752C22.7185 20.5 23.502 21.2835 23.502 22.25V23H4.50195V22.25Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconClose() {
  return (
    <svg
      viewBox="0 0 24 24"
      width="24"
      height="24"
      stroke="currentColor"
      strokeWidth="3"
      fill="currentColor"
      strokeLinecap="round"
      strokeLinejoin="round">
      <line x1="18" y1="6" x2="6" y2="18"></line>
      <line x1="6" y1="6" x2="18" y2="18"></line>
    </svg>
  )
}
export function IconAccessibility() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth=".8"
      stroke="currentColor">
      <path
        d="M13.5 6.5C13.5 5.11929 14.6193 4 16 4C17.3807 4 18.5 5.11929 18.5 6.5C18.5 7.88071 17.3807 9 16 9C14.6193 9 13.5 7.88071 13.5 6.5ZM16 2C13.5147 2 11.5 4.01472 11.5 6.5C11.5 6.93498 11.5617 7.35555 11.6769 7.75343L7.0738 6.16845C5.46929 5.61598 3.72071 6.46882 3.16824 8.07332C2.61576 9.67783 3.4686 11.4264 5.07311 11.9789L11 14.0197V17.7781C11 17.9301 10.9654 18.08 10.8988 18.2165L7.30744 25.58C6.56354 27.1052 7.19692 28.9447 8.72214 29.6886C10.2474 30.4325 12.0868 29.7991 12.8307 28.2739L15.9979 21.7803L19.165 28.2739C19.9089 29.7991 21.7484 30.4325 23.2736 29.6886C24.7988 28.9447 25.4322 27.1052 24.6883 25.58L21.1012 18.2254C21.0346 18.0889 21 17.939 21 17.787V14.0197L26.9269 11.9789C28.5314 11.4264 29.3842 9.67783 28.8318 8.07332C28.2793 6.46882 26.5307 5.61598 24.9262 6.16845L20.3232 7.75341C20.4383 7.35554 20.5 6.93498 20.5 6.5C20.5 4.01472 18.4853 2 16 2ZM5.05927 8.72446C5.25214 8.16434 5.86255 7.86663 6.42266 8.05949L14.0466 10.6846C15.3124 11.1205 16.6876 11.1205 17.9534 10.6846L25.5773 8.05949C26.1375 7.86663 26.7479 8.16434 26.9407 8.72446C27.1336 9.28458 26.8359 9.89498 26.2758 10.0878L20.0117 12.2447C19.4064 12.4532 19 13.0228 19 13.663V17.787C19 18.2428 19.1039 18.6925 19.3037 19.1022L22.8907 26.4567C23.1504 26.9891 22.9293 27.6313 22.3968 27.891C21.8644 28.1507 21.2223 27.9295 20.9626 27.3971L17.7955 20.9035C17.065 19.4059 14.9307 19.4059 14.2003 20.9035L11.0331 27.3971C10.7735 27.9295 10.1313 28.1507 9.59888 27.891C9.06645 27.6313 8.84534 26.9891 9.10503 26.4567L12.6964 19.0933C12.8962 18.6836 13 18.2339 13 17.7781V13.663C13 13.0228 12.5937 12.4532 11.9884 12.2448L5.72424 10.0878C5.16413 9.89498 4.86641 9.28457 5.05927 8.72446Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconVisualSearch() {
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth=".9"
      stroke="currentColor">
      <path
        d="M17.75 3C19.5449 3 21 4.45508 21 6.25V9.25C21 9.66421 20.6642 10 20.25 10C19.8358 10 19.5 9.66421 19.5 9.25V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5L14.75 4.5C14.3358 4.5 14 4.16421 14 3.75C14 3.33579 14.3358 3 14.75 3H17.75ZM6.25 3C4.45507 3 3 4.45507 3 6.25V9.25C3 9.66421 3.33579 10 3.75 10C4.16421 10 4.5 9.66421 4.5 9.25V6.25C4.5 5.2835 5.2835 4.5 6.25 4.5H9.25C9.66421 4.5 10 4.16421 10 3.75C10 3.33579 9.66421 3 9.25 3H6.25ZM17.75 21C19.5449 21 21 19.5449 21 17.75V14.75C21 14.3358 20.6642 14 20.25 14C19.8358 14 19.5 14.3358 19.5 14.75V17.75C19.5 18.7165 18.7165 19.5 17.75 19.5H14.75C14.3358 19.5 14 19.8358 14 20.25C14 20.6642 14.3358 21 14.75 21H17.75ZM3 17.75C3 19.5449 4.45507 21 6.25 21H9.25C9.66421 21 10 20.6642 10 20.25C10 19.8358 9.66421 19.5 9.25 19.5H6.25C5.2835 19.5 4.5 18.7165 4.5 17.75L4.5 14.75C4.5 14.3358 4.16421 14 3.75 14C3.33579 14 3 14.3358 3 14.75L3 17.75ZM12 15C13.6569 15 15 13.6569 15 12C15 10.3431 13.6569 9 12 9C10.3431 9 9 10.3431 9 12C9 13.6569 10.3431 15 12 15ZM12 13.5C11.1716 13.5 10.5 12.8284 10.5 12C10.5 11.1716 11.1716 10.5 12 10.5C12.8284 10.5 13.5 11.1716 13.5 12C13.5 12.8284 12.8284 13.5 12 13.5ZM7.5 8.5C8.05229 8.5 8.5 8.05229 8.5 7.5C8.5 6.94772 8.05229 6.5 7.5 6.5C6.94772 6.5 6.5 6.94772 6.5 7.5C6.5 8.05229 6.94772 8.5 7.5 8.5Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconLanguage() {
  return (
    <svg
      width="28"
      height="28"
      viewBox="0 0 28 28"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1.2"
      stroke="currentColor">
      <path
        d="M12.7502 2C12.336 2 12.0002 2.33579 12.0002 2.75C12.0002 3.16421 12.336 3.5 12.7502 3.5H18.5002V6.30519C18.5002 8.0543 16.7512 9.5 14.7502 9.5C14.336 9.5 14.0002 9.83579 14.0002 10.25C14.0002 10.6642 14.336 11 14.7502 11C17.3137 11 20.0002 9.12567 20.0002 6.30519V2.75C20.0002 2.33579 19.6644 2 19.2502 2H12.7502ZM10.693 7.46282C10.5769 7.18263 10.3034 6.99997 10.0001 7C9.69682 7.00003 9.42339 7.18274 9.3073 7.46295L2.0573 24.963C1.89877 25.3457 2.08047 25.7844 2.46314 25.943C2.84582 26.1015 3.28455 25.9198 3.44309 25.5371L5.53071 20.498H14.4725L16.5613 25.5373C16.7199 25.9199 17.1587 26.1015 17.5413 25.9429C17.9239 25.7843 18.1056 25.3455 17.947 24.9629L15.7434 19.6469C15.7257 19.5153 15.6739 19.3946 15.5971 19.2938L10.693 7.46282ZM13.8507 18.998H6.15214L10.0004 9.70911L13.8507 18.998ZM22.2518 2C22.666 2 23.0018 2.33579 23.0018 2.75V8.5H25.2502C25.6644 8.5 26.0002 8.83579 26.0002 9.25C26.0002 9.66421 25.6644 10 25.2502 10H23.0018V19.2495C23.0018 19.6637 22.666 19.9995 22.2518 19.9995C21.8376 19.9995 21.5018 19.6637 21.5018 19.2495V9.29918C21.5007 9.28292 21.5002 9.26652 21.5002 9.25C21.5002 9.23348 21.5007 9.21708 21.5018 9.20082V2.75C21.5018 2.33579 21.8376 2 22.2518 2Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconSearch() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1.5"
      stroke="currentColor">
      <path
        d="M13.5 3C7.70101 3 3 7.70101 3 13.5C3 19.299 7.70101 24 13.5 24C16.0394 24 18.3683 23.0985 20.1841 21.5981L27.293 28.7071C27.6836 29.0976 28.3167 29.0976 28.7073 28.7071C29.0978 28.3166 29.0978 27.6834 28.7073 27.2929L21.5983 20.1839C23.0986 18.3682 24 16.0393 24 13.5C24 7.70101 19.299 3 13.5 3ZM5 13.5C5 8.80558 8.80558 5 13.5 5C18.1944 5 22 8.80558 22 13.5C22 18.1944 18.1944 22 13.5 22C8.80558 22 5 18.1944 5 13.5Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconCheckOk() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      strokeWidth="2.4"
      strokeLinecap="round"
      strokeLinejoin="round">
      <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path>
      <polyline points="22 4 12 14.01 9 11.01"></polyline>
    </svg>
  )
}
export function IconFeedback() {
  return (
    <svg
      width="24"
      height="24"
      fill="none"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
      stroke="currentColor">
      <path
        d="M5.25 18A3.25 3.25 0 0 1 2 14.75v-8.5A3.25 3.25 0 0 1 5.25 3h13.5A3.25 3.25 0 0 1 22 6.25v8.5A3.25 3.25 0 0 1 18.75 18h-5.738L8 21.75a1.25 1.25 0 0 1-1.999-1V18h-.75Zm7.264-1.5h6.236a1.75 1.75 0 0 0 1.75-1.75v-8.5a1.75 1.75 0 0 0-1.75-1.75H5.25A1.75 1.75 0 0 0 3.5 6.25v8.5c0 .966.784 1.75 1.75 1.75h2.249v3.75l5.015-3.75Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconLocationGps() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1"
      stroke="currentColor">
      <path
        d="M28.8612 5.72272C29.4833 4.10524 27.894 2.51596 26.2766 3.13807L4.28218 11.5975C2.47024 12.2943 2.61372 14.9042 4.49115 15.3983L13.514 17.7727C13.8626 17.8645 14.1348 18.1367 14.2266 18.4853L16.601 27.5081C17.0951 29.3856 19.7049 29.529 20.4018 27.7171L28.8612 5.72272ZM26.9945 5.00476L18.5351 26.9991L16.1607 17.9763C15.8855 16.9305 15.0688 16.1138 14.023 15.8386L5.00014 13.4641L26.9945 5.00476Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconHeart() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1.4"
      stroke="currentColor">
      <path
        d="M3.38563 7.13082C6.35842 2.96011 12.5531 2.95562 15.532 7.12201L15.9964 7.77164L16.4137 7.17921C19.3686 2.98397 25.5742 2.94256 28.5848 7.098C30.6822 9.99286 30.4377 13.9672 28.0014 16.5832L16.7343 28.6811C16.545 28.8844 16.2797 28.9997 16.0019 28.9995C15.7241 28.9994 15.4589 28.8836 15.2698 28.6801L3.99445 16.5399C1.58467 13.9453 1.33031 10.0143 3.38563 7.13082ZM13.905 8.28522C11.7246 5.23554 7.19026 5.23883 5.01426 8.29167C3.50982 10.4023 3.696 13.2797 5.4599 15.1789L16.0036 26.5312L26.5378 15.2201C28.3226 13.3037 28.5017 10.3921 26.9652 8.2714C24.7597 5.22719 20.2136 5.25752 18.0488 8.3309L16.8201 10.0754C16.6335 10.3403 16.3301 10.4984 16.0061 10.4995C15.682 10.5007 15.3775 10.3448 15.1891 10.0812L13.905 8.28522Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconStar() {
  return (
    <svg
      width="28"
      height="28"
      viewBox="0 0 28 28"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1"
      stroke="currentColor">
      <path
        d="M12.7013 3.90984C13.2332 2.83213 14.7699 2.83214 15.3018 3.90984L17.9928 9.36237L24.01 10.2367C25.1993 10.4095 25.6742 11.8711 24.8136 12.71L20.4595 16.9542L21.4874 22.9471C21.6905 24.1316 20.4473 25.0349 19.3835 24.4756L14.0015 21.6462L8.61958 24.4756C7.55582 25.0349 6.31254 24.1316 6.5157 22.9471L7.54357 16.9542L3.18947 12.71C2.32887 11.8711 2.80376 10.4095 3.99308 10.2367L10.0103 9.36237L12.7013 3.90984ZM14.0015 4.66454L11.3438 10.0498C11.1326 10.4777 10.7243 10.7744 10.252 10.843L4.30903 11.7066L8.60941 15.8984C8.95115 16.2315 9.1071 16.7115 9.02642 17.1818L8.01124 23.1008L13.3268 20.3062C13.7492 20.0842 14.2539 20.0842 14.6763 20.3062L19.9918 23.1008L18.9767 17.1818C18.896 16.7115 19.0519 16.2315 19.3937 15.8984L23.6941 11.7066L17.7511 10.843C17.2788 10.7744 16.8705 10.4777 16.6593 10.0498L14.0015 4.66454Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconMoon() {
  return (
    <svg
      width="28"
      height="28"
      viewBox="0 0 28 28"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1"
      stroke="currentColor">
      <path
        d="M13.8232 2.30045C13.667 2.48486 13.6093 2.73322 13.668 2.96761C14.3203 5.5684 14.7731 9.48625 13.0595 12.913C12.2013 14.6292 10.664 15.9331 8.89027 16.9159C7.12023 17.8966 5.16953 18.5267 3.57078 18.9201C3.3413 18.9766 3.15187 19.1379 3.05957 19.3555C2.96727 19.573 2.98291 19.8214 3.10176 20.0256C5.17924 23.5958 9.04884 25.9985 13.4805 25.9985C20.1079 25.9985 25.4805 20.6259 25.4805 13.9985C25.4805 7.69929 20.6274 2.53436 14.4557 2.03758C14.2148 2.01819 13.9794 2.11605 13.8232 2.30045ZM15.3623 3.66654C20.263 4.55307 23.9805 8.84197 23.9805 13.9985C23.9805 19.7975 19.2795 24.4985 13.4805 24.4985C9.96157 24.4985 6.84618 22.7678 4.94019 20.1085C6.40164 19.6919 8.0621 19.0896 9.61724 18.2279C11.5409 17.1621 13.3586 15.6685 14.4011 13.584C16.1176 10.1515 15.9022 6.37722 15.3623 3.66654Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconSun() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1"
      stroke="currentColor">
      <path
        d="M16.0003 2C16.5525 2 17.0003 2.44772 17.0003 3V5C17.0003 5.55228 16.5525 6 16.0003 6C15.448 6 15.0003 5.55228 15.0003 5V3C15.0003 2.44772 15.448 2 16.0003 2ZM16.0003 23C19.8662 23 23.0003 19.866 23.0003 16C23.0003 12.134 19.8662 9 16.0003 9C12.1343 9 9.00025 12.134 9.00025 16C9.00025 19.866 12.1343 23 16.0003 23ZM16.0003 21C13.2388 21 11.0003 18.7614 11.0003 16C11.0003 13.2386 13.2388 11 16.0003 11C18.7617 11 21.0003 13.2386 21.0003 16C21.0003 18.7614 18.7617 21 16.0003 21ZM29.0003 17C29.5525 17 30.0003 16.5523 30.0003 16C30.0003 15.4477 29.5525 15 29.0003 15H27.0003C26.448 15 26.0003 15.4477 26.0003 16C26.0003 16.5523 26.448 17 27.0003 17H29.0003ZM16.0003 26C16.5525 26 17.0003 26.4477 17.0003 27V29.0005C17.0003 29.5528 16.5525 30.0005 16.0003 30.0005C15.448 30.0005 15.0003 29.5528 15.0003 29.0005V27C15.0003 26.4477 15.448 26 16.0003 26ZM5.00025 17C5.55254 17 6.00025 16.5523 6.00025 16C6.00025 15.4477 5.55254 15 5.00025 15H3C2.44772 15 2 15.4477 2 16C2 16.5523 2.44772 17 3 17H5.00025ZM5.29412 5.29368C5.68464 4.90316 6.31781 4.90316 6.70833 5.29368L8.70833 7.29368C9.09886 7.68421 9.09886 8.31737 8.70833 8.7079C8.31781 9.09842 7.68464 9.09842 7.29412 8.7079L5.29412 6.7079C4.9036 6.31737 4.9036 5.68421 5.29412 5.29368ZM6.70833 26.708C6.31781 27.0985 5.68464 27.0985 5.29412 26.708C4.9036 26.3175 4.9036 25.6843 5.29412 25.2938L7.29412 23.2938C7.68464 22.9032 8.31781 22.9032 8.70833 23.2938C9.09886 23.6843 9.09886 24.3175 8.70833 24.708L6.70833 26.708ZM26.7083 5.29368C26.3178 4.90316 25.6846 4.90316 25.2941 5.29368L23.2941 7.29368C22.9036 7.68421 22.9036 8.31737 23.2941 8.7079C23.6846 9.09842 24.3178 9.09842 24.7083 8.7079L26.7083 6.7079C27.0989 6.31737 27.0989 5.68421 26.7083 5.29368ZM25.2941 26.708C25.6846 27.0985 26.3178 27.0985 26.7083 26.708C27.0989 26.3175 27.0989 25.6843 26.7083 25.2938L24.7083 23.2938C24.3178 22.9032 23.6846 22.9032 23.2941 23.2938C22.9036 23.6843 22.9036 24.3175 23.2941 24.708L25.2941 26.708Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconList() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth=".8"
      stroke="currentColor"
      fill="currentColor">
      <path d="M12 10.5C12 11.3284 11.3284 12 10.5 12C9.67157 12 9 11.3284 9 10.5C9 9.67157 9.67157 9 10.5 9C11.3284 9 12 9.67157 12 10.5ZM12 16C12 16.8284 11.3284 17.5 10.5 17.5C9.67157 17.5 9 16.8284 9 16C9 15.1716 9.67157 14.5 10.5 14.5C11.3284 14.5 12 15.1716 12 16ZM10.5 23C11.3284 23 12 22.3284 12 21.5C12 20.6716 11.3284 20 10.5 20C9.67157 20 9 20.6716 9 21.5C9 22.3284 9.67157 23 10.5 23ZM14 10.5C14 9.94772 14.4477 9.5 15 9.5H22C22.5523 9.5 23 9.94772 23 10.5C23 11.0523 22.5523 11.5 22 11.5H15C14.4477 11.5 14 11.0523 14 10.5ZM15 15C14.4477 15 14 15.4477 14 16C14 16.5523 14.4477 17 15 17H22C22.5523 17 23 16.5523 23 16C23 15.4477 22.5523 15 22 15H15ZM14 21.5C14 20.9477 14.4477 20.5 15 20.5H22C22.5523 20.5 23 20.9477 23 21.5C23 22.0523 22.5523 22.5 22 22.5H15C14.4477 22.5 14 22.0523 14 21.5ZM7.5 3C5.01472 3 3 5.01472 3 7.5V24.5C3 26.9853 5.01472 29 7.5 29H24.5C26.9853 29 29 26.9853 29 24.5V7.5C29 5.01472 26.9853 3 24.5 3H7.5ZM5 7.5C5 6.11929 6.11929 5 7.5 5H24.5C25.8807 5 27 6.11929 27 7.5V24.5C27 25.8807 25.8807 27 24.5 27H7.5C6.11929 27 5 25.8807 5 24.5V7.5Z" />
    </svg>
  )
}
export function IconCircles() {
  return (
    <svg
      width="28"
      height="28"
      viewBox="0 0 28 28"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth=".4"
      stroke="currentColor"
      fill="currentColor">
      <path
        d="M13 8C13 5.23858 10.7614 3 8 3C5.23858 3 3 5.23858 3 8C3 10.7614 5.23858 13 8 13C10.7614 13 13 10.7614 13 8ZM11.125 8C11.125 9.72589 9.72589 11.125 8 11.125C6.27411 11.125 4.875 9.72589 4.875 8C4.875 6.27411 6.27411 4.875 8 4.875C9.72589 4.875 11.125 6.27411 11.125 8ZM25 8C25 5.23858 22.7614 3 20 3C17.2386 3 15 5.23858 15 8C15 10.7614 17.2386 13 20 13C22.7614 13 25 10.7614 25 8ZM23.125 8C23.125 9.72589 21.7259 11.125 20 11.125C18.2741 11.125 16.875 9.72589 16.875 8C16.875 6.27411 18.2741 4.875 20 4.875C21.7259 4.875 23.125 6.27411 23.125 8ZM8 25C5.23858 25 3 22.7614 3 20C3 17.2386 5.23858 15 8 15C10.7614 15 13 17.2386 13 20C13 22.7614 10.7614 25 8 25ZM8 23.125C9.72589 23.125 11.125 21.7259 11.125 20C11.125 18.2741 9.72589 16.875 8 16.875C6.27411 16.875 4.875 18.2741 4.875 20C4.875 21.7259 6.27411 23.125 8 23.125ZM25 20C25 17.2386 22.7614 15 20 15C17.2386 15 15 17.2386 15 20C15 22.7614 17.2386 25 20 25C22.7614 25 25 22.7614 25 20ZM23.125 20C23.125 21.7259 21.7259 23.125 20 23.125C18.2741 23.125 16.875 21.7259 16.875 20C16.875 18.2741 18.2741 16.875 20 16.875C21.7259 16.875 23.125 18.2741 23.125 20Z"
        fill="currentColor"
      />
    </svg>
  )
}
export const IconFinance = () => (
  <svg
    width="24"
    height="24"
    fill="currentColor"
    viewBox="0 0 24 24"
    strokeWidth=".5"
    stroke="currentColor"
    xmlns="http://www.w3.org/2000/svg">
    <path d="M8.5 5.247A2.249 2.249 0 0 1 10.75 3h2.5a2.249 2.249 0 0 1 2.25 2.247v1.769h3.25A2.249 2.249 0 0 1 21 9.263v10.988a.75.75 0 0 1-.75.749H3.75a.75.75 0 0 1-.75-.75v-7.99a2.249 2.249 0 0 1 2.25-2.248H8.5V5.247ZM10 19.503h4V5.247a.75.75 0 0 0-.75-.749h-2.5a.75.75 0 0 0-.75.75v14.254ZM8.5 11.51H5.25a.75.75 0 0 0-.75.749v7.242h4V11.51Zm7 7.99h4V9.264a.75.75 0 0 0-.75-.75H15.5v10.989Z" />
  </svg>
)
export function IconApps() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth=".8"
      stroke="currentColor">
      <path
        d="M24.8079 2.95386C23.5387 1.68465 21.4809 1.68465 20.2117 2.95386L16.999 6.16657C16.9547 4.41019 15.517 2.99997 13.75 2.99997H6.25C4.45507 2.99997 3 4.45504 3 6.24997V25.75C3 27.5449 4.45507 29 6.25 29L25.75 29C27.5449 29 29 27.5449 29 25.75V18.25C29 16.4858 27.5944 15.0499 25.842 15.0012L29.0505 11.7927C30.3197 10.5235 30.3197 8.4657 29.0505 7.1965L24.8079 2.95386ZM19.1763 15H17V12.8237L19.1763 15ZM21.6259 4.36807C22.114 3.87991 22.9055 3.87991 23.3936 4.36807L27.6363 8.61071C28.1244 9.09887 28.1244 9.89032 27.6363 10.3785L23.3936 14.6211C22.9055 15.1093 22.114 15.1093 21.6259 14.6211L17.3832 10.3785C16.8951 9.89032 16.8951 9.09887 17.3832 8.61071L21.6259 4.36807ZM15 6.24997V15H5V6.24997C5 5.55961 5.55964 4.99997 6.25 4.99997H13.75C14.4404 4.99997 15 5.55961 15 6.24997ZM5 25.75V17H15V27H6.25C5.55964 27 5 26.4403 5 25.75ZM17 17H25.75C26.4404 17 27 17.5596 27 18.25V25.75C27 26.4403 26.4404 27 25.75 27H17V17Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconEye() {
  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      strokeWidth="1.2"
      stroke="currentColor">
      <path
        d="M28.0335 17.29C28.1635 17.72 28.5634 18 28.9933 18V17.99C29.0933 17.99 29.1832 17.98 29.2832 17.95C29.8131 17.79 30.113 17.24 29.9531 16.71C29.9231 16.61 26.6138 6 15.9961 6C5.3784 6 2.06911 16.61 2.03912 16.72C1.87915 17.25 2.17909 17.8 2.70897 17.96C3.23886 18.12 3.79874 17.82 3.9587 17.29C4.06868 16.91 6.88807 8 15.9961 8C25.1005 8 27.9114 16.9033 28.0335 17.29ZM12 18C12 15.7909 13.7909 14 16 14C18.2091 14 20 15.7909 20 18C20 20.2091 18.2091 22 16 22C13.7909 22 12 20.2091 12 18ZM16 12C12.6863 12 10 14.6863 10 18C10 21.3137 12.6863 24 16 24C19.3137 24 22 21.3137 22 18C22 14.6863 19.3137 12 16 12Z"
        fill="currentColor"
      />
    </svg>
  )
}
export function IconText() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      strokeWidth="1"
      stroke="currentColor"
      fill="currentColor">
      <path d="m2.75,16.25h12.5c.41,0,.75.34.75.75,0,.38-.28.69-.65.74h-.1s-12.5,0-12.5,0c-.41,0-.75-.34-.75-.75,0-.38.28-.69.65-.74h.1s12.5,0,12.5,0H2.75Z" />
      <path d="m2.75,11.25h18.5c.41,0,.75.34.75.75,0,.38-.28.69-.65.74h-.1s-18.5,0-18.5,0c-.41,0-.75-.34-.75-.75,0-.38.28-.69.65-.74h.1s18.5,0,18.5,0H2.75Z" />
      <path d="m2.75,6.25h18.5c.41,0,.75.34.75.75,0,.38-.28.69-.65.74h-.1s-18.5,0-18.5,0c-.41,0-.75-.34-.75-.75,0-.38.28-.69.65-.74h.1s18.5,0,18.5,0H2.75Z" />
    </svg>
  )
}
export function IconLeaf() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 32 32"
      strokeWidth="1"
      stroke="currentColor">
      <path
        d="m5.57,27.88l2.68-2.58c2.07,1.76,4.74,2.84,7.67,2.89,6.74.12,12.3-5.24,12.42-11.98l.16-8.84c.03-1.86-1.45-3.39-3.3-3.43l-8.84-.16c-6.74-.12-12.3,5.24-12.42,11.98-.05,2.93.93,5.64,2.61,7.77l-2.68,2.58c-.49.47-.5,1.24-.03,1.73.47.49,1.24.5,1.73.03Zm.81-12.07c.1-5.39,4.55-9.68,9.94-9.59l8.84.16c.51,0,.92.43.91.94l-.16,8.84c-.1,5.39-4.55,9.68-9.94,9.59-2.26-.04-4.32-.84-5.95-2.16l7.85-7.57c.49-.47.5-1.24.03-1.73-.47-.49-1.24-.5-1.73-.03l-7.85,7.57c-1.26-1.68-1.98-3.77-1.94-6.02Z"
        fill="currentColor"
      />
    </svg>
  )
}
export const IconDownload = () => (
  <svg
    width="24"
    height="24"
    fill="none"
    viewBox="0 0 24 24"
    strokeWidth=".5"
    stroke="currentColor"
    xmlns="http://www.w3.org/2000/svg">
    <path
      d="M18.25 20.5a.75.75 0 1 1 0 1.5l-13 .004a.75.75 0 1 1 0-1.5l13-.004ZM11.648 2.012l.102-.007a.75.75 0 0 1 .743.648l.007.102-.001 13.685 3.722-3.72a.75.75 0 0 1 .976-.073l.085.073a.75.75 0 0 1 .072.976l-.073.084-4.997 4.997a.75.75 0 0 1-.976.073l-.085-.073-5.003-4.996a.75.75 0 0 1 .976-1.134l.084.072 3.719 3.714L11 2.755a.75.75 0 0 1 .648-.743l.102-.007-.102.007Z"
      fill="currentColor"
    />
  </svg>
)
export const IconMore = () => (
  <svg
    viewBox="0 0 24 24"
    width="24"
    height="24"
    stroke="currentColor"
    strokeWidth="2"
    fill="none"
    strokeLinecap="round"
    strokeLinejoin="round">
    <circle cx="12" cy="12" r="1"></circle>
    <circle cx="12" cy="5" r="1"></circle>
    <circle cx="12" cy="19" r="1"></circle>
  </svg>
)
export const IconInfo = () => (
  <svg
    width="24"
    height="24"
    fill="currentColor"
    strokeWidth=".7"
    stroke="currentColor"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg">
    <path d="M12 1.999c5.524 0 10.002 4.478 10.002 10.002 0 5.523-4.478 10.001-10.002 10.001-5.524 0-10.002-4.478-10.002-10.001C1.998 6.477 6.476 1.999 12 1.999Zm0 1.5a8.502 8.502 0 1 0 0 17.003A8.502 8.502 0 0 0 12 3.5Zm-.004 7a.75.75 0 0 1 .744.648l.007.102.003 5.502a.75.75 0 0 1-1.493.102l-.007-.101-.003-5.502a.75.75 0 0 1 .75-.75ZM12 7.003a.999.999 0 1 1 0 1.997.999.999 0 0 1 0-1.997Z" />
  </svg>
)
export const IconThemeSystem = () => (
  <svg
    width="24"
    height="24"
    fill="currentColor"
    strokeWidth=".7"
    stroke="currentColor"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg">
    <path d="M6.75 22a.75.75 0 0 1-.102-1.493l.102-.007h1.749v-2.498H4.25a2.25 2.25 0 0 1-2.245-2.096L2 15.752V5.25a2.25 2.25 0 0 1 2.096-2.245L4.25 3h15.499a2.25 2.25 0 0 1 2.245 2.096l.005.154v10.502a2.25 2.25 0 0 1-2.096 2.245l-.154.005h-4.25V20.5h1.751a.75.75 0 0 1 .102 1.494L17.25 22H6.75Zm7.248-3.998h-4l.001 2.498h4l-.001-2.498ZM19.748 4.5H4.25a.75.75 0 0 0-.743.648L3.5 5.25v10.502c0 .38.282.694.648.743l.102.007h15.499a.75.75 0 0 0 .743-.648l.007-.102V5.25a.75.75 0 0 0-.648-.743l-.102-.007Z" />
  </svg>
)
export const IconChevronDown = () => (
  <svg
    width="24"
    height="24"
    fill="currentColor"
    strokeWidth=".5"
    stroke="currentColor"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg">
    <path d="M4.293 8.293a1 1 0 0 1 1.414 0L12 14.586l6.293-6.293a1 1 0 1 1 1.414 1.414l-7 7a1 1 0 0 1-1.414 0l-7-7a1 1 0 0 1 0-1.414Z" />
  </svg>
)

export const IconBluesky = () => (
  <svg fill="currentColor" viewBox="0 0 64 57">
    <path d="M13.873 3.805C21.21 9.332 29.103 20.537 32 26.55v15.882c0-.338-.13.044-.41.867-1.512 4.456-7.418 21.847-20.923 7.944-7.111-7.32-3.819-14.64 9.125-16.85-7.405 1.264-15.73-.825-18.014-9.015C1.12 23.022 0 8.51 0 6.55 0-3.268 8.579-.182 13.873 3.805ZM50.127 3.805C42.79 9.332 34.897 20.537 32 26.55v15.882c0-.338.13.044.41.867 1.512 4.456 7.418 21.847 20.923 7.944 7.111-7.32 3.819-14.64-9.125-16.85 7.405 1.264 15.73-.825 18.014-9.015C62.88 23.022 64 8.51 64 6.55c0-9.818-8.578-6.732-13.873-2.745Z"></path>
  </svg>
)
export const IconX = () => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 77.44 80"
    fill="currentColor">
    <path d="m60.99,5h11.87l-25.95,29.65,30.52,40.35h-23.89l-18.71-24.47-21.42,24.47H1.53l27.75-31.71L0,5h24.5l16.92,22.37L60.99,5Zm-4.17,62.89h6.58L20.93,11.74h-7.07l42.95,56.16h0Z" />
  </svg>
)
export const IconGitHub = () => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 24 24"
    fill="currentColor">
    <path
      className="svg"
      d="M12,.37A11.93,11.93,0,0,0,8.15,23.62c.59.08.81-.29.81-.58V21c-3.3.74-4-1.61-4-1.61A3,3,0,0,0,3.6,17.68c-1-.73.08-.73.08-.73A2.52,2.52,0,0,1,5.51,18.2a2.54,2.54,0,0,0,3.44,1H9a2.57,2.57,0,0,1,.74-1.61c-2.65-.3-5.43-1.33-5.43-6A4.51,4.51,0,0,1,5.51,8.44a4.17,4.17,0,0,1,.15-3.16S6.68,5,9,6.53a10.53,10.53,0,0,1,3-.37,13.33,13.33,0,0,1,3,.37c2.27-1.54,3.3-1.25,3.3-1.25a4.58,4.58,0,0,1,.14,3.16,4.71,4.71,0,0,1,1.25,3.23c0,4.62-2.79,5.57-5.43,5.86a2.84,2.84,0,0,1,.81,2.21V23c0,.29.22.66.81.58A12,12,0,0,0,24,12.25,12,12,0,0,0,12,.37Z"
    />
  </svg>
)
export const IconInstagram = () => (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
    <path
      d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"
      className="svg"
    />
  </svg>
)
export const IconKofi = () => (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
    <path
      className="svg"
      d="m31.84,11.93c-1.03-5.45-6.48-6.12-6.48-6.12H.96C.16,5.81.06,6.87.06,6.87c0,0-.11,9.77-.03,15.76.22,3.23,3.45,3.56,3.45,3.56,0,0,11.02-.03,15.95-.06,3.25-.57,3.58-3.42,3.55-4.98,5.8.32,9.89-3.77,8.86-9.22Zm-14.75,4.68c-1.66,1.94-5.35,5.3-5.35,5.3,0,0-.16.16-.41.03-.1-.07-.14-.12-.14-.12-.59-.59-4.49-4.06-5.38-5.27-.95-1.29-1.39-3.6-.12-4.95,1.27-1.35,4.01-1.45,5.82.54,0,0,2.09-2.38,4.62-1.28,2.54,1.09,2.44,4.01.96,5.75Zm8.23.64c-1.24.15-2.24.04-2.24.04v-7.58h2.36s2.63.73,2.63,3.52c0,2.55-1.31,3.56-2.75,4.02Z"
    />
  </svg>
)
export const IconDiscord = () => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 24 24"
    fill="currentColor">
    <path
      className="svg"
      d="M20.35,4.43a20.11,20.11,0,0,0-5-1.53,12.8,12.8,0,0,0-.63,1.29,18.77,18.77,0,0,0-5.5,0c-.17-.4-.42-.91-.63-1.29a19.6,19.6,0,0,0-5,1.53A20,20,0,0,0,.1,18.05,20.27,20.27,0,0,0,6.18,21.1,16,16,0,0,0,7.48,19a13.32,13.32,0,0,1-2.05-1c.17-.13.34-.26.49-.39a14.34,14.34,0,0,0,12.15,0l.49.39a13.32,13.32,0,0,1-2,1,16,16,0,0,0,1.3,2.1,20.15,20.15,0,0,0,6.08-3.05A19.91,19.91,0,0,0,20.35,4.43ZM8,15.3a2.29,2.29,0,0,1-2.16-2.4A2.28,2.28,0,0,1,8,10.5a2.27,2.27,0,0,1,2.16,2.4A2.29,2.29,0,0,1,8,15.3Zm8,0a2.29,2.29,0,0,1-2.16-2.4A2.28,2.28,0,0,1,16,10.5a2.27,2.27,0,0,1,2.16,2.4A2.28,2.28,0,0,1,16,15.3Z"
    />
  </svg>
)
export const IconPatreon = () => (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
    <circle className="svg" cx="15.34" cy="9.11" r="8.66" />
    <rect className="svg" y="0.45" width="4.23" height="23.1" />
  </svg>
)
export const IconTwitter = () => (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
    <path d="M13.25,3.58a5,5,0,0,1,7,.23A10.54,10.54,0,0,0,23.39,2.6a5.28,5.28,0,0,1-2.16,2.74A9.55,9.55,0,0,0,24,4.55v0a10.07,10.07,0,0,1-2.45,2.55,14.35,14.35,0,0,1-6.61,12.63,13.92,13.92,0,0,1-7.66,2,13.72,13.72,0,0,1-5.13-1.06A17.48,17.48,0,0,1,0,19.58H0a3.94,3.94,0,0,1,.68,0A10,10,0,0,0,7.3,17.51a4.82,4.82,0,0,1-2.58-.78,5,5,0,0,1-2-2.65A4.72,4.72,0,0,0,4.89,14,4.94,4.94,0,0,1,1,9.12a5.28,5.28,0,0,0,2.22.62,5,5,0,0,1-1.5-6.6A14,14,0,0,0,11.83,8.31,5,5,0,0,1,13.25,3.58Z" />
  </svg>
)

export const Icon = () => (
  <svg
    width="28"
    height="28"
    viewBox="0 0 28 28"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    strokeWidth="1"
    stroke="currentColor">
    <path
      d="M3 6.25C3 4.45507 4.45507 3 6.25 3H21.75C23.5449 3 25 4.45507 25 6.25V21.75C25 23.5449 23.5449 25 21.75 25H6.25C4.45507 25 3 23.5449 3 21.75V6.25ZM6.25 4.5C5.2835 4.5 4.5 5.2835 4.5 6.25V21.75C4.5 22.7165 5.2835 23.5 6.25 23.5H21.75C22.7165 23.5 23.5 22.7165 23.5 21.75V6.25C23.5 5.2835 22.7165 4.5 21.75 4.5H6.25Z"
      fill="currentColor"
    />
  </svg>
)
