-- MySQL Script generated by MySQL Workbench
-- qua 21 jul 2021 19:01:05
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema biblioteca
-- -----------------------------------------------------
DROP SCHEMA IF EXISTS `biblioteca` ;

-- -----------------------------------------------------
-- Schema biblioteca
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `biblioteca` DEFAULT CHARACTER SET utf8 ;
USE `biblioteca` ;

-- -----------------------------------------------------
-- Table `biblioteca`.`menu`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `biblioteca`.`menu` ;

CREATE TABLE IF NOT EXISTS `biblioteca`.`menu` (
  `idMenu` INT NOT NULL AUTO_INCREMENT,
  `nome` VARCHAR(45) NOT NULL,
  `link` VARCHAR(100) NOT NULL,
  `exibir` INT NOT NULL,
  PRIMARY KEY (`idMenu`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `biblioteca`.`perfil`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `biblioteca`.`perfil` ;

CREATE TABLE IF NOT EXISTS `biblioteca`.`perfil` (
  `idPerfil` INT NOT NULL AUTO_INCREMENT,
  `nome` VARCHAR(45) NOT NULL,
  PRIMARY KEY (`idPerfil`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `biblioteca`.`usuario`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `biblioteca`.`usuario` ;

CREATE TABLE IF NOT EXISTS `biblioteca`.`usuario` (
  `idUsuario` INT NOT NULL AUTO_INCREMENT,
  `nome` VARCHAR(60) NOT NULL,
  `sobrenome` VARCHAR(60) NULL,
  `dataNascimento` DATE NOT NULL,
  `sexo` ENUM('f', 'm') NOT NULL,
  `cpf` VARCHAR(14) NOT NULL,
  `rg` VARCHAR(60) NOT NULL,
  `login` VARCHAR(60) NOT NULL,
  `senha` VARCHAR(60) NOT NULL,
  `status` INT NOT NULL DEFAULT 1,
  `email` VARCHAR(120) NOT NULL,
  `telefone` VARCHAR(22) NOT NULL,
  `cep` VARCHAR(8) NOT NULL,
  `rua` VARCHAR(60) NOT NULL,
  `numero` INT NULL,
  `uf` VARCHAR(2) NOT NULL,
  `bairro` VARCHAR(60) NOT NULL,
  `cidade` VARCHAR(60) NOT NULL,
  `complemento` VARCHAR(120) NULL,
  `idPerfil` INT NOT NULL,
  PRIMARY KEY (`idUsuario`),
  INDEX `fk_usuario_perfil_idx` (`idPerfil` ASC) VISIBLE,
  CONSTRAINT `fk_usuario_perfil`
    FOREIGN KEY (`idPerfil`)
    REFERENCES `biblioteca`.`perfil` (`idPerfil`)
    ON DELETE RESTRICT
    ON UPDATE CASCADE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `biblioteca`.`menu_perfil`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `biblioteca`.`menu_perfil` ;

CREATE TABLE IF NOT EXISTS `biblioteca`.`menu_perfil` (
  `idMenu` INT NOT NULL,
  `idPerfil` INT NOT NULL,
  PRIMARY KEY (`idMenu`, `idPerfil`),
  INDEX `fk_menu_has_perfil_perfil1_idx` (`idPerfil` ASC) VISIBLE,
  INDEX `fk_menu_has_perfil_menu1_idx` (`idMenu` ASC) VISIBLE,
  CONSTRAINT `fk_menu_has_perfil_menu1`
    FOREIGN KEY (`idMenu`)
    REFERENCES `biblioteca`.`menu` (`idMenu`)
    ON DELETE RESTRICT
    ON UPDATE CASCADE,
  CONSTRAINT `fk_menu_has_perfil_perfil1`
    FOREIGN KEY (`idPerfil`)
    REFERENCES `biblioteca`.`perfil` (`idPerfil`)
    ON DELETE RESTRICT
    ON UPDATE CASCADE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `biblioteca`.`livro`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `biblioteca`.`livro` ;

CREATE TABLE IF NOT EXISTS `biblioteca`.`livro` (
  `idLivro` INT NOT NULL AUTO_INCREMENT,
  `titulo` VARCHAR(180) NOT NULL,
  `descricao` TEXT NOT NULL,
  `autor` VARCHAR(120) NOT NULL,
  `editora` VARCHAR(60) NULL,
  `categoria` VARCHAR(120) NOT NULL,
  `paginas` INT NULL,
  `ano` YEAR NULL,
  `isbn` VARCHAR(60) NOT NULL,
  `idioma` VARCHAR(60) NOT NULL,
  `disponivel` INT NOT NULL DEFAULT 1,
  `imagem` VARCHAR(120) NULL,
  PRIMARY KEY (`idLivro`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `biblioteca`.`cliente`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `biblioteca`.`cliente` ;

CREATE TABLE IF NOT EXISTS `biblioteca`.`cliente` (
  `idCliente` INT NOT NULL AUTO_INCREMENT,
  `nome` VARCHAR(60) NOT NULL,
  `sobrenome` VARCHAR(60) NOT NULL,
  `dataNascimento` DATE NOT NULL,
  `sexo` ENUM('f', 'm') NOT NULL,
  `cpf` VARCHAR(14) NOT NULL,
  `status` INT NOT NULL DEFAULT 1,
  `email` VARCHAR(120) NOT NULL,
  `telefone` VARCHAR(22) NOT NULL,
  `cep` VARCHAR(8) NOT NULL,
  `rua` VARCHAR(60) NOT NULL,
  `numero` INT NOT NULL,
  `uf` VARCHAR(2) NOT NULL,
  `bairro` VARCHAR(60) NOT NULL,
  `cidade` VARCHAR(60) NOT NULL,
  `complemento` VARCHAR(120) NULL,
  PRIMARY KEY (`idCliente`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `biblioteca`.`emprestimo`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `biblioteca`.`emprestimo` ;

CREATE TABLE IF NOT EXISTS `biblioteca`.`emprestimo` (
  `idEmprestimo` INT NOT NULL AUTO_INCREMENT,
  `dataEntrega` DATE NOT NULL,
  `dataDevolucao` DATE NOT NULL,
  `status` INT NOT NULL,
  `multaMotivo` VARCHAR(120) NULL,
  `multaValor` DOUBLE NULL,
  `multaPaga` INT NULL,
  `idLivro` INT NOT NULL,
  `idUsuario` INT NOT NULL,
  `idCliente` INT NOT NULL,
  PRIMARY KEY (`idEmprestimo`),
  INDEX `fk_emprestimo_livro1_idx` (`idLivro` ASC) VISIBLE,
  INDEX `fk_emprestimo_usuario1_idx` (`idUsuario` ASC) VISIBLE,
  INDEX `fk_emprestimo_cliente1_idx` (`idCliente` ASC) VISIBLE,
  CONSTRAINT `fk_emprestimo_livro1`
    FOREIGN KEY (`idLivro`)
    REFERENCES `biblioteca`.`livro` (`idLivro`)
    ON DELETE RESTRICT
    ON UPDATE CASCADE,
  CONSTRAINT `fk_emprestimo_usuario1`
    FOREIGN KEY (`idUsuario`)
    REFERENCES `biblioteca`.`usuario` (`idUsuario`)
    ON DELETE RESTRICT
    ON UPDATE CASCADE,
  CONSTRAINT `fk_emprestimo_cliente1`
    FOREIGN KEY (`idCliente`)
    REFERENCES `biblioteca`.`cliente` (`idCliente`)
    ON DELETE RESTRICT
    ON UPDATE CASCADE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
