/*
 * This code has been automatically generated by gentables.py from
 * the table provided in RFC7541.  Do not modify!
 *
 * This is being included here so we can fuzz-test the decoder in
 * oss-fuzz before we go forward with the HTTP/2 implementation.
 *
 * lwan - web server
 * Copyright (c) 2022 L. A. F. Pereira <l@tia.mat.br>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 */

#if defined(FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION)

#include <assert.h>
#include <endian.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ringbuffer.h"

#define LIKELY(x) x
#define UNLIKELY(x) x

static inline uint64_t read64be(const void *ptr)
{
    uint64_t v;
    memcpy(&v, ptr, 8);
    return htobe64(v);
}

static inline uint32_t read32be(const void *ptr)
{
    uint32_t v;
    memcpy(&v, ptr, 4);
    return htobe32(v);
}

struct h2_huffman_code {
    uint8_t symbol;
    int8_t num_bits;
};

static const struct h2_huffman_code level0[256] = {
    [0 ... 7] = {48, 5},      [8 ... 15] = {49, 5},
    [16 ... 23] = {50, 5},    [24 ... 31] = {97, 5},
    [32 ... 39] = {99, 5},    [40 ... 47] = {101, 5},
    [48 ... 55] = {105, 5},   [56 ... 63] = {111, 5},
    [64 ... 71] = {115, 5},   [72 ... 79] = {116, 5},
    [80 ... 83] = {32, 6},    [84 ... 87] = {37, 6},
    [88 ... 91] = {45, 6},    [92 ... 95] = {46, 6},
    [96 ... 99] = {47, 6},    [100 ... 103] = {51, 6},
    [104 ... 107] = {52, 6},  [108 ... 111] = {53, 6},
    [112 ... 115] = {54, 6},  [116 ... 119] = {55, 6},
    [120 ... 123] = {56, 6},  [124 ... 127] = {57, 6},
    [128 ... 131] = {61, 6},  [132 ... 135] = {65, 6},
    [136 ... 139] = {95, 6},  [140 ... 143] = {98, 6},
    [144 ... 147] = {100, 6}, [148 ... 151] = {102, 6},
    [152 ... 155] = {103, 6}, [156 ... 159] = {104, 6},
    [160 ... 163] = {108, 6}, [164 ... 167] = {109, 6},
    [168 ... 171] = {110, 6}, [172 ... 175] = {112, 6},
    [176 ... 179] = {114, 6}, [180 ... 183] = {117, 6},
    [184 ... 185] = {58, 7},  [186 ... 187] = {66, 7},
    [188 ... 189] = {67, 7},  [190 ... 191] = {68, 7},
    [192 ... 193] = {69, 7},  [194 ... 195] = {70, 7},
    [196 ... 197] = {71, 7},  [198 ... 199] = {72, 7},
    [200 ... 201] = {73, 7},  [202 ... 203] = {74, 7},
    [204 ... 205] = {75, 7},  [206 ... 207] = {76, 7},
    [208 ... 209] = {77, 7},  [210 ... 211] = {78, 7},
    [212 ... 213] = {79, 7},  [214 ... 215] = {80, 7},
    [216 ... 217] = {81, 7},  [218 ... 219] = {82, 7},
    [220 ... 221] = {83, 7},  [222 ... 223] = {84, 7},
    [224 ... 225] = {85, 7},  [226 ... 227] = {86, 7},
    [228 ... 229] = {87, 7},  [230 ... 231] = {89, 7},
    [232 ... 233] = {106, 7}, [234 ... 235] = {107, 7},
    [236 ... 237] = {113, 7}, [238 ... 239] = {118, 7},
    [240 ... 241] = {119, 7}, [242 ... 243] = {120, 7},
    [244 ... 245] = {121, 7}, [246 ... 247] = {122, 7},
    [248] = {38, 8},          [249] = {42, 8},
    [250] = {44, 8},          [251] = {59, 8},
    [252] = {88, 8},          [253] = {90, 8},
};

static inline const struct h2_huffman_code *next_level0(uint8_t peeked_byte)
{
    static const struct h2_huffman_code level0_11111111[256] = {
        [0 ... 63] = {63, 2},     [64 ... 95] = {39, 3},
        [96 ... 127] = {43, 3},   [128 ... 159] = {124, 3},
        [160 ... 175] = {35, 4},  [176 ... 191] = {62, 4},
        [192 ... 199] = {0, 5},   [200 ... 207] = {36, 5},
        [208 ... 215] = {64, 5},  [216 ... 223] = {91, 5},
        [224 ... 231] = {93, 5},  [232 ... 239] = {126, 5},
        [240 ... 243] = {94, 6},  [244 ... 247] = {125, 6},
        [248 ... 249] = {60, 7},  [250 ... 251] = {96, 7},
        [252 ... 253] = {123, 7},
    };
    static const struct h2_huffman_code level0_11111110[256] = {
        [0 ... 63] = {33, 2},
        [64 ... 127] = {34, 2},
        [128 ... 191] = {40, 2},
        [192 ... 255] = {41, 2},
    };
    return peeked_byte & 1 ? level0_11111111 : level0_11111110;
}

static inline const struct h2_huffman_code *next_level1(uint8_t peeked_byte)
{
    static const struct h2_huffman_code level1_11111111[256] = {
        [0 ... 7] = {176, 5},     [8 ... 15] = {177, 5},
        [16 ... 23] = {179, 5},   [24 ... 31] = {209, 5},
        [32 ... 39] = {216, 5},   [40 ... 47] = {217, 5},
        [48 ... 55] = {227, 5},   [56 ... 63] = {229, 5},
        [64 ... 71] = {230, 5},   [72 ... 75] = {129, 6},
        [76 ... 79] = {132, 6},   [80 ... 83] = {133, 6},
        [84 ... 87] = {134, 6},   [88 ... 91] = {136, 6},
        [92 ... 95] = {146, 6},   [96 ... 99] = {154, 6},
        [100 ... 103] = {156, 6}, [104 ... 107] = {160, 6},
        [108 ... 111] = {163, 6}, [112 ... 115] = {164, 6},
        [116 ... 119] = {169, 6}, [120 ... 123] = {170, 6},
        [124 ... 127] = {173, 6}, [128 ... 131] = {178, 6},
        [132 ... 135] = {181, 6}, [136 ... 139] = {185, 6},
        [140 ... 143] = {186, 6}, [144 ... 147] = {187, 6},
        [148 ... 151] = {189, 6}, [152 ... 155] = {190, 6},
        [156 ... 159] = {196, 6}, [160 ... 163] = {198, 6},
        [164 ... 167] = {228, 6}, [168 ... 171] = {232, 6},
        [172 ... 175] = {233, 6}, [176 ... 177] = {1, 7},
        [178 ... 179] = {135, 7}, [180 ... 181] = {137, 7},
        [182 ... 183] = {138, 7}, [184 ... 185] = {139, 7},
        [186 ... 187] = {140, 7}, [188 ... 189] = {141, 7},
        [190 ... 191] = {143, 7}, [192 ... 193] = {147, 7},
        [194 ... 195] = {149, 7}, [196 ... 197] = {150, 7},
        [198 ... 199] = {151, 7}, [200 ... 201] = {152, 7},
        [202 ... 203] = {155, 7}, [204 ... 205] = {157, 7},
        [206 ... 207] = {158, 7}, [208 ... 209] = {165, 7},
        [210 ... 211] = {166, 7}, [212 ... 213] = {168, 7},
        [214 ... 215] = {174, 7}, [216 ... 217] = {175, 7},
        [218 ... 219] = {180, 7}, [220 ... 221] = {182, 7},
        [222 ... 223] = {183, 7}, [224 ... 225] = {188, 7},
        [226 ... 227] = {191, 7}, [228 ... 229] = {197, 7},
        [230 ... 231] = {231, 7}, [232 ... 233] = {239, 7},
        [234] = {9, 8},           [235] = {142, 8},
        [236] = {144, 8},         [237] = {145, 8},
        [238] = {148, 8},         [239] = {159, 8},
        [240] = {171, 8},         [241] = {206, 8},
        [242] = {215, 8},         [243] = {225, 8},
        [244] = {236, 8},         [245] = {237, 8},
    };
    static const struct h2_huffman_code level1_11111110[256] = {
        [0 ... 31] = {92, 3},     [32 ... 63] = {195, 3},
        [64 ... 95] = {208, 3},   [96 ... 111] = {128, 4},
        [112 ... 127] = {130, 4}, [128 ... 143] = {131, 4},
        [144 ... 159] = {162, 4}, [160 ... 175] = {184, 4},
        [176 ... 191] = {194, 4}, [192 ... 207] = {224, 4},
        [208 ... 223] = {226, 4}, [224 ... 231] = {153, 5},
        [232 ... 239] = {161, 5}, [240 ... 247] = {167, 5},
        [248 ... 255] = {172, 5},
    };
    return peeked_byte & 1 ? level1_11111111 : level1_11111110;
}

static inline const struct h2_huffman_code *next_level2(uint8_t peeked_byte)
{
    static const struct h2_huffman_code level2_11111110[256] = {
        [0 ... 31] = {254, 3},   [32 ... 47] = {2, 4},
        [48 ... 63] = {3, 4},    [64 ... 79] = {4, 4},
        [80 ... 95] = {5, 4},    [96 ... 111] = {6, 4},
        [112 ... 127] = {7, 4},  [128 ... 143] = {8, 4},
        [144 ... 159] = {11, 4}, [160 ... 175] = {12, 4},
        [176 ... 191] = {14, 4}, [192 ... 207] = {15, 4},
        [208 ... 223] = {16, 4}, [224 ... 239] = {17, 4},
        [240 ... 255] = {18, 4},
    };
    static const struct h2_huffman_code level2_11111111[256] = {
        [0 ... 15] = {19, 4},     [16 ... 31] = {20, 4},
        [32 ... 47] = {21, 4},    [48 ... 63] = {23, 4},
        [64 ... 79] = {24, 4},    [80 ... 95] = {25, 4},
        [96 ... 111] = {26, 4},   [112 ... 127] = {27, 4},
        [128 ... 143] = {28, 4},  [144 ... 159] = {29, 4},
        [160 ... 175] = {30, 4},  [176 ... 191] = {31, 4},
        [192 ... 207] = {127, 4}, [208 ... 223] = {220, 4},
        [224 ... 239] = {249, 4}, [240 ... 243] = {10, 6},
        [244 ... 247] = {13, 6},  [248 ... 251] = {22, 6},
        [252 ... 255] = {0, -1},
    };
    static const struct h2_huffman_code level2_11111000[256] = {
        [0 ... 63] = {192, 2},
        [64 ... 127] = {193, 2},
        [128 ... 191] = {200, 2},
        [192 ... 255] = {201, 2},
    };
    static const struct h2_huffman_code level2_11110110[256] = {
        [0 ... 127] = {199, 1},
        [128 ... 255] = {207, 1},
    };
    static const struct h2_huffman_code level2_11111001[256] = {
        [0 ... 63] = {202, 2},
        [64 ... 127] = {205, 2},
        [128 ... 191] = {210, 2},
        [192 ... 255] = {213, 2},
    };
    static const struct h2_huffman_code level2_11111011[256] = {
        [0 ... 63] = {242, 2},    [64 ... 127] = {243, 2},
        [128 ... 191] = {255, 2}, [192 ... 223] = {203, 3},
        [224 ... 255] = {204, 3},
    };
    static const struct h2_huffman_code level2_11111100[256] = {
        [0 ... 31] = {211, 3},    [32 ... 63] = {212, 3},
        [64 ... 95] = {214, 3},   [96 ... 127] = {221, 3},
        [128 ... 159] = {222, 3}, [160 ... 191] = {223, 3},
        [192 ... 223] = {241, 3}, [224 ... 255] = {244, 3},
    };
    static const struct h2_huffman_code level2_11111010[256] = {
        [0 ... 63] = {218, 2},
        [64 ... 127] = {219, 2},
        [128 ... 191] = {238, 2},
        [192 ... 255] = {240, 2},
    };
    static const struct h2_huffman_code level2_11110111[256] = {
        [0 ... 127] = {234, 1},
        [128 ... 255] = {235, 1},
    };
    static const struct h2_huffman_code level2_11111101[256] = {
        [0 ... 31] = {245, 3},    [32 ... 63] = {246, 3},
        [64 ... 95] = {247, 3},   [96 ... 127] = {248, 3},
        [128 ... 159] = {250, 3}, [160 ... 191] = {251, 3},
        [192 ... 223] = {252, 3}, [224 ... 255] = {253, 3},
    };
    switch (peeked_byte) {
    case 0b11111110:
        return level2_11111110;
    case 0b11111111:
        return level2_11111111;
    case 0b11111000:
        return level2_11111000;
    case 0b11110110:
        return level2_11110110;
    case 0b11111001:
        return level2_11111001;
    case 0b11111011:
        return level2_11111011;
    case 0b11111100:
        return level2_11111100;
    case 0b11111010:
        return level2_11111010;
    case 0b11110111:
        return level2_11110111;
    case 0b11111101:
        return level2_11111101;
    default:
        return NULL;
    }
}

struct bit_reader {
    const uint8_t *bitptr;
    uint64_t bitbuf;
    int64_t total_bitcount;
    int bitcount;
};

static inline uint8_t peek_byte(struct bit_reader *reader)
{
    if (reader->bitcount < 8) {
        if (reader->total_bitcount >= 64) {
            reader->bitbuf |= read64be(reader->bitptr) >> reader->bitcount;
            reader->bitptr +=
                (63 - reader->bitcount + (reader->bitcount & 1)) >> 3;
            reader->bitcount |= 56;
        } else if (reader->total_bitcount >= 32) {
            reader->bitbuf |= read32be(reader->bitptr) >> reader->bitcount;
            reader->bitptr +=
                (31 - reader->bitcount + (reader->bitcount & 1)) >> 3;
            reader->bitcount |= 24;
        } else {
            reader->bitbuf |= *reader->bitptr >> reader->bitcount;
            reader->bitptr +=
                (7 - reader->bitcount + (reader->bitcount & 1)) >> 3;
            reader->bitcount |= 8;
        }
    }
    return reader->bitbuf >> 56;
}

static inline bool consume(struct bit_reader *reader, int count)
{
    assert(count > 0);
    reader->bitbuf <<= count;
    reader->bitcount -= count;
    reader->total_bitcount -= count;
    return reader->total_bitcount > 0;
}

DEFINE_RING_BUFFER_TYPE(uint8_ring_buffer, uint8_t, 64)

struct lwan_h2_huffman_decoder {
    struct bit_reader bit_reader;
    struct uint8_ring_buffer buffer;
};

void lwan_h2_huffman_init(struct lwan_h2_huffman_decoder *huff,
                          const uint8_t *input,
                          size_t input_len)
{
    huff->bit_reader = (struct bit_reader){
        .bitptr = input,
        .total_bitcount = (int64_t)input_len * 8,
    };
    uint8_ring_buffer_init(&huff->buffer);
}

ssize_t lwan_h2_huffman_next(struct lwan_h2_huffman_decoder *huff)
{
    struct bit_reader *reader = &huff->bit_reader;
    struct uint8_ring_buffer *buffer = &huff->buffer;

    while (reader->total_bitcount > 7) {
        uint8_t peeked_byte = peek_byte(reader);
        if (LIKELY(level0[peeked_byte].num_bits)) {
            if (!uint8_ring_buffer_try_put_copy(buffer,
                                                level0[peeked_byte].symbol))
                goto done;
            consume(reader, level0[peeked_byte].num_bits);
            assert(reader->total_bitcount >= 0);
            continue;
        }

        if (!consume(reader, 8))
            return -1;

        const struct h2_huffman_code *level1 = next_level0(peeked_byte);
        peeked_byte = peek_byte(reader);
        if (level1[peeked_byte].num_bits) {
            if (!uint8_ring_buffer_try_put_copy(buffer,
                                                level1[peeked_byte].symbol))
                goto done;
            if (!consume(reader, level1[peeked_byte].num_bits))
                return -1;
            continue;
        }

        if (!consume(reader, 8))
            return -1;

        const struct h2_huffman_code *level2 = next_level1(peeked_byte);
        peeked_byte = peek_byte(reader);
        if (level2[peeked_byte].num_bits) {
            if (!uint8_ring_buffer_try_put_copy(buffer,
                                                level2[peeked_byte].symbol))
                goto done;
            if (!consume(reader, level2[peeked_byte].num_bits))
                return -1;
            continue;
        }

        if (!consume(reader, 8))
            return -1;

        const struct h2_huffman_code *level3 = next_level2(peeked_byte);
        if (LIKELY(level3)) {
            peeked_byte = peek_byte(reader);
            if (level3[peeked_byte].num_bits < 0) {
                /* EOS found */
                goto done;
            }
            if (LIKELY(level3[peeked_byte].num_bits)) {
                if (!uint8_ring_buffer_try_put_copy(buffer,
                                                    level3[peeked_byte].symbol))
                    goto done;
                if (!consume(reader, level3[peeked_byte].num_bits))
                    return -1;
                continue;
            }
        }

        return -1;
    }

    /* FIXME: ensure we're not promoting types unnecessarily here */
    if (reader->total_bitcount) {
        const uint8_t peeked_byte = peek_byte(reader);
        const uint8_t eos_prefix =
            (uint8_t)(((1u << reader->total_bitcount) - 1u)
                      << (8u - reader->total_bitcount));

        if ((peeked_byte & eos_prefix) == eos_prefix)
            goto done;

        if (level0[peeked_byte].num_bits == (int8_t)reader->total_bitcount) {
            uint8_ring_buffer_try_put_copy(buffer, level0[peeked_byte].symbol);
            goto done;
        }

        /* If we get here, then the remaining bits are either:
         *  - Not a prefix of EOS
         *  - Incomplete sequence
         *  - Has overlong padding
         */
        return -1;
    }

done:
    return (ssize_t)uint8_ring_buffer_size(buffer);
}

bool lwan_h2_huffman_decode_for_fuzzing(const uint8_t *input, size_t input_len)
{
    struct lwan_h2_huffman_decoder decoder;

    lwan_h2_huffman_init(&decoder, input, input_len);

    while (true) {
        ssize_t n_decoded = lwan_h2_huffman_next(&decoder);

        if (UNLIKELY(n_decoded < 0))
            return false;
        if (n_decoded < 64)
            return true;

        uint8_ring_buffer_init(&decoder.buffer);
    }
}
#endif
