/*
 * lwan - web server
 * Copyright (c) 2012 L. A. F. Pereira <l@tia.mat.br>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#pragma once

#include <stddef.h>
#include <sys/types.h>

#define INT_TO_STR_BUFFER_SIZE (3 * sizeof(size_t))

char *int_to_string(ssize_t value,
                    char buffer[static INT_TO_STR_BUFFER_SIZE],
                    size_t *len);
char *uint_to_string(size_t value,
                     char buffer[static INT_TO_STR_BUFFER_SIZE],
                     size_t *len);

const char *uint_to_string_2_digits(size_t value) __attribute__((pure));
