import dedent from "ts-dedent"

import { LicenseType, type ModelMap, ModelType } from "./_shared"

const commonLicenses = [
  LicenseType.OpenSource,
  LicenseType.Apache2,
  LicenseType.Commercial
]

export const dollyModelMap: ModelMap = {
  "Dolly v2 3B": {
    description: dedent`
      Trained on ~15k instruction/response fine tuning records databricks-dolly-15k generated by Databricks employees in capability domains from the InstructGPT paper, including brainstorming, classification, closed QA, generation, information extraction, open QA and summarization.

      Req: >=16GB of CPU.
    `,
    modelType: ModelType.NeoX,
    size: 2085535776,
    downloadUrl:
      "https://huggingface.co/rustformers/dolly-v2-ggml/resolve/909bf7b5f7673605cde3153850f7e19e4cc35932/dolly-v2-3b-q5_1-ggjt.bin",
    blake3: "43ff067dd77edf0d8cc13d2966d14fca710c312362783642f4ed1d4e692c9f00",
    sha256: "889535a92e45e8e120289c53768688facbdec00f2f97ee269660679bfaffd99d",
    licenses: [...commonLicenses],
    tokenizers: ["databricks/dolly-v2-3b"],
    citations: [
      "https://huggingface.co/databricks/dolly-v2-3b",
      "https://huggingface.co/rustformers/dolly-v2-ggml"
    ]
  },
  "Dolly v2 7B": {
    description: dedent`
      Req: >=24GB of CPU.
    `,
    modelType: ModelType.NeoX,
    size: 5148350464,
    downloadUrl:
      "https://huggingface.co/rustformers/dolly-v2-ggml/resolve/909bf7b5f7673605cde3153850f7e19e4cc35932/dolly-v2-7b-q5_1-ggjt.bin",
    blake3: "5c302b966b13fb314d62b6d8dea9b9e237ae1fa71be5b3f51b83935218685734",
    sha256: "30d002d29e2e2ae942ff600d69012062af85e203e8f1f0d7e1133ad96f6ea354",
    licenses: [...commonLicenses],
    citations: [
      "https://huggingface.co/databricks/dolly-v2-7b",
      "https://huggingface.co/rustformers/dolly-v2-ggml"
    ],
    tokenizers: ["databricks/dolly-v2-7b"]
  }
}
