import { cn } from "@lab/theme/utils"
import { Button } from "@lab/ui/button"
import { MarkdownContainer } from "@lab/ui/markdown-container"
import { Notes, User } from "iconoir-react"
import { type CSSProperties, useMemo } from "react"

import { getTruncatedHash } from "~features/inference-server/model-digest"
import { Role, type ThreadMessage } from "~features/thread/_shared"

const defaultMessage = `
# h1 Occaecat exercitation
## h2 Occaecat exercitation velit mollit in ad labore eu esse.

Est quis cupidatat consequat pariatur nostrud consectetur velit minim duis magna velit consequat tempor occaecat. Labore Lorem ut eu adipisicing qui nulla sunt voluptate voluptate id ad consequat tempor. Exercitation veniam labore Lorem velit ullamco. Et dolore aliquip quis incididunt dolor deserunt eu laborum eu. Ex est anim laborum nostrud aute nulla.

### h3 Occaecat exercitation velit mollit in ad labore eu esse.

Enim ad laboris sunt deserunt id nostrud aliquip. Tempor do anim pariatur esse pariatur velit. Esse sint pariatur elit ad adipisicing officia. Occaecat aliquip aliqua sunt aute consequat non non amet velit.
`

// TODO: A bit convoluted atm, need refactor to make it simpler.
export const MessageBlock = ({
  BotIcon = User,
  message = {
    role: Role.User,
    content: defaultMessage
  } as ThreadMessage,
  style = {} as CSSProperties,
  className = ""
}) => {
  const isNote = useMemo(() => message.role === Role.Note, [message])
  const isUser = useMemo(() => message.role === Role.User, [message])
  const isBot = useMemo(() => message.role === Role.Bot, [message])

  if (!message.content) {
    return null
  }

  return (
    <div
      style={style}
      className={cn(
        "group",
        "transition-all",
        "animate-fade-in-once opacity-0",
        "flex",
        className
      )}>
      <div
        className={cn(
          "px-4 py-3 rounded-md rounded-tr-none w-full transition-colors",
          isNote && "bg-gold-7 hover:bg-gold-8 text-gold-11 hover:text-gold-12",
          isUser && "bg-gray-4 hover:bg-gray-5 text-gray-11 hover:text-gray-12",
          isBot && "bg-blue-7 hover:bg-blue-8 text-blue-11 hover:text-blue-12"
        )}>
        <MarkdownContainer className={cn("max-w-screen-sm")}>
          {message.content}
        </MarkdownContainer>

        <div className="flex flex-col text-xs justify-end text-end mt-4 gap-1">
          {message.model && <pre>{message.model}</pre>}
          {message.digest && <pre>{getTruncatedHash(message.digest)}</pre>}
          {message.timestamp && <pre>{message.timestamp}</pre>}
        </div>
      </div>
      <Button
        className={cn(
          "w-12 h-12 p-0 justify-center",
          "transition-colors rounded-l-none",
          isNote && "bg-gold-6 hover:bg-gold-7 text-gold-11 hover:text-gold-12",
          isUser && "bg-gray-3 hover:bg-gray-4",
          isBot && "bg-blue-6 hover:bg-blue-7 text-blue-11 hover:text-blue-12"
        )}>
        {isUser && <User />}
        {isBot && <BotIcon />}
        {isNote && <Notes />}
      </Button>
    </div>
  )
}
