# encoding: utf-8
import os
def transKV2SwiftEnum(className, fontName, fileName, icons):
    enum_format = """
//
//  %s.swift
//  LGButton
//
//  Created by philZhang.
//  Copyright 2018 philZhang. All rights reserved.
//
public enum %s {
    public static let __fontName__ = "%s"
    public static let __fileName__ = "%s"

%s

    public static let icons = %s
}
""" % (className, className, fontName, fileName, '%s', '%s')
    key_len = 0
    trans = {}
    for key in icons.keys():
        if key[0].isdigit():
            key = "_%s"%key
        key_len = max(len(key)+2, key_len)
        trans["`%s`" % (key.strip().replace("-", "_").replace(".", "_"))] = key

    var_formatter = '\n\tpublic static let %-{}s = "%s";'.format(key_len)
    swift_code = enum_format % ("".join(map(lambda k: var_formatter % (k, trans[k]), trans.keys())),
                                '[%s]' % (", ".join(map(lambda k: '"%s":"\\u%s"' % (k, icons[k]), icons.keys()))))
    with open("./%s.swift"%(className), "w+") as f:
        f.write(swift_code)

if __name__ == '__main__':
    FontAwesomeIcons = {"500px": "{f26e}",
    "adjust": "{f042}",
    "adn": "{f170}",
    "address-book":"{f2b9}",
    "address-book-o":"{f2ba}",
    "address-card":"{f2bb}",
    "address-card-o":"{f2bc}",
    "align-center": "{f037}",
    "align-justify": "{f039}",
    "align-left": "{f036}",
    "align-right": "{f038}",
    "amazon": "{f270}",
    "ambulance": "{f0f9}",
    "american-sign-language-interpreting": "{f2a3}",
    "anchor": "{f13d}",
    "android": "{f17b}",
    "angellist": "{f209}",
    "angle-double-down": "{f103}",
    "angle-double-left": "{f100}",
    "angle-double-right": "{f101}",
    "angle-double-up": "{f102}",
    "angle-down": "{f107}",
    "angle-left": "{f104}",
    "angle-right": "{f105}",
    "angle-up": "{f106}",
    "apple": "{f179}",
    "archive": "{f187}",
    "area-chart": "{f1fe}",
    "arrow-circle-down": "{f0ab}",
    "arrow-circle-left": "{f0a8}",
    "arrow-circle-o-down": "{f01a}",
    "arrow-circle-o-left": "{f190}",
    "arrow-circle-o-right": "{f18e}",
    "arrow-circle-o-up": "{f01b}",
    "arrow-circle-right": "{f0a9}",
    "arrow-circle-up": "{f0aa}",
    "arrow-down": "{f063}",
    "arrow-left": "{f060}",
    "arrow-right": "{f061}",
    "arrow-up": "{f062}",
    "arrows": "{f047}",
    "arrows-alt": "{f0b2}",
    "arrows-h": "{f07e}",
    "arrows-v": "{f07d}",
    "asl-interpreting": "{f2a3}",
    "assistive-listening-systems": "{f2a2}",
    "asterisk": "{f069}",
    "at": "{f1fa}",
    "audio-description": "{f29e}",
    "automobile": "{f1b9}",
    "backward": "{f04a}",
    "balance-scale": "{f24e}",
    "ban": "{f05e}",
    "bandcamp": "{f2d5}",
    "bank": "{f19c}",
    "bar-chart": "{f080}",
    "bar-chart-o": "{f080}",
    "barcode": "{f02a}",
    "bars": "{f0c9}",
    "bath": "{f2cd}",
    "battery-0": "{f244}",
    "battery-1": "{f243}",
    "battery-2": "{f242}",
    "battery-3": "{f241}",
    "battery-4": "{f240}",
    "battery-empty": "{f244}",
    "battery-full": "{f240}",
    "battery-half": "{f242}",
    "battery-quarter": "{f243}",
    "battery-three-quarters": "{f241}",
    "bed": "{f236}",
    "beer": "{f0fc}",
    "behance": "{f1b4}",
    "behance-square": "{f1b5}",
    "bell": "{f0f3}",
    "bell-o": "{f0a2}",
    "bell-slash": "{f1f6}",
    "bell-slash-o": "{f1f7}",
    "bicycle": "{f206}",
    "binoculars": "{f1e5}",
    "birthday-cake": "{f1fd}",
    "bitbucket": "{f171}",
    "bitbucket-square": "{f172}",
    "bitcoin": "{f15a}",
    "black-tie": "{f27e}",
    "blind": "{f29d}",
    "bluetooth": "{f293}",
    "bluetooth-b": "{f294}",
    "bold": "{f032}",
    "bolt": "{f0e7}",
    "bomb": "{f1e2}",
    "book": "{f02d}",
    "bookmark": "{f02e}",
    "bookmark-o": "{f097}",
    "braille": "{f2a1}",
    "briefcase": "{f0b1}",
    "btc": "{f15a}",
    "bug": "{f188}",
    "building": "{f1ad}",
    "building-o": "{f0f7}",
    "bullhorn": "{f0a1}",
    "bullseye": "{f140}",
    "bus": "{f207}",
    "buysellads": "{f20d}",
    "cab": "{f1ba}",
    "calculator": "{f1ec}",
    "calendar": "{f073}",
    "calendar-check-o": "{f274}",
    "calendar-minus-o": "{f272}",
    "calendar-o": "{f133}",
    "calendar-plus-o": "{f271}",
    "calendar-times-o": "{f273}",
    "camera": "{f030}",
    "camera-retro": "{f083}",
    "car": "{f1b9}",
    "caret-down": "{f0d7}",
    "caret-left": "{f0d9}",
    "caret-right": "{f0da}",
    "caret-square-o-down": "{f150}",
    "caret-square-o-left": "{f191}",
    "caret-square-o-right": "{f152}",
    "caret-square-o-up": "{f151}",
    "caret-up": "{f0d8}",
    "cart-arrow-down": "{f218}",
    "cart-plus": "{f217}",
    "cc": "{f20a}",
    "cc-amex": "{f1f3}",
    "cc-diners-club": "{f24c}",
    "cc-discover": "{f1f2}",
    "cc-jcb": "{f24b}",
    "cc-mastercard": "{f1f1}",
    "cc-paypal": "{f1f4}",
    "cc-stripe": "{f1f5}",
    "cc-visa": "{f1f0}",
    "certificate": "{f0a3}",
    "chain": "{f0c1}",
    "chain-broken": "{f127}",
    "check": "{f00c}",
    "check-circle": "{f058}",
    "check-circle-o": "{f05d}",
    "check-square": "{f14a}",
    "check-square-o": "{f046}",
    "chevron-circle-down": "{f13a}",
    "chevron-circle-left": "{f137}",
    "chevron-circle-right": "{f138}",
    "chevron-circle-up": "{f139}",
    "chevron-down": "{f078}",
    "chevron-left": "{f053}",
    "chevron-right": "{f054}",
    "chevron-up": "{f077}",
    "child": "{f1ae}",
    "chrome": "{f268}",
    "circle": "{f111}",
    "circle-o": "{f10c}",
    "circle-o-notch": "{f1ce}",
    "circle-thin": "{f1db}",
    "clipboard": "{f0ea}",
    "clock-o": "{f017}",
    "clone": "{f24d}",
    "close": "{f00d}",
    "cloud": "{f0c2}",
    "cloud-download": "{f0ed}",
    "cloud-upload": "{f0ee}",
    "cny": "{f157}",
    "code": "{f121}",
    "code-fork": "{f126}",
    "codepen": "{f1cb}",
    "codiepie": "{f284}",
    "coffee": "{f0f4}",
    "cog": "{f013}",
    "cogs": "{f085}",
    "columns": "{f0db}",
    "comment": "{f075}",
    "comment-o": "{f0e5}",
    "commenting": "{f27a}",
    "commenting-o": "{f27b}",
    "comments": "{f086}",
    "comments-o": "{f0e6}",
    "compass": "{f14e}",
    "compress": "{f066}",
    "connectdevelop": "{f20e}",
    "contao": "{f26d}",
    "copy": "{f0c5}",
    "copyright": "{f1f9}",
    "creative-commons": "{f25e}",
    "credit-card": "{f09d}",
    "credit-card-alt": "{f283}",
    "crop": "{f125}",
    "crosshairs": "{f05b}",
    "css3": "{f13c}",
    "cube": "{f1b2}",
    "cubes": "{f1b3}",
    "cut": "{f0c4}",
    "cutlery": "{f0f5}",
    "dashboard": "{f0e4}",
    "dashcube": "{f210}",
    "database": "{f1c0}",
    "deaf": "{f2a4}",
    "deafness": "{f2a4}",
    "dedent": "{f03b}",
    "delicious": "{f1a5}",
    "desktop": "{f108}",
    "deviantart": "{f1bd}",
    "diamond": "{f219}",
    "digg": "{f1a6}",
    "dollar": "{f155}",
    "dot-circle-o": "{f192}",
    "download": "{f019}",
    "dribbble": "{f17d}",
    "dropbox": "{f16b}",
    "drupal": "{f1a9}",
    "edge": "{f282}",
    "edit": "{f044}",
    "eercast": "{f2da}",
    "eject": "{f052}",
    "ellipsis-h": "{f141}",
    "ellipsis-v": "{f142}",
    "empire": "{f1d1}",
    "envelope": "{f0e0}",
    "envelope-o": "{f003}",
    "envelope-square": "{f199}",
    "envelope-open": "{f2b6}",
    "envelope-open-o": "{f2b7}",
    "envira": "{f299}",
    "eraser": "{f12d}",
    "etsy": "{f2d7}",
    "eur": "{f153}",
    "euro": "{f153}",
    "exchange": "{f0ec}",
    "exclamation": "{f12a}",
    "exclamation-circle": "{f06a}",
    "exclamation-triangle": "{f071}",
    "expand": "{f065}",
    "expeditedssl": "{f23e}",
    "external-link": "{f08e}",
    "external-link-square": "{f14c}",
    "eye": "{f06e}",
    "eye-slash": "{f070}",
    "eyedropper": "{f1fb}",
    "fa": "{f2b4}",
    "facebook": "{f09a}",
    "facebook-f": "{f09a}",
    "facebook-official": "{f230}",
    "facebook-square": "{f082}",
    "fast-backward": "{f049}",
    "fast-forward": "{f050}",
    "fax": "{f1ac}",
    "feed": "{f09e}",
    "female": "{f182}",
    "fighter-jet": "{f0fb}",
    "file": "{f15b}",
    "file-archive-o": "{f1c6}",
    "file-audio-o": "{f1c7}",
    "file-code-o": "{f1c9}",
    "file-excel-o": "{f1c3}",
    "file-image-o": "{f1c5}",
    "file-movie-o": "{f1c8}",
    "file-o": "{f016}",
    "file-pdf-o": "{f1c1}",
    "file-photo-o": "{f1c5}",
    "file-picture-o": "{f1c5}",
    "file-powerpoint-o": "{f1c4}",
    "file-sound-o": "{f1c7}",
    "file-text": "{f15c}",
    "file-text-o": "{f0f6}",
    "file-video-o": "{f1c8}",
    "file-word-o": "{f1c2}",
    "file-zip-o": "{f1c6}",
    "files-o": "{f0c5}",
    "film": "{f008}",
    "filter": "{f0b0}",
    "fire": "{f06d}",
    "fire-extinguisher": "{f134}",
    "firefox": "{f269}",
    "first-order": "{f2b0}",
    "flag": "{f024}",
    "flag-checkered": "{f11e}",
    "flag-o": "{f11d}",
    "flash": "{f0e7}",
    "flask": "{f0c3}",
    "flickr": "{f16e}",
    "floppy-o": "{f0c7}",
    "folder": "{f07b}",
    "folder-o": "{f114}",
    "folder-open": "{f07c}",
    "folder-open-o": "{f115}",
    "font": "{f031}",
    "font-awesome": "{f2b4}",
    "fonticons": "{f280}",
    "fort-awesome": "{f286}",
    "forumbee": "{f211}",
    "forward": "{f04e}",
    "foursquare": "{f180}",
    "free-code-camp": "{f2c5}",
    "frown-o": "{f119}",
    "futbol-o": "{f1e3}",
    "gamepad": "{f11b}",
    "gavel": "{f0e3}",
    "gbp": "{f154}",
    "ge": "{f1d1}",
    "gear": "{f013}",
    "gears": "{f085}",
    "genderless": "{f22d}",
    "get-pocket": "{f265}",
    "gg": "{f260}",
    "gg-circle": "{f261}",
    "gift": "{f06b}",
    "git": "{f1d3}",
    "git-square": "{f1d2}",
    "github": "{f09b}",
    "github-alt": "{f113}",
    "github-square": "{f092}",
    "gitlab": "{f296}",
    "gittip": "{f184}",
    "glass": "{f000}",
    "glide": "{f2a5}",
    "glide-g": "{f2a6}",
    "globe": "{f0ac}",
    "google": "{f1a0}",
    "google-plus": "{f0d5}",
    "google-plus-circle": "{f2b3}",
    "google-plus-official": "{f2b3}",
    "google-plus-square": "{f0d4}",
    "google-wallet": "{f1ee}",
    "graduation-cap": "{f19d}",
    "gratipay": "{f184}",
    "grav": "{f2d6}",
    "group": "{f0c0}",
    "h-square": "{f0fd}",
    "hacker-news": "{f1d4}",
    "handshake-o": "{f2b5}",
    "hand-grab-o": "{f255}",
    "hand-lizard-o": "{f258}",
    "hand-o-down": "{f0a7}",
    "hand-o-left": "{f0a5}",
    "hand-o-right": "{f0a4}",
    "hand-o-up": "{f0a6}",
    "hand-paper-o": "{f256}",
    "hand-peace-o": "{f25b}",
    "hand-pointer-o": "{f25a}",
    "hand-rock-o": "{f255}",
    "hand-scissors-o": "{f257}",
    "hand-spock-o": "{f259}",
    "hand-stop-o": "{f256}",
    "hard-of-hearing": "{f2a4}",
    "hashtag": "{f292}",
    "hdd-o": "{f0a0}",
    "header": "{f1dc}",
    "headphones": "{f025}",
    "heart": "{f004}",
    "heart-o": "{f08a}",
    "heartbeat": "{f21e}",
    "history": "{f1da}",
    "home": "{f015}",
    "hospital-o": "{f0f8}",
    "hotel": "{f236}",
    "hourglass": "{f254}",
    "hourglass-1": "{f251}",
    "hourglass-2": "{f252}",
    "hourglass-3": "{f253}",
    "hourglass-end": "{f253}",
    "hourglass-half": "{f252}",
    "hourglass-o": "{f250}",
    "hourglass-start": "{f251}",
    "houzz": "{f27c}",
    "html5": "{f13b}",
    "i-cursor": "{f246}",
    "id-badge": "{f2c1}",
    "id-card": "{f2c2}",
    "id-card-o": "{f2c3}",
    "ils": "{f20b}",
    "image": "{f03e}",
    "imdb": "{f2d8}",
    "inbox": "{f01c}",
    "indent": "{f03c}",
    "industry": "{f275}",
    "info": "{f129}",
    "info-circle": "{f05a}",
    "inr": "{f156}",
    "instagram": "{f16d}",
    "institution": "{f19c}",
    "internet-explorer": "{f26b}",
    "intersex": "{f224}",
    "ioxhost": "{f208}",
    "italic": "{f033}",
    "joomla": "{f1aa}",
    "jpy": "{f157}",
    "jsfiddle": "{f1cc}",
    "key": "{f084}",
    "keyboard-o": "{f11c}",
    "krw": "{f159}",
    "language": "{f1ab}",
    "laptop": "{f109}",
    "lastfm": "{f202}",
    "lastfm-square": "{f203}",
    "leaf": "{f06c}",
    "leanpub": "{f212}",
    "legal": "{f0e3}",
    "lemon-o": "{f094}",
    "level-down": "{f149}",
    "level-up": "{f148}",
    "life-bouy": "{f1cd}",
    "life-buoy": "{f1cd}",
    "life-ring": "{f1cd}",
    "life-saver": "{f1cd}",
    "lightbulb-o": "{f0eb}",
    "line-chart": "{f201}",
    "link": "{f0c1}",
    "linkedin": "{f0e1}",
    "linkedin-square": "{f08c}",
    "linode": "{f2b8}",
    "linux": "{f17c}",
    "list": "{f03a}",
    "list-alt": "{f022}",
    "list-ol": "{f0cb}",
    "list-ul": "{f0ca}",
    "location-arrow": "{f124}",
    "lock": "{f023}",
    "long-arrow-down": "{f175}",
    "long-arrow-left": "{f177}",
    "long-arrow-right": "{f178}",
    "long-arrow-up": "{f176}",
    "low-vision": "{f2a8}",
    "magic": "{f0d0}",
    "magnet": "{f076}",
    "mail-forward": "{f064}",
    "mail-reply": "{f112}",
    "mail-reply-all": "{f122}",
    "male": "{f183}",
    "map": "{f279}",
    "map-marker": "{f041}",
    "map-o": "{f278}",
    "map-pin": "{f276}",
    "map-signs": "{f277}",
    "mars": "{f222}",
    "mars-double": "{f227}",
    "mars-stroke": "{f229}",
    "mars-stroke-h": "{f22b}",
    "mars-stroke-v": "{f22a}",
    "maxcdn": "{f136}",
    "meanpath": "{f20c}",
    "medium": "{f23a}",
    "medkit": "{f0fa}",
    "meetup": "{f2e0}",
    "meh-o": "{f11a}",
    "mercury": "{f223}",
    "microchip": "{f2db}",
    "microphone": "{f130}",
    "microphone-slash": "{f131}",
    "minus": "{f068}",
    "minus-circle": "{f056}",
    "minus-square": "{f146}",
    "minus-square-o": "{f147}",
    "mixcloud": "{f289}",
    "mobile": "{f10b}",
    "mobile-phone": "{f10b}",
    "modx": "{f285}",
    "money": "{f0d6}",
    "moon-o": "{f186}",
    "mortar-board": "{f19d}",
    "motorcycle": "{f21c}",
    "mouse-pointer": "{f245}",
    "music": "{f001}",
    "navicon": "{f0c9}",
    "neuter": "{f22c}",
    "newspaper-o": "{f1ea}",
    "object-group": "{f247}",
    "object-ungroup": "{f248}",
    "odnoklassniki": "{f263}",
    "odnoklassniki-square": "{f264}",
    "opencart": "{f23d}",
    "openid": "{f19b}",
    "opera": "{f26a}",
    "optin-monster": "{f23c}",
    "outdent": "{f03b}",
    "pagelines": "{f18c}",
    "paint-brush": "{f1fc}",
    "paper-plane": "{f1d8}",
    "paper-plane-o": "{f1d9}",
    "paperclip": "{f0c6}",
    "paragraph": "{f1dd}",
    "paste": "{f0ea}",
    "pause": "{f04c}",
    "pause-circle": "{f28b}",
    "pause-circle-o": "{f28c}",
    "paw": "{f1b0}",
    "paypal": "{f1ed}",
    "pencil": "{f040}",
    "pencil-square": "{f14b}",
    "pencil-square-o": "{f044}",
    "percent": "{f295}",
    "phone": "{f095}",
    "phone-square": "{f098}",
    "photo": "{f03e}",
    "picture-o": "{f03e}",
    "pie-chart": "{f200}",
    "pied-piper": "{f2ae}",
    "pied-piper-alt": "{f1a8}",
    "pied-piper-pp": "{f1a7}",
    "pinterest": "{f0d2}",
    "pinterest-p": "{f231}",
    "pinterest-square": "{f0d3}",
    "plane": "{f072}",
    "play": "{f04b}",
    "play-circle": "{f144}",
    "play-circle-o": "{f01d}",
    "plug": "{f1e6}",
    "plus": "{f067}",
    "plus-circle": "{f055}",
    "plus-square": "{f0fe}",
    "plus-square-o": "{f196}",
    "podcast": "{f2ce}",
    "power-off": "{f011}",
    "print": "{f02f}",
    "product-hunt": "{f288}",
    "puzzle-piece": "{f12e}",
    "qq": "{f1d6}",
    "qrcode": "{f029}",
    "question": "{f128}",
    "question-circle": "{f059}",
    "question-circle-o": "{f29c}",
    "quora": "{f2c4}",
    "quote-left": "{f10d}",
    "quote-right": "{f10e}",
    "ra": "{f1d0}",
    "random": "{f074}",
    "ravelry": "{f2d9}",
    "rebel": "{f1d0}",
    "recycle": "{f1b8}",
    "reddit": "{f1a1}",
    "reddit-alien": "{f281}",
    "reddit-square": "{f1a2}",
    "refresh": "{f021}",
    "registered": "{f25d}",
    "remove": "{f00d}",
    "renren": "{f18b}",
    "reorder": "{f0c9}",
    "repeat": "{f01e}",
    "reply": "{f112}",
    "reply-all": "{f122}",
    "resistance": "{f1d0}",
    "retweet": "{f079}",
    "rmb": "{f157}",
    "road": "{f018}",
    "rocket": "{f135}",
    "rotate-left": "{f0e2}",
    "rotate-right": "{f01e}",
    "rouble": "{f158}",
    "rss": "{f09e}",
    "rss-square": "{f143}",
    "rub": "{f158}",
    "ruble": "{f158}",
    "rupee": "{f156}",
    "safari": "{f267}",
    "save": "{f0c7}",
    "scissors": "{f0c4}",
    "scribd": "{f28a}",
    "search": "{f002}",
    "search-minus": "{f010}",
    "search-plus": "{f00e}",
    "sellsy": "{f213}",
    "send": "{f1d8}",
    "send-o": "{f1d9}",
    "server": "{f233}",
    "share": "{f064}",
    "share-alt": "{f1e0}",
    "share-alt-square": "{f1e1}",
    "share-square": "{f14d}",
    "share-square-o": "{f045}",
    "shekel": "{f20b}",
    "sheqel": "{f20b}",
    "shield": "{f132}",
    "ship": "{f21a}",
    "shirtsinbulk": "{f214}",
    "shopping-bag": "{f290}",
    "shopping-basket": "{f291}",
    "shopping-cart": "{f07a}",
    "shower": "{f2cc}",
    "sign-in": "{f090}",
    "sign-language": "{f2a7}",
    "sign-out": "{f08b}",
    "signal": "{f012}",
    "signing": "{f2a7}",
    "simplybuilt": "{f215}",
    "sitemap": "{f0e8}",
    "skyatlas": "{f216}",
    "skype": "{f17e}",
    "slack": "{f198}",
    "sliders": "{f1de}",
    "slideshare": "{f1e7}",
    "smile-o": "{f118}",
    "snapchat": "{f2ab}",
    "snapchat-ghost": "{f2ac}",
    "snapchat-square": "{f2ad}",
    "snowflake": "{f2dc}",
    "soccer-ball-o": "{f1e3}",
    "sort": "{f0dc}",
    "sort-alpha-asc": "{f15d}",
    "sort-alpha-desc": "{f15e}",
    "sort-amount-asc": "{f160}",
    "sort-amount-desc": "{f161}",
    "sort-asc": "{f0de}",
    "sort-desc": "{f0dd}",
    "sort-down": "{f0dd}",
    "sort-numeric-asc": "{f162}",
    "sort-numeric-desc": "{f163}",
    "sort-up": "{f0de}",
    "soundcloud": "{f1be}",
    "space-shuttle": "{f197}",
    "spinner": "{f110}",
    "spoon": "{f1b1}",
    "spotify": "{f1bc}",
    "square": "{f0c8}",
    "square-o": "{f096}",
    "stack-exchange": "{f18d}",
    "stack-overflow": "{f16c}",
    "star": "{f005}",
    "star-half": "{f089}",
    "star-half-empty": "{f123}",
    "star-half-full": "{f123}",
    "star-half-o": "{f123}",
    "star-o": "{f006}",
    "steam": "{f1b6}",
    "steam-square": "{f1b7}",
    "step-backward": "{f048}",
    "step-forward": "{f051}",
    "stethoscope": "{f0f1}",
    "sticky-note": "{f249}",
    "sticky-note-o": "{f24a}",
    "stop": "{f04d}",
    "stop-circle": "{f28d}",
    "stop-circle-o": "{f28e}",
    "street-view": "{f21d}",
    "strikethrough": "{f0cc}",
    "stumbleupon": "{f1a4}",
    "stumbleupon-circle": "{f1a3}",
    "subscript": "{f12c}",
    "subway": "{f239}",
    "suitcase": "{f0f2}",
    "sun-o": "{f185}",
    "superpowers": "{f2dd}",
    "superscript": "{f12b}",
    "support": "{f1cd}",
    "table": "{f0ce}",
    "tablet": "{f10a}",
    "tachometer": "{f0e4}",
    "tag": "{f02b}",
    "tags": "{f02c}",
    "tasks": "{f0ae}",
    "taxi": "{f1ba}",
    "telegram": "{f2c6}",
    "television": "{f26c}",
    "tencent-weibo": "{f1d5}",
    "terminal": "{f120}",
    "text-height": "{f034}",
    "text-width": "{f035}",
    "th": "{f00a}",
    "th-large": "{f009}",
    "th-list": "{f00b}",
    "themeisle": "{f2b2}",
    "thermometer-empty": "{f2cb}",
    "thermometer-full": "{f2c7}",
    "thermometer-half": "{f2c9}",
    "thermometer-quarter": "{f2ca}",
    "thermometer-three-quarters": "{f2c8}",
    "thumb-tack": "{f08d}",
    "thumbs-down": "{f165}",
    "thumbs-o-down": "{f088}",
    "thumbs-o-up": "{f087}",
    "thumbs-up": "{f164}",
    "ticket": "{f145}",
    "times": "{f00d}",
    "times-circle": "{f057}",
    "times-circle-o": "{f05c}",
    "tint": "{f043}",
    "toggle-down": "{f150}",
    "toggle-left": "{f191}",
    "toggle-off": "{f204}",
    "toggle-on": "{f205}",
    "toggle-right": "{f152}",
    "toggle-up": "{f151}",
    "trademark": "{f25c}",
    "train": "{f238}",
    "transgender": "{f224}",
    "transgender-alt": "{f225}",
    "trash": "{f1f8}",
    "trash-o": "{f014}",
    "tree": "{f1bb}",
    "trello": "{f181}",
    "tripadvisor": "{f262}",
    "trophy": "{f091}",
    "truck": "{f0d1}",
    "try": "{f195}",
    "tty": "{f1e4}",
    "tumblr": "{f173}",
    "tumblr-square": "{f174}",
    "turkish-lira": "{f195}",
    "tv": "{f26c}",
    "twitch": "{f1e8}",
    "twitter": "{f099}",
    "twitter-square": "{f081}",
    "umbrella": "{f0e9}",
    "underline": "{f0cd}",
    "undo": "{f0e2}",
    "universal-access": "{f29a}",
    "university": "{f19c}",
    "unlink": "{f127}",
    "unlock": "{f09c}",
    "unlock-alt": "{f13e}",
    "unsorted": "{f0dc}",
    "upload": "{f093}",
    "usb": "{f287}",
    "usd": "{f155}",
    "user": "{f007}",
    "user-o": "{f2c0}",
    "user-md": "{f0f0}",
    "user-plus": "{f234}",
    "user-secret": "{f21b}",
    "user-times": "{f235}",
    "user-circle": "{f2bd}",
    "user-circle-o": "{f2be}",
    "users": "{f0c0}",
    "venus": "{f221}",
    "venus-double": "{f226}",
    "venus-mars": "{f228}",
    "viacoin": "{f237}",
    "viadeo": "{f2a9}",
    "viadeo-square": "{f2aa}",
    "video-camera": "{f03d}",
    "vimeo": "{f27d}",
    "vimeo-square": "{f194}",
    "vine": "{f1ca}",
    "vk": "{f189}",
    "volume-control-phone": "{f2a0}",
    "volume-down": "{f027}",
    "volume-off": "{f026}",
    "volume-up": "{f028}",
    "warning": "{f071}",
    "wechat": "{f1d7}",
    "weibo": "{f18a}",
    "weixin": "{f1d7}",
    "whatsapp": "{f232}",
    "wheelchair": "{f193}",
    "wheelchair-alt": "{f29b}",
    "wifi": "{f1eb}",
    "wikipedia-w": "{f266}",
    "window-close": "{f2d3}",
    "window-close-o": "{f2d4}",
    "window-maximize": "{f2d0}",
    "window-minimize": "{f2d1}",
    "window-restore": "{f2d2}",
    "windows": "{f17a}",
    "won": "{f159}",
    "wordpress": "{f19a}",
    "wpbeginner": "{f297}",
    "wpexplorer": "{f2de}",
    "wpforms": "{f298}",
    "wrench": "{f0ad}",
    "xing": "{f168}",
    "xing-square": "{f169}",
    "y-combinator": "{f23b}",
    "y-combinator-square": "{f1d4}",
    "yahoo": "{f19e}",
    "yc": "{f23b}",
    "yc-square": "{f1d4}",
    "yelp": "{f1e9}",
    "yen": "{f157}",
    "yoast": "{f2b1}",
    "youtube": "{f167}",
    "youtube-play": "{f16a}",
    "youtube-square": "{f166}"}
    transKV2SwiftEnum("FontAwesome", "FontAwesome", "FontAwesome", FontAwesomeIcons)

    iconicIcon = {"account-login":"{e000}", "account-logout":"{e001}", "action-redo":"{e002}", "action-undo":"{e003}", "align-center":"{e004}", "align-left":"{e005}", "align-right":"{e006}", "aperture":"{e007}", "arrow-bottom":"{e008}", "arrow-circle-bottom":"{e009}", "arrow-circle-left":"{e00a}", "arrow-circle-right":"{e00b}", "arrow-circle-top":"{e00c}", "arrow-left":"{e00d}", "arrow-right":"{e00e}", "arrow-thick-bottom":"{e00f}", "arrow-thick-left":"{e010}", "arrow-thick-right":"{e011}", "arrow-thick-top":"{e012}", "arrow-top":"{e013}", "audio-spectrum":"{e014}", "audio":"{e015}", "badge":"{e016}", "ban":"{e017}", "bar-chart":"{e018}", "basket":"{e019}", "battery-empty":"{e01a}", "battery-full":"{e01b}", "beaker":"{e01c}", "bell":"{e01d}", "bluetooth":"{e01e}", "bold":"{e01f}", "bolt":"{e020}", "book":"{e021}", "bookmark":"{e022}", "box":"{e023}", "briefcase":"{e024}", "british-pound":"{e025}", "browser":"{e026}", "brush":"{e027}", "bug":"{e028}", "bullhorn":"{e029}", "calculator":"{e02a}", "calendar":"{e02b}", "camera-slr":"{e02c}", "caret-bottom":"{e02d}", "caret-left":"{e02e}", "caret-right":"{e02f}", "caret-top":"{e030}", "cart":"{e031}", "chat":"{e032}", "check":"{e033}", "chevron-bottom":"{e034}", "chevron-left":"{e035}", "chevron-right":"{e036}", "chevron-top":"{e037}", "circle-check":"{e08}", "circle-x":"{e039}", "clipboard":"{e03a}", "clock":"{e03b}", "cloud-download":"{e03c}", "cloud-upload":"{e03d}", "cloud":"{e03e}", "cloudy":"{e03f}", "code":"{e040}", "cog":"{e041}", "collapse-down":"{e042}", "collapse-left":"{e043}", "collapse-right":"{e044}", "collapse-up":"{e045}", "command":"{e046}", "comment-square":"{e047}", "compass":"{e048}", "contrast":"{e049}", "copywriting":"{e04a}", "credit-card":"{e04b}", "crop":"{e04c}", "dashboard":"{e04d}", "data-transfer-download":"{e04e}", "data-transfer-upload":"{e04f}", "delete":"{e050}", "dial":"{e051}", "document":"{e052}", "dollar":"{e053}", "double-quote-sans-left":"{e054}", "double-quote-sans-right":"{e055}", "double-quote-serif-left":"{e056}", "double-quote-serif-right":"{e057}", "droplet":"{e058}", "eject":"{e059}", "elevator":"{e05a}", "ellipses":"{e05b}", "envelope-closed":"{e05c}", "envelope-open":"{e05d}", "euro":"{e05e}", "excerpt":"{e05f}", "expand-down":"{e060}", "expand-left":"{e061}", "expand-right":"{e062}", "expand-up":"{e063}", "external-link":"{e064}", "eye":"{e065}", "eyedropper":"{e066}", "file":"{e067}", "fire":"{e068}", "flag":"{e069}", "flash":"{e06a}", "folder":"{e06b}", "fork":"{e06c}", "fullscreen-enter":"{e06d}", "fullscreen-exit":"{e06e}", "globe":"{e06f}", "graph":"{e070}", "grid-four-up":"{e071}", "grid-three-up":"{e072}", "grid-two-up":"{e073}", "hard-drive":"{e074}", "header":"{e075}", "headphones":"{e076}", "heart":"{e077}", "home":"{e078}", "image":"{e079}", "inbox":"{e07a}", "infinity":"{e07b}", "info":"{e07c}", "italic":"{e07d}", "justify-center":"{e07e}", "justify-left":"{e07f}", "justify-right":"{e080}", "key":"{e081}", "laptop":"{e082}", "layers":"{e083}", "lightbulb":"{e084}", "link-broken":"{e085}", "link-intact":"{e086}", "list-rich":"{e087}", "list":"{e088}", "location":"{e089}", "lock-locked":"{e08a}", "lock-unlocked":"{e08b}", "loop-circular":"{e08c}", "loop-square":"{e08d}", "loop":"{e08e}", "magnifying-glass":"{e08f}", "map-marker":"{e090}", "map":"{e091}", "media-pause":"{e092}", "media-play":"{e093}", "media-record":"{e094}", "media-skip-backward":"{e095}", "media-skip-forward":"{e096}", "media-step-backward":"{e097}", "media-step-forward":"{e098}", "media-stop":"{e099}", "medical-cross":"{e09a}", "menu":"{e09b}", "microphone":"{e09c}", "minus":"{e09d}", "monitor":"{e09e}", "moon":"{e09f}", "move":"{e0a0}", "musical-note":"{e0a1}", "paperclip":"{e0a2}", "pencil":"{e0a3}", "people":"{e0a4}", "person":"{e0a5}", "phone":"{e0a6}", "pie-chart":"{e0a7}", "pin":"{e0a8}", "play-circle":"{e0a9}", "plus":"{e0aa}", "power-standby":"{e0ab}", "print":"{e0ac}", "project":"{e0ad}", "pulse":"{e0ae}", "puzzle-piece":"{e0af}", "question-mark":"{e0b0}", "rain":"{e0b1}", "random":"{e0b2}", "reload":"{e0b3}", "resize-both":"{e0b4}", "resize-height":"{e0b5}", "resize-width":"{e0b6}", "rss-alt":"{e0b7}", "rss":"{e0b8}", "script":"{e0b9}", "share-boxed":"{e0ba}", "share":"{e0bb}", "shield":"{e0bc}", "signal":"{e0bd}", "signpost":"{e0be}", "sort-ascending":"{e0bf}", "sort-descending":"{e0c0}", "spreadsheet":"{e0c1}", "star":"{e0c2}", "sun":"{e0c3}", "tablet":"{e0c4}", "tag":"{e0c5}", "tags":"{e0c6}", "target":"{e0c7}", "task":"{e0c8}", "terminal":"{e0c9}", "text":"{e0ca}", "thumb-down":"{e0cb}", "thumb-up":"{e0cc}", "timer":"{e0cd}", "transfer":"{e0ce}", "trash":"{e0cf}", "underline":"{e0d0}", "vertical-align-bottom":"{e0d1}", "vertical-align-center":"{e0d2}", "vertical-align-top":"{e0d3}", "video":"{e0d4}", "volume-high":"{e0d5}", "volume-low":"{e0d6}", "volume-off":"{e0d7}", "warning":"{e0d8}", "wifi":"{e0d9}", "wrench":"{e0da}", "x":"{e0db}", "yen":"{e0dc}", "zoom-in":"{e0dd}", "zoom-out":"{e0de}"}
    transKV2SwiftEnum("FontOpenic", "Icons", "open-iconic", iconicIcon)

    ionIcons={"alert":"{f101}", "alert-circled":"{f100}", "android-add":"{f2c7}", "android-add-circle":"{f359}", "android-alarm-clock":"{f35a}", "android-alert":"{f35b}", "android-apps":"{f35c}", "android-archive":"{f2c9}", "android-arrow-back":"{f2ca}", "android-arrow-down":"{f35d}", "android-arrow-dropdown":"{f35f}", "android-arrow-dropdown-circle":"{f35e}", "android-arrow-dropleft":"{f361}", "android-arrow-dropleft-circle":"{f360}", "android-arrow-dropright":"{f363}", "android-arrow-dropright-circle":"{f362}", "android-arrow-dropup":"{f365}", "android-arrow-dropup-circle":"{f364}", "android-arrow-forward":"{f30f}", "android-arrow-up":"{f366}", "android-attach":"{f367}", "android-bar":"{f368}", "android-bicycle":"{f369}", "android-boat":"{f36a}", "android-bookmark":"{f36b}", "android-bulb":"{f36c}", "android-bus":"{f36d}", "android-calendar":"{f2d1}", "android-call":"{f2d2}", "android-camera":"{f2d3}", "android-cancel":"{f36e}", "android-car":"{f36f}", "android-cart":"{f370}", "android-chat":"{f2d4}", "android-checkbox":"{f374}", "android-checkbox-blank":"{f371}", "android-checkbox-outline":"{f373}", "android-checkbox-outline-blank":"{f372}", "android-checkmark-circle":"{f375}", "android-clipboard":"{f376}", "android-close":"{f2d7}", "android-cloud":"{f37a}", "android-cloud-circle":"{f377}", "android-cloud-done":"{f378}", "android-cloud-outline":"{f379}", "android-color-palette":"{f37b}", "android-compass":"{f37c}", "android-contact":"{f2d8}", "android-contacts":"{f2d9}", "android-contract":"{f37d}", "android-create":"{f37e}", "android-delete":"{f37f}", "android-desktop":"{f380}", "android-document":"{f381}", "android-done":"{f383}", "android-done-all":"{f382}", "android-download":"{f2dd}", "android-drafts":"{f384}", "android-exit":"{f385}", "android-expand":"{f386}", "android-favorite":"{f388}", "android-favorite-outline":"{f387}", "android-film":"{f389}", "android-folder":"{f2e0}", "android-folder-open":"{f38a}", "android-funnel":"{f38b}", "android-globe":"{f38c}", "android-hand":"{f2e3}", "android-hangout":"{f38d}", "android-happy":"{f38e}", "android-home":"{f38f}", "android-image":"{f2e4}", "android-laptop":"{f390}", "android-list":"{f391}", "android-locate":"{f2e9}", "android-lock":"{f392}", "android-mail":"{f2eb}", "android-map":"{f393}", "android-menu":"{f394}", "android-microphone":"{f2ec}", "android-microphone-off":"{f395}", "android-more-horizontal":"{f396}", "android-more-vertical":"{f397}", "android-navigate":"{f398}", "android-notifications":"{f39b}", "android-notifications-none":"{f399}", "android-notifications-off":"{f39a}", "android-open":"{f39c}", "android-options":"{f39d}", "android-people":"{f39e}", "android-person":"{f3a0}", "android-person-add":"{f39f}", "android-phone-landscape":"{f3a1}", "android-phone-portrait":"{f3a2}", "android-pin":"{f3a3}", "android-plane":"{f3a4}", "android-playstore":"{f2f0}", "android-print":"{f3a5}", "android-radio-button-off":"{f3a6}", "android-radio-button-on":"{f3a7}", "android-refresh":"{f3a8}", "android-remove":"{f2f4}", "android-remove-circle":"{f3a9}", "android-restaurant":"{f3aa}", "android-sad":"{f3ab}", "android-search":"{f2f5}", "android-send":"{f2f6}", "android-settings":"{f2f7}", "android-share":"{f2f8}", "android-share-alt":"{f3ac}", "android-star":"{f2fc}", "android-star-half":"{f3ad}", "android-star-outline":"{f3ae}", "android-stopwatch":"{f2fd}", "android-subway":"{f3af}", "android-sunny":"{f3b0}", "android-sync":"{f3b1}", "android-textsms":"{f3b2}", "android-time":"{f3b3}", "android-train":"{f3b4}", "android-unlock":"{f3b5}", "android-upload":"{f3b6}", "android-volume-down":"{f3b7}", "android-volume-mute":"{f3b8}", "android-volume-off":"{f3b9}", "android-volume-up":"{f3ba}", "android-walk":"{f3bb}", "android-warning":"{f3bc}", "android-watch":"{f3bd}", "android-wifi":"{f305}", "aperture":"{f313}", "archive":"{f102}", "arrow-down-a":"{f103}", "arrow-down-b":"{f104}", "arrow-down-c":"{f105}", "arrow-expand":"{f25e}", "arrow-graph-down-left":"{f25f}", "arrow-graph-down-right":"{f260}", "arrow-graph-up-left":"{f261}", "arrow-graph-up-right":"{f262}", "arrow-left-a":"{f106}", "arrow-left-b":"{f107}", "arrow-left-c":"{f108}", "arrow-move":"{f263}", "arrow-resize":"{f264}", "arrow-return-left":"{f265}", "arrow-return-right":"{f266}", "arrow-right-a":"{f109}", "arrow-right-b":"{f10a}", "arrow-right-c":"{f10b}", "arrow-shrink":"{f267}", "arrow-swap":"{f268}", "arrow-up-a":"{f10c}", "arrow-up-b":"{f10d}", "arrow-up-c":"{f10e}", "asterisk":"{f314}", "at":"{f10f}", "backspace":"{f3bf}", "backspace-outline":"{f3be}", "bag":"{f110}", "battery-charging":"{f111}", "battery-empty":"{f112}", "battery-full":"{f113}", "battery-half":"{f114}", "battery-low":"{f115}", "beaker":"{f269}", "beer":"{f26a}", "bluetooth":"{f116}", "bonfire":"{f315}", "bookmark":"{f26b}", "bowtie":"{f3c0}", "briefcase":"{f26c}", "bug":"{f2be}", "calculator":"{f26d}", "calendar":"{f117}", "camera":"{f118}", "card":"{f119}", "cash":"{f316}", "chatbox":"{f11b}", "chatbox-working":"{f11a}", "chatboxes":"{f11c}", "chatbubble":"{f11e}", "chatbubble-working":"{f11d}", "chatbubbles":"{f11f}", "checkmark":"{f122}", "checkmark-circled":"{f120}", "checkmark-round":"{f121}", "chevron-down":"{f123}", "chevron-left":"{f124}", "chevron-right":"{f125}", "chevron-up":"{f126}", "clipboard":"{f127}", "clock":"{f26e}", "close":"{f12a}", "close-circled":"{f128}", "close-round":"{f129}", "closed-captioning":"{f317}", "cloud":"{f12b}", "code":"{f271}", "code-download":"{f26f}", "code-working":"{f270}", "coffee":"{f272}", "compass":"{f273}", "compose":"{f12c}", "connection-bars":"{f274}", "contrast":"{f275}", "crop":"{f3c1}", "cube":"{f318}", "disc":"{f12d}", "document":"{f12f}", "document-text":"{f12e}", "drag":"{f130}", "earth":"{f276}", "easel":"{f3c2}", "edit":"{f2bf}", "egg":"{f277}", "eject":"{f131}", "email":"{f132}", "email-unread":"{f3c3}", "erlenmeyer-flask":"{f3c5}", "erlenmeyer-flask-bubbles":"{f3c4}", "eye":"{f133}", "eye-disabled":"{f306}", "female":"{f278}", "filing":"{f134}", "film-marker":"{f135}", "fireball":"{f319}", "flag":"{f279}", "flame":"{f31a}", "flash":"{f137}", "flash-off":"{f136}", "folder":"{f139}", "fork":"{f27a}", "fork-repo":"{f2c0}", "forward":"{f13a}", "funnel":"{f31b}", "gear-a":"{f13d}", "gear-b":"{f13e}", "grid":"{f13f}", "hammer":"{f27b}", "happy":"{f31c}", "happy-outline":"{f3c6}", "headphone":"{f140}", "heart":"{f141}", "heart-broken":"{f31d}", "help":"{f143}", "help-buoy":"{f27c}", "help-circled":"{f142}", "home":"{f144}", "icecream":"{f27d}", "image":"{f147}", "images":"{f148}", "information":"{f14a}", "information-circled":"{f149}", "ionic":"{f14b}", "ios-alarm":"{f3c8}", "ios-alarm-outline":"{f3c7}", "ios-albums":"{f3ca}", "ios-albums-outline":"{f3c9}", "ios-americanfootball":"{f3cc}", "ios-americanfootball-outline":"{f3cb}", "ios-analytics":"{f3ce}", "ios-analytics-outline":"{f3cd}", "ios-arrow-back":"{f3cf}", "ios-arrow-down":"{f3d0}", "ios-arrow-forward":"{f3d1}", "ios-arrow-left":"{f3d2}", "ios-arrow-right":"{f3d3}", "ios-arrow-thin-down":"{f3d4}", "ios-arrow-thin-left":"{f3d5}", "ios-arrow-thin-right":"{f3d6}", "ios-arrow-thin-up":"{f3d7}", "ios-arrow-up":"{f3d8}", "ios-at":"{f3da}", "ios-at-outline":"{f3d9}", "ios-barcode":"{f3dc}", "ios-barcode-outline":"{f3db}", "ios-baseball":"{f3de}", "ios-baseball-outline":"{f3dd}", "ios-basketball":"{f3e0}", "ios-basketball-outline":"{f3df}", "ios-bell":"{f3e2}", "ios-bell-outline":"{f3e1}", "ios-body":"{f3e4}", "ios-body-outline":"{f3e3}", "ios-bolt":"{f3e6}", "ios-bolt-outline":"{f3e5}", "ios-book":"{f3e8}", "ios-book-outline":"{f3e7}", "ios-bookmarks":"{f3ea}", "ios-bookmarks-outline":"{f3e9}", "ios-box":"{f3ec}", "ios-box-outline":"{f3eb}", "ios-briefcase":"{f3ee}", "ios-briefcase-outline":"{f3ed}", "ios-browsers":"{f3f0}", "ios-browsers-outline":"{f3ef}", "ios-calculator":"{f3f2}", "ios-calculator-outline":"{f3f1}", "ios-calendar":"{f3f4}", "ios-calendar-outline":"{f3f3}", "ios-camera":"{f3f6}", "ios-camera-outline":"{f3f5}", "ios-cart":"{f3f8}", "ios-cart-outline":"{f3f7}", "ios-chatboxes":"{f3fa}", "ios-chatboxes-outline":"{f3f9}", "ios-chatbubble":"{f3fc}", "ios-chatbubble-outline":"{f3fb}", "ios-checkmark":"{f3ff}", "ios-checkmark-empty":"{f3fd}", "ios-checkmark-outline":"{f3fe}", "ios-circle-filled":"{f400}", "ios-circle-outline":"{f401}", "ios-clock":"{f403}", "ios-clock-outline":"{f402}", "ios-close":"{f406}", "ios-close-empty":"{f404}", "ios-close-outline":"{f405}", "ios-cloud":"{f40c}", "ios-cloud-download":"{f408}", "ios-cloud-download-outline":"{f407}", "ios-cloud-outline":"{f409}", "ios-cloud-upload":"{f40b}", "ios-cloud-upload-outline":"{f40a}", "ios-cloudy":"{f410}", "ios-cloudy-night":"{f40e}", "ios-cloudy-night-outline":"{f40d}", "ios-cloudy-outline":"{f40f}", "ios-cog":"{f412}", "ios-cog-outline":"{f411}", "ios-color-filter":"{f414}", "ios-color-filter-outline":"{f413}", "ios-color-wand":"{f416}", "ios-color-wand-outline":"{f415}", "ios-compose":"{f418}", "ios-compose-outline":"{f417}", "ios-contact":"{f41a}", "ios-contact-outline":"{f419}", "ios-copy":"{f41c}", "ios-copy-outline":"{f41b}", "ios-crop":"{f41e}", "ios-crop-strong":"{f41d}", "ios-download":"{f420}", "ios-download-outline":"{f41f}", "ios-drag":"{f421}", "ios-email":"{f423}", "ios-email-outline":"{f422}", "ios-eye":"{f425}", "ios-eye-outline":"{f424}", "ios-fastforward":"{f427}", "ios-fastforward-outline":"{f426}", "ios-filing":"{f429}", "ios-filing-outline":"{f428}", "ios-film":"{f42b}", "ios-film-outline":"{f42a}", "ios-flag":"{f42d}", "ios-flag-outline":"{f42c}", "ios-flame":"{f42f}", "ios-flame-outline":"{f42e}", "ios-flask":"{f431}", "ios-flask-outline":"{f430}", "ios-flower":"{f433}", "ios-flower-outline":"{f432}", "ios-folder":"{f435}", "ios-folder-outline":"{f434}", "ios-football":"{f437}", "ios-football-outline":"{f436}", "ios-game-controller-a":"{f439}", "ios-game-controller-a-outline":"{f438}", "ios-game-controller-b":"{f43b}", "ios-game-controller-b-outline":"{f43a}", "ios-gear":"{f43d}", "ios-gear-outline":"{f43c}", "ios-glasses":"{f43f}", "ios-glasses-outline":"{f43e}", "ios-grid-view":"{f441}", "ios-grid-view-outline":"{f440}", "ios-heart":"{f443}", "ios-heart-outline":"{f442}", "ios-help":"{f446}", "ios-help-empty":"{f444}", "ios-help-outline":"{f445}", "ios-home":"{f448}", "ios-home-outline":"{f447}", "ios-infinite":"{f44a}", "ios-infinite-outline":"{f449}", "ios-information":"{f44d}", "ios-information-empty":"{f44b}", "ios-information-outline":"{f44c}", "ios-ionic-outline":"{f44e}", "ios-keypad":"{f450}", "ios-keypad-outline":"{f44f}", "ios-lightbulb":"{f452}", "ios-lightbulb-outline":"{f451}", "ios-list":"{f454}", "ios-list-outline":"{f453}", "ios-location":"{f456}", "ios-location-outline":"{f455}", "ios-locked":"{f458}", "ios-locked-outline":"{f457}", "ios-loop":"{f45a}", "ios-loop-strong":"{f459}", "ios-medical":"{f45c}", "ios-medical-outline":"{f45b}", "ios-medkit":"{f45e}", "ios-medkit-outline":"{f45d}", "ios-mic":"{f461}", "ios-mic-off":"{f45f}", "ios-mic-outline":"{f460}", "ios-minus":"{f464}", "ios-minus-empty":"{f462}", "ios-minus-outline":"{f463}", "ios-monitor":"{f466}", "ios-monitor-outline":"{f465}", "ios-moon":"{f468}", "ios-moon-outline":"{f467}", "ios-more":"{f46a}", "ios-more-outline":"{f469}", "ios-musical-note":"{f46b}", "ios-musical-notes":"{f46c}", "ios-navigate":"{f46e}", "ios-navigate-outline":"{f46d}", "ios-nutrition":"{f470}", "ios-nutrition-outline":"{f46f}", "ios-paper":"{f472}", "ios-paper-outline":"{f471}", "ios-paperplane":"{f474}", "ios-paperplane-outline":"{f473}", "ios-partlysunny":"{f476}", "ios-partlysunny-outline":"{f475}", "ios-pause":"{f478}", "ios-pause-outline":"{f477}", "ios-paw":"{f47a}", "ios-paw-outline":"{f479}", "ios-people":"{f47c}", "ios-people-outline":"{f47b}", "ios-person":"{f47e}", "ios-person-outline":"{f47d}", "ios-personadd":"{f480}", "ios-personadd-outline":"{f47f}", "ios-photos":"{f482}", "ios-photos-outline":"{f481}", "ios-pie":"{f484}", "ios-pie-outline":"{f483}", "ios-pint":"{f486}", "ios-pint-outline":"{f485}", "ios-play":"{f488}", "ios-play-outline":"{f487}", "ios-plus":"{f48b}", "ios-plus-empty":"{f489}", "ios-plus-outline":"{f48a}", "ios-pricetag":"{f48d}", "ios-pricetag-outline":"{f48c}", "ios-pricetags":"{f48f}", "ios-pricetags-outline":"{f48e}", "ios-printer":"{f491}", "ios-printer-outline":"{f490}", "ios-pulse":"{f493}", "ios-pulse-strong":"{f492}", "ios-rainy":"{f495}", "ios-rainy-outline":"{f494}", "ios-recording":"{f497}", "ios-recording-outline":"{f496}", "ios-redo":"{f499}", "ios-redo-outline":"{f498}", "ios-refresh":"{f49c}", "ios-refresh-empty":"{f49a}", "ios-refresh-outline":"{f49b}", "ios-reload":"{f49d}", "ios-reverse-camera":"{f49f}", "ios-reverse-camera-outline":"{f49e}", "ios-rewind":"{f4a1}", "ios-rewind-outline":"{f4a0}", "ios-rose":"{f4a3}", "ios-rose-outline":"{f4a2}", "ios-search":"{f4a5}", "ios-search-strong":"{f4a4}", "ios-settings":"{f4a7}", "ios-settings-strong":"{f4a6}", "ios-shuffle":"{f4a9}", "ios-shuffle-strong":"{f4a8}", "ios-skipbackward":"{f4ab}", "ios-skipbackward-outline":"{f4aa}", "ios-skipforward":"{f4ad}", "ios-skipforward-outline":"{f4ac}", "ios-snowy":"{f4ae}", "ios-speedometer":"{f4b0}", "ios-speedometer-outline":"{f4af}", "ios-star":"{f4b3}", "ios-star-half":"{f4b1}", "ios-star-outline":"{f4b2}", "ios-stopwatch":"{f4b5}", "ios-stopwatch-outline":"{f4b4}", "ios-sunny":"{f4b7}", "ios-sunny-outline":"{f4b6}", "ios-telephone":"{f4b9}", "ios-telephone-outline":"{f4b8}", "ios-tennisball":"{f4bb}", "ios-tennisball-outline":"{f4ba}", "ios-thunderstorm":"{f4bd}", "ios-thunderstorm-outline":"{f4bc}", "ios-time":"{f4bf}", "ios-time-outline":"{f4be}", "ios-timer":"{f4c1}", "ios-timer-outline":"{f4c0}", "ios-toggle":"{f4c3}", "ios-toggle-outline":"{f4c2}", "ios-trash":"{f4c5}", "ios-trash-outline":"{f4c4}", "ios-undo":"{f4c7}", "ios-undo-outline":"{f4c6}", "ios-unlocked":"{f4c9}", "ios-unlocked-outline":"{f4c8}", "ios-upload":"{f4cb}", "ios-upload-outline":"{f4ca}", "ios-videocam":"{f4cd}", "ios-videocam-outline":"{f4cc}", "ios-volume-high":"{f4ce}", "ios-volume-low":"{f4cf}", "ios-wineglass":"{f4d1}", "ios-wineglass-outline":"{f4d0}", "ios-world":"{f4d3}", "ios-world-outline":"{f4d2}", "ipad":"{f1f9}", "iphone":"{f1fa}", "ipod":"{f1fb}", "jet":"{f295}", "key":"{f296}", "knife":"{f297}", "laptop":"{f1fc}", "leaf":"{f1fd}", "levels":"{f298}", "lightbulb":"{f299}", "link":"{f1fe}", "load-a":"{f29a}", "load-b":"{f29b}", "load-c":"{f29c}", "load-d":"{f29d}", "location":"{f1ff}", "lock-combination":"{f4d4}", "locked":"{f200}", "log-in":"{f29e}", "log-out":"{f29f}", "loop":"{f201}", "magnet":"{f2a0}", "male":"{f2a1}", "man":"{f202}", "map":"{f203}", "medkit":"{f2a2}", "merge":"{f33f}", "mic-a":"{f204}", "mic-b":"{f205}", "mic-c":"{f206}", "minus":"{f209}", "minus-circled":"{f207}", "minus-round":"{f208}", "model-s":"{f2c1}", "monitor":"{f20a}", "more":"{f20b}", "mouse":"{f340}", "music-note":"{f20c}", "navicon":"{f20e}", "navicon-round":"{f20d}", "navigate":"{f2a3}", "network":"{f341}", "no-smoking":"{f2c2}", "nuclear":"{f2a4}", "outlet":"{f342}", "paintbrush":"{f4d5}", "paintbucket":"{f4d6}", "paper-airplane":"{f2c3}", "paperclip":"{f20f}", "pause":"{f210}", "person":"{f213}", "person-add":"{f211}", "person-stalker":"{f212}", "pie-graph":"{f2a5}", "pin":"{f2a6}", "pinpoint":"{f2a7}", "pizza":"{f2a8}", "plane":"{f214}", "planet":"{f343}", "play":"{f215}", "playstation":"{f30a}", "plus":"{f218}", "plus-circled":"{f216}", "plus-round":"{f217}", "podium":"{f344}", "pound":"{f219}", "power":"{f2a9}", "pricetag":"{f2aa}", "pricetags":"{f2ab}", "printer":"{f21a}", "pull-request":"{f345}", "qr-scanner":"{f346}", "quote":"{f347}", "radio-waves":"{f2ac}", "record":"{f21b}", "refresh":"{f21c}", "reply":"{f21e}", "reply-all":"{f21d}", "ribbon-a":"{f348}", "ribbon-b":"{f349}", "sad":"{f34a}", "sad-outline":"{f4d7}", "scissors":"{f34b}", "search":"{f21f}", "settings":"{f2ad}", "share":"{f220}", "shuffle":"{f221}", "skip-backward":"{f222}", "skip-forward":"{f223}", "social-android":"{f225}", "social-android-outline":"{f224}", "social-angular":"{f4d9}", "social-angular-outline":"{f4d8}", "social-apple":"{f227}", "social-apple-outline":"{f226}", "social-bitcoin":"{f2af}", "social-bitcoin-outline":"{f2ae}", "social-buffer":"{f229}", "social-buffer-outline":"{f228}", "social-chrome":"{f4db}", "social-chrome-outline":"{f4da}", "social-codepen":"{f4dd}", "social-codepen-outline":"{f4dc}", "social-css3":"{f4df}", "social-css3-outline":"{f4de}", "social-designernews":"{f22b}", "social-designernews-outline":"{f22a}", "social-dribbble":"{f22d}", "social-dribbble-outline":"{f22c}", "social-dropbox":"{f22f}", "social-dropbox-outline":"{f22e}", "social-euro":"{f4e1}", "social-euro-outline":"{f4e0}", "social-facebook":"{f231}", "social-facebook-outline":"{f230}", "social-foursquare":"{f34d}", "social-foursquare-outline":"{f34c}", "social-freebsd-devil":"{f2c4}", "social-github":"{f233}", "social-github-outline":"{f232}", "social-google":"{f34f}", "social-google-outline":"{f34e}", "social-googleplus":"{f235}", "social-googleplus-outline":"{f234}", "social-hackernews":"{f237}", "social-hackernews-outline":"{f236}", "social-html5":"{f4e3}", "social-html5-outline":"{f4e2}", "social-instagram":"{f351}", "social-instagram-outline":"{f350}", "social-javascript":"{f4e5}", "social-javascript-outline":"{f4e4}", "social-linkedin":"{f239}", "social-linkedin-outline":"{f238}", "social-markdown":"{f4e6}", "social-nodejs":"{f4e7}", "social-octocat":"{f4e8}", "social-pinterest":"{f2b1}", "social-pinterest-outline":"{f2b0}", "social-python":"{f4e9}", "social-reddit":"{f23b}", "social-reddit-outline":"{f23a}", "social-rss":"{f23d}", "social-rss-outline":"{f23c}", "social-sass":"{f4ea}", "social-skype":"{f23f}", "social-skype-outline":"{f23e}", "social-snapchat":"{f4ec}", "social-snapchat-outline":"{f4eb}", "social-tumblr":"{f241}", "social-tumblr-outline":"{f240}", "social-tux":"{f2c5}", "social-twitch":"{f4ee}", "social-twitch-outline":"{f4ed}", "social-twitter":"{f243}", "social-twitter-outline":"{f242}", "social-usd":"{f353}", "social-usd-outline":"{f352}", "social-vimeo":"{f245}", "social-vimeo-outline":"{f244}", "social-whatsapp":"{f4f0}", "social-whatsapp-outline":"{f4ef}", "social-windows":"{f247}", "social-windows-outline":"{f246}", "social-wordpress":"{f249}", "social-wordpress-outline":"{f248}", "social-yahoo":"{f24b}", "social-yahoo-outline":"{f24a}", "social-yen":"{f4f2}", "social-yen-outline":"{f4f1}", "social-youtube":"{f24d}", "social-youtube-outline":"{f24c}", "soup-can":"{f4f4}", "soup-can-outline":"{f4f3}", "speakerphone":"{f2b2}", "speedometer":"{f2b3}", "spoon":"{f2b4}", "star":"{f24e}", "stats-bars":"{f2b5}", "steam":"{f30b}", "stop":"{f24f}", "thermometer":"{f2b6}", "thumbsdown":"{f250}", "thumbsup":"{f251}", "toggle":"{f355}", "toggle-filled":"{f354}", "transgender":"{f4f5}", "trash-a":"{f252}", "trash-b":"{f253}", "trophy":"{f356}", "tshirt":"{f4f7}", "tshirt-outline":"{f4f6}", "umbrella":"{f2b7}", "university":"{f357}", "unlocked":"{f254}", "upload":"{f255}", "usb":"{f2b8}", "videocamera":"{f256}", "volume-high":"{f257}", "volume-low":"{f258}", "volume-medium":"{f259}", "volume-mute":"{f25a}", "wand":"{f358}", "waterdrop":"{f25b}", "wifi":"{f25c}", "wineglass":"{f2b9}", "woman":"{f25d}", "wrench":"{f2ba}", "xbox":"{f30c}",}
    transKV2SwiftEnum("FontIon", "Ionicons", "Ionicons", ionIcons)

    mapIcons = {"map.icon.abseiling":"{e800}", "map.icon.accounting":"{e801}", "map.icon.airport":"{e802}", "map.icon.amusement.park":"{e803}", "map.icon.aquarium":"{e804}", "map.icon.archery":"{e805}", "map.icon.art.gallery":"{e806}", "map.icon.assistive.listening.system":"{e807}", "map.icon.atm":"{e808}", "map.icon.audio.description":"{e809}", "map.icon.bakery":"{e80a}", "map.icon.bank":"{e80b}", "map.icon.bar":"{e80c}", "map.icon.baseball":"{e80d}", "map.icon.beauty.salon":"{e80e}", "map.icon.bicycle.store":"{e80f}", "map.icon.bicycling":"{e810}", "map.icon.boat.ramp":"{e811}", "map.icon.boat.tour":"{e812}", "map.icon.boating":"{e813}", "map.icon.book.store":"{e814}", "map.icon.bowling.alley":"{e815}", "map.icon.braille":"{e816}", "map.icon.bus.station":"{e817}", "map.icon.cafe":"{e818}", "map.icon.campground":"{e819}", "map.icon.canoe":"{e81a}", "map.icon.car.dealer":"{e81b}", "map.icon.car.rental":"{e81c}", "map.icon.car.repair":"{e81d}", "map.icon.car.wash":"{e81e}", "map.icon.casino":"{e81f}", "map.icon.cemetery":"{e820}", "map.icon.chairlift":"{e821}", "map.icon.church":"{e822}", "map.icon.circle":"{e823}", "map.icon.city.hall":"{e824}", "map.icon.climbing":"{e825}", "map.icon.closed.captioning":"{e826}", "map.icon.clothing.store":"{e827}", "map.icon.compass":"{e828}", "map.icon.convenience.store":"{e829}", "map.icon.courthouse":"{e82a}", "map.icon.cross.country.skiing":"{e82b}", "map.icon.crosshairs":"{e82c}", "map.icon.dentist":"{e82d}", "map.icon.department.store":"{e82e}", "map.icon.diving":"{e82f}", "map.icon.doctor":"{e830}", "map.icon.electrician":"{e831}", "map.icon.electronics.store":"{e832}", "map.icon.embassy":"{e833}", "map.icon.expand":"{e834}", "map.icon.female":"{e835}", "map.icon.finance":"{e836}", "map.icon.fire.station":"{e837}", "map.icon.fish.cleaning":"{e838}", "map.icon.fishing.pier":"{e839}", "map.icon.fishing":"{e83a}", "map.icon.florist":"{e83b}", "map.icon.food":"{e83c}", "map.icon.fullscreen":"{e83d}", "map.icon.funeral.home":"{e83e}", "map.icon.furniture.store":"{e83f}", "map.icon.gas.station":"{e840}", "map.icon.general.contractor":"{e841}", "map.icon.golf":"{e842}", "map.icon.grocery.or.supermarket":"{e843}", "map.icon.gym":"{e844}", "map.icon.hair.care":"{e845}", "map.icon.hang.gliding":"{e846}", "map.icon.hardware.store":"{e847}", "map.icon.health":"{e848}", "map.icon.hindu.temple":"{e849}", "map.icon.horse.riding":"{e84a}", "map.icon.hospital":"{e84b}", "map.icon.ice.fishing":"{e84c}", "map.icon.ice.skating":"{e84d}", "map.icon.inline.skating":"{e84e}", "map.icon.insurance.agency":"{e84f}", "map.icon.jet.skiing":"{e850}", "map.icon.jewelry.store":"{e851}", "map.icon.kayaking":"{e852}", "map.icon.laundry":"{e853}", "map.icon.lawyer":"{e854}", "map.icon.library":"{e855}", "map.icon.liquor.store":"{e856}", "map.icon.local.government":"{e857}", "map.icon.location.arrow":"{e858}", "map.icon.locksmith":"{e859}", "map.icon.lodging":"{e85a}", "map.icon.low.vision.access":"{e85b}", "map.icon.male":"{e85c}", "map.icon.map.pin":"{e85d}", "map.icon.marina":"{e85e}", "map.icon.mosque":"{e85f}", "map.icon.motobike.trail":"{e860}", "map.icon.movie.rental":"{e861}", "map.icon.movie.theater":"{e862}", "map.icon.moving.company":"{e863}", "map.icon.museum":"{e864}", "map.icon.natural.feature":"{e865}", "map.icon.night.club":"{e866}", "map.icon.open.captioning":"{e867}", "map.icon.painter":"{e868}", "map.icon.park":"{e869}", "map.icon.parking":"{e86a}", "map.icon.pet.store":"{e86b}", "map.icon.pharmacy":"{e86c}", "map.icon.physiotherapist":"{e86d}", "map.icon.place.of.worship":"{e86e}", "map.icon.playground":"{e86f}", "map.icon.plumber":"{e870}", "map.icon.point.of.interest":"{e871}", "map.icon.police":"{e872}", "map.icon.political":"{e873}", "map.icon.post.box":"{e874}", "map.icon.post.office":"{e875}", "map.icon.postal.code.prefix":"{e876}", "map.icon.postal.code":"{e877}", "map.icon.rafting":"{e878}", "map.icon.real.estate.agency":"{e879}", "map.icon.restaurant":"{e87a}", "map.icon.roofing.contractor":"{e87b}", "map.icon.route.pin":"{e87c}", "map.icon.route":"{e87d}", "map.icon.rv.park":"{e87e}", "map.icon.sailing":"{e87f}", "map.icon.school":"{e880}", "map.icon.scuba.diving":"{e881}", "map.icon.search":"{e882}", "map.icon.shield":"{e883}", "map.icon.shopping.mall":"{e884}", "map.icon.sign.language":"{e885}", "map.icon.skateboarding":"{e886}", "map.icon.ski.jumping":"{e887}", "map.icon.skiing":"{e888}", "map.icon.sledding":"{e889}", "map.icon.snow.shoeing":"{e88a}", "map.icon.snow":"{e88b}", "map.icon.snowboarding":"{e88c}", "map.icon.snowmobile":"{e88d}", "map.icon.spa":"{e88e}", "map.icon.square.pin":"{e88f}", "map.icon.square.rounded":"{e890}", "map.icon.square":"{e891}", "map.icon.stadium":"{e892}", "map.icon.storage":"{e893}", "map.icon.store":"{e894}", "map.icon.subway.station":"{e895}", "map.icon.surfing":"{e896}", "map.icon.swimming":"{e897}", "map.icon.synagogue":"{e898}", "map.icon.taxi.stand":"{e899}", "map.icon.tennis":"{e89a}", "map.icon.toilet":"{e89b}", "map.icon.trail.walking":"{e89c}", "map.icon.train.station":"{e89d}", "map.icon.transit.station":"{e89e}", "map.icon.travel.agency":"{e89f}", "map.icon.unisex":"{e8a0}", "map.icon.university":"{e8a1}", "map.icon.veterinary.care":"{e8a2}", "map.icon.viewing":"{e8a3}", "map.icon.volume.control.telephone":"{e8a4}", "map.icon.walking":"{e8a5}", "map.icon.waterskiing":"{e8a6}", "map.icon.whale.watching":"{e8a7}", "map.icon.wheelchair":"{e8a8}", "map.icon.wind.surfing":"{e8a9}", "map.icon.zoo":"{e8aa}", "map.icon.zoom.in.alt":"{e8ab}", "map.icon.zoom.in":"{e8ac}", "map.icon.zoom.out.alt":"{e8ad}", "map.icon.zoom.out":"{e8ae}"}
    transKV2SwiftEnum(className="FontMap", fontName="map-icons", fileName="map-icons", icons=mapIcons)

    materialIcon = {"3d.rotation":"{e84d}", "ac.unit":"{eb3b}", "access.alarm":"{e190}", "access.alarms":"{e191}", "access.time":"{e192}", "accessibility":"{e84e}", "accessible":"{e914}", "account.balance":"{e84f}", "account.balance.wallet":"{e850}", "account.box":"{e851}", "account.circle":"{e853}", "adb":"{e60e}", "add":"{e145}", "add.a.photo":"{e439}", "add.alarm":"{e193}", "add.alert":"{e003}", "add.box":"{e146}", "add.circle":"{e147}", "add.circle.outline":"{e148}", "add.location":"{e567}", "add.shopping.cart":"{e854}", "add.to.photos":"{e39d}", "add.to.queue":"{e05c}", "adjust":"{e39e}", "airline.seat.flat":"{e630}", "airline.seat.flat.angled":"{e631}", "airline.seat.individual.suite":"{e632}", "airline.seat.legroom.extra":"{e633}", "airline.seat.legroom.normal":"{e634}", "airline.seat.legroom.reduced":"{e635}", "airline.seat.recline.extra":"{e636}", "airline.seat.recline.normal":"{e637}", "airplanemode.active":"{e195}", "airplanemode.inactive":"{e194}", "airplay":"{e055}", "airport.shuttle":"{eb3c}", "alarm":"{e855}", "alarm.add":"{e856}", "alarm.off":"{e857}", "alarm.on":"{e858}", "album":"{e019}", "all.inclusive":"{eb3d}", "all.out":"{e90b}", "android":"{e859}", "announcement":"{e85a}", "apps":"{e5c3}", "archive":"{e149}", "arrow.back":"{e5c4}", "arrow.downward":"{e5db}", "arrow.drop.down":"{e5c5}", "arrow.drop.down.circle":"{e5c6}", "arrow.drop.up":"{e5c7}", "arrow.forward":"{e5c8}", "arrow.upward":"{e5d8}", "art.track":"{e060}", "aspect.ratio":"{e85b}", "assessment":"{e85c}", "assignment":"{e85d}", "assignment.ind":"{e85e}", "assignment.late":"{e85f}", "assignment.return":"{e860}", "assignment.returned":"{e861}", "assignment.turned.in":"{e862}", "assistant":"{e39f}", "assistant.photo":"{e3a0}", "attach.file":"{e226}", "attach.money":"{e227}", "attachment":"{e2bc}", "audiotrack":"{e3a1}", "autorenew":"{e863}", "av.timer":"{e01b}", "backspace":"{e14a}", "backup":"{e864}", "battery.alert":"{e19c}", "battery.charging.full":"{e1a3}", "battery.full":"{e1a4}", "battery.std":"{e1a5}", "battery.unknown":"{e1a6}", "beach.access":"{eb3e}", "beenhere":"{e52d}", "block":"{e14b}", "bluetooth":"{e1a7}", "bluetooth.audio":"{e60f}", "bluetooth.connected":"{e1a8}", "bluetooth.disabled":"{e1a9}", "bluetooth.searching":"{e1aa}", "blur.circular":"{e3a2}", "blur.linear":"{e3a3}", "blur.off":"{e3a4}", "blur.on":"{e3a5}", "book":"{e865}", "bookmark":"{e866}", "bookmark.border":"{e867}", "border.all":"{e228}", "border.bottom":"{e229}", "border.clear":"{e22a}", "border.color":"{e22b}", "border.horizontal":"{e22c}", "border.inner":"{e22d}", "border.left":"{e22e}", "border.outer":"{e22f}", "border.right":"{e230}", "border.style":"{e231}", "border.top":"{e232}", "border.vertical":"{e233}", "branding.watermark":"{e06b}", "brightness.1":"{e3a6}", "brightness.2":"{e3a7}", "brightness.3":"{e3a8}", "brightness.4":"{e3a9}", "brightness.5":"{e3aa}", "brightness.6":"{e3ab}", "brightness.7":"{e3ac}", "brightness.auto":"{e1ab}", "brightness.high":"{e1ac}", "brightness.low":"{e1ad}", "brightness.medium":"{e1ae}", "broken.image":"{e3ad}", "brush":"{e3ae}", "bubble.chart":"{e6dd}", "bug.report":"{e868}", "build":"{e869}", "burst.mode":"{e43c}", "business":"{e0af}", "business.center":"{eb3f}", "cached":"{e86a}", "cake":"{e7e9}", "call":"{e0b0}", "call.end":"{e0b1}", "call.made":"{e0b2}", "call.merge":"{e0b3}", "call.missed":"{e0b4}", "call.missed.outgoing":"{e0e4}", "call.received":"{e0b5}", "call.split":"{e0b6}", "call.to.action":"{e06c}", "camera":"{e3af}", "camera.alt":"{e3b0}", "camera.enhance":"{e8fc}", "camera.front":"{e3b1}", "camera.rear":"{e3b2}", "camera.roll":"{e3b3}", "cancel":"{e5c9}", "card.giftcard":"{e8f6}", "card.membership":"{e8f7}", "card.travel":"{e8f8}", "casino":"{eb40}", "cast":"{e307}", "cast.connected":"{e308}", "center.focus.strong":"{e3b4}", "center.focus.weak":"{e3b5}", "change.history":"{e86b}", "chat":"{e0b7}", "chat.bubble":"{e0ca}", "chat.bubble.outline":"{e0cb}", "check":"{e5ca}", "check.box":"{e834}", "check.box.outline.blank":"{e835}", "check.circle":"{e86c}", "chevron.left":"{e5cb}", "chevron.right":"{e5cc}", "child.care":"{eb41}", "child.friendly":"{eb42}", "chrome.reader.mode":"{e86d}", "class":"{e86e}", "clear":"{e14c}", "clear.all":"{e0b8}", "close":"{e5cd}", "closed.caption":"{e01c}", "cloud":"{e2bd}", "cloud.circle":"{e2be}", "cloud.done":"{e2bf}", "cloud.download":"{e2c0}", "cloud.off":"{e2c1}", "cloud.queue":"{e2c2}", "cloud.upload":"{e2c3}", "code":"{e86f}", "collections":"{e3b6}", "collections.bookmark":"{e431}", "color.lens":"{e3b7}", "colorize":"{e3b8}", "comment":"{e0b9}", "compare":"{e3b9}", "compare.arrows":"{e915}", "computer":"{e30a}", "confirmation.number":"{e638}", "contact.mail":"{e0d0}", "contact.phone":"{e0cf}", "contacts":"{e0ba}", "content.copy":"{e14d}", "content.cut":"{e14e}", "content.paste":"{e14f}", "control.point":"{e3ba}", "control.point.duplicate":"{e3bb}", "copyright":"{e90c}", "create":"{e150}", "create.new.folder":"{e2cc}", "credit.card":"{e870}", "crop":"{e3be}", "crop.16.9":"{e3bc}", "crop.3.2":"{e3bd}", "crop.5.4":"{e3bf}", "crop.7.5":"{e3c0}", "crop.din":"{e3c1}", "crop.free":"{e3c2}", "crop.landscape":"{e3c3}", "crop.original":"{e3c4}", "crop.portrait":"{e3c5}", "crop.rotate":"{e437}", "crop.square":"{e3c6}", "dashboard":"{e871}", "data.usage":"{e1af}", "date.range":"{e916}", "dehaze":"{e3c7}", "delete":"{e872}", "delete.forever":"{e92b}", "delete.sweep":"{e16c}", "description":"{e873}", "desktop.mac":"{e30b}", "desktop.windows":"{e30c}", "details":"{e3c8}", "developer.board":"{e30d}", "developer.mode":"{e1b0}", "device.hub":"{e335}", "devices":"{e1b1}", "devices.other":"{e337}", "dialer.sip":"{e0bb}", "dialpad":"{e0bc}", "directions":"{e52e}", "directions.bike":"{e52f}", "directions.boat":"{e532}", "directions.bus":"{e530}", "directions.car":"{e531}", "directions.railway":"{e534}", "directions.run":"{e566}", "directions.subway":"{e533}", "directions.transit":"{e565}", "directions.walk":"{e536}", "disc.full":"{e610}", "dns":"{e875}", "do.not.disturb":"{e612}", "do.not.disturb.alt":"{e611}", "do.not.disturb.off":"{e643}", "do.not.disturb.on":"{e644}", "dock":"{e30e}", "domain":"{e7ee}", "done":"{e876}", "done.all":"{e877}", "donut.large":"{e917}", "donut.small":"{e918}", "drafts":"{e151}", "drag.handle":"{e25d}", "drive.eta":"{e613}", "dvr":"{e1b2}", "edit":"{e3c9}", "edit.location":"{e568}", "eject":"{e8fb}", "email":"{e0be}", "enhanced.encryption":"{e63f}", "equalizer":"{e01d}", "error":"{e000}", "error.outline":"{e001}", "euro.symbol":"{e926}", "ev.station":"{e56d}", "event":"{e878}", "event.available":"{e614}", "event.busy":"{e615}", "event.note":"{e616}", "event.seat":"{e903}", "exit.to.app":"{e879}", "expand.less":"{e5ce}", "expand.more":"{e5cf}", "explicit":"{e01e}", "explore":"{e87a}", "exposure":"{e3ca}", "exposure.neg.1":"{e3cb}", "exposure.neg.2":"{e3cc}", "exposure.plus.1":"{e3cd}", "exposure.plus.2":"{e3ce}", "exposure.zero":"{e3cf}", "extension":"{e87b}", "face":"{e87c}", "fast.forward":"{e01f}", "fast.rewind":"{e020}", "favorite":"{e87d}", "favorite.border":"{e87e}", "featured.play.list":"{e06d}", "featured.video":"{e06e}", "feedback":"{e87f}", "fiber.dvr":"{e05d}", "fiber.manual.record":"{e061}", "fiber.new":"{e05e}", "fiber.pin":"{e06a}", "fiber.smart.record":"{e062}", "file.download":"{e2c4}", "file.upload":"{e2c6}", "filter":"{e3d3}", "filter.1":"{e3d0}", "filter.2":"{e3d1}", "filter.3":"{e3d2}", "filter.4":"{e3d4}", "filter.5":"{e3d5}", "filter.6":"{e3d6}", "filter.7":"{e3d7}", "filter.8":"{e3d8}", "filter.9":"{e3d9}", "filter.9.plus":"{e3da}", "filter.b.and.w":"{e3db}", "filter.center.focus":"{e3dc}", "filter.drama":"{e3dd}", "filter.frames":"{e3de}", "filter.hdr":"{e3df}", "filter.list":"{e152}", "filter.none":"{e3e0}", "filter.tilt.shift":"{e3e2}", "filter.vintage":"{e3e3}", "find.in.page":"{e880}", "find.replace":"{e881}", "fingerprint":"{e90d}", "first.page":"{e5dc}", "fitness.center":"{eb43}", "flag":"{e153}", "flare":"{e3e4}", "flash.auto":"{e3e5}", "flash.off":"{e3e6}", "flash.on":"{e3e7}", "flight":"{e539}", "flight.land":"{e904}", "flight.takeoff":"{e905}", "flip":"{e3e8}", "flip.to.back":"{e882}", "flip.to.front":"{e883}", "folder":"{e2c7}", "folder.open":"{e2c8}", "folder.shared":"{e2c9}", "folder.special":"{e617}", "font.download":"{e167}", "format.align.center":"{e234}", "format.align.justify":"{e235}", "format.align.left":"{e236}", "format.align.right":"{e237}", "format.bold":"{e238}", "format.clear":"{e239}", "format.color.fill":"{e23a}", "format.color.reset":"{e23b}", "format.color.text":"{e23c}", "format.indent.decrease":"{e23d}", "format.indent.increase":"{e23e}", "format.italic":"{e23f}", "format.line.spacing":"{e240}", "format.list.bulleted":"{e241}", "format.list.numbered":"{e242}", "format.paint":"{e243}", "format.quote":"{e244}", "format.shapes":"{e25e}", "format.size":"{e245}", "format.strikethrough":"{e246}", "format.textdirection.l.to.r":"{e247}", "format.textdirection.r.to.l":"{e248}", "format.underlined":"{e249}", "forum":"{e0bf}", "forward":"{e154}", "forward.10":"{e056}", "forward.30":"{e057}", "forward.5":"{e058}", "free.breakfast":"{eb44}", "fullscreen":"{e5d0}", "fullscreen.exit":"{e5d1}", "functions":"{e24a}", "g.translate":"{e927}", "gamepad":"{e30f}", "games":"{e021}", "gavel":"{e90e}", "gesture":"{e155}", "get.app":"{e884}", "gif":"{e908}", "golf.course":"{eb45}", "gps.fixed":"{e1b3}", "gps.not.fixed":"{e1b4}", "gps.off":"{e1b5}", "grade":"{e885}", "gradient":"{e3e9}", "grain":"{e3ea}", "graphic.eq":"{e1b8}", "grid.off":"{e3eb}", "grid.on":"{e3ec}", "group":"{e7ef}", "group.add":"{e7f0}", "group.work":"{e886}", "hd":"{e052}", "hdr.off":"{e3ed}", "hdr.on":"{e3ee}", "hdr.strong":"{e3f1}", "hdr.weak":"{e3f2}", "headset":"{e310}", "headset.mic":"{e311}", "healing":"{e3f3}", "hearing":"{e023}", "help":"{e887}", "help.outline":"{e8fd}", "high.quality":"{e024}", "highlight":"{e25f}", "highlight.off":"{e888}", "history":"{e889}", "home":"{e88a}", "hot.tub":"{eb46}", "hotel":"{e53a}", "hourglass.empty":"{e88b}", "hourglass.full":"{e88c}", "http":"{e902}", "https":"{e88d}", "image":"{e3f4}", "image.aspect.ratio":"{e3f5}", "import.contacts":"{e0e0}", "import.export":"{e0c3}", "important.devices":"{e912}", "inbox":"{e156}", "indeterminate.check.box":"{e909}", "info":"{e88e}", "info.outline":"{e88f}", "input":"{e890}", "insert.chart":"{e24b}", "insert.comment":"{e24c}", "insert.drive.file":"{e24d}", "insert.emoticon":"{e24e}", "insert.invitation":"{e24f}", "insert.link":"{e250}", "insert.photo":"{e251}", "invert.colors":"{e891}", "invert.colors.off":"{e0c4}", "iso":"{e3f6}", "keyboard":"{e312}", "keyboard.arrow.down":"{e313}", "keyboard.arrow.left":"{e314}", "keyboard.arrow.right":"{e315}", "keyboard.arrow.up":"{e316}", "keyboard.backspace":"{e317}", "keyboard.capslock":"{e318}", "keyboard.hide":"{e31a}", "keyboard.return":"{e31b}", "keyboard.tab":"{e31c}", "keyboard.voice":"{e31d}", "kitchen":"{eb47}", "label":"{e892}", "label.outline":"{e893}", "landscape":"{e3f7}", "language":"{e894}", "laptop":"{e31e}", "laptop.chromebook":"{e31f}", "laptop.mac":"{e320}", "laptop.windows":"{e321}", "last.page":"{e5dd}", "launch":"{e895}", "layers":"{e53b}", "layers.clear":"{e53c}", "leak.add":"{e3f8}", "leak.remove":"{e3f9}", "lens":"{e3fa}", "library.add":"{e02e}", "library.books":"{e02f}", "library.music":"{e030}", "lightbulb.outline":"{e90f}", "line.style":"{e919}", "line.weight":"{e91a}", "linear.scale":"{e260}", "link":"{e157}", "linked.camera":"{e438}", "list":"{e896}", "live.help":"{e0c6}", "live.tv":"{e639}", "local.activity":"{e53f}", "local.airport":"{e53d}", "local.atm":"{e53e}", "local.bar":"{e540}", "local.cafe":"{e541}", "local.car.wash":"{e542}", "local.convenience.store":"{e543}", "local.dining":"{e556}", "local.drink":"{e544}", "local.florist":"{e545}", "local.gas.station":"{e546}", "local.grocery.store":"{e547}", "local.hospital":"{e548}", "local.hotel":"{e549}", "local.laundry.service":"{e54a}", "local.library":"{e54b}", "local.mall":"{e54c}", "local.movies":"{e54d}", "local.offer":"{e54e}", "local.parking":"{e54f}", "local.pharmacy":"{e550}", "local.phone":"{e551}", "local.pizza":"{e552}", "local.play":"{e553}", "local.post.office":"{e554}", "local.printshop":"{e555}", "local.see":"{e557}", "local.shipping":"{e558}", "local.taxi":"{e559}", "location.city":"{e7f1}", "location.disabled":"{e1b6}", "location.off":"{e0c7}", "location.on":"{e0c8}", "location.searching":"{e1b7}", "lock":"{e897}", "lock.open":"{e898}", "lock.outline":"{e899}", "looks":"{e3fc}", "looks.3":"{e3fb}", "looks.4":"{e3fd}", "looks.5":"{e3fe}", "looks.6":"{e3ff}", "looks.one":"{e400}", "looks.two":"{e401}", "loop":"{e028}", "loupe":"{e402}", "low.priority":"{e16d}", "loyalty":"{e89a}", "mail":"{e158}", "mail.outline":"{e0e1}", "map":"{e55b}", "markunread":"{e159}", "markunread.mailbox":"{e89b}", "memory":"{e322}", "menu":"{e5d2}", "merge.type":"{e252}", "message":"{e0c9}", "mic":"{e029}", "mic.none":"{e02a}", "mic.off":"{e02b}", "mms":"{e618}", "mode.comment":"{e253}", "mode.edit":"{e254}", "monetization.on":"{e263}", "money.off":"{e25c}", "monochrome.photos":"{e403}", "mood":"{e7f2}", "mood.bad":"{e7f3}", "more":"{e619}", "more.horiz":"{e5d3}", "more.vert":"{e5d4}", "motorcycle":"{e91b}", "mouse":"{e323}", "move.to.inbox":"{e168}", "movie":"{e02c}", "movie.creation":"{e404}", "movie.filter":"{e43a}", "multiline.chart":"{e6df}", "music.note":"{e405}", "music.video":"{e063}", "my.location":"{e55c}", "nature":"{e406}", "nature.people":"{e407}", "navigate.before":"{e408}", "navigate.next":"{e409}", "navigation":"{e55d}", "near.me":"{e569}", "network.cell":"{e1b9}", "network.check":"{e640}", "network.locked":"{e61a}", "network.wifi":"{e1ba}", "new.releases":"{e031}", "next.week":"{e16a}", "nfc":"{e1bb}", "no.encryption":"{e641}", "no.sim":"{e0cc}", "not.interested":"{e033}", "note":"{e06f}", "note.add":"{e89c}", "notifications":"{e7f4}", "notifications.active":"{e7f7}", "notifications.none":"{e7f5}", "notifications.off":"{e7f6}", "notifications.paused":"{e7f8}", "offline.pin":"{e90a}", "ondemand.video":"{e63a}", "opacity":"{e91c}", "open.in.browser":"{e89d}", "open.in.new":"{e89e}", "open.with":"{e89f}", "pages":"{e7f9}", "pageview":"{e8a0}", "palette":"{e40a}", "pan.tool":"{e925}", "panorama":"{e40b}", "panorama.fish.eye":"{e40c}", "panorama.horizontal":"{e40d}", "panorama.vertical":"{e40e}", "panorama.wide.angle":"{e40f}", "party.mode":"{e7fa}", "pause":"{e034}", "pause.circle.filled":"{e035}", "pause.circle.outline":"{e036}", "payment":"{e8a1}", "people":"{e7fb}", "people.outline":"{e7fc}", "perm.camera.mic":"{e8a2}", "perm.contact.calendar":"{e8a3}", "perm.data.setting":"{e8a4}", "perm.device.information":"{e8a5}", "perm.identity":"{e8a6}", "perm.media":"{e8a7}", "perm.phone.msg":"{e8a8}", "perm.scan.wifi":"{e8a9}", "person":"{e7fd}", "person.add":"{e7fe}", "person.outline":"{e7ff}", "person.pin":"{e55a}", "person.pin.circle":"{e56a}", "personal.video":"{e63b}", "pets":"{e91d}", "phone":"{e0cd}", "phone.android":"{e324}", "phone.bluetooth.speaker":"{e61b}", "phone.forwarded":"{e61c}", "phone.in.talk":"{e61d}", "phone.iphone":"{e325}", "phone.locked":"{e61e}", "phone.missed":"{e61f}", "phone.paused":"{e620}", "phonelink":"{e326}", "phonelink.erase":"{e0db}", "phonelink.lock":"{e0dc}", "phonelink.off":"{e327}", "phonelink.ring":"{e0dd}", "phonelink.setup":"{e0de}", "photo":"{e410}", "photo.album":"{e411}", "photo.camera":"{e412}", "photo.filter":"{e43b}", "photo.library":"{e413}", "photo.size.select.actual":"{e432}", "photo.size.select.large":"{e433}", "photo.size.select.small":"{e434}", "picture.as.pdf":"{e415}", "picture.in.picture":"{e8aa}", "picture.in.picture.alt":"{e911}", "pie.chart":"{e6c4}", "pie.chart.outlined":"{e6c5}", "pin.drop":"{e55e}", "place":"{e55f}", "play.arrow":"{e037}", "play.circle.filled":"{e038}", "play.circle.outline":"{e039}", "play.for.work":"{e906}", "playlist.add":"{e03b}", "playlist.add.check":"{e065}", "playlist.play":"{e05f}", "plus.one":"{e800}", "poll":"{e801}", "polymer":"{e8ab}", "pool":"{eb48}", "portable.wifi.off":"{e0ce}", "portrait":"{e416}", "power":"{e63c}", "power.input":"{e336}", "power.settings.new":"{e8ac}", "pregnant.woman":"{e91e}", "present.to.all":"{e0df}", "print":"{e8ad}", "priority.high":"{e645}", "public":"{e80b}", "publish":"{e255}", "query.builder":"{e8ae}", "question.answer":"{e8af}", "queue":"{e03c}", "queue.music":"{e03d}", "queue.play.next":"{e066}", "radio":"{e03e}", "radio.button.checked":"{e837}", "radio.button.unchecked":"{e836}", "rate.review":"{e560}", "receipt":"{e8b0}", "recent.actors":"{e03f}", "record.voice.over":"{e91f}", "redeem":"{e8b1}", "redo":"{e15a}", "refresh":"{e5d5}", "remove":"{e15b}", "remove.circle":"{e15c}", "remove.circle.outline":"{e15d}", "remove.from.queue":"{e067}", "remove.red.eye":"{e417}", "remove.shopping.cart":"{e928}", "reorder":"{e8fe}", "repeat":"{e040}", "repeat.one":"{e041}", "replay":"{e042}", "replay.10":"{e059}", "replay.30":"{e05a}", "replay.5":"{e05b}", "reply":"{e15e}", "reply.all":"{e15f}", "report":"{e160}", "report.problem":"{e8b2}", "restaurant":"{e56c}", "restaurant.menu":"{e561}", "restore":"{e8b3}", "restore.page":"{e929}", "ring.volume":"{e0d1}", "room":"{e8b4}", "room.service":"{eb49}", "rotate.90.degrees.ccw":"{e418}", "rotate.left":"{e419}", "rotate.right":"{e41a}", "rounded.corner":"{e920}", "router":"{e328}", "rowing":"{e921}", "rss.feed":"{e0e5}", "rv.hookup":"{e642}", "satellite":"{e562}", "save":"{e161}", "scanner":"{e329}", "schedule":"{e8b5}", "school":"{e80c}", "screen.lock.landscape":"{e1be}", "screen.lock.portrait":"{e1bf}", "screen.lock.rotation":"{e1c0}", "screen.rotation":"{e1c1}", "screen.share":"{e0e2}", "sd.card":"{e623}", "sd.storage":"{e1c2}", "search":"{e8b6}", "security":"{e32a}", "select.all":"{e162}", "send":"{e163}", "sentiment.dissatisfied":"{e811}", "sentiment.neutral":"{e812}", "sentiment.satisfied":"{e813}", "sentiment.very.dissatisfied":"{e814}", "sentiment.very.satisfied":"{e815}", "settings":"{e8b8}", "settings.applications":"{e8b9}", "settings.backup.restore":"{e8ba}", "settings.bluetooth":"{e8bb}", "settings.brightness":"{e8bd}", "settings.cell":"{e8bc}", "settings.ethernet":"{e8be}", "settings.input.antenna":"{e8bf}", "settings.input.component":"{e8c0}", "settings.input.composite":"{e8c1}", "settings.input.hdmi":"{e8c2}", "settings.input.svideo":"{e8c3}", "settings.overscan":"{e8c4}", "settings.phone":"{e8c5}", "settings.power":"{e8c6}", "settings.remote":"{e8c7}", "settings.system.daydream":"{e1c3}", "settings.voice":"{e8c8}", "share":"{e80d}", "shop":"{e8c9}", "shop.two":"{e8ca}", "shopping.basket":"{e8cb}", "shopping.cart":"{e8cc}", "short.text":"{e261}", "show.chart":"{e6e1}", "shuffle":"{e043}", "signal.cellular.4.bar":"{e1c8}", "signal.cellular.connected.no.internet.4.bar":"{e1cd}", "signal.cellular.no.sim":"{e1ce}", "signal.cellular.null":"{e1cf}", "signal.cellular.off":"{e1d0}", "signal.wifi.4.bar":"{e1d8}", "signal.wifi.4.bar.lock":"{e1d9}", "signal.wifi.off":"{e1da}", "sim.card":"{e32b}", "sim.card.alert":"{e624}", "skip.next":"{e044}", "skip.previous":"{e045}", "slideshow":"{e41b}", "slow.motion.video":"{e068}", "smartphone":"{e32c}", "smoke.free":"{eb4a}", "smoking.rooms":"{eb4b}", "sms":"{e625}", "sms.failed":"{e626}", "snooze":"{e046}", "sort":"{e164}", "sort.by.alpha":"{e053}", "spa":"{eb4c}", "space.bar":"{e256}", "speaker":"{e32d}", "speaker.group":"{e32e}", "speaker.notes":"{e8cd}", "speaker.notes.off":"{e92a}", "speaker.phone":"{e0d2}", "spellcheck":"{e8ce}", "star":"{e838}", "star.border":"{e83a}", "star.half":"{e839}", "stars":"{e8d0}", "stay.current.landscape":"{e0d3}", "stay.current.portrait":"{e0d4}", "stay.primary.landscape":"{e0d5}", "stay.primary.portrait":"{e0d6}", "stop":"{e047}", "stop.screen.share":"{e0e3}", "storage":"{e1db}", "store":"{e8d1}", "store.mall.directory":"{e563}", "straighten":"{e41c}", "streetview":"{e56e}", "strikethrough.s":"{e257}", "style":"{e41d}", "subdirectory.arrow.left":"{e5d9}", "subdirectory.arrow.right":"{e5da}", "subject":"{e8d2}", "subscriptions":"{e064}", "subtitles":"{e048}", "subway":"{e56f}", "supervisor.account":"{e8d3}", "surround.sound":"{e049}", "swap.calls":"{e0d7}", "swap.horiz":"{e8d4}", "swap.vert":"{e8d5}", "swap.vertical.circle":"{e8d6}", "switch.camera":"{e41e}", "switch.video":"{e41f}", "sync":"{e627}", "sync.disabled":"{e628}", "sync.problem":"{e629}", "system.update":"{e62a}", "system.update.alt":"{e8d7}", "tab":"{e8d8}", "tab.unselected":"{e8d9}", "tablet":"{e32f}", "tablet.android":"{e330}", "tablet.mac":"{e331}", "tag.faces":"{e420}", "tap.and.play":"{e62b}", "terrain":"{e564}", "text.fields":"{e262}", "text.format":"{e165}", "textsms":"{e0d8}", "texture":"{e421}", "theaters":"{e8da}", "thumb.down":"{e8db}", "thumb.up":"{e8dc}", "thumbs.up.down":"{e8dd}", "time.to.leave":"{e62c}", "timelapse":"{e422}", "timeline":"{e922}", "timer":"{e425}", "timer.10":"{e423}", "timer.3":"{e424}", "timer.off":"{e426}", "title":"{e264}", "toc":"{e8de}", "today":"{e8df}", "toll":"{e8e0}", "tonality":"{e427}", "touch.app":"{e913}", "toys":"{e332}", "track.changes":"{e8e1}", "traffic":"{e565}", "train":"{e570}", "tram":"{e571}", "transfer.within.a.station":"{e572}", "transform":"{e428}", "translate":"{e8e2}", "trending.down":"{e8e3}", "trending.flat":"{e8e4}", "trending.up":"{e8e5}", "tune":"{e429}", "turned.in":"{e8e6}", "turned.in.not":"{e8e7}", "tv":"{e333}", "unarchive":"{e169}", "undo":"{e166}", "unfold.less":"{e5d6}", "unfold.more":"{e5d7}", "update":"{e923}", "usb":"{e1e0}", "verified.user":"{e8e8}", "vertical.align.bottom":"{e258}", "vertical.align.center":"{e259}", "vertical.align.top":"{e25a}", "vibration":"{e62d}", "video.call":"{e070}", "video.label":"{e071}", "video.library":"{e04a}", "videocam":"{e04b}", "videocam.off":"{e04c}", "videogame.asset":"{e338}", "view.agenda":"{e8e9}", "view.array":"{e8ea}", "view.carousel":"{e8eb}", "view.column":"{e8ec}", "view.comfy":"{e42a}", "view.compact":"{e42b}", "view.day":"{e8ed}", "view.headline":"{e8ee}", "view.list":"{e8ef}", "view.module":"{e8f0}", "view.quilt":"{e8f1}", "view.stream":"{e8f2}", "view.week":"{e8f3}", "vignette":"{e435}", "visibility":"{e8f4}", "visibility.off":"{e8f5}", "voice.chat":"{e62e}", "voicemail":"{e0d9}", "volume.down":"{e04d}", "volume.mute":"{e04e}", "volume.off":"{e04f}", "volume.up":"{e050}", "vpn.key":"{e0da}", "vpn.lock":"{e62f}", "wallpaper":"{e1bc}", "warning":"{e002}", "watch":"{e334}", "watch.later":"{e924}", "wb.auto":"{e42c}", "wb.cloudy":"{e42d}", "wb.incandescent":"{e42e}", "wb.iridescent":"{e436}", "wb.sunny":"{e430}", "wc":"{e63d}", "web":"{e051}", "web.asset":"{e069}", "weekend":"{e16b}", "whatshot":"{e80e}", "widgets":"{e1bd}", "wifi":"{e63e}", "wifi.lock":"{e1e1}", "wifi.tethering":"{e1e2}", "work":"{e8f9}", "wrap.text":"{e25b}", "youtube.searched.for":"{e8fa}", "zoom.in":"{e8ff}", "zoom.out":"{e900}", "zoom.out.map":"{e56b}"}
    transKV2SwiftEnum(className="FontMaterial", fontName="Material Icons", fileName="MaterialIcons-Regular", icons=materialIcon)

    octicon = {"alert":"{f02d}", "alignment-align":"{f08a}", "alignment-aligned-to":"{f08e}", "alignment-unalign":"{f08b}", "arrow-down":"{f03f}", "arrow-left":"{f040}", "arrow-right":"{f03e}", "arrow-small-down":"{f0a0}", "arrow-small-left":"{f0a1}", "arrow-small-right":"{f071}", "arrow-small-up":"{f09f}", "arrow-up":"{f03d}", "beer":"{f069}", "book":"{f007}", "bookmark":"{f07b}", "briefcase":"{f0d3}", "broadcast":"{f048}", "browser":"{f0c5}", "bug":"{f091}", "calendar":"{f068}", "check":"{f03a}", "checklist":"{f076}", "chevron-down":"{f0a3}", "chevron-left":"{f0a4}", "chevron-right":"{f078}", "chevron-up":"{f0a2}", "circle-slash":"{f084}", "circuit-board":"{f0d6}", "clippy":"{f035}", "clock":"{f046}", "cloud-download":"{f00b}", "cloud-upload":"{f00c}", "code":"{f05f}", "color-mode":"{f065}", "comment":"{f02b}", "comment-discussion":"{f04f}", "credit-card":"{f045}", "dash":"{f0ca}", "dashboard":"{f07d}", "database":"{f096}", "device-camera":"{f056}", "device-camera-video":"{f057}", "device-desktop":"{f27c}", "device-mobile":"{f038}", "diff":"{f04d}", "diff-added":"{f06b}", "diff-ignored":"{f099}", "diff-modified":"{f06d}", "diff-removed":"{f06c}", "diff-renamed":"{f06e}", "ellipsis":"{f09a}", "eye":"{f04e}", "file-binary":"{f094}", "file-code":"{f010}", "file-directory":"{f016}", "file-media":"{f012}", "file-pdf":"{f014}", "file-submodule":"{f017}", "file-symlink-directory":"{f0b1}", "file-symlink-file":"{f0b0}", "file-text":"{f011}", "file-zip":"{f013}", "flame":"{f0d2}", "fold":"{f0cc}", "gear":"{f02f}", "gift":"{f042}", "gist":"{f00e}", "gist-secret":"{f08c}", "git-branch":"{f020}", "git-commit":"{f01f}", "git-compare":"{f0ac}", "git-merge":"{f023}", "git-pull-request":"{f009}", "globe":"{f0b6}", "graph":"{f043}", "heart":"{2665}", "history":"{f07e}", "home":"{f08d}", "horizontal-rule":"{f070}", "hourglass":"{f09e}", "hubot":"{f09d}", "inbox":"{f0cf}", "info":"{f059}", "issue-closed":"{f028}", "issue-opened":"{f026}", "issue-reopened":"{f027}", "jersey":"{f019}", "jump-down":"{f072}", "jump-left":"{f0a5}", "jump-right":"{f0a6}", "jump-up":"{f073}", "key":"{f049}", "keyboard":"{f00d}", "law":"{f0d8}", "light-bulb":"{f000}", "link":"{f05c}", "link-external":"{f07f}", "list-ordered":"{f062}", "list-unordered":"{f061}", "location":"{f060}", "lock":"{f06a}", "logo-github":"{f092}", "mail":"{f03b}", "mail-read":"{f03c}", "mail-reply":"{f051}", "mark-github":"{f00a}", "markdown":"{f0c9}", "megaphone":"{f077}", "mention":"{f0be}", "microscope":"{f089}", "milestone":"{f075}", "mirror":"{f024}", "mortar-board":"{f0d7}", "move-down":"{f0a8}", "move-left":"{f074}", "move-right":"{f0a9}", "move-up":"{f0a7}", "mute":"{f080}", "no-newline":"{f09c}", "octoface":"{f008}", "organization":"{f037}", "package":"{f0c4}", "paintcan":"{f0d1}", "pencil":"{f058}", "person":"{f018}", "pin":"{f041}", "playback-fast-forward":"{f0bd}", "playback-pause":"{f0bb}", "playback-play":"{f0bf}", "playback-rewind":"{f0bc}", "plug":"{f0d4}", "plus":"{f05d}", "podium":"{f0af}", "primitive-dot":"{f052}", "primitive-square":"{f053}", "pulse":"{f085}", "puzzle":"{f0c0}", "question":"{f02c}", "quote":"{f063}", "radio-tower":"{f030}", "repo":"{f001}", "repo-clone":"{f04c}", "repo-force-push":"{f04a}", "repo-forked":"{f002}", "repo-pull":"{f006}", "repo-push":"{f005}", "rocket":"{f033}", "rss":"{f034}", "ruby":"{f047}", "screen-full":"{f066}", "screen-normal":"{f067}", "search":"{f02e}", "server":"{f097}", "settings":"{f07c}", "sign-in":"{f036}", "sign-out":"{f032}", "split":"{f0c6}", "squirrel":"{f0b2}", "star":"{f02a}", "steps":"{f0c7}", "stop":"{f08f}", "sync":"{f087}", "tag":"{f015}", "telescope":"{f088}", "terminal":"{f0c8}", "three-bars":"{f05e}", "thumbsdown":"{f0db}", "thumbsup":"{f0da}", "tools":"{f031}", "trashcan":"{f0d0}", "triangle-down":"{f05b}", "triangle-left":"{f044}", "triangle-right":"{f05a}", "triangle-up":"{f0aa}", "unfold":"{f039}", "unmute":"{f0ba}", "versions":"{f064}", "x":"{f081}", "zap":"{26A1}",}
    transKV2SwiftEnum(className="FontOct", fontName="octicons", fileName="octicons", icons=octicon)

    themifyIcon = {"wand":"{e600}", "volume":"{e601}", "user":"{e602}", "unlock":"{e603}", "unlink":"{e604}", "trash":"{e605}", "thought":"{e606}", "target":"{e607}", "tag":"{e608}", "tablet":"{e609}", "star":"{e60a}", "spray":"{e60b}", "signal":"{e60c}", "shopping.cart":"{e60d}", "shopping.cart.full":"{e60e}", "settings":"{e60f}", "search":"{e610}", "zoom.in":"{e611}", "zoom.out":"{e612}", "cut":"{e613}", "ruler":"{e614}", "ruler.pencil":"{e615}", "ruler.alt":"{e616}", "bookmark":"{e617}", "bookmark.alt":"{e618}", "reload":"{e619}", "plus":"{e61a}", "pin":"{e61b}", "pencil":"{e61c}", "pencil.alt":"{e61d}", "paint.roller":"{e61e}", "paint.bucket":"{e61f}", "na":"{e620}", "mobile":"{e621}", "minus":"{e622}", "medall":"{e623}", "medall.alt":"{e624}", "marker":"{e625}", "marker.alt":"{e626}", "arrow.up":"{e627}", "arrow.right":"{e628}", "arrow.left":"{e629}", "arrow.down":"{e62a}", "lock":"{e62b}", "location.arrow":"{e62c}", "link":"{e62d}", "layout":"{e62e}", "layers":"{e62f}", "layers.alt":"{e630}", "key":"{e631}", "import":"{e632}", "image":"{e633}", "heart":"{e634}", "heart.broken":"{e635}", "hand.stop":"{e636}", "hand.open":"{e637}", "hand.drag":"{e638}", "folder":"{e639}", "flag":"{e63a}", "flag.alt":"{e63b}", "flag.alt.2":"{e63c}", "eye":"{e63d}", "export":"{e63e}", "exchange.vertical":"{e63f}", "desktop":"{e640}", "cup":"{e641}", "crown":"{e642}", "comments":"{e643}", "comment":"{e644}", "comment.alt":"{e645}", "close":"{e646}", "clip":"{e647}", "angle.up":"{e648}", "angle.right":"{e649}", "angle.left":"{e64a}", "angle.down":"{e64b}", "check":"{e64c}", "check.box":"{e64d}", "camera":"{e64e}", "announcement":"{e64f}", "brush":"{e650}", "briefcase":"{e651}", "bolt":"{e652}", "bolt.alt":"{e653}", "blackboard":"{e654}", "bag":"{e655}", "move":"{e656}", "arrows.vertical":"{e657}", "arrows.horizontal":"{e658}", "fullscreen":"{e659}", "arrow.top.right":"{e65a}", "arrow.top.left":"{e65b}", "arrow.circle.up":"{e65c}", "arrow.circle.right":"{e65d}", "arrow.circle.left":"{e65e}", "arrow.circle.down":"{e65f}", "angle.double.up":"{e660}", "angle.double.right":"{e661}", "angle.double.left":"{e662}", "angle.double.down":"{e663}", "zip":"{e664}", "world":"{e665}", "wheelchair":"{e666}", "view.list":"{e667}", "view.list.alt":"{e668}", "view.grid":"{e669}", "uppercase":"{e66a}", "upload":"{e66b}", "underline":"{e66c}", "truck":"{e66d}", "timer":"{e66e}", "ticket":"{e66f}", "thumb.up":"{e670}", "thumb.down":"{e671}", "text":"{e672}", "stats.up":"{e673}", "stats.down":"{e674}", "split.v":"{e675}", "split.h":"{e676}", "smallcap":"{e677}", "shine":"{e678}", "shift.right":"{e679}", "shift.left":"{e67a}", "shield":"{e67b}", "notepad":"{e67c}", "server":"{e67d}", "quote.right":"{e67e}", "quote.left":"{e67f}", "pulse":"{e680}", "printer":"{e681}", "power.off":"{e682}", "plug":"{e683}", "pie.chart":"{e684}", "paragraph":"{e685}", "panel":"{e686}", "package":"{e687}", "music":"{e688}", "music.alt":"{e689}", "mouse":"{e68a}", "mouse.alt":"{e68b}", "money":"{e68c}", "microphone":"{e68d}", "menu":"{e68e}", "menu.alt":"{e68f}", "map":"{e690}", "map.alt":"{e691}", "loop":"{e692}", "location.pin":"{e693}", "list":"{e694}", "light.bulb":"{e695}", "Italic":"{e696}", "info":"{e697}", "infinite":"{e698}", "id.badge":"{e699}", "hummer":"{e69a}", "home":"{e69b}", "help":"{e69c}", "headphone":"{e69d}", "harddrives":"{e69e}", "harddrive":"{e69f}", "gift":"{e6a0}", "game":"{e6a1}", "filter":"{e6a2}", "files":"{e6a3}", "file":"{e6a4}", "eraser":"{e6a5}", "envelope":"{e6a6}", "download":"{e6a7}", "direction":"{e6a8}", "direction.alt":"{e6a9}", "dashboard":"{e6aa}", "control.stop":"{e6ab}", "control.shuffle":"{e6ac}", "control.play":"{e6ad}", "control.pause":"{e6ae}", "control.forward":"{e6af}", "control.backward":"{e6b0}", "cloud":"{e6b1}", "cloud.up":"{e6b2}", "cloud.down":"{e6b3}", "clipboard":"{e6b4}", "car":"{e6b5}", "calendar":"{e6b6}", "book":"{e6b7}", "bell":"{e6b8}", "basketball":"{e6b9}", "bar.chart":"{e6ba}", "bar.chart.alt":"{e6bb}", "back.right":"{e6bc}", "back.left":"{e6bd}", "arrows.corner":"{e6be}", "archive":"{e6bf}", "anchor":"{e6c0}", "align.right":"{e6c1}", "align.left":"{e6c2}", "align.justify":"{e6c3}", "align.center":"{e6c4}", "alert":"{e6c5}", "alarm.clock":"{e6c6}", "agenda":"{e6c7}", "write":"{e6c8}", "window":"{e6c9}", "widgetized":"{e6ca}", "widget":"{e6cb}", "widget.alt":"{e6cc}", "wallet":"{e6cd}", "video.clapper":"{e6ce}", "video.camera":"{e6cf}", "vector":"{e6d0}", "themify.logo":"{e6d1}", "themify.favicon":"{e6d2}", "themify.favicon.alt":"{e6d3}", "support":"{e6d4}", "stamp":"{e6d5}", "split.v.alt":"{e6d6}", "slice":"{e6d7}", "shortcode":"{e6d8}", "shift.right.alt":"{e6d9}", "shift.left.alt":"{e6da}", "ruler.alt.2":"{e6db}", "receipt":"{e6dc}", "pin2":"{e6dd}", "pin.alt":"{e6de}", "pencil.alt2":"{e6df}", "palette":"{e6e0}", "more":"{e6e1}", "more.alt":"{e6e2}", "microphone.alt":"{e6e3}", "magnet":"{e6e4}", "line.double":"{e6e5}", "line.dotted":"{e6e6}", "line.dashed":"{e6e7}", "layout.width.full":"{e6e8}", "layout.width.default":"{e6e9}", "layout.width.default.alt":"{e6ea}", "layout.tab":"{e6eb}", "layout.tab.window":"{e6ec}", "layout.tab.v":"{e6ed}", "layout.tab.min":"{e6ee}", "layout.slider":"{e6ef}", "layout.slider.alt":"{e6f0}", "layout.sidebar.right":"{e6f1}", "layout.sidebar.none":"{e6f2}", "layout.sidebar.left":"{e6f3}", "layout.placeholder":"{e6f4}", "layout.menu":"{e6f5}", "layout.menu.v":"{e6f6}", "layout.menu.separated":"{e6f7}", "layout.menu.full":"{e6f8}", "layout.media.right.alt":"{e6f9}", "layout.media.right":"{e6fa}", "layout.media.overlay":"{e6fb}", "layout.media.overlay.alt":"{e6fc}", "layout.media.overlay.alt.2":"{e6fd}", "layout.media.left.alt":"{e6fe}", "layout.media.left":"{e6ff}", "layout.media.center.alt":"{e700}", "layout.media.center":"{e701}", "layout.list.thumb":"{e702}", "layout.list.thumb.alt":"{e703}", "layout.list.post":"{e704}", "layout.list.large.image":"{e705}", "layout.line.solid":"{e706}", "layout.grid4":"{e707}", "layout.grid3":"{e708}", "layout.grid2":"{e709}", "layout.grid2.thumb":"{e70a}", "layout.cta.right":"{e70b}", "layout.cta.left":"{e70c}", "layout.cta.center":"{e70d}", "layout.cta.btn.right":"{e70e}", "layout.cta.btn.left":"{e70f}", "layout.column4":"{e710}", "layout.column3":"{e711}", "layout.column2":"{e712}", "layout.accordion.separated":"{e713}", "layout.accordion.merged":"{e714}", "layout.accordion.list":"{e715}", "ink.pen":"{e716}", "info.alt":"{e717}", "help.alt":"{e718}", "headphone.alt":"{e719}", "hand.point.up":"{e71a}", "hand.point.right":"{e71b}", "hand.point.left":"{e71c}", "hand.point.down":"{e71d}", "gallery":"{e71e}", "face.smile":"{e71f}", "face.sad":"{e720}", "credit.card":"{e721}", "control.skip.forward":"{e722}", "control.skip.backward":"{e723}", "control.record":"{e724}", "control.eject":"{e725}", "comments.smiley":"{e726}", "brush.alt":"{e727}", "youtube":"{e728}", "vimeo":"{e729}", "twitter":"{e72a}", "time":"{e72b}", "tumblr":"{e72c}", "skype":"{e72d}", "share":"{e72e}", "share.alt":"{e72f}", "rocket":"{e730}", "pinterest":"{e731}", "new.window":"{e732}", "microsoft":"{e733}", "list.ol":"{e734}", "linkedin":"{e735}", "layout.sidebar.2":"{e736}", "layout.grid4.alt":"{e737}", "layout.grid3.alt":"{e738}", "layout.grid2.alt":"{e739}", "layout.column4.alt":"{e73a}", "layout.column3.alt":"{e73b}", "layout.column2.alt":"{e73c}", "instagram":"{e73d}", "google":"{e73e}", "github":"{e73f}", "flickr":"{e740}", "facebook":"{e741}", "dropbox":"{e742}", "dribbble":"{e743}", "apple":"{e744}", "android":"{e745}", "save":"{e746}", "save.alt":"{e747}", "yahoo":"{e748}", "wordpress":"{e749}", "vimeo.alt":"{e74a}", "twitter.alt":"{e74b}", "tumblr.alt":"{e74c}", "trello":"{e74d}", "stack.overflow":"{e74e}", "soundcloud":"{e74f}", "sharethis":"{e750}", "sharethis.alt":"{e751}", "reddit":"{e752}", "pinterest.alt":"{e753}", "microsoft.alt":"{e754}", "linux":"{e755}", "jsfiddle":"{e756}", "joomla":"{e757}", "html5":"{e758}", "flickr.alt":"{e759}", "email":"{e75a}", "drupal":"{e75b}", "dropbox.alt":"{e75c}", "css3":"{e75d}", "rss":"{e75e}", "rss.alt":"{e75f}"}
    transKV2SwiftEnum(className="FontThemify", fontName="themify", fileName="themify", icons=themifyIcon)


