English | [简体中文](README_zh.md)

<h2 align="center">Flutter GPT Box</h2>

<p align="center">
A third-party GPT Client for OpenAI API.
</p>

<!-- Badges-->
<p align="center">
  <a href="https://cdn.lpkt.cn/donate"><img alt="donate" src="https://img.shields.io/badge/donate-me-pink"></a>
  <img alt="lang" src="https://img.shields.io/badge/lang-dart-cyan">
  <img alt="license" src="https://img.shields.io/badge/license-GPLv3-yellow">
</p>

## 😣 Attention
This app is now under development, some features may be missing / not available.
Please refrain from using it in production environments or for critical data.


## 🪄 Features
- (🥳 New) Tools
  - Load history chats as context.
  - Ask GPT to add Memories.
  - Api supports viewing the content of Http links. [Video](https://cdn.lpkt.cn/gptbox/screenshot/tools.mp4)
  - Run JS locally.
- Restore from [ChatGPT Next Web backup](https://github.com/ChatGPTNextWeb/ChatGPT-Next-Web) / [OpenAI exported file](https://chatgpt.com).
- Text / Image / Audio chat.
- Localization. (English, 简体中文, Deutsch, 繁體中文, Indonesian, Français, Dutch, Türkçe, Español, Русский язык, Português, 日本語)
- Share chat as image.
- Url Scheme, eg: `lpkt.cn://gptbox/new?msg=hello`
- Sync with WebDAV / iCloud.
- Mobile & Desktop supports.
- Render code block / latex formula.
- Performance far exceeds traditional Web.


## 🏙️ Screenshots
<table>
  <tr>
    <td><img width="277px" src="https://cdn.lpkt.cn/gptbox/screenshot/1.jpg"></td>
    <td><img width="277px" src="https://cdn.lpkt.cn/gptbox/screenshot/2.jpg"></td>
    <td><img width="277px" src="https://cdn.lpkt.cn/gptbox/screenshot/3.jpg"></td>
    <td><img width="277px" src="https://cdn.lpkt.cn/gptbox/screenshot/4.jpg"></td>
  </tr>
</table>


## ⬇️ Use

Platform | From
--- | ---
iOS & macOS | [AppStore](https://apps.apple.com/app/id6476033062)
Android | [Github](https://github.com/lollipopkit/flutter_gpt_box/releases) / [CDN](https://cdn.lpkt.cn/gptbox/pkg/?order=desc) / [OpenAPK](https://www.openapk.net/gptbox/flutter.gpt.box/)
Linux & Windows | [Github](https://github.com/lollipopkit/flutter_gpt_box/releases) / [CDN](https://cdn.lpkt.cn/gptbox/pkg/?order=desc)

Only download from the source **you trust**


## 🆘 Help

<div align="center">
  <a href="https://t.me/lpktg"><img alt="donate" src="https://img.shields.io/badge/Telegram-lpktg-green"></a>
  <a href="https://discord.gg/SsVNbRhK7w"><img alt="discord" src="https://img.shields.io/badge/Discord-lpkt-purple"></a>
</div>

Before you open an issue, please read the following:
1. Paste the **entire log** (long press home title) in the issue template.
2. Make sure whether the issue is caused by this app.
3. Welcome all valid and positive feedback, subjective feedback (such as you think other UI is better) may not be accepted.

After you read the above, you can:
- If you have **any question or feature request**, please open a [discussion](https://github.com/lollipopkit/flutter_gpt_box/discussions/new/choose).  
- If app has **any bug**, please open an [issue](https://github.com/lollipopkit/flutter_gpt_box/issues/new).


## 🧱 Contribution
- Any positive contribution is welcome.
- [l10n guide](https://blog.lpkt.cn/posts/faq/) can be found in my blog.


## 💡 My other apps
- [Server Box](https://github.com/lollipopkit/flutter_server_box) - Server status & tools.
- [More](https://github.com/lollipopkit) - Tools & etc.


## 📝 License
`GPL v3 lollipopkit`

