# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

<a name="4.1.0"></a>

# [4.1.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@4.0.0...@lmc-eu/spirit-web-twig@4.1.0) (2024-12-16)

### Code Refactoring

- **web-react:** Collapse API prop changed ([9935692](https://github.com/lmc-eu/spirit-design-system/commit/9935692))
- **web-twig:** Collapse API attribute changed ([f09a740](https://github.com/lmc-eu/spirit-design-system/commit/f09a740))

### Documentation

- Add missing migration links to packages ([9a96b53](https://github.com/lmc-eu/spirit-design-system/commit/9a96b53))
- **web-twig:** Add link to list with all deprecations ([2c12a12](https://github.com/lmc-eu/spirit-design-system/commit/2c12a12)), closes [#DS-1215](https://github.com/lmc-eu/spirit-design-system/issues/DS-1215)
- **web-twig:** Move Container into DocsSection using `container` enum prop ([c3ad4b2](https://github.com/lmc-eu/spirit-design-system/commit/c3ad4b2))

### Features

- **web-twig:** Introduce isFluid prop to Container ([8f86d61](https://github.com/lmc-eu/spirit-design-system/commit/8f86d61))

### Styles

- **web-twig:** Fix docs using markdown linter ([332d07c](https://github.com/lmc-eu/spirit-design-system/commit/332d07c)), closes [#DS-1100](https://github.com/lmc-eu/spirit-design-system/issues/DS-1100)

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="4.0.0"></a>

# [4.0.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@4.0.0-alpha.2...@lmc-eu/spirit-web-twig@4.0.0) (2024-11-25)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="4.0.0-alpha.2"></a>

# [4.0.0-alpha.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@4.0.0-alpha.1...@lmc-eu/spirit-web-twig@4.0.0-alpha.2) (2024-11-25)

### Code Refactoring

- **web-twig:** Wrap ValidationText list in div ([c5c083e](https://github.com/lmc-eu/spirit-design-system/commit/c5c083e))

### Features

- **web-twig:** Introduce Plain Button [#DS-1454](https://github.com/lmc-eu/spirit-design-system/issues/DS-1454) ([c08e8fa](https://github.com/lmc-eu/spirit-design-system/commit/c08e8fa))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="4.0.0-alpha.1"></a>

# [4.0.0-alpha.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@4.0.0-alpha.0...@lmc-eu/spirit-web-twig@4.0.0-alpha.1) (2024-11-06)

### BREAKING CHANGES

- **web-twig:** Add the option to allow visited state in Link [#DS-1501](https://github.com/lmc-eu/spirit-design-system/issues/DS-1501) ([f2084b6](https://github.com/lmc-eu/spirit-design-system/commit/f2084b6))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="4.0.0-alpha.0"></a>

# [4.0.0-alpha.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@3.4.1...@lmc-eu/spirit-web-twig@4.0.0-alpha.0) (2024-10-17)

### BREAKING CHANGES

- **web-twig:** Button/ButtonLink have isSymmetrical prop instead of isSquare [#DS-1484](https://github.com/lmc-eu/spirit-design-system/issues/DS-1484) ([7fdccb4](https://github.com/lmc-eu/spirit-design-system/commit/7fdccb4))
- **web-twig:** Remove action colors from Pill [#DS-1446](https://github.com/lmc-eu/spirit-design-system/issues/DS-1446) ([83702bc](https://github.com/lmc-eu/spirit-design-system/commit/83702bc))
- **web-twig:** Remove inverted variant from Button and ButtonLink [#DS-1445](https://github.com/lmc-eu/spirit-design-system/issues/DS-1445) ([21708e8](https://github.com/lmc-eu/spirit-design-system/commit/21708e8))
- **web-twig:** Remove isUnderlined prop from Link component ([4d3fd03](https://github.com/lmc-eu/spirit-design-system/commit/4d3fd03)), closes [#DS-1509](https://github.com/lmc-eu/spirit-design-system/issues/DS-1509)
- **web-twig:** Rename `inverted` variant of `Toast` to `neutral` [#DS-1446](https://github.com/lmc-eu/spirit-design-system/issues/DS-1446) ([9ef6fb9](https://github.com/lmc-eu/spirit-design-system/commit/9ef6fb9))
- **web-twig:** Switch `Header` component to v3 design tokens [#DS-1453](https://github.com/lmc-eu/spirit-design-system/issues/DS-1453) ([aa9c549](https://github.com/lmc-eu/spirit-design-system/commit/aa9c549))
- **web-twig:** Switch Link, Heading and Text to v3 design tokens [#DS-1451](https://github.com/lmc-eu/spirit-design-system/issues/DS-1451) ([fd7eca2](https://github.com/lmc-eu/spirit-design-system/commit/fd7eca2))
- **web-twig:** Toast JS Plugin docs updated ([f5ad8a7](https://github.com/lmc-eu/spirit-design-system/commit/f5ad8a7)), closes [#DS-1509](https://github.com/lmc-eu/spirit-design-system/issues/DS-1509)

### Documentation

- **web-react,web-twig:** Use new spacing tokens values in ScrollView [#DS-1451](https://github.com/lmc-eu/spirit-design-system/issues/DS-1451) ([1aec1c9](https://github.com/lmc-eu/spirit-design-system/commit/1aec1c9))
- **web-react,web-twig:** Use new spacing tokens values in Tooltip [#DS-1451](https://github.com/lmc-eu/spirit-design-system/issues/DS-1451) ([5481a20](https://github.com/lmc-eu/spirit-design-system/commit/5481a20))
- **web-twig:** Redesign the demo app [#DS-1479](https://github.com/lmc-eu/spirit-design-system/issues/DS-1479) ([18f7fe0](https://github.com/lmc-eu/spirit-design-system/commit/18f7fe0))
- **web,web-react,web-twig:** Switch Grid spacing tokens to v3 structure ([7cd1186](https://github.com/lmc-eu/spirit-design-system/commit/7cd1186))
- **web,web-react,web-twig:** Switch to v3 spacings in Tabs [#DS-1444](https://github.com/lmc-eu/spirit-design-system/issues/DS-1444) ([9c2603e](https://github.com/lmc-eu/spirit-design-system/commit/9c2603e))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="3.4.1"></a>

## [3.4.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@3.4.0...@lmc-eu/spirit-web-twig@3.4.1) (2024-10-14)

### Bug Fixes

- **web-twig:** Disable password toggle on TextField [#DS-1478](https://github.com/lmc-eu/spirit-design-system/issues/DS-1478) ([7aac16d](https://github.com/lmc-eu/spirit-design-system/commit/7aac16d))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="3.4.0"></a>

# [3.4.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@3.3.0...@lmc-eu/spirit-web-twig@3.4.0) (2024-09-09)

### Bug Fixes

- **web-twig:** Add unintentionally removed content of the composer.json ([88fbe39](https://github.com/lmc-eu/spirit-design-system/commit/88fbe39))
- **web-twig:** Use `docker compose` instead of removed `docker-compose` ([b65cab4](https://github.com/lmc-eu/spirit-design-system/commit/b65cab4))

### Documentation

- **web-twig:** Make all code block snippets use Twig syntax ([8704587](https://github.com/lmc-eu/spirit-design-system/commit/8704587))
- **web-twig:** Remove misplaced quotes from Toast Collapsible docs [#DS-1420](https://github.com/lmc-eu/spirit-design-system/issues/DS-1420) ([f99e83d](https://github.com/lmc-eu/spirit-design-system/commit/f99e83d))

### Features

- **web-twig:** Add `spacing` property to `Grid` [#DS-1388](https://github.com/lmc-eu/spirit-design-system/issues/DS-1388) ([7cadf6f](https://github.com/lmc-eu/spirit-design-system/commit/7cadf6f))
- **web-twig:** Add alignmentX and alignmentY prop to Grid component [#DS-1414](https://github.com/lmc-eu/spirit-design-system/issues/DS-1414) ([cb37679](https://github.com/lmc-eu/spirit-design-system/commit/cb37679))
- **web-twig:** Add spacing property to Tabs component [#DS-1315](https://github.com/lmc-eu/spirit-design-system/issues/DS-1315) ([f159ab0](https://github.com/lmc-eu/spirit-design-system/commit/f159ab0))
- **web-twig:** Introduce new underlined prop to the Link component ([6424ab8](https://github.com/lmc-eu/spirit-design-system/commit/6424ab8)), closes [#DS-943](https://github.com/lmc-eu/spirit-design-system/issues/DS-943)

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="3.3.0"></a>

# [3.3.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@3.2.0...@lmc-eu/spirit-web-twig@3.3.0) (2024-07-24)

### Bug Fixes

- **web-react:** Tooltip - fix reported bugs ([f0d30cf](https://github.com/lmc-eu/spirit-design-system/commit/f0d30cf))

### Code Refactoring

- **demo:** Switch from `docs-Section` to `UNSTABLE_Section` component ([44cfab9](https://github.com/lmc-eu/spirit-design-system/commit/44cfab9))

### Documentation

- Change relative path to absolute path in md [#DS-1364](https://github.com/lmc-eu/spirit-design-system/issues/DS-1364) ([ebd2b3f](https://github.com/lmc-eu/spirit-design-system/commit/ebd2b3f))

### Features

- **web-twig:** Introduce Divider component [#DS-1391](https://github.com/lmc-eu/spirit-design-system/issues/DS-1391) ([f2a6b10](https://github.com/lmc-eu/spirit-design-system/commit/f2a6b10))
- **web-twig:** ModalHeader hide close button prop DS-1063 ([4ffd63d](https://github.com/lmc-eu/spirit-design-system/commit/4ffd63d))

### Tests

- **e2e:** Create test for opened Modal components ([305b252](https://github.com/lmc-eu/spirit-design-system/commit/305b252))
- **web-twig:** Fix & Enable Tooltip visual tests ([d9036d9](https://github.com/lmc-eu/spirit-design-system/commit/d9036d9))
- **web-twig:** Update snapshots with new icons ([82118e9](https://github.com/lmc-eu/spirit-design-system/commit/82118e9))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="3.2.0"></a>

# [3.2.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@3.1.0...@lmc-eu/spirit-web-twig@3.2.0) (2024-06-26)

### Bug Fixes

- **web:** Id of Checkbox component indeterminate demo ([84ec8e8](https://github.com/lmc-eu/spirit-design-system/commit/84ec8e8))

### Chores

- **web-twig:** Add lint scripts to check composer.json format ([a08d113](https://github.com/lmc-eu/spirit-design-system/commit/a08d113))
- **web-twig:** Fix makefile comment to not be displayed in help message ([7a0f904](https://github.com/lmc-eu/spirit-design-system/commit/7a0f904))

### Code Refactoring

- **web-twig:** Change ID naming to kebab-case ([0968939](https://github.com/lmc-eu/spirit-design-system/commit/0968939))
- **web-twig:** Rename unstable Divider to fix case insensitive problem ([f5c2684](https://github.com/lmc-eu/spirit-design-system/commit/f5c2684))
- **web-twig:** Update UNSTABLE_EmptyState according to design [#DS-1311](https://github.com/lmc-eu/spirit-design-system/issues/DS-1311) ([09aa447](https://github.com/lmc-eu/spirit-design-system/commit/09aa447))
- **web-twig:** Upgrade lmc/twigx-bundle to allow `unstable` prefix in file name ([5a9b97e](https://github.com/lmc-eu/spirit-design-system/commit/5a9b97e))

### Documentation

- **web-twig:** Add documentation and demo for ActionLayout component [#DS-1310](https://github.com/lmc-eu/spirit-design-system/issues/DS-1310) ([0d99a64](https://github.com/lmc-eu/spirit-design-system/commit/0d99a64))
- **web-twig:** Add documentation and demo for EmptyState component [#DS-1310](https://github.com/lmc-eu/spirit-design-system/issues/DS-1310) ([16329b1](https://github.com/lmc-eu/spirit-design-system/commit/16329b1))
- **web, web-react:** Emphasize the UNSTABLE component warning ([3c0f2e1](https://github.com/lmc-eu/spirit-design-system/commit/3c0f2e1))

### Features

- **web-twig:** Add Snapshot tests to Divider [#DS-1304](https://github.com/lmc-eu/spirit-design-system/issues/DS-1304) ([d6b7644](https://github.com/lmc-eu/spirit-design-system/commit/d6b7644))
- **web-twig:** Introduce ActionLayout component [#DS-1311](https://github.com/lmc-eu/spirit-design-system/issues/DS-1311) ([a8fe85d](https://github.com/lmc-eu/spirit-design-system/commit/a8fe85d))
- **web-twig:** Introduce unstable_EmptyState component [#DS-1308](https://github.com/lmc-eu/spirit-design-system/issues/DS-1308) ([675d12d](https://github.com/lmc-eu/spirit-design-system/commit/675d12d))

### Styles

- **web-twig:** Format Divider component test ([17bc62f](https://github.com/lmc-eu/spirit-design-system/commit/17bc62f))
- **web-twig:** Update to latest version of Alma Career Czechia PHP coding style ([380aa38](https://github.com/lmc-eu/spirit-design-system/commit/380aa38))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="3.1.0"></a>

# [3.1.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@3.0.0...@lmc-eu/spirit-web-twig@3.1.0) (2024-06-12)

### Bug Fixes

- **web-twig:** Make ValidationText and HelperText ID optional [#DS-1336](https://github.com/lmc-eu/spirit-design-system/issues/DS-1336) ([0e2feea](https://github.com/lmc-eu/spirit-design-system/commit/0e2feea))

### Features

- **web-twig:** Introduce UNSTABLE_Divider component [#DS-1302](https://github.com/lmc-eu/spirit-design-system/issues/DS-1302) ([0f2da6d](https://github.com/lmc-eu/spirit-design-system/commit/0f2da6d))

### Styles

- **repo:** Reformat docs using Prettier v3 ([670757d](https://github.com/lmc-eu/spirit-design-system/commit/670757d))
- **repo:** Replace unicode "heavy check mark" with "check mark" ([32f2d76](https://github.com/lmc-eu/spirit-design-system/commit/32f2d76))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="3.0.0"></a>

# [3.0.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.16.0...@lmc-eu/spirit-web-twig@3.0.0) (2024-06-10)

### BREAKING CHANGES

- **web-twig:** Add mandatory id prop for Dropdown component [#DS-1190](https://github.com/lmc-eu/spirit-design-system/issues/DS-1190) ([c31b566](https://github.com/lmc-eu/spirit-design-system/commit/c31b566))
- **web-twig:** Drop support for PHP 7.4 ([124bf0d](https://github.com/lmc-eu/spirit-design-system/commit/124bf0d)), closes [#DS-1212](https://github.com/lmc-eu/spirit-design-system/issues/DS-1212)
- **web-twig:** Id prop is required for all Form components [#DS-885](https://github.com/lmc-eu/spirit-design-system/issues/DS-885) ([c07a72c](https://github.com/lmc-eu/spirit-design-system/commit/c07a72c))
- **web-twig:** Make TooltipPopover hidden by default ([90687a0](https://github.com/lmc-eu/spirit-design-system/commit/90687a0))
- **web-twig:** Remove `HeaderDesktopActions` `color` prop in favor of `isAtEnd` [#DS-1059](https://github.com/lmc-eu/spirit-design-system/issues/DS-1059) ([1c57fc1](https://github.com/lmc-eu/spirit-design-system/commit/1c57fc1))
- **web-twig:** Remove class and style from abstract Header components [#DS-920](https://github.com/lmc-eu/spirit-design-system/issues/DS-920) ([ab43160](https://github.com/lmc-eu/spirit-design-system/commit/ab43160))
- **web-twig:** Remove dependency twig/twig for v1 ([a27f856](https://github.com/lmc-eu/spirit-design-system/commit/a27f856))
- **web-twig:** Remove deprecated warning icon for the danger color on Alert [#DS-1177](https://github.com/lmc-eu/spirit-design-system/issues/DS-1177) ([fd62930](https://github.com/lmc-eu/spirit-design-system/commit/fd62930))
- **web-twig:** Remove Dropdown and Tooltip non-flow-relative placements [#DS-1138](https://github.com/lmc-eu/spirit-design-system/issues/DS-1138) ([1f5a703](https://github.com/lmc-eu/spirit-design-system/commit/1f5a703))
- **web-twig:** Remove feature flag for the uniform `Modal` variant [#DS-1181](https://github.com/lmc-eu/spirit-design-system/issues/DS-1181) ([3389643](https://github.com/lmc-eu/spirit-design-system/commit/3389643))
- **web-twig:** Remove Grid `tablet` and `desktop` props [#DS-1068](https://github.com/lmc-eu/spirit-design-system/issues/DS-1068) ([71510f0](https://github.com/lmc-eu/spirit-design-system/commit/71510f0))
- **web-twig:** Remove GridSpan component [#DS-1244](https://github.com/lmc-eu/spirit-design-system/issues/DS-1244) ([e607de8](https://github.com/lmc-eu/spirit-design-system/commit/e607de8))
- **web-twig:** Rename Dropdown components [#DS-1248](https://github.com/lmc-eu/spirit-design-system/issues/DS-1248) ([64275f9](https://github.com/lmc-eu/spirit-design-system/commit/64275f9))
- **web-twig:** Rename height and maxHeight ModalDialog props and enhance them [#DS-1134](https://github.com/lmc-eu/spirit-design-system/issues/DS-1134) ([bc6bb25](https://github.com/lmc-eu/spirit-design-system/commit/bc6bb25))
- **web-twig:** Rename TabLink target prop to targetPaneId [#DS-1096](https://github.com/lmc-eu/spirit-design-system/issues/DS-1096) ([4ff64fd](https://github.com/lmc-eu/spirit-design-system/commit/4ff64fd))
- **web-twig:** Set isExpandedOnMobile in ModalDialog to false by default [#DS-1201](https://github.com/lmc-eu/spirit-design-system/issues/DS-1201) ([6868914](https://github.com/lmc-eu/spirit-design-system/commit/6868914))
- **web-twig:** The alert role has been removed for Alert component [#DS-1175](https://github.com/lmc-eu/spirit-design-system/issues/DS-1175) ([3ae0524](https://github.com/lmc-eu/spirit-design-system/commit/3ae0524))
- **web-twig:** Tooltip className changes ([b9ee11c](https://github.com/lmc-eu/spirit-design-system/commit/b9ee11c))
- **web-twig:** Tooltip plugin support only TooltipFloatingUI ([215dd2c](https://github.com/lmc-eu/spirit-design-system/commit/215dd2c))
- **web-twig:** Turn off scrolling inside ModalDialog by default [#DS-1184](https://github.com/lmc-eu/spirit-design-system/issues/DS-1184) ([3957242](https://github.com/lmc-eu/spirit-design-system/commit/3957242))

### Documentation

- **repo:** Introduce new Migration Guide structure and prepare WIP guides for new versions [#DS-1218](https://github.com/lmc-eu/spirit-design-system/issues/DS-1218) ([63ab3f1](https://github.com/lmc-eu/spirit-design-system/commit/63ab3f1))
- **web-twig:** Document correctly when the goBackTitle prop is required in Breadcrumbs [#DS-921](https://github.com/lmc-eu/spirit-design-system/issues/DS-921) ([30cbe8f](https://github.com/lmc-eu/spirit-design-system/commit/30cbe8f))
- **web-twig:** Remove Dropdown Enhance shadow section [#DS-1067](https://github.com/lmc-eu/spirit-design-system/issues/DS-1067) ([174402e](https://github.com/lmc-eu/spirit-design-system/commit/174402e))
- **web-twig:** Remove feature class for bordered Alert [#DS-1230](https://github.com/lmc-eu/spirit-design-system/issues/DS-1230) ([6ce45d7](https://github.com/lmc-eu/spirit-design-system/commit/6ce45d7))
- **web-twig:** Remove feature flag for controlled placement of `Tooltip` [#DS-1182](https://github.com/lmc-eu/spirit-design-system/issues/DS-1182) ([3f2f84b](https://github.com/lmc-eu/spirit-design-system/commit/3f2f84b))

### Features

- **web-twig:** Use data placement in Tooltip [#DS-1183](https://github.com/lmc-eu/spirit-design-system/issues/DS-1183) ([0c589dd](https://github.com/lmc-eu/spirit-design-system/commit/0c589dd))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.16.0"></a>

# [2.16.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.15.0...@lmc-eu/spirit-web-twig@2.16.0) (2024-06-03)

### Bug Fixes

- **web-twig:** FileUploader `isRequired` prop only marks label ([7a940b3](https://github.com/lmc-eu/spirit-design-system/commit/7a940b3))

### Chores

- **web-twig:** Fix dependency link paths for Docker development ([ea1b9e8](https://github.com/lmc-eu/spirit-design-system/commit/ea1b9e8))

### Features

- **web-react:** Add Message and Link for ToastBar [#DS-1213](https://github.com/lmc-eu/spirit-design-system/issues/DS-1213) ([e60fabb](https://github.com/lmc-eu/spirit-design-system/commit/e60fabb))
- **web-twig:** Add autoclose feature to Toast component ([17a54b1](https://github.com/lmc-eu/spirit-design-system/commit/17a54b1))
- **web-twig:** Add Message and Link for ToastBar [#DS-1213](https://github.com/lmc-eu/spirit-design-system/issues/DS-1213) ([d0f9663](https://github.com/lmc-eu/spirit-design-system/commit/d0f9663))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.15.0"></a>

# [2.15.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.14.1...@lmc-eu/spirit-web-twig@2.15.0) (2024-05-20)

### Bug Fixes

- **web-twig:** Remove extra quotes causing invalid HTML of `Checkbox` ([69c2d84](https://github.com/lmc-eu/spirit-design-system/commit/69c2d84)), closes [#1343](https://github.com/lmc-eu/spirit-design-system/issues/1343)

### Features

- **web-twig:** Allow Icon to render as a Symbol tag [#DS-1223](https://github.com/lmc-eu/spirit-design-system/issues/DS-1223) ([e6079a8](https://github.com/lmc-eu/spirit-design-system/commit/e6079a8))
- **web-twig:** Introduce bulk `Toast` queue clearing [#DS-1222](https://github.com/lmc-eu/spirit-design-system/issues/DS-1222) ([959650a](https://github.com/lmc-eu/spirit-design-system/commit/959650a))
- **web-twig:** Make Toast work with dynamic collapsible queue and dynamic ToastBars [#DS-1223](https://github.com/lmc-eu/spirit-design-system/issues/DS-1223) ([d206907](https://github.com/lmc-eu/spirit-design-system/commit/d206907))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.14.1"></a>

## [2.14.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.14.0...@lmc-eu/spirit-web-twig@2.14.1) (2024-04-24)

### Bug Fixes

- **web-twig:** `Dropdown` can now be placed inside a non-scrollable `Modal` [#DS-939](https://github.com/lmc-eu/spirit-design-system/issues/DS-939) ([a4e569c](https://github.com/lmc-eu/spirit-design-system/commit/a4e569c))
- **web-twig:** Don't render the `name` attribute of `Checkbox` when empty ([cfece12](https://github.com/lmc-eu/spirit-design-system/commit/cfece12))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.14.0"></a>

# [2.14.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.13.0...@lmc-eu/spirit-web-twig@2.14.0) (2024-04-11)

### Documentation

- **repo:** Rebrand to Alma Career ([4a9a28b](https://github.com/lmc-eu/spirit-design-system/commit/4a9a28b))
- **web-twig:** List Deprecations in the web twig package [#DS-1148](https://github.com/lmc-eu/spirit-design-system/issues/DS-1148) ([eb8d07f](https://github.com/lmc-eu/spirit-design-system/commit/eb8d07f))
- **web-twig:** Set danger icons in Alert component ([caeff6f](https://github.com/lmc-eu/spirit-design-system/commit/caeff6f))

### Features

- **web-twig:** Deprecate Grid Span in favor of Grid Item [#DS-1041](https://github.com/lmc-eu/spirit-design-system/issues/DS-1041) ([d6a1c4e](https://github.com/lmc-eu/spirit-design-system/commit/d6a1c4e))
- **web-twig:** Introduce the `Toast` component [#DS-1115](https://github.com/lmc-eu/spirit-design-system/issues/DS-1115) ([ee9789d](https://github.com/lmc-eu/spirit-design-system/commit/ee9789d))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.13.0"></a>

# [2.13.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.12.1...@lmc-eu/spirit-web-twig@2.13.0) (2024-03-11)

### Documentation

- **web-twig:** Fix default placement in Dropdown demo ([9f17156](https://github.com/lmc-eu/spirit-design-system/commit/9f17156))
- **web-twig:** Introducing deprecations list ([6a0c065](https://github.com/lmc-eu/spirit-design-system/commit/6a0c065)), closes [#DS-1148](https://github.com/lmc-eu/spirit-design-system/issues/DS-1148)
- **web-twig:** Show Bordered Alert Feature Flag in Demo [#DS-1156](https://github.com/lmc-eu/spirit-design-system/issues/DS-1156) ([a6edcfe](https://github.com/lmc-eu/spirit-design-system/commit/a6edcfe))
- **web-twig:** Unify the `Dropdown` demo according to its `web` package counterpart ([f25bfe0](https://github.com/lmc-eu/spirit-design-system/commit/f25bfe0))

### Features

- **web-twig:** `Stack` no longer requires the `hasSpacing` prop to apply custom `spacing` [#DS-1133](https://github.com/lmc-eu/spirit-design-system/issues/DS-1133) ([c75af1d](https://github.com/lmc-eu/spirit-design-system/commit/c75af1d))
- **web-twig:** Deprecate icon for `danger` color in Alert component ([4241478](https://github.com/lmc-eu/spirit-design-system/commit/4241478)), closes [#DS-1156](https://github.com/lmc-eu/spirit-design-system/issues/DS-1156)

### Tests

- **web-twig:** Update snapshots according to the modified icons ([4a3df20](https://github.com/lmc-eu/spirit-design-system/commit/4a3df20))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.12.1"></a>

## [2.12.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.12.0...@lmc-eu/spirit-web-twig@2.12.1) (2024-02-23)

### Bug Fixes

- **web-twig:** Tooltip docs changes ([18c3650](https://github.com/lmc-eu/spirit-design-system/commit/18c3650))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.12.0"></a>

# [2.12.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.11.0...@lmc-eu/spirit-web-twig@2.12.0) (2024-02-20)

### Bug Fixes

- **web-twig:** Enable rendering Symfony Forms fields inside `FieldGroup` ([59fc8a2](https://github.com/lmc-eu/spirit-design-system/commit/59fc8a2))

### Documentation

- **web-react, web-twig:** Add `isFluid` to the API documentations of `FieldGroup` ([7e69912](https://github.com/lmc-eu/spirit-design-system/commit/7e69912))
- **web-twig:** Add demo with Tooltip on Icon cmp ([2f13597](https://github.com/lmc-eu/spirit-design-system/commit/2f13597))
- **web:** Fix Sass implementation notes ([24054e1](https://github.com/lmc-eu/spirit-design-system/commit/24054e1))

### Features

- **web-react:** Deprecate non-flow-relative placements in `Dropdown` [#DS-1132](https://github.com/lmc-eu/spirit-design-system/issues/DS-1132) ([51da754](https://github.com/lmc-eu/spirit-design-system/commit/51da754))
- **web-twig:** Deprecate non-flow-relative placements in `Dropdown` [#DS-1132](https://github.com/lmc-eu/spirit-design-system/issues/DS-1132) ([8e171ed](https://github.com/lmc-eu/spirit-design-system/commit/8e171ed))
- **web-twig:** Tooltip can be opened by hover ([eab479c](https://github.com/lmc-eu/spirit-design-system/commit/eab479c))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.11.0"></a>

# [2.11.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.10.0...@lmc-eu/spirit-web-twig@2.11.0) (2024-02-07)

### Documentation

- **web-twig:** Improve additional API options info [#DS-1099](https://github.com/lmc-eu/spirit-design-system/issues/DS-1099) ([cd38d9a](https://github.com/lmc-eu/spirit-design-system/commit/cd38d9a))

### Features

- **web-twig:** Introduce option to disable scrolling inside Modal [#DS-732](https://github.com/lmc-eu/spirit-design-system/issues/DS-732) ([c0515b5](https://github.com/lmc-eu/spirit-design-system/commit/c0515b5))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.10.0"></a>

# [2.10.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.9.0...@lmc-eu/spirit-web-twig@2.10.0) (2024-01-30)

### Chores

- **web,web-twig,web-react:** Unify demo differences in components [#DS-660](https://github.com/lmc-eu/spirit-design-system/issues/DS-660) ([db7426e](https://github.com/lmc-eu/spirit-design-system/commit/db7426e))

### Code Refactoring

- **web-twig, demo:** Move Tooltip demo scripts to the demo app ([9fc6ae0](https://github.com/lmc-eu/spirit-design-system/commit/9fc6ae0))

### Documentation

- **web-twig:** Use spacing style props in all components [#DS-1109](https://github.com/lmc-eu/spirit-design-system/issues/DS-1109) ([3692198](https://github.com/lmc-eu/spirit-design-system/commit/3692198))
- **web, web-twig, web-react:** Clarify that `Modal` can be stacked, but not nested in the DOM ([16f3b70](https://github.com/lmc-eu/spirit-design-system/commit/16f3b70))

### Features

- **web-react:** Introduce vertical alignment options for `Modal` [#DS-940](https://github.com/lmc-eu/spirit-design-system/issues/DS-940) ([67e2594](https://github.com/lmc-eu/spirit-design-system/commit/67e2594))
- **web-twig:** Introduce advanced Tooltip usage supported by FloatingUI ([91eaec0](https://github.com/lmc-eu/spirit-design-system/commit/91eaec0)), closes [#DS-1087](https://github.com/lmc-eu/spirit-design-system/issues/DS-1087)
- **web-twig:** Introduce spacing style props to all components [#DS-1109](https://github.com/lmc-eu/spirit-design-system/issues/DS-1109) ([78a697e](https://github.com/lmc-eu/spirit-design-system/commit/78a697e))
- **web-twig:** Introduce vertical alignment options for `Modal` [#DS-940](https://github.com/lmc-eu/spirit-design-system/issues/DS-940) ([d1da586](https://github.com/lmc-eu/spirit-design-system/commit/d1da586))

### Reverts

- **web-twig:** Set Tooltip to use modifier class instead of data attr to set the placement inside ([0fa635a](https://github.com/lmc-eu/spirit-design-system/commit/0fa635a))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.9.0"></a>

# [2.9.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.8.0...@lmc-eu/spirit-web-twig@2.9.0) (2024-01-17)

### Bug Fixes

- **web-twig:** Do not render CSS property in the `GridItem` style attribute if the value is empty ([146a21c](https://github.com/lmc-eu/spirit-design-system/commit/146a21c))

### Features

- **web-react:** Introduce optional uniform appearance of `Modal` [#DS-1091](https://github.com/lmc-eu/spirit-design-system/issues/DS-1091) ([531a9d9](https://github.com/lmc-eu/spirit-design-system/commit/531a9d9))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.8.0"></a>

# [2.8.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.7.0...@lmc-eu/spirit-web-twig@2.8.0) (2024-01-12)

### Chores

- **demo:** Link packages to missing modules ([c255f8c](https://github.com/lmc-eu/spirit-design-system/commit/c255f8c))

### Documentation

- **web-twig:** Update Dropdown demo with Item usage [#DS-956](https://github.com/lmc-eu/spirit-design-system/issues/DS-956) ([3b9d464](https://github.com/lmc-eu/spirit-design-system/commit/3b9d464))
- **web-twig:** Use dash instead of underscore for `id` and `name` attribute values in `Modal` docs ([05b5803](https://github.com/lmc-eu/spirit-design-system/commit/05b5803))

### Features

- **web-twig:** Introduce custom Stack spacing [#DS-1079](https://github.com/lmc-eu/spirit-design-system/issues/DS-1079) ([cb55f5b](https://github.com/lmc-eu/spirit-design-system/commit/cb55f5b))
- **web-twig:** Introduce Full Floating UI demo to Tooltip, update internal implementation [#DS-1084](https://github.com/lmc-eu/spirit-design-system/issues/DS-1084) ([08822a4](https://github.com/lmc-eu/spirit-design-system/commit/08822a4))
- **web-twig:** Introduce optional uniform appearance of `Modal` ([c5ff3bc](https://github.com/lmc-eu/spirit-design-system/commit/c5ff3bc))

### Styles

- **web-twig:** Fix PHPStan issue with adding SimpleXMLElement ([b8a89f9](https://github.com/lmc-eu/spirit-design-system/commit/b8a89f9))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.7.0"></a>

# [2.7.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.6.0...@lmc-eu/spirit-web-twig@2.7.0) (2023-12-05)

### Bug Fixes

- **web-twig:** Do not render class in the `style` attribute of the `GridItem` ([38bcd4e](https://github.com/lmc-eu/spirit-design-system/commit/38bcd4e))
- **web-twig:** Do not render class in the style attribute of the `ModalDialog` ([4adbc16](https://github.com/lmc-eu/spirit-design-system/commit/4adbc16))

### Documentation

- **web-react, web-twig:** Switch responsive Grid props to the cols object ([18f3df9](https://github.com/lmc-eu/spirit-design-system/commit/18f3df9))
- **web-twig:** Better document void attributes like `novalidate` ([5562ddc](https://github.com/lmc-eu/spirit-design-system/commit/5562ddc))

### Features

- **web-twig:** Allow object in Grid prop cols, deprecate desktop and tablet [#DS-995](https://github.com/lmc-eu/spirit-design-system/issues/DS-995) ([7d9d4f0](https://github.com/lmc-eu/spirit-design-system/commit/7d9d4f0))
- **web-twig:** Introduce Item component [#DS-1049](https://github.com/lmc-eu/spirit-design-system/issues/DS-1049) ([02c0f7c](https://github.com/lmc-eu/spirit-design-system/commit/02c0f7c))

### Styles

- **web-twig:** Unify usage of space between compound braces of props ([40b99a0](https://github.com/lmc-eu/spirit-design-system/commit/40b99a0))

### Tests

- **web-twig:** Remove Grid layout prop test - the prop is no longer there ([8dd95de](https://github.com/lmc-eu/spirit-design-system/commit/8dd95de))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.6.0"></a>

# [2.6.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.5.0...@lmc-eu/spirit-web-twig@2.6.0) (2023-11-15)

### Bug Fixes

- **web, web-twig:** FileUploader changed selectors in JS plugin ([967d5a4](https://github.com/lmc-eu/spirit-design-system/commit/967d5a4))

### Code Refactoring

- **web-twig:** FileUploader imageObjectFit data attr changed to style ([37c34c1](https://github.com/lmc-eu/spirit-design-system/commit/37c34c1))

### Documentation

- **web-twig:** FileUploaderAttachment documentation update ([b80a155](https://github.com/lmc-eu/spirit-design-system/commit/b80a155)), closes [#DS-1036](https://github.com/lmc-eu/spirit-design-system/issues/DS-1036)
- **web-twig:** Put pure CSS examples of `Tooltip` in line so they are usable in more viewport sizes ([1b7d8a4](https://github.com/lmc-eu/spirit-design-system/commit/1b7d8a4))
- **web-twig:** Showcase Dropdown enhanced shadow Feature flag [#DS-963](https://github.com/lmc-eu/spirit-design-system/issues/DS-963) ([92503c0](https://github.com/lmc-eu/spirit-design-system/commit/92503c0))
- **web-twig:** Showcase placement valuse on Tooltip demo ([6d6c600](https://github.com/lmc-eu/spirit-design-system/commit/6d6c600)), closes [#DS-923](https://github.com/lmc-eu/spirit-design-system/issues/DS-923)
- **web, web-twig, web-react:** Document ModalHeader and ModalFooter usage recommendations [#DS-1033](https://github.com/lmc-eu/spirit-design-system/issues/DS-1033) ([403cc0b](https://github.com/lmc-eu/spirit-design-system/commit/403cc0b))
- **web,web-twig,web-react:** Add interactive demo of `Dropdown` placements [#DS-1037](https://github.com/lmc-eu/spirit-design-system/issues/DS-1037) ([deb054c](https://github.com/lmc-eu/spirit-design-system/commit/deb054c))
- **web,web-twig,web-react:** Make use of new `GridItem` component in `Tooltip` placement examples ([81d9952](https://github.com/lmc-eu/spirit-design-system/commit/81d9952))

### Features

- **web-twig:** Allow combining links and buttons in `HeaderDesktopActions` ([8144702](https://github.com/lmc-eu/spirit-design-system/commit/8144702))

### Tests

- **web-twig:** Add tests for imageObjectFit property ([495c4d5](https://github.com/lmc-eu/spirit-design-system/commit/495c4d5))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.5.0"></a>

# [2.5.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.4.0...@lmc-eu/spirit-web-twig@2.5.0) (2023-11-02)

### Features

- **web-twig:** Attachment image preview object fit [#DS-1005](https://github.com/lmc-eu/spirit-design-system/issues/DS-1005) ([e54e840](https://github.com/lmc-eu/spirit-design-system/commit/e54e840))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.4.0"></a>

# [2.4.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.3.1...@lmc-eu/spirit-web-twig@2.4.0) (2023-10-25)

### Bug Fixes

- **web-twig:** Fix pass custom classnames to the `Spinner` component ([5ad7dc9](https://github.com/lmc-eu/spirit-design-system/commit/5ad7dc9))
- **web-twig:** Use correct brackets when setting prop to false in Modal ([7352b96](https://github.com/lmc-eu/spirit-design-system/commit/7352b96))
- **web-twig:** Use embed in DocsSection to fix falling tests with unclosed block ([96f3c2e](https://github.com/lmc-eu/spirit-design-system/commit/96f3c2e))

### Documentation

- **web-twig:** Explain abbreviation in the Accessibility section ([c8b4d97](https://github.com/lmc-eu/spirit-design-system/commit/c8b4d97))
- **web-twig:** Unified Alert copies [#DS-979](https://github.com/lmc-eu/spirit-design-system/issues/DS-979) ([9c9df69](https://github.com/lmc-eu/spirit-design-system/commit/9c9df69))
- **web, web-react, web-twig:** Dealing with text truncate in Breadcrumb ([d15fd1b](https://github.com/lmc-eu/spirit-design-system/commit/d15fd1b)), closes [#DS-960](https://github.com/lmc-eu/spirit-design-system/issues/DS-960)

### Features

- **web-twig:** Add disabled backdrop click option to Modal component ([ffe1835](https://github.com/lmc-eu/spirit-design-system/commit/ffe1835))
- **web-twig:** FileUploader - Support for crop image [#DS-954](https://github.com/lmc-eu/spirit-design-system/issues/DS-954) ([96559cf](https://github.com/lmc-eu/spirit-design-system/commit/96559cf))
- **web-twig:** Introduce BreadcrumbsItem component ([3c9cf8c](https://github.com/lmc-eu/spirit-design-system/commit/3c9cf8c)), closes [#DS-835](https://github.com/lmc-eu/spirit-design-system/issues/DS-835)
- **web-twig:** Introduce Grid Item component [#DS-961](https://github.com/lmc-eu/spirit-design-system/issues/DS-961) ([d3fb1ef](https://github.com/lmc-eu/spirit-design-system/commit/d3fb1ef))
- **web-twig:** Make BreadcrumbsItem href optional [#DS-957](https://github.com/lmc-eu/spirit-design-system/issues/DS-957) ([439577e](https://github.com/lmc-eu/spirit-design-system/commit/439577e))
- **web-twig:** Use the new Placement dictionary in `Dropdown` and `Tooltip` [#DS-923](https://github.com/lmc-eu/spirit-design-system/issues/DS-923) ([eae000d](https://github.com/lmc-eu/spirit-design-system/commit/eae000d))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.3.1"></a>

## [2.3.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.3.0...@lmc-eu/spirit-web-twig@2.3.1) (2023-09-26)

### Bug Fixes

- **web-twig:** Do not render `id` twice in the `HeaderDialog` ([9350c8a](https://github.com/lmc-eu/spirit-design-system/commit/9350c8a))
- **web-twig:** Icon in FileUploader when disabled ([f0b9619](https://github.com/lmc-eu/spirit-design-system/commit/f0b9619))
- **web,web-twig:** Fix `Button` flickering during spinner animation in Firefox ([f3cfd93](https://github.com/lmc-eu/spirit-design-system/commit/f3cfd93))

### Chores

- **web-twig:** Ignore tests and stories from exported package ([7205145](https://github.com/lmc-eu/spirit-design-system/commit/7205145)), closes [#DS-969](https://github.com/lmc-eu/spirit-design-system/issues/DS-969)

### Code Refactoring

- **web-twig:** Use `VisuallyHidden` component instead of className ([46a120a](https://github.com/lmc-eu/spirit-design-system/commit/46a120a)), closes [#DS-926](https://github.com/lmc-eu/spirit-design-system/issues/DS-926)
- **web-twig:** Use class name prefix for utilities and helpers ([4e1b5eb](https://github.com/lmc-eu/spirit-design-system/commit/4e1b5eb)), closes [#DS-926](https://github.com/lmc-eu/spirit-design-system/issues/DS-926)
- **web-twig:** Use demo package css instead of own ([b16595c](https://github.com/lmc-eu/spirit-design-system/commit/b16595c))

### Documentation

- **web-react, web-twig:** Add DocsStack component ([a52215d](https://github.com/lmc-eu/spirit-design-system/commit/a52215d))
- **web-twig:** Add Dropdown demo [#DS-895](https://github.com/lmc-eu/spirit-design-system/issues/DS-895) ([e987ea3](https://github.com/lmc-eu/spirit-design-system/commit/e987ea3))
- **web-twig:** Add FileUploader demo [#DS-896](https://github.com/lmc-eu/spirit-design-system/issues/DS-896) ([9b5432c](https://github.com/lmc-eu/spirit-design-system/commit/9b5432c))
- **web-twig:** Add Icons demo [#DS-900](https://github.com/lmc-eu/spirit-design-system/issues/DS-900) ([cce1910](https://github.com/lmc-eu/spirit-design-system/commit/cce1910))
- **web-twig:** Add Tooltip demo [#DS-914](https://github.com/lmc-eu/spirit-design-system/issues/DS-914) ([a84b9fb](https://github.com/lmc-eu/spirit-design-system/commit/a84b9fb))
- **web-twig:** Make stack inside `DocsSection` optional ([53fc021](https://github.com/lmc-eu/spirit-design-system/commit/53fc021))
- **web-twig:** Use new docs components in all demos ([d120c65](https://github.com/lmc-eu/spirit-design-system/commit/d120c65))
- **web, web-react, web-twig:** Unify `Modal` READMEs ([f126dca](https://github.com/lmc-eu/spirit-design-system/commit/f126dca))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.3.0"></a>

# [2.3.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.2.0...@lmc-eu/spirit-web-twig@2.3.0) (2023-09-06)

### Documentation

- **web-twig, web-react:** Improve `Modal` documentation regarding `ScrollView` and optional title ([f4a54ca](https://github.com/lmc-eu/spirit-design-system/commit/f4a54ca))
- **web-twig:** Add Breadcrumbs demo [#DS-981](https://github.com/lmc-eu/spirit-design-system/issues/DS-981) ([c7ae091](https://github.com/lmc-eu/spirit-design-system/commit/c7ae091))
- **web-twig:** Add Button demo [#DS-892](https://github.com/lmc-eu/spirit-design-system/issues/DS-892) ([b351ad0](https://github.com/lmc-eu/spirit-design-system/commit/b351ad0))
- **web-twig:** Introduce `DocsSection` and `DocsBox` components ([fcb97dc](https://github.com/lmc-eu/spirit-design-system/commit/fcb97dc))

### Features

- **web-twig:** Deprecate optional `goBackTitle` in Breadcrumbs ([b469abe](https://github.com/lmc-eu/spirit-design-system/commit/b469abe)), closes [#DS-834](https://github.com/lmc-eu/spirit-design-system/issues/DS-834)
- **web-twig:** Introduce VisuallyHidden component ([3122a4d](https://github.com/lmc-eu/spirit-design-system/commit/3122a4d))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.2.0"></a>

# [2.2.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.1.0...@lmc-eu/spirit-web-twig@2.2.0) (2023-08-23)

### Bug Fixes

- **web-twig:** Deprecate `class` prop in the `Header` abstract components ([1cea973](https://github.com/lmc-eu/spirit-design-system/commit/1cea973))
- **web-twig:** Fix condition to render `aria-labelledby` attribute in the Modal component ([70fb37b](https://github.com/lmc-eu/spirit-design-system/commit/70fb37b))
- **web:** Remove unused data attribute in Accordion [#DS-883](https://github.com/lmc-eu/spirit-design-system/issues/DS-883) ([fcfb261](https://github.com/lmc-eu/spirit-design-system/commit/fcfb261))

### Chores

- **web-twig:** Exclude **tests** directory from archive refs [#DS-635](https://github.com/lmc-eu/spirit-design-system/issues/DS-635) ([736c4b1](https://github.com/lmc-eu/spirit-design-system/commit/736c4b1))

### Code Refactoring

- **web-twig:** Mark the `id` prop in form fields as required starting from next major version ([28cfcf1](https://github.com/lmc-eu/spirit-design-system/commit/28cfcf1))
- **web-twig:** Use new `HelperText` component in all form fields ([6f284d3](https://github.com/lmc-eu/spirit-design-system/commit/6f284d3))

### Documentation

- **form-validations, web-react, web-twig:** Sort props in tables ([4d8fb15](https://github.com/lmc-eu/spirit-design-system/commit/4d8fb15))
- **form-validations, web, web-twig, web-react:** Unify unicode characters in API tables ([8c837eb](https://github.com/lmc-eu/spirit-design-system/commit/8c837eb))
- **web-react, web-twig:** Unify the syntax of enums in API tables ([f83e9ac](https://github.com/lmc-eu/spirit-design-system/commit/f83e9ac))
- **web-twig:** Default `icon` according to `color` variant in the `Alert` ([4d51643](https://github.com/lmc-eu/spirit-design-system/commit/4d51643))
- **web-twig:** Document all allowed HTML attributes in all components ([02b1dac](https://github.com/lmc-eu/spirit-design-system/commit/02b1dac))
- **web-twig:** Highlight and unify links to Web package JS plugin documentations [#DS-870](https://github.com/lmc-eu/spirit-design-system/issues/DS-870) ([92da34f](https://github.com/lmc-eu/spirit-design-system/commit/92da34f))
- **web-twig:** Introduce section about snapshot tests refs [#DS-636](https://github.com/lmc-eu/spirit-design-system/issues/DS-636) ([5fb0b63](https://github.com/lmc-eu/spirit-design-system/commit/5fb0b63))
- **web-twig:** Introduce showcase app localhost url ([4fdc03e](https://github.com/lmc-eu/spirit-design-system/commit/4fdc03e))
- **web-twig:** Unify API of the `autocomplete` and `label` props ([f514829](https://github.com/lmc-eu/spirit-design-system/commit/f514829))
- **web-twig:** Unify table comments in Docs ([840c6be](https://github.com/lmc-eu/spirit-design-system/commit/840c6be))
- **web-twig:** Unify the syntax of boolean props ([5ad6a98](https://github.com/lmc-eu/spirit-design-system/commit/5ad6a98))
- **web, web-twig:** Unify column names in API tables ([b33b8ff](https://github.com/lmc-eu/spirit-design-system/commit/b33b8ff))

### Features

- **web-twig:** Add support of image preview and edit button to FileUploaderAttachment [#DS-851](https://github.com/lmc-eu/spirit-design-system/issues/DS-851) ([401c399](https://github.com/lmc-eu/spirit-design-system/commit/401c399))
- **web-twig:** Document and test `Icon` props in the `Spinner` component ([14c4aef](https://github.com/lmc-eu/spirit-design-system/commit/14c4aef)), closes [#DS-759](https://github.com/lmc-eu/spirit-design-system/issues/DS-759)
- **web-twig:** Enable pass `formtarget` attribute to the `Button` ([b39befd](https://github.com/lmc-eu/spirit-design-system/commit/b39befd))
- **web-twig:** Introduce `FieldGroup` component ([74a4e01](https://github.com/lmc-eu/spirit-design-system/commit/74a4e01))
- **web-twig:** Introduce `HelperText` component ([d2ab6d1](https://github.com/lmc-eu/spirit-design-system/commit/d2ab6d1))
- **web-twig:** Introduce `id` prop in `ValidationText` component ([f8e5ee4](https://github.com/lmc-eu/spirit-design-system/commit/f8e5ee4))

### Tests

- **web-twig:** Colocate snapshot tests with components refs [#DS-635](https://github.com/lmc-eu/spirit-design-system/issues/DS-635) ([7530d7a](https://github.com/lmc-eu/spirit-design-system/commit/7530d7a))
- **web-twig:** Delete orphan snapshots ([c7f3f9e](https://github.com/lmc-eu/spirit-design-system/commit/c7f3f9e))
- **web-twig:** Use shorter snapshot file name refs [#DS-635](https://github.com/lmc-eu/spirit-design-system/issues/DS-635) ([8831ba7](https://github.com/lmc-eu/spirit-design-system/commit/8831ba7))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.1.0"></a>

# [2.1.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@2.0.0...@lmc-eu/spirit-web-twig@2.1.0) (2023-08-09)

### Bug Fixes

- **demo:** Use builded icons for web-twig demo refs [#DS-748](https://github.com/lmc-eu/spirit-design-system/issues/DS-748) ([17c2a2b](https://github.com/lmc-eu/spirit-design-system/commit/17c2a2b))

### Chores

- **demo:** Add command for trusting self-signed certificates ([cf0da2f](https://github.com/lmc-eu/spirit-design-system/commit/cf0da2f)), closes [#DS-743](https://github.com/lmc-eu/spirit-design-system/issues/DS-743)

### Documentation

- **web-twig:** Use command for packagist sync ([20ba79a](https://github.com/lmc-eu/spirit-design-system/commit/20ba79a))
- **web, web-react, web-twig:** Minor typo fix ([be40478](https://github.com/lmc-eu/spirit-design-system/commit/be40478))
- **web,web-twig:** Mark visual-only examples in `FileUploader` demo ([27b3533](https://github.com/lmc-eu/spirit-design-system/commit/27b3533))
- **web,web-twig:** Showcase the fluid variant of `Select` ([3486a99](https://github.com/lmc-eu/spirit-design-system/commit/3486a99))

### Features

- **web:** Extend `FileUploaderAttachment` with preview and custom actions slot ([768906f](https://github.com/lmc-eu/spirit-design-system/commit/768906f))

### Tests

- **twig:** Update snapshots with icons using `currentColor` ([40cb7ec](https://github.com/lmc-eu/spirit-design-system/commit/40cb7ec))
- **web-twig:** Update snapshots due to spirit-icons change ([3c62953](https://github.com/lmc-eu/spirit-design-system/commit/3c62953))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="2.0.0"></a>

# [2.0.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.34.1...@lmc-eu/spirit-web-twig@2.0.0) (2023-07-21)

### BREAKING CHANGES

- **web-twig:** Add `spirit` infix to data attr names in components [#DS-585](https://github.com/lmc-eu/spirit-design-system/issues/DS-585) ([9dd93ac](https://github.com/lmc-eu/spirit-design-system/commit/9dd93ac))
- **web-twig:** Remove `class` prop from all components [#DS-678](https://github.com/lmc-eu/spirit-design-system/issues/DS-678) ([11c6ee6](https://github.com/lmc-eu/spirit-design-system/commit/11c6ee6))
- **web-twig:** Remove `error` Validation State in favor of `danger` [#DS-677](https://github.com/lmc-eu/spirit-design-system/issues/DS-677) ([9887171](https://github.com/lmc-eu/spirit-design-system/commit/9887171))
- **web-twig:** Remove `isFullWidth` and `breakpoint` props from `Dropdown` [#DS-588](https://github.com/lmc-eu/spirit-design-system/issues/DS-588) ([edeabac](https://github.com/lmc-eu/spirit-design-system/commit/edeabac))
- **web-twig:** Remove `onClick` prop [#DS-686](https://github.com/lmc-eu/spirit-design-system/issues/DS-686) ([ab62f78](https://github.com/lmc-eu/spirit-design-system/commit/ab62f78))
- **web-twig:** Remove `size` prop from `Icon` in favor of `boxSize` [#DS-647](https://github.com/lmc-eu/spirit-design-system/issues/DS-647) ([f982ce9](https://github.com/lmc-eu/spirit-design-system/commit/f982ce9))
- **web-twig:** Remove `theme` prop and `default` color from `Tag` [#DS-648](https://github.com/lmc-eu/spirit-design-system/issues/DS-648) ([bf62242](https://github.com/lmc-eu/spirit-design-system/commit/bf62242))
- **web-twig:** Remove boolprop filter from Twig components [#DS-798](https://github.com/lmc-eu/spirit-design-system/issues/DS-798) ([981195b](https://github.com/lmc-eu/spirit-design-system/commit/981195b))
- **web-twig:** Remove data-toggle from TabLink component refs [#DS-840](https://github.com/lmc-eu/spirit-design-system/issues/DS-840) ([0d7df9b](https://github.com/lmc-eu/spirit-design-system/commit/0d7df9b)), closes [#935](https://github.com/lmc-eu/spirit-design-system/issues/935)
- **web-twig:** Remove deprecated `Header` component [#652](https://github.com/lmc-eu/spirit-design-system/issues/652) ([3044ce1](https://github.com/lmc-eu/spirit-design-system/commit/3044ce1)), closes [#935](https://github.com/lmc-eu/spirit-design-system/issues/935), [#935](https://github.com/lmc-eu/spirit-design-system/issues/935)
- **web-twig:** Remove modal body padding feature class [#DS-863](https://github.com/lmc-eu/spirit-design-system/issues/DS-863) ([933a956](https://github.com/lmc-eu/spirit-design-system/commit/933a956))
- **web-twig:** Remove old Modal and rename ModalComposed to Modal [#DS-616](https://github.com/lmc-eu/spirit-design-system/issues/DS-616) ([ee92622](https://github.com/lmc-eu/spirit-design-system/commit/ee92622))
- **web-twig:** Remove Twig `boolprop` filter and its extension [#DS-798](https://github.com/lmc-eu/spirit-design-system/issues/DS-798) ([f71a8b0](https://github.com/lmc-eu/spirit-design-system/commit/f71a8b0))
- **web-twig:** Rename `CheckboxField` component to `Checkbox` [#DS-522](https://github.com/lmc-eu/spirit-design-system/issues/DS-522) ([c24d9f6](https://github.com/lmc-eu/spirit-design-system/commit/c24d9f6))
- **web-twig:** Rename `RadioField` component to `Radio` [#DS-521](https://github.com/lmc-eu/spirit-design-system/issues/DS-521) ([cba5ec6](https://github.com/lmc-eu/spirit-design-system/commit/cba5ec6))
- **web-twig:** Rename message prop to validationText in Form Fields [#DS-676](https://github.com/lmc-eu/spirit-design-system/issues/DS-676) ([38c0620](https://github.com/lmc-eu/spirit-design-system/commit/38c0620))
- **web-twig:** Rename ScrollView `indicators` prop to `overflowDecorators` [#DS-825](https://github.com/lmc-eu/spirit-design-system/issues/DS-825) ([c4f64e4](https://github.com/lmc-eu/spirit-design-system/commit/c4f64e4))
- **web-twig:** Set `Stack` default spacing to zero [#DS-741](https://github.com/lmc-eu/spirit-design-system/issues/DS-741) ([096b9a5](https://github.com/lmc-eu/spirit-design-system/commit/096b9a5))

### Bug Fixes

- **web-twig:** Fix animations helper using class on Icon, not UNSAFE_className ([2028c6b](https://github.com/lmc-eu/spirit-design-system/commit/2028c6b))

### Documentation

- **web-twig:** Introduce migration guide for v2 refs [#DS-800](https://github.com/lmc-eu/spirit-design-system/issues/DS-800) ([7ae79a3](https://github.com/lmc-eu/spirit-design-system/commit/7ae79a3))
- **web-twig:** Remove v1 disabled demo from `TextArea` and `TextField` [#DS-649](https://github.com/lmc-eu/spirit-design-system/issues/DS-649) ([3ee812a](https://github.com/lmc-eu/spirit-design-system/commit/3ee812a))

### Features

- **web-twig:** Add autocomplete attribute to the CheckboxField ([1aeb91b](https://github.com/lmc-eu/spirit-design-system/commit/1aeb91b))

### Styles

- **web-twig:** Fix indentation of Tabs fixture ([198af86](https://github.com/lmc-eu/spirit-design-system/commit/198af86))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.34.1"></a>

## [1.34.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.34.0...@lmc-eu/spirit-web-twig@1.34.1) (2023-07-21)

### Chores

- **web-twig:** Remove old unused component snapshots ([153bb45](https://github.com/lmc-eu/spirit-design-system/commit/153bb45))

### Code Refactoring

- **web-twig:** Move FileUploader form demo script to Demo App ([4aa1d7d](https://github.com/lmc-eu/spirit-design-system/commit/4aa1d7d)), closes [#DS-831](https://github.com/lmc-eu/spirit-design-system/issues/DS-831)

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.34.0"></a>

# [1.34.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.33.0...@lmc-eu/spirit-web-twig@1.34.0) (2023-06-28)

### Bug Fixes

- **web-twig:** Do not render space after label [#DS-842](https://github.com/lmc-eu/spirit-design-system/issues/DS-842) ([3802b43](https://github.com/lmc-eu/spirit-design-system/commit/3802b43))

### Documentation

- **web-twig:** Add unit to the `maxFileSize` in the `FileUploaderInput` props ([ca3f0be](https://github.com/lmc-eu/spirit-design-system/commit/ca3f0be))
- **web-twig:** Fix and improve `FileUploader` docs to be uniform with the `web` package ([d808489](https://github.com/lmc-eu/spirit-design-system/commit/d808489))
- **web-twig:** Improve TextArea's documentation ([2972d4d](https://github.com/lmc-eu/spirit-design-system/commit/2972d4d))
- **web-twig:** Use native attribute `maxlength` in the TextArea ([20821bc](https://github.com/lmc-eu/spirit-design-system/commit/20821bc))

### Features

- **web-twig:** Allow pass `translate` attribute to the `Heading` and `Text` components ([82f1395](https://github.com/lmc-eu/spirit-design-system/commit/82f1395))
- **web-twig:** Introduce Pagination component [#DS-328](https://github.com/lmc-eu/spirit-design-system/issues/DS-328) ([0184842](https://github.com/lmc-eu/spirit-design-system/commit/0184842))
- **web-twig:** Make the preferred height and max height of `ModalDialog` customizable [#DS-723](https://github.com/lmc-eu/spirit-design-system/issues/DS-723) ([1ccba92](https://github.com/lmc-eu/spirit-design-system/commit/1ccba92))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.33.0"></a>

# [1.33.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.32.0...@lmc-eu/spirit-web-twig@1.33.0) (2023-06-11)

### Bug Fixes

- **web-twig:** Fix rendering main props in the TextFieldBase component [#DS-811](https://github.com/lmc-eu/spirit-design-system/issues/DS-811) ([68ca267](https://github.com/lmc-eu/spirit-design-system/commit/68ca267))
- **web-twig:** Render input and main props if the prop value is not `null` or empty ([09212b6](https://github.com/lmc-eu/spirit-design-system/commit/09212b6))

### Code Refactoring

- **web-twig:** Apply more stricter comparison ([75548bb](https://github.com/lmc-eu/spirit-design-system/commit/75548bb))

### Documentation

- **web-twig:** Demonstrate the composition of `Modal` and `ScrollView` [#DS-808](https://github.com/lmc-eu/spirit-design-system/issues/DS-808) ([d91e28a](https://github.com/lmc-eu/spirit-design-system/commit/d91e28a))
- **web-twig:** Fix TextArea's documentation ([52a79da](https://github.com/lmc-eu/spirit-design-system/commit/52a79da))
- **web-twig:** Introduce demo page for form validations ([86c69e2](https://github.com/lmc-eu/spirit-design-system/commit/86c69e2)), closes [#DS-812](https://github.com/lmc-eu/spirit-design-system/issues/DS-812)
- **web-twig:** Remove unnecessary structural comments from `Modal` demos ([0f15c66](https://github.com/lmc-eu/spirit-design-system/commit/0f15c66))
- **web-twig:** Unify syntax when use TextArea component in the stories ([5b85031](https://github.com/lmc-eu/spirit-design-system/commit/5b85031))
- **web,web-twig:** Wrap `Alert` demos into sections and add Icons demo ([2408053](https://github.com/lmc-eu/spirit-design-system/commit/2408053)), closes [#309](https://github.com/lmc-eu/spirit-design-system/issues/309), [#DS-668](https://github.com/lmc-eu/spirit-design-system/issues/DS-668)

### Features

- **web-twig:** Add disabled state to the FileUploaderInput [#DS-772](https://github.com/lmc-eu/spirit-design-system/issues/DS-772) ([fa486f1](https://github.com/lmc-eu/spirit-design-system/commit/fa486f1))
- **web-twig:** Allow transfer of attributes directly to input element ([0c9db8d](https://github.com/lmc-eu/spirit-design-system/commit/0c9db8d)), closes [#DS-812](https://github.com/lmc-eu/spirit-design-system/issues/DS-812)
- **web-twig:** Introduce `inputProps` prop for form field components ([ee85ade](https://github.com/lmc-eu/spirit-design-system/commit/ee85ade)), closes [#DS-812](https://github.com/lmc-eu/spirit-design-system/issues/DS-812)
- **web-twig:** Introduce Select component [#DS-790](https://github.com/lmc-eu/spirit-design-system/issues/DS-790) ([41f8af1](https://github.com/lmc-eu/spirit-design-system/commit/41f8af1))
- **web,web-twig:** Add vertical padding to `ModalBody` [#DS-763](https://github.com/lmc-eu/spirit-design-system/issues/DS-763) ([2e668c7](https://github.com/lmc-eu/spirit-design-system/commit/2e668c7))

### Tests

- **web-twig:** Pass data attribute with and without value ([cd1927c](https://github.com/lmc-eu/spirit-design-system/commit/cd1927c))
- **web-twig:** Render input and main props if the prop value is not `null` or empty ([737896b](https://github.com/lmc-eu/spirit-design-system/commit/737896b))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.32.0"></a>

# [1.32.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.31.0...@lmc-eu/spirit-web-twig@1.32.0) (2023-05-29)

### Documentation

- **web-twig:** Update TextFieldBase message prop API to same type as other multiline messages ([f3c109c](https://github.com/lmc-eu/spirit-design-system/commit/f3c109c))

### Features

- **web-twig:** Add ScrollView component [#DS-465](https://github.com/lmc-eu/spirit-design-system/issues/DS-465) ([54dc164](https://github.com/lmc-eu/spirit-design-system/commit/54dc164))
- **web,web-react,web-twig:** Allow multiline message in CheckboxField [#DS-735](https://github.com/lmc-eu/spirit-design-system/issues/DS-735) ([395af3d](https://github.com/lmc-eu/spirit-design-system/commit/395af3d))
- **web,web-react,web-twig:** Allow multiline message in TextArea [#DS-738](https://github.com/lmc-eu/spirit-design-system/issues/DS-738) ([9759666](https://github.com/lmc-eu/spirit-design-system/commit/9759666))
- **web,web-react,web-twig:** Allow multiline message in TextField [#DS-734](https://github.com/lmc-eu/spirit-design-system/issues/DS-734) ([81b0882](https://github.com/lmc-eu/spirit-design-system/commit/81b0882))
- **web,web-react,web-twig:** Allow multiline validationText in FileUploaderInput [#DS-737](https://github.com/lmc-eu/spirit-design-system/issues/DS-737) ([6724d7a](https://github.com/lmc-eu/spirit-design-system/commit/6724d7a))

### Tests

- **web-twig:** Slightly improve readability of Twig snapshots by adding more line breaks ([cf212a2](https://github.com/lmc-eu/spirit-design-system/commit/cf212a2))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.31.0"></a>

# [1.31.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.30.0...@lmc-eu/spirit-web-twig@1.31.0) (2023-05-18)

### Bug Fixes

- **web-twig:** Custom escaping of HTML attributes ([42176b2](https://github.com/lmc-eu/spirit-design-system/commit/42176b2)), closes [#742](https://github.com/lmc-eu/spirit-design-system/issues/742), [#DS-760](https://github.com/lmc-eu/spirit-design-system/issues/DS-760)

### Chores

- **demo:** Enable typescript support ([07edf5f](https://github.com/lmc-eu/spirit-design-system/commit/07edf5f))
- **repo:** Improvement of DX by adding commands to Makefile ([78d5ba2](https://github.com/lmc-eu/spirit-design-system/commit/78d5ba2))
- **web-twig:** Add shell commands for connecting to docker containers ([f66e48b](https://github.com/lmc-eu/spirit-design-system/commit/f66e48b))
- **web-twig:** Run Encore build in separate image ([9d2b322](https://github.com/lmc-eu/spirit-design-system/commit/9d2b322))

### Documentation

- **web-twig:** Remove duplicated extend in Breadcrumb story ([17e0ef8](https://github.com/lmc-eu/spirit-design-system/commit/17e0ef8))

### Features

- **web-twig:** Add `isAutoResizing` prop to TextArea [#DS-320](https://github.com/lmc-eu/spirit-design-system/issues/DS-320) ([8c7a785](https://github.com/lmc-eu/spirit-design-system/commit/8c7a785))
- **web-twig:** Extend Stack component [#JALL-107](https://github.com/lmc-eu/spirit-design-system/issues/JALL-107) ([def3ef1](https://github.com/lmc-eu/spirit-design-system/commit/def3ef1))
- **web-twig:** Hiding input when the queue is full [#DS-730](https://github.com/lmc-eu/spirit-design-system/issues/DS-730) ([2612484](https://github.com/lmc-eu/spirit-design-system/commit/2612484))
- **web-twig:** Introduce `FileUploader` component [#DS-684](https://github.com/lmc-eu/spirit-design-system/issues/DS-684) ([bd85a04](https://github.com/lmc-eu/spirit-design-system/commit/bd85a04))
- **web-twig:** Rename divider classes according to the Figma documentation ([7cbf2bd](https://github.com/lmc-eu/spirit-design-system/commit/7cbf2bd)), closes [#DS-571](https://github.com/lmc-eu/spirit-design-system/issues/DS-571)

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.30.0"></a>

# [1.30.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.29.0...@lmc-eu/spirit-web-twig@1.30.0) (2023-04-26)

### Code Refactoring

- **web-twig:** Move ComponentTest outputs to separate files, use DataProvider [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([f3dde94](https://github.com/lmc-eu/spirit-design-system/commit/f3dde94))

### Features

- **web-twig:** Allow style in inlineSvg and in Icon, deprecate class in Icon and Spinner [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([12aee00](https://github.com/lmc-eu/spirit-design-system/commit/12aee00))
- **web-twig:** Deprecate class in Accordion [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([bfd8896](https://github.com/lmc-eu/spirit-design-system/commit/bfd8896))
- **web-twig:** Deprecate class in Breadcrumbs [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([095d015](https://github.com/lmc-eu/spirit-design-system/commit/095d015))
- **web-twig:** Deprecate class in Button [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([e87fa15](https://github.com/lmc-eu/spirit-design-system/commit/e87fa15))
- **web-twig:** Deprecate class in ButtonLink and add more tests [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([117afbc](https://github.com/lmc-eu/spirit-design-system/commit/117afbc))
- **web-twig:** Deprecate class in CheckboxField [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([b382686](https://github.com/lmc-eu/spirit-design-system/commit/b382686))
- **web-twig:** Deprecate class in Collapse [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([13155bb](https://github.com/lmc-eu/spirit-design-system/commit/13155bb))
- **web-twig:** Deprecate class in Container [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([8878e8e](https://github.com/lmc-eu/spirit-design-system/commit/8878e8e))
- **web-twig:** Deprecate class in Dropdown [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([488446b](https://github.com/lmc-eu/spirit-design-system/commit/488446b))
- **web-twig:** Deprecate class in Grid [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([bf5b7f4](https://github.com/lmc-eu/spirit-design-system/commit/bf5b7f4))
- **web-twig:** Deprecate class in Header [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([2e1334a](https://github.com/lmc-eu/spirit-design-system/commit/2e1334a))
- **web-twig:** Deprecate class in Heading [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([f780d4b](https://github.com/lmc-eu/spirit-design-system/commit/f780d4b))
- **web-twig:** Deprecate class in Link [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([755f75f](https://github.com/lmc-eu/spirit-design-system/commit/755f75f))
- **web-twig:** Deprecate class in Modal [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([34c245c](https://github.com/lmc-eu/spirit-design-system/commit/34c245c))
- **web-twig:** Deprecate class in Pill [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([51e2bbd](https://github.com/lmc-eu/spirit-design-system/commit/51e2bbd))
- **web-twig:** Deprecate class in RadioField [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([ac19c8a](https://github.com/lmc-eu/spirit-design-system/commit/ac19c8a))
- **web-twig:** Deprecate class in Stack [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([1a32535](https://github.com/lmc-eu/spirit-design-system/commit/1a32535))
- **web-twig:** Deprecate class in Tabs [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([9f55b2f](https://github.com/lmc-eu/spirit-design-system/commit/9f55b2f))
- **web-twig:** Deprecate class in Tag [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([ead773b](https://github.com/lmc-eu/spirit-design-system/commit/ead773b))
- **web-twig:** Deprecate class in Text [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([44affe8](https://github.com/lmc-eu/spirit-design-system/commit/44affe8))
- **web-twig:** Deprecate class in TextArea, TextField and TextFieldBase [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([21869cd](https://github.com/lmc-eu/spirit-design-system/commit/21869cd))
- **web-twig:** Deprecate class in Tooltip [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([1470427](https://github.com/lmc-eu/spirit-design-system/commit/1470427))
- **web-twig:** Introduce styleProps, deprecate class in Alert [#DS-646](https://github.com/lmc-eu/spirit-design-system/issues/DS-646) ([99a8cc2](https://github.com/lmc-eu/spirit-design-system/commit/99a8cc2))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.29.0"></a>

# [1.29.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.28.1...@lmc-eu/spirit-web-twig@1.29.0) (2023-04-17)

### Bug Fixes

- **web-twig:** Condition for onClick deprecation ([978747d](https://github.com/lmc-eu/spirit-design-system/commit/978747d))
- **web-twig:** Make `AccordionHeader` slot actually work ([bab30ef](https://github.com/lmc-eu/spirit-design-system/commit/bab30ef))
- **web-twig:** Remove `raw` filter that cause a XSS issue ([dc76a13](https://github.com/lmc-eu/spirit-design-system/commit/dc76a13))
- **web-twig:** Remove unused expandOnMobile variable in ModalComposed ([818e26a](https://github.com/lmc-eu/spirit-design-system/commit/818e26a))
- **web-twig:** Remove unused Header Button onClick prop ([b9aa01c](https://github.com/lmc-eu/spirit-design-system/commit/b9aa01c))
- **web-twig:** TextArea content offset ([c03ab2c](https://github.com/lmc-eu/spirit-design-system/commit/c03ab2c))

### Chores

- **web-twig:** Intruduce `analyze` script ([e4e60ef](https://github.com/lmc-eu/spirit-design-system/commit/e4e60ef))
- **web-twig:** Keep `static` directory in git for assets ([2ac871b](https://github.com/lmc-eu/spirit-design-system/commit/2ac871b))

### Code Refactoring

- **web-twig:** Pass `title` prop as native attribute through rest ([80ac214](https://github.com/lmc-eu/spirit-design-system/commit/80ac214))

### Dependencies

- **web-twig:** Avoid TwigX of version 3.2.0 ([d2910f2](https://github.com/lmc-eu/spirit-design-system/commit/d2910f2))

### Documentation

- **web-twig:** Add links to examples instead of duplicating them ([e2efa73](https://github.com/lmc-eu/spirit-design-system/commit/e2efa73))
- **web-twig:** Add missing `ol` tag in Breadcrumbs example ([cd36c21](https://github.com/lmc-eu/spirit-design-system/commit/cd36c21))
- **web-twig:** Add stories to file structure example ([819338a](https://github.com/lmc-eu/spirit-design-system/commit/819338a))
- **web-twig:** Explain why the `raw` filter is avoided for input `value` ([2bd1003](https://github.com/lmc-eu/spirit-design-system/commit/2bd1003))
- **web-twig:** Improve deprecation message [#DS-662](https://github.com/lmc-eu/spirit-design-system/issues/DS-662) ([f023798](https://github.com/lmc-eu/spirit-design-system/commit/f023798))
- **web-twig:** Introduce Breadscrumbs stories refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([1c4b7f2](https://github.com/lmc-eu/spirit-design-system/commit/1c4b7f2))
- **web-twig:** Introduce Button story ([87b2bd4](https://github.com/lmc-eu/spirit-design-system/commit/87b2bd4)), closes [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247)
- **web-twig:** Introduce ButtonLink story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([bdecd53](https://github.com/lmc-eu/spirit-design-system/commit/bdecd53))
- **web-twig:** Introduce Collapse story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([2c75004](https://github.com/lmc-eu/spirit-design-system/commit/2c75004))
- **web-twig:** Introduce Container story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([e5ca481](https://github.com/lmc-eu/spirit-design-system/commit/e5ca481))
- **web-twig:** Introduce Dropdown stories refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([06c1684](https://github.com/lmc-eu/spirit-design-system/commit/06c1684))
- **web-twig:** Introduce Grid story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([67d45da](https://github.com/lmc-eu/spirit-design-system/commit/67d45da))
- **web-twig:** Introduce Header story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([946eed6](https://github.com/lmc-eu/spirit-design-system/commit/946eed6))
- **web-twig:** Introduce Heading story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([293b0b0](https://github.com/lmc-eu/spirit-design-system/commit/293b0b0))
- **web-twig:** Introduce Helpers story refs, add Tabs to docs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([3105ded](https://github.com/lmc-eu/spirit-design-system/commit/3105ded))
- **web-twig:** Introduce Icons story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([b2273e1](https://github.com/lmc-eu/spirit-design-system/commit/b2273e1))
- **web-twig:** Introduce Item story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([af33048](https://github.com/lmc-eu/spirit-design-system/commit/af33048))
- **web-twig:** Introduce Link story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([c2273ce](https://github.com/lmc-eu/spirit-design-system/commit/c2273ce))
- **web-twig:** Introduce Modal stories refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([52b8ca8](https://github.com/lmc-eu/spirit-design-system/commit/52b8ca8))
- **web-twig:** Introduce Pill story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([2840af0](https://github.com/lmc-eu/spirit-design-system/commit/2840af0))
- **web-twig:** Introduce Stack story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([9855029](https://github.com/lmc-eu/spirit-design-system/commit/9855029))
- **web-twig:** Introduce Tabs story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([df1dcf7](https://github.com/lmc-eu/spirit-design-system/commit/df1dcf7))
- **web-twig:** Introduce Tag story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([bb2dfbb](https://github.com/lmc-eu/spirit-design-system/commit/bb2dfbb))
- **web-twig:** Introduce Text story refs [#DS-247](https://github.com/lmc-eu/spirit-design-system/issues/DS-247) ([a1a2315](https://github.com/lmc-eu/spirit-design-system/commit/a1a2315))
- **web-twig:** Introduce unescaped props prefix `UNSAFE_` ([72b45f1](https://github.com/lmc-eu/spirit-design-system/commit/72b45f1))
- **web-twig:** Introduction CheckboxField stories ([37f564c](https://github.com/lmc-eu/spirit-design-system/commit/37f564c))
- **web-twig:** Introduction RadioField stories ([cc2798a](https://github.com/lmc-eu/spirit-design-system/commit/cc2798a))
- **web-twig:** Introduction TextArea stories ([d9053e0](https://github.com/lmc-eu/spirit-design-system/commit/d9053e0))
- **web-twig:** Introduction TextField stories ([48e956c](https://github.com/lmc-eu/spirit-design-system/commit/48e956c))
- **web-twig:** Introduction Tooltip stories ([64037cb](https://github.com/lmc-eu/spirit-design-system/commit/64037cb))

### Features

- **web-twig:** Allow event handling attributes via transferring props ([2016587](https://github.com/lmc-eu/spirit-design-system/commit/2016587))
- **web-twig:** Deprecate `onClick` prop on every component ([e3a7684](https://github.com/lmc-eu/spirit-design-system/commit/e3a7684)), closes [#DS-645](https://github.com/lmc-eu/spirit-design-system/issues/DS-645)
- **web-twig:** Introduce autocomplete attribute for RadioField ([29d0547](https://github.com/lmc-eu/spirit-design-system/commit/29d0547))
- **web-twig:** Introduce GridSpan ([d26cd3a](https://github.com/lmc-eu/spirit-design-system/commit/d26cd3a))
- **web-twig:** Introduce loading state to Button and ButtonLink [#DS-640](https://github.com/lmc-eu/spirit-design-system/issues/DS-640) ([b7e5bab](https://github.com/lmc-eu/spirit-design-system/commit/b7e5bab))
- **web-twig:** Introduce Spinner component [#DS-639](https://github.com/lmc-eu/spirit-design-system/issues/DS-639) ([c9f39d5](https://github.com/lmc-eu/spirit-design-system/commit/c9f39d5))
- **web-twig:** Introduce UNSAFE props for Field components ([9122d74](https://github.com/lmc-eu/spirit-design-system/commit/9122d74)), closes [#DS-645](https://github.com/lmc-eu/spirit-design-system/issues/DS-645)
- **web-twig:** Rename Text Color dictionary to Action Link, introduce correct Text Color [#DS-639](https://github.com/lmc-eu/spirit-design-system/issues/DS-639) ([da6fb75](https://github.com/lmc-eu/spirit-design-system/commit/da6fb75))

### Styles

- **web-twig:** Fix indentation of Modal component ([e549c47](https://github.com/lmc-eu/spirit-design-system/commit/e549c47))
- **web-twig:** Ignore SimpleXMLElement static analysis error ([515ad02](https://github.com/lmc-eu/spirit-design-system/commit/515ad02))

### Tests

- **web-twig:** Correct usage of boolean with attribute ([c8bc461](https://github.com/lmc-eu/spirit-design-system/commit/c8bc461))
- **web-twig:** Introduce HTML format method for better snapshots ([ede292e](https://github.com/lmc-eu/spirit-design-system/commit/ede292e))
- **web-twig:** Reformat all snapshots with PHP tidy extension ([4426e06](https://github.com/lmc-eu/spirit-design-system/commit/4426e06))
- **web-twig:** Update snapshot tests with updated spinner icon ([00bfaf8](https://github.com/lmc-eu/spirit-design-system/commit/00bfaf8))
- **web-twig:** Update Spinner snapshot ([11aac67](https://github.com/lmc-eu/spirit-design-system/commit/11aac67))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.28.1"></a>

## [1.28.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.28.0...@lmc-eu/spirit-web-twig@1.28.1) (2023-03-23)

### Bug Fixes

- **web-twig:** Escape value attributtes in input components ([12219cf](https://github.com/lmc-eu/spirit-design-system/commit/12219cf)), closes [#DS-645](https://github.com/lmc-eu/spirit-design-system/issues/DS-645)
- **web-twig:** Remove unfortunately commit index file ([0f598b7](https://github.com/lmc-eu/spirit-design-system/commit/0f598b7))

### Chores

- **web-twig:** Alert component story displayed in demo app ([c32b16f](https://github.com/lmc-eu/spirit-design-system/commit/c32b16f)), closes [#DS-299](https://github.com/lmc-eu/spirit-design-system/issues/DS-299)
- **web-twig:** Build assets for demo app ([164511a](https://github.com/lmc-eu/spirit-design-system/commit/164511a)), closes [#DS-299](https://github.com/lmc-eu/spirit-design-system/issues/DS-299)
- **web-twig:** Create default controller and template for local web ([27b6a9f](https://github.com/lmc-eu/spirit-design-system/commit/27b6a9f))
- **web-twig:** Create new `spirit-web-twig-demo` app for local devel ([64fedb6](https://github.com/lmc-eu/spirit-design-system/commit/64fedb6))
- **web-twig:** Create new `spirit-web-twig-demo` app for local devel ([6ec6756](https://github.com/lmc-eu/spirit-design-system/commit/6ec6756))
- **web-twig:** Export ignore of Symfony files and directories ([098330f](https://github.com/lmc-eu/spirit-design-system/commit/098330f))
- **web-twig:** Prepare development server for Symfony application ([b0d3d7b](https://github.com/lmc-eu/spirit-design-system/commit/b0d3d7b)), closes [#DS-469](https://github.com/lmc-eu/spirit-design-system/issues/DS-469), [#395](https://github.com/lmc-eu/spirit-design-system/issues/395)
- **web-twig:** Prepare development server for Symfony application ([a8943cf](https://github.com/lmc-eu/spirit-design-system/commit/a8943cf)), closes [#DS-469](https://github.com/lmc-eu/spirit-design-system/issues/DS-469), [#395](https://github.com/lmc-eu/spirit-design-system/issues/395)
- **web-twig:** Prepare multistage Docker build for hosting Symfony app ([2848ba0](https://github.com/lmc-eu/spirit-design-system/commit/2848ba0))
- **web-twig:** Remove static directory with icons that were ([ccfc64a](https://github.com/lmc-eu/spirit-design-system/commit/ccfc64a))
- **web-twig:** Render component detail in demo app ([254a8eb](https://github.com/lmc-eu/spirit-design-system/commit/254a8eb)), closes [#DS-299](https://github.com/lmc-eu/spirit-design-system/issues/DS-299)
- **web-twig:** Respect override file of docker compose when starting ([844bcf4](https://github.com/lmc-eu/spirit-design-system/commit/844bcf4)), closes [#DS-469](https://github.com/lmc-eu/spirit-design-system/issues/DS-469), [#395](https://github.com/lmc-eu/spirit-design-system/issues/395)
- **web-twig:** Setup minimul Symfony app for local webserver ([533d386](https://github.com/lmc-eu/spirit-design-system/commit/533d386))

### Documentation

- **web-twig:** Fix typo in message prop ([dbf1660](https://github.com/lmc-eu/spirit-design-system/commit/dbf1660))

### Tests

- **web-twig:** Fix typo in message prop ([308d933](https://github.com/lmc-eu/spirit-design-system/commit/308d933))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.28.0"></a>

# [1.28.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.27.0...@lmc-eu/spirit-web-twig@1.28.0) (2023-03-21)

### Code Refactoring

- **web-twig:** Unify internal prop name with public API of `ModalHeader` ([d15c3f0](https://github.com/lmc-eu/spirit-design-system/commit/d15c3f0))

### Documentation

- **web-twig:** Adding attributes to the component readme [#DS-604](https://github.com/lmc-eu/spirit-design-system/issues/DS-604) ([842f95d](https://github.com/lmc-eu/spirit-design-system/commit/842f95d))
- **web-twig:** Fix internal links ([398f8f9](https://github.com/lmc-eu/spirit-design-system/commit/398f8f9))
- **web-twig:** Paragraph indentation and typos ([f24dfc3](https://github.com/lmc-eu/spirit-design-system/commit/f24dfc3))

### Features

- **web-twig:** Introduce new `Header` with subcomponents [#DS-248](https://github.com/lmc-eu/spirit-design-system/issues/DS-248) ([9f5b7c4](https://github.com/lmc-eu/spirit-design-system/commit/9f5b7c4))

### Tests

- **web-twig:** Improve `Link` snapshot tests ([a7cbb87](https://github.com/lmc-eu/spirit-design-system/commit/a7cbb87))
- **web-twig:** Offload the immense source of the Spirit logo into a partial ([7b7245c](https://github.com/lmc-eu/spirit-design-system/commit/7b7245c))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.27.0"></a>

# [1.27.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.26.0...@lmc-eu/spirit-web-twig@1.27.0) (2023-03-08)

### Bug Fixes

- **web-twig:** Fix bugs in Validation state error deprecation ([e834758](https://github.com/lmc-eu/spirit-design-system/commit/e834758))

### Documentation

- **web-react, web-twig:** Fix Size Extended dictionary type in API tables ([86d8baf](https://github.com/lmc-eu/spirit-design-system/commit/86d8baf))

### Features

- **web-react:** TextField and TextArea helper text [#DS-597](https://github.com/lmc-eu/spirit-design-system/issues/DS-597) ([b0aa2de](https://github.com/lmc-eu/spirit-design-system/commit/b0aa2de))
- **web-react:** Validation state dictionary [#DS-590](https://github.com/lmc-eu/spirit-design-system/issues/DS-590) ([bb495da](https://github.com/lmc-eu/spirit-design-system/commit/bb495da))
- **web-twig:** Align dictionaries [#DS-628](https://github.com/lmc-eu/spirit-design-system/issues/DS-628) ([061275a](https://github.com/lmc-eu/spirit-design-system/commit/061275a))
- **web-twig:** TextField and TextArea helper text [#DS-597](https://github.com/lmc-eu/spirit-design-system/issues/DS-597) ([c2d8de9](https://github.com/lmc-eu/spirit-design-system/commit/c2d8de9))
- **web-twig:** Update Tag - dictionaries and deprecate theme and `default` [#DS-442](https://github.com/lmc-eu/spirit-design-system/issues/DS-442) [#DS-377](https://github.com/lmc-eu/spirit-design-system/issues/DS-377) ([07cb957](https://github.com/lmc-eu/spirit-design-system/commit/07cb957))
- **web-twig:** Use Color and Size Dictionaries in Button and ButtonLink components [#DS-436](https://github.com/lmc-eu/spirit-design-system/issues/DS-436) ([89f43a5](https://github.com/lmc-eu/spirit-design-system/commit/89f43a5))
- **web-twig:** Validation state dictionary [#DS-590](https://github.com/lmc-eu/spirit-design-system/issues/DS-590) ([4d2f048](https://github.com/lmc-eu/spirit-design-system/commit/4d2f048))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.26.0"></a>

# [1.26.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.25.1...@lmc-eu/spirit-web-twig@1.26.0) (2023-02-17)

### Bug Fixes

- **web-twig:** Add missing icon colors key-pairs for Alert component ([adac3d9](https://github.com/lmc-eu/spirit-design-system/commit/adac3d9)), closes [#DS-619](https://github.com/lmc-eu/spirit-design-system/issues/DS-619)

### Features

- **web-twig:** Introduce Modal Composed with subcomponents [#DS-507](https://github.com/lmc-eu/spirit-design-system/issues/DS-507) ([da720e1](https://github.com/lmc-eu/spirit-design-system/commit/da720e1))
- **web-twig:** Use Action and Emotion Color Dictionaries in Pill component [#DS-574](https://github.com/lmc-eu/spirit-design-system/issues/DS-574) ([abb4b92](https://github.com/lmc-eu/spirit-design-system/commit/abb4b92))
- **web-twig:** Use Text Color Dictionary in Link component [#DS-573](https://github.com/lmc-eu/spirit-design-system/issues/DS-573) ([a6ad9e2](https://github.com/lmc-eu/spirit-design-system/commit/a6ad9e2))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.25.1"></a>

## [1.25.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.25.0...@lmc-eu/spirit-web-twig@1.25.1) (2023-02-13)

### Bug Fixes

- **web-twig:** Deprecated `size` prop on Icon cannot modify dimensions ([dc94695](https://github.com/lmc-eu/spirit-design-system/commit/dc94695)), closes [#DS-600](https://github.com/lmc-eu/spirit-design-system/issues/DS-600)

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.25.0"></a>

# [1.25.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.24.0...@lmc-eu/spirit-web-twig@1.25.0) (2023-02-09)

### Bug Fixes

- **web-twig:** Fix Heading README Dictionaries URL ([490cad8](https://github.com/lmc-eu/spirit-design-system/commit/490cad8))
- **web-twig:** Remove `data-component` attribute from Modal ([7ca314e](https://github.com/lmc-eu/spirit-design-system/commit/7ca314e))

### Features

- **web-twig:** Deprecate `size` prop in Icon component in favor of `boxSize` [#DS-452](https://github.com/lmc-eu/spirit-design-system/issues/DS-452) ([fe2af13](https://github.com/lmc-eu/spirit-design-system/commit/fe2af13))
- **web-twig:** Use Emotion Color Dictionary in Alert component [#DS-555](https://github.com/lmc-eu/spirit-design-system/issues/DS-555) ([5f2ce79](https://github.com/lmc-eu/spirit-design-system/commit/5f2ce79))
- **web-twig:** Use size dictionaries in Heading component [#DS-572](https://github.com/lmc-eu/spirit-design-system/issues/DS-572) ([92f7745](https://github.com/lmc-eu/spirit-design-system/commit/92f7745))
- **web-twig:** Use size dictionaries in Text component [#DS-450](https://github.com/lmc-eu/spirit-design-system/issues/DS-450) ([32f5239](https://github.com/lmc-eu/spirit-design-system/commit/32f5239))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.24.0"></a>

# [1.24.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.23.0...@lmc-eu/spirit-web-twig@1.24.0) (2023-02-06)

### Features

- **web-twig:** Deprecate `isFullWidth` prop in Dropdown component ([544264d](https://github.com/lmc-eu/spirit-design-system/commit/544264d))
- **web-twig:** Introduce `fullWidthMode` prop to Dropdown [#DS-493](https://github.com/lmc-eu/spirit-design-system/issues/DS-493) ([1afc53a](https://github.com/lmc-eu/spirit-design-system/commit/1afc53a))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.23.0"></a>

# [1.23.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.22.0...@lmc-eu/spirit-web-twig@1.23.0) (2023-02-01)

### Code Refactoring

- **web-twig:** Rename allowedAttributes to transferringAttributes ([942304e](https://github.com/lmc-eu/spirit-design-system/commit/942304e))

### Features

- **web-twig:** Allow autocomplete attribute in TextField component ([d2ba902](https://github.com/lmc-eu/spirit-design-system/commit/d2ba902))
- **web-twig:** Allow name attribute for Button component (refs [#DS-569](https://github.com/lmc-eu/spirit-design-system/issues/DS-569)) ([cd7009f](https://github.com/lmc-eu/spirit-design-system/commit/cd7009f))
- **web-twig:** Allowed attributes argument for mainProps filter ([ceb04cc](https://github.com/lmc-eu/spirit-design-system/commit/ceb04cc))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.22.0"></a>

# [1.22.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.21.0...@lmc-eu/spirit-web-twig@1.22.0) (2023-01-29)

### Bug Fixes

- **web-twig:** Add the missing `isOpen` prop to `Collapse` ([e65e7d8](https://github.com/lmc-eu/spirit-design-system/commit/e65e7d8))
- **web-twig:** Define native return type to "Twig\Extension\ExtensionInterface::getFilters()" ([b96a428](https://github.com/lmc-eu/spirit-design-system/commit/b96a428))

### Features

- **web-twig:** Add `hasPasswordToggle` feature to the TextField [#DS-509](https://github.com/lmc-eu/spirit-design-system/issues/DS-509) ([2bea4d2](https://github.com/lmc-eu/spirit-design-system/commit/2bea4d2))
- **web-twig:** Add option to Icon component to disable SVG reusability ([c1cdbec](https://github.com/lmc-eu/spirit-design-system/commit/c1cdbec))

### Tests

- **web-twig:** Add missing Tooltip snapshot test ([6f02dba](https://github.com/lmc-eu/spirit-design-system/commit/6f02dba))
- **web-twig:** Update snapshost due to icons change ([8341864](https://github.com/lmc-eu/spirit-design-system/commit/8341864))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.21.0"></a>

# [1.21.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.20.0...@lmc-eu/spirit-web-twig@1.21.0) (2023-01-16)

### Bug Fixes

- **web-twig:** Collapse content element props ([17e7542](https://github.com/lmc-eu/spirit-design-system/commit/17e7542))
- **web-twig:** Default filter is not working as expected for false value ([6c855ff](https://github.com/lmc-eu/spirit-design-system/commit/6c855ff))

### Code Refactoring

- **web-twig:** Unify quotes in attributes and print them raw ([3194ec6](https://github.com/lmc-eu/spirit-design-system/commit/3194ec6))

### Documentation

- **web-twig:** Add warning about using default filter in component's ([c445920](https://github.com/lmc-eu/spirit-design-system/commit/c445920))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.20.0"></a>

# [1.20.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.19.0...@lmc-eu/spirit-web-twig@1.20.0) (2023-01-10)

### Bug Fixes

- **web-twig:** Add missing test snapshots ([04f8e20](https://github.com/lmc-eu/spirit-design-system/commit/04f8e20))
- **web-twig:** Make Collapse components props optional according to its readme [#DS-275](https://github.com/lmc-eu/spirit-design-system/issues/DS-275) ([87f8b2d](https://github.com/lmc-eu/spirit-design-system/commit/87f8b2d))

### Documentation

- **web-twig:** Document the missing input types of `TextField`: `number`, `search`, `tel`, `url` ([5f3ec92](https://github.com/lmc-eu/spirit-design-system/commit/5f3ec92))

### Features

- **web-twig:** Introduce Accordion for Twig [#DS-448](https://github.com/lmc-eu/spirit-design-system/issues/DS-448) ([74e1467](https://github.com/lmc-eu/spirit-design-system/commit/74e1467))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.19.0"></a>

# [1.19.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.18.0...@lmc-eu/spirit-web-twig@1.19.0) (2022-12-16)

### Documentation

- **contributing:** Addition to readme and contribution files ([692d7df](https://github.com/lmc-eu/spirit-design-system/commit/692d7df))
- **contributing:** Updating readme and contribution files ([6f7dc73](https://github.com/lmc-eu/spirit-design-system/commit/6f7dc73))

### Features

- **web-twig:** Add Item variant to RadioField and CheckboxField [#DS-364](https://github.com/lmc-eu/spirit-design-system/issues/DS-364) ([fdbf4ba](https://github.com/lmc-eu/spirit-design-system/commit/fdbf4ba))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.18.0"></a>

# [1.18.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.17.0...@lmc-eu/spirit-web-twig@1.18.0) (2022-12-08)

### Features

- **web-twig:** Collapse Twig properties update, tests, documentation ([3bdf57d](https://github.com/lmc-eu/spirit-design-system/commit/3bdf57d))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.17.0"></a>

# [1.17.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.16.0...@lmc-eu/spirit-web-twig@1.17.0) (2022-11-30)

### BREAKING CHANGES

- **web-twig:** Rename TextField `size` attribute to `inputWidth` ([c0fc803](https://github.com/lmc-eu/spirit-design-system/commit/c0fc803))

### Bug Fixes

- **web-twig:** Do not render icon before the first breadcrumb item [#JALL-32](https://github.com/lmc-eu/spirit-design-system/issues/JALL-32) ([b08fd49](https://github.com/lmc-eu/spirit-design-system/commit/b08fd49))
- **web-twig:** Fix rendering of the value attribute in TextArea [#DS-319](https://github.com/lmc-eu/spirit-design-system/issues/DS-319) ([152603c](https://github.com/lmc-eu/spirit-design-system/commit/152603c))

### Documentation

- **web-twig:** Add size property to TextField ([73f6506](https://github.com/lmc-eu/spirit-design-system/commit/73f6506))

### Features

- **web-twig:** Introduce TextArea component [#DS-319](https://github.com/lmc-eu/spirit-design-system/issues/DS-319) ([6692806](https://github.com/lmc-eu/spirit-design-system/commit/6692806))

### Styles

- **web-twig:** Add space before variable initialization ([c048f43](https://github.com/lmc-eu/spirit-design-system/commit/c048f43))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.16.0"></a>

# [1.16.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.15.0...@lmc-eu/spirit-web-twig@1.16.0) (2022-11-09)

### Bug Fixes

- **web-twig:** Add missing default value for optional breakpoint prop ([f56d4e4](https://github.com/lmc-eu/spirit-design-system/commit/f56d4e4))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.15.0"></a>

# [1.15.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.14.0...@lmc-eu/spirit-web-twig@1.15.0) (2022-11-07)

### Chores

- **web-twig:** Introduce `.gitattributes` to lower download size ([bc9675b](https://github.com/lmc-eu/spirit-design-system/commit/bc9675b))

### Documentation

- **web-twig:** Documenting Collapse examples in twig syntax ([4e2b17a](https://github.com/lmc-eu/spirit-design-system/commit/4e2b17a))

### Features

- **web-twig:** Introduce Dropdown component (refs [#DS-395](https://github.com/lmc-eu/spirit-design-system/issues/DS-395)) ([79e7993](https://github.com/lmc-eu/spirit-design-system/commit/79e7993))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.14.0"></a>

# [1.14.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.13.0...@lmc-eu/spirit-web-twig@1.14.0) (2022-10-25)

### Bug Fixes

- **web-twig:** Revert reuse icon viewBox, but set it to correct values [#DS-429](https://github.com/lmc-eu/spirit-design-system/issues/DS-429) ([f0cbb78](https://github.com/lmc-eu/spirit-design-system/commit/f0cbb78))

### Features

- **web-twig:** Collapse twig implementation [#DS-275](https://github.com/lmc-eu/spirit-design-system/issues/DS-275) ([172c161](https://github.com/lmc-eu/spirit-design-system/commit/172c161))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.13.0"></a>

# [1.13.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.12.0...@lmc-eu/spirit-web-twig@1.13.0) (2022-10-13)

### BREAKING CHANGES

- **web-twig:** Update Pill variants - remove secondary and add emotion colors [#DS-408](https://github.com/lmc-eu/spirit-design-system/issues/DS-408) ([124ec27](https://github.com/lmc-eu/spirit-design-system/commit/124ec27))

### Bug Fixes

- **web-twig:** Omit viewBox in reused SVGs to avoid scaling bug [#JALL-7](https://github.com/lmc-eu/spirit-design-system/issues/JALL-7) ([de46450](https://github.com/lmc-eu/spirit-design-system/commit/de46450))

### Styles

- **web:** Upgrade stylelint config and fix errors [#DS-322](https://github.com/lmc-eu/spirit-design-system/issues/DS-322) ([4df87da](https://github.com/lmc-eu/spirit-design-system/commit/4df87da))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.12.0"></a>

# [1.12.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.11.0...@lmc-eu/spirit-web-twig@1.12.0) (2022-10-03)

### BREAKING CHANGES

- Remove `narrow` preset of `Grid` in favour of product-specific layouts ([64f5588](https://github.com/lmc-eu/spirit-design-system/commit/64f5588))
- **web-twig:** Delete duplicate `Tabs` sub-components ([46c430d](https://github.com/lmc-eu/spirit-design-system/commit/46c430d))
- **web-twig:** Drop support Symfony 3.4 and not LTS versions 4.x and 5.x ([286644c](https://github.com/lmc-eu/spirit-design-system/commit/286644c))
- **web-twig:** Fix `TabLink` API ([488800b](https://github.com/lmc-eu/spirit-design-system/commit/488800b))

### Chores

- **web-twig:** Add changes done by version script to VCS ([7d62978](https://github.com/lmc-eu/spirit-design-system/commit/7d62978))

### Features

- **web-twig:** Add abstract component TextFieldBase [#DS-319](https://github.com/lmc-eu/spirit-design-system/issues/DS-319) ([1a27cfc](https://github.com/lmc-eu/spirit-design-system/commit/1a27cfc))
- **web-twig:** Introduce support Symfony 6.1 and PHP 8.1 ([676ce5e](https://github.com/lmc-eu/spirit-design-system/commit/676ce5e))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.11.0"></a>

# [1.11.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.10.0...@lmc-eu/spirit-web-twig@1.11.0) (2022-09-22)

### Bug Fixes

- **web-twig:** Variable props does not exist ([2acba5d](https://github.com/lmc-eu/spirit-design-system/commit/2acba5d))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.10.0"></a>

# [1.10.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.9.0...@lmc-eu/spirit-web-twig@1.10.0) (2022-09-15)

### Bug Fixes

- ECS lint error in SvgExtension.php ([ba0f769](https://github.com/lmc-eu/spirit-design-system/commit/ba0f769))
- Update snapshot tests ([6dc61dc](https://github.com/lmc-eu/spirit-design-system/commit/6dc61dc))
- **web-twig:** Blank spaces in class props ([2e6f047](https://github.com/lmc-eu/spirit-design-system/commit/2e6f047))
- **web-twig:** ButtonLink disabled state not working without disabled class ([ef7de03](https://github.com/lmc-eu/spirit-design-system/commit/ef7de03))
- **web-twig:** ButtonLink remove disabled attribute ([480dce3](https://github.com/lmc-eu/spirit-design-system/commit/480dce3))
- **web-twig:** Remove Icon name first letter upper-casing ([801381f](https://github.com/lmc-eu/spirit-design-system/commit/801381f))
- **web-twig:** Set correct order of filters in TabPane ([d8f4e95](https://github.com/lmc-eu/spirit-design-system/commit/d8f4e95))
- **web-twig:** Unifying Link implementation ([28fe216](https://github.com/lmc-eu/spirit-design-system/commit/28fe216))

### Features

- **web-twig:** Add aria-hidden to Icon component ([6519ed8](https://github.com/lmc-eu/spirit-design-system/commit/6519ed8))
- **web-twig:** Add five columns option to Grid ([709dd30](https://github.com/lmc-eu/spirit-design-system/commit/709dd30))
- **web-twig:** Add property size to the Button [#DS-318](https://github.com/lmc-eu/spirit-design-system/issues/DS-318) ([5ce2821](https://github.com/lmc-eu/spirit-design-system/commit/5ce2821))
- **web-twig:** Allow mainProps in Icon component ([1cf080b](https://github.com/lmc-eu/spirit-design-system/commit/1cf080b))
- **web-twig:** Remove Icon class from the Icon component ([3987190](https://github.com/lmc-eu/spirit-design-system/commit/3987190))
- **web-twig:** Use Icon in Alert and add centered variant [#DS-304](https://github.com/lmc-eu/spirit-design-system/issues/DS-304) ([5cf933f](https://github.com/lmc-eu/spirit-design-system/commit/5cf933f))
- **web-twig:** Use Icon in Breadcrumbs [#DS-305](https://github.com/lmc-eu/spirit-design-system/issues/DS-305) ([71e9032](https://github.com/lmc-eu/spirit-design-system/commit/71e9032))
- **web-twig:** Use Icon in Header [#DS-305](https://github.com/lmc-eu/spirit-design-system/issues/DS-305) ([0172867](https://github.com/lmc-eu/spirit-design-system/commit/0172867))
- **web-twig:** Use Icon in Modal [#DS-305](https://github.com/lmc-eu/spirit-design-system/issues/DS-305) ([c8cb2cf](https://github.com/lmc-eu/spirit-design-system/commit/c8cb2cf))
- **web-twig:** Use Icon in Tooltip [#DS-305](https://github.com/lmc-eu/spirit-design-system/issues/DS-305) ([41b8501](https://github.com/lmc-eu/spirit-design-system/commit/41b8501))
- **web:** Update Breadcrumbs' last item's theme color (refs [#DS-313](https://github.com/lmc-eu/spirit-design-system/issues/DS-313)) ([7f53b42](https://github.com/lmc-eu/spirit-design-system/commit/7f53b42))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.9.0"></a>

# [1.9.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.8.0...@lmc-eu/spirit-web-twig@1.9.0) (2022-08-31)

### Bug Fixes

- **web-twig:** Add missing service registration for ComponentLexer ([5f94b44](https://github.com/lmc-eu/spirit-design-system/commit/5f94b44))
- **web-twig:** Default components path in spirit for extending components ([f6a137e](https://github.com/lmc-eu/spirit-design-system/commit/f6a137e))
- **web-twig:** Make `TextField` `id` mandatory as it is required for linking the label to the input ([d57b9ad](https://github.com/lmc-eu/spirit-design-system/commit/d57b9ad))
- **web-twig:** Remove classes used in TwigX Bundle ([635c73e](https://github.com/lmc-eu/spirit-design-system/commit/635c73e))
- **web-twig:** Set right order of filters ([6d7cde2](https://github.com/lmc-eu/spirit-design-system/commit/6d7cde2))
- **web-twig:** Tooltip raw id attribute ([8b47290](https://github.com/lmc-eu/spirit-design-system/commit/8b47290))
- **web-twig:** TooltipWrapper does not use additional classes ([8136de2](https://github.com/lmc-eu/spirit-design-system/commit/8136de2))
- **web-twig:** TooltipWrapper double closure of the component ([bdf6936](https://github.com/lmc-eu/spirit-design-system/commit/bdf6936))
- **web-twig:** Use ComponentLexer from TwigXBundle package ([a65866c](https://github.com/lmc-eu/spirit-design-system/commit/a65866c))

### Chores

- **web-twig:** Add package into lerna managed workspace (refs [#393](https://github.com/lmc-eu/spirit-design-system/issues/393)) ([1912563](https://github.com/lmc-eu/spirit-design-system/commit/1912563))
- **web-twig:** Introduce docker support for seamless development ([45dc8d2](https://github.com/lmc-eu/spirit-design-system/commit/45dc8d2))
- **web-twig:** Parse future version and update composer.json with it ([a8b3a4d](https://github.com/lmc-eu/spirit-design-system/commit/a8b3a4d)), closes [#393](https://github.com/lmc-eu/spirit-design-system/issues/393)
- **web-twig:** Remove ignored cache and coverage files ([ecc110b](https://github.com/lmc-eu/spirit-design-system/commit/ecc110b))
- **web-twig:** Remove Jenkins pipeline ([57ad0a9](https://github.com/lmc-eu/spirit-design-system/commit/57ad0a9))
- **web-twig:** Require v2 of twigx-bundle and remove minimum stability flag ([006e3c5](https://github.com/lmc-eu/spirit-design-system/commit/006e3c5))

### Code Refactoring

- **web-twig:** Move content to `packages/web-twig` ([23a9915](https://github.com/lmc-eu/spirit-design-system/commit/23a9915))
- **web-twig:** Refactor directory structure of components ([dfb68d1](https://github.com/lmc-eu/spirit-design-system/commit/dfb68d1))
- **web-twig:** Rename Tabs components to same names as we have in react package ([e352145](https://github.com/lmc-eu/spirit-design-system/commit/e352145))
- **web-twig:** Require compiler as separate dependency (refs [#DS-277](https://github.com/lmc-eu/spirit-design-system/issues/DS-277)) ([20cb419](https://github.com/lmc-eu/spirit-design-system/commit/20cb419))

### Dependencies

- **web-twig:** Remove unused dependency `doctrine/cache` ([acd28f8](https://github.com/lmc-eu/spirit-design-system/commit/acd28f8))
- **web-twig:** Update `twigx-bundle` to 2.1.0 ([9ac8aec](https://github.com/lmc-eu/spirit-design-system/commit/9ac8aec))

### Documentation

- **web-twig:** How to publish changes to package readonly repository ([455a328](https://github.com/lmc-eu/spirit-design-system/commit/455a328))
- **web-twig:** Regenerate changelog based on commit history (refs [#393](https://github.com/lmc-eu/spirit-design-system/issues/393)) ([a1c02b4](https://github.com/lmc-eu/spirit-design-system/commit/a1c02b4))
- **web-twig:** Remove step of adding internal repository to composer ([15e2154](https://github.com/lmc-eu/spirit-design-system/commit/15e2154))
- **web-twig:** Update links to every component readme file ([028558e](https://github.com/lmc-eu/spirit-design-system/commit/028558e))

### Features

- **web-twig:** Add size prop to Icon component [#DS-288](https://github.com/lmc-eu/spirit-design-system/issues/DS-288) ([37a6674](https://github.com/lmc-eu/spirit-design-system/commit/37a6674))
- **web-twig:** Change license from proprietary to MIT ([9b65fd7](https://github.com/lmc-eu/spirit-design-system/commit/9b65fd7))
- **web-twig:** Enable glob function pattersn in a paths ([d154204](https://github.com/lmc-eu/spirit-design-system/commit/d154204))
- **web-twig:** Introduce `Breadcrumbs` component (refs [#DS-302](https://github.com/lmc-eu/spirit-design-system/issues/DS-302)) ([0cb08ad](https://github.com/lmc-eu/spirit-design-system/commit/0cb08ad))
- **web-twig:** Introduce `informative` variant to `Alert` [#DS-274](https://github.com/lmc-eu/spirit-design-system/issues/DS-274) ([210a013](https://github.com/lmc-eu/spirit-design-system/commit/210a013))
- **web-twig:** Introduce `Tooltip` component (refs [#DS-252](https://github.com/lmc-eu/spirit-design-system/issues/DS-252)) ([cbba01b](https://github.com/lmc-eu/spirit-design-system/commit/cbba01b))
- **web-twig:** Introduce filter for Boolean props ([47d3872](https://github.com/lmc-eu/spirit-design-system/commit/47d3872))
- **web-twig:** Introduce Icon component [#DS-288](https://github.com/lmc-eu/spirit-design-system/issues/DS-288) ([69074f3](https://github.com/lmc-eu/spirit-design-system/commit/69074f3))
- **web-twig:** Introduce Modal component ([43f73ee](https://github.com/lmc-eu/spirit-design-system/commit/43f73ee))
- **web-twig:** Introduce RadioField component ([e47f30b](https://github.com/lmc-eu/spirit-design-system/commit/e47f30b))

### Styles

- **web-twig:** Cast type of variable used in foreach loop ([434affb](https://github.com/lmc-eu/spirit-design-system/commit/434affb))
- **web-twig:** Reformat documentation by the style rule ([c69f920](https://github.com/lmc-eu/spirit-design-system/commit/c69f920))

### Tests

- **web-twig:** Add missing brackets in new instance of Logger ([f35c2e7](https://github.com/lmc-eu/spirit-design-system/commit/f35c2e7))
- **web-twig:** Update snapshots after removing dependency ([53bc60c](https://github.com/lmc-eu/spirit-design-system/commit/53bc60c))
- **web-twig:** Use real paths in data provider for Compiler Pass ([2c81c5a](https://github.com/lmc-eu/spirit-design-system/commit/2c81c5a))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.8.0"></a>

# [1.8.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.7.0...@lmc-eu/spirit-web-twig@1.8.0) (2022-08-29)

### Code Refactoring

- **web-twig:** Refactor Twig components and update their readme, api not changed (refs #DS-249) ([6dcbcbe](https://github.com/lmc-eu/spirit-design-system/commit/6dcbcbe)), closes [#DS-249](https://github.com/lmc-eu/spirit-design-system/issues/DS-249)

### Features

- **web-twig:** Introduce Tabs component (refs #DS-233) ([1e43b05](https://github.com/lmc-eu/spirit-design-system/commit/1e43b05)), closes [#DS-233](https://github.com/lmc-eu/spirit-design-system/issues/DS-233)
- **web-twig:** Introduce Pill component ([23bfcf7](https://github.com/lmc-eu/spirit-design-system/commit/23bfcf7))
- **web-twig:** Update Tag - add sizes, split theme and color classes, allow elementType change. Use ([a56d0f5](https://github.com/lmc-eu/spirit-design-system/commit/a56d0f5))

### Bug Fixes

- **web-twig:** Bugfix `isRequired` functionality in `TextField` component ([6858643](https://github.com/lmc-eu/spirit-design-system/commit/6858643))

### Tests

- **web-twig:** Fixed the version of the spatie/phpunit-snapshot-assertions package ([8929c9c](https://github.com/lmc-eu/spirit-design-system/commit/8929c9c))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.7.0"></a>

# [1.7.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.6.0...@lmc-eu/spirit-web-twig@1.7.0) (2022-05-09)

### Features

- **web-twig:** SVG Twig extension ([8b9e609](https://github.com/lmc-eu/spirit-design-system/commit/8b9e609))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.6.0"></a>

# [1.6.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.5.0...@lmc-eu/spirit-web-twig@1.6.0) (2022-04-29)

### Bug Fixes

- **web-twig:** Rename Header toggle class to `mobileOnlyActions` ([3360074](https://github.com/lmc-eu/spirit-design-system/commit/3360074))
- **web-twig:** Bugfix Link component classes ([c7389a0](https://github.com/lmc-eu/spirit-design-system/commit/c7389a0))
- **web-twig:** Bugfix Link component title ([02ca0ad](https://github.com/lmc-eu/spirit-design-system/commit/02ca0ad))
- **web-twig:** Bugfix title prop in ButtonLink ([7708bed](https://github.com/lmc-eu/spirit-design-system/commit/7708bed))

### Documentation

- **web-twig:** Add new components into readme and fix newVersion script ([61fe5f7](https://github.com/lmc-eu/spirit-design-system/commit/61fe5f7))
- **web-twig:** Bugfix Header.md title ([fb91e3d](https://github.com/lmc-eu/spirit-design-system/commit/fb91e3d))
- **web-twig:** Add Header into spirit components list in README ([0185451](https://github.com/lmc-eu/spirit-design-system/commit/0185451))
- **web-twig:** Documentation for Header component (refs #DS-161) ([37f83d3](https://github.com/lmc-eu/spirit-design-system/commit/37f83d3)), closes [#DS-161](https://github.com/lmc-eu/spirit-design-system/issues/DS-161)

### Features

- **web-twig:** Print raw label and message props in TextField and CheckboxField components ([aa5315f](https://github.com/lmc-eu/spirit-design-system/commit/aa5315f))
- **web-twig:** Allow validation attributtes as main props for Text and Checkbox (refs #DS-199) ([6aeb0f6](https://github.com/lmc-eu/spirit-design-system/commit/6aeb0f6)), closes [#DS-199](https://github.com/lmc-eu/spirit-design-system/issues/DS-199)
- **web-twig:** Add Alert component ([edbb04b](https://github.com/lmc-eu/spirit-design-system/commit/edbb04b))

- **web-twig:** Introduce Link component as typography helper ([15e0886](https://github.com/lmc-eu/spirit-design-system/commit/15e0886))
- **web-twig:** Introduce Heading component as typography helper ([ecca69a](https://github.com/lmc-eu/spirit-design-system/commit/ecca69a))
- **web-twig:** Introduce Text component as typography helper ([addced6](https://github.com/lmc-eu/spirit-design-system/commit/addced6))
- **web-twig:** Optimize navbarToggle component & allow aria-\* mainProps and ignore empty string (DS ([d77252d](https://github.com/lmc-eu/spirit-design-system/commit/d77252d))
- **web-twig:** Introduce Header component (refs #DS-161) ([a423509](https://github.com/lmc-eu/spirit-design-system/commit/a423509)), closes [#DS-161](https://github.com/lmc-eu/spirit-design-system/issues/DS-161)
- **web-twig:** Introduce Header Nav component (refs #DS-161) ([4c9ce1a](https://github.com/lmc-eu/spirit-design-system/commit/4c9ce1a)), closes [#DS-161](https://github.com/lmc-eu/spirit-design-system/issues/DS-161)
- **web-twig:** Introduce Header Navbar Actions component (refs #DS-161) ([10730ca](https://github.com/lmc-eu/spirit-design-system/commit/10730ca)), closes [#DS-161](https://github.com/lmc-eu/spirit-design-system/issues/DS-161)
- **web-twig:** Introduce Header Navbar Close component (refs #DS-161) ([c504e61](https://github.com/lmc-eu/spirit-design-system/commit/c504e61)), closes [#DS-161](https://github.com/lmc-eu/spirit-design-system/issues/DS-161)
- **web-twig:** Introduce Header Navbar component (refs #DS-161) ([a1a2726](https://github.com/lmc-eu/spirit-design-system/commit/a1a2726)), closes [#DS-161](https://github.com/lmc-eu/spirit-design-system/issues/DS-161)
- **web-twig:** Introduce Header NavItem (refs #DS-161) ([7967b82](https://github.com/lmc-eu/spirit-design-system/commit/7967b82)), closes [#DS-161](https://github.com/lmc-eu/spirit-design-system/issues/DS-161)
- **web-twig:** Introduce Header NavLink component (refs #DS-161) ([74c6d96](https://github.com/lmc-eu/spirit-design-system/commit/74c6d96)), closes [#DS-161](https://github.com/lmc-eu/spirit-design-system/issues/DS-161)
- **web-twig:** Remove PasswordField in favor of TextField ([9c16853](https://github.com/lmc-eu/spirit-design-system/commit/9c16853))
- **web-twig:** Add main props `data-*` and `id` into `Button` and `ButtonLink` components ([2919d7a](https://github.com/lmc-eu/spirit-design-system/commit/2919d7a))

### Tests

- **web-twig:** Testing Header component (refs #DS-161) ([c366ae4](https://github.com/lmc-eu/spirit-design-system/commit/c366ae4)), closes [#DS-161](https://github.com/lmc-eu/spirit-design-system/issues/DS-161)

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.5.0"></a>

# [1.5.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.4.0...@lmc-eu/spirit-web-twig@1.5.0) (2022-04-04)

### BREAKING CHANGES

- **web-twig:** Use is prefix for boolean props ([ebb9f5e](https://github.com/lmc-eu/spirit-design-system/commit/ebb9f5e))

### Bug Fixes

- **web-twig:** Fix boolean props, check first if they are defined and then if they are true ([d63eaee](https://github.com/lmc-eu/spirit-design-system/commit/d63eaee))
- **web-twig:** Bugfix boolean props value ([342760a](https://github.com/lmc-eu/spirit-design-system/commit/342760a))
- **web-twig:** Bugfix Grid behavior and its unused props ([f557e02](https://github.com/lmc-eu/spirit-design-system/commit/f557e02))
- **web-twig:** Bugfix Grid component prop desktop ([b411b36](https://github.com/lmc-eu/spirit-design-system/commit/b411b36))

### Chores

- **web-twig:** Add script to release new versions and add contributing doc ([7968777](https://github.com/lmc-eu/spirit-design-system/commit/7968777))

### Features

- **web-twig:** Add title prop into ButtonLink ([20da3aa](https://github.com/lmc-eu/spirit-design-system/commit/20da3aa))
- **web-twig:** Add onClick prop into `ButtonLink` component ([b3b6998](https://github.com/lmc-eu/spirit-design-system/commit/b3b6998))

### Tests

- **web-twig:** Add snapshot to not disabled button ([999d436](https://github.com/lmc-eu/spirit-design-system/commit/999d436))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.4.0"></a>

# [1.4.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.3.0...@lmc-eu/spirit-web-twig@1.4.0) (2022-03-28)

### Features

- **web-twig:** Add support Twig 1.44.6 for Jobs ([20aa0f0](https://github.com/lmc-eu/spirit-design-system/commit/20aa0f0))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.3.0"></a>

# [1.3.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.2.0...@lmc-eu/spirit-web-twig@1.3.0) (2022-03-22)

### Bug Fixes

- **web-twig:** Bugfix CamelCase component name ([c1e3044](https://github.com/lmc-eu/spirit-design-system/commit/c1e3044))

### Documentation

- **web-twig:** Add ButtonLink component documentation ([20d13a2](https://github.com/lmc-eu/spirit-design-system/commit/20d13a2))

### Features

- **web-twig:** Add CheckboxField component ([95bd5df](https://github.com/lmc-eu/spirit-design-system/commit/95bd5df))
- **web-twig:** Add PasswordField implementation into TextField ([fb15e39](https://github.com/lmc-eu/spirit-design-system/commit/fb15e39))
- **web-twig:** Add TextField component ([38f161b](https://github.com/lmc-eu/spirit-design-system/commit/38f161b))
- **web-twig:** Add Stack component ([0b79438](https://github.com/lmc-eu/spirit-design-system/commit/0b79438))
- **web-twig:** Add ButtonLink component (refs #DS-132) ([da74e1c](https://github.com/lmc-eu/spirit-design-system/commit/da74e1c)), closes [#DS-132](https://github.com/lmc-eu/spirit-design-system/issues/DS-132)
- **web-twig:** Add Container and Grid components ([dbdcfa3](https://github.com/lmc-eu/spirit-design-system/commit/dbdcfa3))

### Tests

- **web-twig:** Add Snapshot tests ([cf26cc6](https://github.com/lmc-eu/spirit-design-system/commit/cf26cc6))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.2.0"></a>

# [1.2.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.1.0...@lmc-eu/spirit-web-twig@1.2.0) (2021-12-15)

### Documentation

- **web-twig:** Update README ([762160d](https://github.com/lmc-eu/spirit-design-system/commit/762160d))

### Features

- **web-twig:** Extend and customize components ([322c83c](https://github.com/lmc-eu/spirit-design-system/commit/322c83c))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.1.0"></a>

# [1.1.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@1.0.0...@lmc-eu/spirit-web-twig@1.1.0) (2021-12-13)

### Documentation

- **web-twig:** Fix readme ([e990c21](https://github.com/lmc-eu/spirit-design-system/commit/e990c21))

### Features

- **web-twig:** Add support Symfony 3 ([147004a](https://github.com/lmc-eu/spirit-design-system/commit/147004a))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="1.0.0"></a>

# [1.0.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@0.1.0...@lmc-eu/spirit-web-twig@1.0.0) (2021-12-10)

### Code Refactoring

- **web-twig:** Rename bundle and move repository ([5cbe22e](https://github.com/lmc-eu/spirit-design-system/commit/5cbe22e))

### Features

- **web-twig:** Add Components into bundle & refactoring (refs #DS-87) ([f9e20ee](https://github.com/lmc-eu/spirit-design-system/commit/f9e20ee)), closes [#DS-87](https://github.com/lmc-eu/spirit-design-system/issues/DS-87)

### Tests

- **web-twig:** Upgrade tests ([eceb775](https://github.com/lmc-eu/spirit-design-system/commit/eceb775))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="0.1.0"></a>

# [0.1.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@0.0.2...@lmc-eu/spirit-web-twig@0.1.0) (2021-11-29)

### Features

- **web-twig:** Updates ([8e2011d](https://github.com/lmc-eu/spirit-design-system/commit/8e2011d))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="0.0.2"></a>

## [0.0.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-web-twig@0.0.1...@lmc-eu/spirit-web-twig@0.0.2) (2021-11-24)

### Documentation

- **web-twig:** Bugfix readme ([efb1094](https://github.com/lmc-eu/spirit-design-system/commit/efb1094))

### Features

- **web-twig:** Connect params into twig ([7d771cf](https://github.com/lmc-eu/spirit-design-system/commit/7d771cf))

### Tests

- **web-twig:** Bugfix tests ([bfeba38](https://github.com/lmc-eu/spirit-design-system/commit/bfeba38))

**Note:** Version bump only for package @lmc-eu/spirit-web-twig

<a name="0.0.1"></a>

## 0.0.1 (2021-11-24)

### Features

- **web-twig:** Initial commit ([65bb1cb](https://github.com/lmc-eu/spirit-design-system/commit/65bb1cb))
