# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

<a name="2.0.8"></a>

## [2.0.8](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@2.0.6...@lmc-eu/spirit-form-validations@2.0.8) (2024-11-25)

### Code Refactoring

- **form-validations:** Update form validations error lists ([4486006](https://github.com/lmc-eu/spirit-design-system/commit/4486006))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="2.0.7"></a>

## [2.0.7](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@2.0.5...@lmc-eu/spirit-form-validations@2.0.7) (2024-11-22)

### Chores

- **form-validations:** Manual version bump ([d3eaa7e](https://github.com/lmc-eu/spirit-design-system/commit/d3eaa7e))

### Dependencies

- Update all non-major dependencies ([188c30d](https://github.com/lmc-eu/spirit-design-system/commit/188c30d))
- Update all non-major dependencies ([da33775](https://github.com/lmc-eu/spirit-design-system/commit/da33775))
- **web, web-react, web-twig:** Implement sass-embedded library ([07df504](https://github.com/lmc-eu/spirit-design-system/commit/07df504))

<a name="2.0.6"></a>

## [2.0.6](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@2.0.5...@lmc-eu/spirit-form-validations@2.0.6) (2024-10-17)

### Documentation

- **form-validations,web,web-react:** Redesign the demo app [#DS-1479](https://github.com/lmc-eu/spirit-design-system/issues/DS-1479) ([2a2e309](https://github.com/lmc-eu/spirit-design-system/commit/2a2e309))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="2.0.5"></a>

## [2.0.5](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@2.0.4...@lmc-eu/spirit-form-validations@2.0.5) (2024-10-17)

### Dependencies

- Update all non-major dependencies ([949b633](https://github.com/lmc-eu/spirit-design-system/commit/949b633))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="2.0.4"></a>

## [2.0.4](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@2.0.3...@lmc-eu/spirit-form-validations@2.0.4) (2024-10-14)

### Bug Fixes

- **form-validations:** Fix form IDs in form-validations demo ([dbd2d5d](https://github.com/lmc-eu/spirit-design-system/commit/dbd2d5d))

### Dependencies

- Update all non-major dependencies ([97f71bd](https://github.com/lmc-eu/spirit-design-system/commit/97f71bd))
- Update all non-major dependencies ([bca6b32](https://github.com/lmc-eu/spirit-design-system/commit/bca6b32))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="2.0.3"></a>

## [2.0.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@2.0.2...@lmc-eu/spirit-form-validations@2.0.3) (2024-07-24)

### Code Refactoring

- **demo:** Switch from `docs-Section` to `UNSTABLE_Section` component ([44cfab9](https://github.com/lmc-eu/spirit-design-system/commit/44cfab9))

### Dependencies

- Update all non-major dependencies ([cca8e0a](https://github.com/lmc-eu/spirit-design-system/commit/cca8e0a))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="2.0.2"></a>

## [2.0.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@2.0.1...@lmc-eu/spirit-form-validations@2.0.2) (2024-06-26)

### Code Refactoring

- **form-validations:** Change ID naming to kebab-case ([f47a75e](https://github.com/lmc-eu/spirit-design-system/commit/f47a75e))

### Dependencies

- Update all non-major dependencies ([7876fb8](https://github.com/lmc-eu/spirit-design-system/commit/7876fb8))
- Update all non-major dependencies ([2ece372](https://github.com/lmc-eu/spirit-design-system/commit/2ece372))
- Update dependency vite to v5 ([c6d2d93](https://github.com/lmc-eu/spirit-design-system/commit/c6d2d93))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="2.0.1"></a>

## [2.0.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@2.0.0...@lmc-eu/spirit-form-validations@2.0.1) (2024-06-12)

### Styles

- **repo:** Replace unicode "heavy check mark" with "check mark" ([32f2d76](https://github.com/lmc-eu/spirit-design-system/commit/32f2d76))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="2.0.0"></a>

# [2.0.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.1.7...@lmc-eu/spirit-form-validations@2.0.0) (2024-06-10)

### BREAKING CHANGES

- **repo:** Drop support for Node.js v16 ([08788be](https://github.com/lmc-eu/spirit-design-system/commit/08788be)), closes [#DS-466](https://github.com/lmc-eu/spirit-design-system/issues/DS-466)

### Bug Fixes

- **form-validations:** Use GridItem instead of GridSpan in demo [#DS-1279](https://github.com/lmc-eu/spirit-design-system/issues/DS-1279) ([3f0ba56](https://github.com/lmc-eu/spirit-design-system/commit/3f0ba56))

### Documentation

- **repo:** Introduce new Migration Guide structure and prepare WIP guides for new versions [#DS-1218](https://github.com/lmc-eu/spirit-design-system/issues/DS-1218) ([63ab3f1](https://github.com/lmc-eu/spirit-design-system/commit/63ab3f1))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.1.7"></a>

## [1.1.7](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.1.6...@lmc-eu/spirit-form-validations@1.1.7) (2024-06-03)

### Chores

- **form-validations:** Add missing TypeScript dependency ([71948ef](https://github.com/lmc-eu/spirit-design-system/commit/71948ef))

### Dependencies

- Update all non-major dependencies ([d0625a8](https://github.com/lmc-eu/spirit-design-system/commit/d0625a8))

### Tests

- **form-validations:** Use jest-config-spirit common preset ([5436240](https://github.com/lmc-eu/spirit-design-system/commit/5436240))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.1.6"></a>

## [1.1.6](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.1.5...@lmc-eu/spirit-form-validations@1.1.6) (2024-05-20)

### Chores

- **form-validations:** Remove dev preview app from package ([ba02d34](https://github.com/lmc-eu/spirit-design-system/commit/ba02d34))

### Code Refactoring

- **form-validations:** Remove demo partials from the package ([6a989c1](https://github.com/lmc-eu/spirit-design-system/commit/6a989c1))

### Dependencies

- Update all non-major dependencies ([7b34614](https://github.com/lmc-eu/spirit-design-system/commit/7b34614))

### Documentation

- **form-validations:** Fix typo in a destroy function ([1363912](https://github.com/lmc-eu/spirit-design-system/commit/1363912))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.1.5"></a>

## [1.1.5](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.1.4...@lmc-eu/spirit-form-validations@1.1.5) (2024-04-24)

### Chores

- **repo:** Add missing jest dependency ([f313886](https://github.com/lmc-eu/spirit-design-system/commit/f313886))
- **repo:** Fix Nx settings by running `nx repair` ([4f0bc02](https://github.com/lmc-eu/spirit-design-system/commit/4f0bc02))

### Code Refactoring

- **ci:** Yarn no longer supports `pre*` and `post*` scripts ([44b8f1c](https://github.com/lmc-eu/spirit-design-system/commit/44b8f1c))

### Dependencies

- Pin dependencies ([91f46eb](https://github.com/lmc-eu/spirit-design-system/commit/91f46eb))
- Update all non-major dependencies ([1a4adb6](https://github.com/lmc-eu/spirit-design-system/commit/1a4adb6))
- Update all non-major dependencies ([10774a2](https://github.com/lmc-eu/spirit-design-system/commit/10774a2))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.1.4"></a>

## [1.1.4](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.1.3...@lmc-eu/spirit-form-validations@1.1.4) (2024-04-11)

### Dependencies

- Update all non-major dependencies ([b971d44](https://github.com/lmc-eu/spirit-design-system/commit/b971d44))

### Documentation

- **repo:** Rebrand to Alma Career ([4a9a28b](https://github.com/lmc-eu/spirit-design-system/commit/4a9a28b))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.1.3"></a>

## [1.1.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.1.2...@lmc-eu/spirit-form-validations@1.1.3) (2024-03-11)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.1.2"></a>

## [1.1.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.1.1...@lmc-eu/spirit-form-validations@1.1.2) (2024-02-20)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.1.1"></a>

## [1.1.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.1.0...@lmc-eu/spirit-form-validations@1.1.1) (2024-02-07)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.1.0"></a>

# [1.1.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.11...@lmc-eu/spirit-form-validations@1.1.0) (2024-01-30)

### Features

- **demo,web,web-react,form-validations:** Set font-display to block in google fonts load ([258d9e9](https://github.com/lmc-eu/spirit-design-system/commit/258d9e9))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.11"></a>

## [1.0.11](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.10...@lmc-eu/spirit-form-validations@1.0.11) (2024-01-17)

### Reverts

- **form-validations:** Move `common` files back to the package ([ba0c3ab](https://github.com/lmc-eu/spirit-design-system/commit/ba0c3ab))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.10"></a>

## [1.0.10](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.9...@lmc-eu/spirit-form-validations@1.0.10) (2024-01-12)

### Chores

- **form-validations:** Use common local server configuration ([6dbd751](https://github.com/lmc-eu/spirit-design-system/commit/6dbd751)), closes [#DS-1093](https://github.com/lmc-eu/spirit-design-system/issues/DS-1093)

### Code Refactoring

- **form-validations:** Use `warning` utility instead of console ([d0ff3ce](https://github.com/lmc-eu/spirit-design-system/commit/d0ff3ce))

### Dependencies

- Update all non-major dependencies ([67f8357](https://github.com/lmc-eu/spirit-design-system/commit/67f8357))
- Update all non-major dependencies ([04252f1](https://github.com/lmc-eu/spirit-design-system/commit/04252f1))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.9"></a>

## [1.0.9](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.8...@lmc-eu/spirit-form-validations@1.0.9) (2023-12-05)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.8"></a>

## [1.0.8](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.7...@lmc-eu/spirit-form-validations@1.0.8) (2023-11-18)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.7"></a>

## [1.0.7](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.6...@lmc-eu/spirit-form-validations@1.0.7) (2023-11-15)

### Dependencies

- Update all non-major dependencies ([828bc68](https://github.com/lmc-eu/spirit-design-system/commit/828bc68))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.6"></a>

## [1.0.6](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.5...@lmc-eu/spirit-form-validations@1.0.6) (2023-11-02)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.5"></a>

## [1.0.5](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.4...@lmc-eu/spirit-form-validations@1.0.5) (2023-10-25)

### Dependencies

- Update all non-major dependencies ([e7b6413](https://github.com/lmc-eu/spirit-design-system/commit/e7b6413))
- Update all non-major dependencies ([f8e1a11](https://github.com/lmc-eu/spirit-design-system/commit/f8e1a11))
- Update dependency @lmc-eu/browserslist-config to v2 ([29d7a59](https://github.com/lmc-eu/spirit-design-system/commit/29d7a59))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.4"></a>

## [1.0.4](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.3...@lmc-eu/spirit-form-validations@1.0.4) (2023-09-26)

### Code Refactoring

- **form-validations:** Use demo package css instead of own ([771066e](https://github.com/lmc-eu/spirit-design-system/commit/771066e))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.3"></a>

## [1.0.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.2...@lmc-eu/spirit-form-validations@1.0.3) (2023-09-06)

### Dependencies

- Update all non-major dependencies ([2ed3156](https://github.com/lmc-eu/spirit-design-system/commit/2ed3156))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.2"></a>

## [1.0.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.1...@lmc-eu/spirit-form-validations@1.0.2) (2023-08-23)

### Dependencies

- Update all non-major dependencies ([acba328](https://github.com/lmc-eu/spirit-design-system/commit/acba328))
- Update dependency @testing-library/jest-dom to v6 ([d21b678](https://github.com/lmc-eu/spirit-design-system/commit/d21b678))

### Documentation

- **form-validations, web-react, web-twig:** Sort props in tables ([4d8fb15](https://github.com/lmc-eu/spirit-design-system/commit/4d8fb15))
- **form-validations, web, web-twig, web-react:** Unify unicode characters in API tables ([8c837eb](https://github.com/lmc-eu/spirit-design-system/commit/8c837eb))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.1"></a>

## [1.0.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@1.0.0...@lmc-eu/spirit-form-validations@1.0.1) (2023-08-09)

### Dependencies

- Update all non-major dependencies ([19335a3](https://github.com/lmc-eu/spirit-design-system/commit/19335a3))

### Documentation

- **web,web-twig:** Mark visual-only examples in `FileUploader` demo ([27b3533](https://github.com/lmc-eu/spirit-design-system/commit/27b3533))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="1.0.0"></a>

# [1.0.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@0.2.5...@lmc-eu/spirit-form-validations@1.0.0) (2023-07-21)

### BREAKING CHANGES

- **form-validation:** Add `spirit` infix to `data-element` in Validation Text [#DS-585](https://github.com/lmc-eu/spirit-design-system/issues/DS-585) ([0228281](https://github.com/lmc-eu/spirit-design-system/commit/0228281))
- **form-validations:** Rename `validator_message` to `validation_text` [#DS-838](https://github.com/lmc-eu/spirit-design-system/issues/DS-838) ([b87f302](https://github.com/lmc-eu/spirit-design-system/commit/b87f302))

### Documentation

- **form-validations:** Introduce migration guide for v1 refs [#DS-800](https://github.com/lmc-eu/spirit-design-system/issues/DS-800) ([027004b](https://github.com/lmc-eu/spirit-design-system/commit/027004b))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="0.2.5"></a>

## [0.2.5](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@0.2.4...@lmc-eu/spirit-form-validations@0.2.5) (2023-07-21)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="0.2.4"></a>

## [0.2.4](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@0.2.3...@lmc-eu/spirit-form-validations@0.2.4) (2023-07-02)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="0.2.3"></a>

## [0.2.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@0.2.2...@lmc-eu/spirit-form-validations@0.2.3) (2023-06-29)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="0.2.2"></a>

## [0.2.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@0.2.1...@lmc-eu/spirit-form-validations@0.2.2) (2023-06-28)

### Dependencies

- Update all non-major dependencies ([ba23f3d](https://github.com/lmc-eu/spirit-design-system/commit/ba23f3d))
- Update all non-major dependencies ([c70b276](https://github.com/lmc-eu/spirit-design-system/commit/c70b276))

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="0.2.1"></a>

## [0.2.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-form-validations@0.2.0...@lmc-eu/spirit-form-validations@0.2.1) (2023-06-11)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-form-validations

<a name="0.2.0"></a>

# 0.2.0 (2023-05-29)

### Bug Fixes

- **form-validations:** Attach validation text to different parent on checkbox ([d248bdf](https://github.com/lmc-eu/spirit-design-system/commit/d248bdf)), closes [#DS-787](https://github.com/lmc-eu/spirit-design-system/issues/DS-787)
- **form-validations:** Remove default success class ([cd33508](https://github.com/lmc-eu/spirit-design-system/commit/cd33508))
- **form-validations:** Use `span` for checkbox validation text wrapper ([ba7c115](https://github.com/lmc-eu/spirit-design-system/commit/ba7c115))
- **form-validations:** Validator value can be multiple strings ([2d5be0f](https://github.com/lmc-eu/spirit-design-system/commit/2d5be0f)), closes [#DS-667](https://github.com/lmc-eu/spirit-design-system/issues/DS-667)

### Chores

- **form-validations:** Prepare distirbution build ([a326918](https://github.com/lmc-eu/spirit-design-system/commit/a326918)), closes [#DS-608](https://github.com/lmc-eu/spirit-design-system/issues/DS-608), [#366](https://github.com/lmc-eu/spirit-design-system/issues/366)
- **form-validations:** Update spirit-web and spirit-design-tokens versions ([262ff00](https://github.com/lmc-eu/spirit-design-system/commit/262ff00))

### Code Refactoring

- **form-validations:** Add better types and remove ignores ([187fa55](https://github.com/lmc-eu/spirit-design-system/commit/187fa55)), closes [#DS-667](https://github.com/lmc-eu/spirit-design-system/issues/DS-667)
- **form-validations:** Check if input is of type Boolean ([7171efa](https://github.com/lmc-eu/spirit-design-system/commit/7171efa)), closes [#DS-667](https://github.com/lmc-eu/spirit-design-system/issues/DS-667)
- **form-validations:** Move constructor logic into methods ([8662cef](https://github.com/lmc-eu/spirit-design-system/commit/8662cef)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)
- **form-validations:** Move types into separate file ([0b7e9b3](https://github.com/lmc-eu/spirit-design-system/commit/0b7e9b3)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)
- **form-validations:** Rename `fn` abbreviation to `validatorCallback` ([dd0bbc0](https://github.com/lmc-eu/spirit-design-system/commit/dd0bbc0))
- **form-validations:** Rename `msg` abbreviation to `message` ([d0034e2](https://github.com/lmc-eu/spirit-design-system/commit/d0034e2))
- **form-validations:** Use data attribute prefix as constant ([5c18bf6](https://github.com/lmc-eu/spirit-design-system/commit/5c18bf6)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)

### Documentation

- **form-validations:** Add custom error messages demo ([ec69564](https://github.com/lmc-eu/spirit-design-system/commit/ec69564))
- **form-validations:** Add global custom validator demo ([cd826dc](https://github.com/lmc-eu/spirit-design-system/commit/cd826dc))
- **form-validations:** Add specific field validator demo ([60815c9](https://github.com/lmc-eu/spirit-design-system/commit/60815c9))
- **form-validations:** Attach event listeners in loop on demo page ([94b75ae](https://github.com/lmc-eu/spirit-design-system/commit/94b75ae))
- **form-validations:** Fix badly named data attributes for default validators ([0fc82cb](https://github.com/lmc-eu/spirit-design-system/commit/0fc82cb))
- **form-validations:** Fix checkbox message by adding missing input name ([7452fbf](https://github.com/lmc-eu/spirit-design-system/commit/7452fbf)), closes [#DS-787](https://github.com/lmc-eu/spirit-design-system/issues/DS-787)
- **form-validations:** Fix zip code pattern to support czech zip code ([155cc06](https://github.com/lmc-eu/spirit-design-system/commit/155cc06))
- **form-validations:** Introduce basic documentation ([36096f1](https://github.com/lmc-eu/spirit-design-system/commit/36096f1)), closes [#DS-608](https://github.com/lmc-eu/spirit-design-system/issues/DS-608), [#366](https://github.com/lmc-eu/spirit-design-system/issues/366)
- **form-validations:** Introduce examples of validated forms ([e832625](https://github.com/lmc-eu/spirit-design-system/commit/e832625)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)
- **form-validations:** Public API methods `validate` and `getErrors` ([b26d65b](https://github.com/lmc-eu/spirit-design-system/commit/b26d65b)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)

### Features

- **form-validation:** Initial implementation of validations ([8065bd3](https://github.com/lmc-eu/spirit-design-system/commit/8065bd3)), closes [#DS-608](https://github.com/lmc-eu/spirit-design-system/issues/DS-608), [#366](https://github.com/lmc-eu/spirit-design-system/issues/366)
- **form-validations:** Ability to add custom validator ([100229f](https://github.com/lmc-eu/spirit-design-system/commit/100229f)), closes [#DS-667](https://github.com/lmc-eu/spirit-design-system/issues/DS-667)
- **form-validations:** Ability to add error to field ([13722dd](https://github.com/lmc-eu/spirit-design-system/commit/13722dd)), closes [#DS-667](https://github.com/lmc-eu/spirit-design-system/issues/DS-667)
- **form-validations:** Ability to reset end destroy validations ([41877fc](https://github.com/lmc-eu/spirit-design-system/commit/41877fc)), closes [#DS-667](https://github.com/lmc-eu/spirit-design-system/issues/DS-667)
- **form-validations:** Add min/max length validation ([740630c](https://github.com/lmc-eu/spirit-design-system/commit/740630c)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)
- **form-validations:** Add missing default validation texts ([8a5bd1d](https://github.com/lmc-eu/spirit-design-system/commit/8a5bd1d)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)
- **form-validations:** Introduce new package refs [#DS-608](https://github.com/lmc-eu/spirit-design-system/issues/DS-608),[#366](https://github.com/lmc-eu/spirit-design-system/issues/366) ([663b39e](https://github.com/lmc-eu/spirit-design-system/commit/663b39e))
- **form-validations:** Set custom languages and locale ([f29658f](https://github.com/lmc-eu/spirit-design-system/commit/f29658f)), closes [#DS-667](https://github.com/lmc-eu/spirit-design-system/issues/DS-667)
- **form-validations:** Style Validations examples ([d875d29](https://github.com/lmc-eu/spirit-design-system/commit/d875d29))
- **form-validations:** Text is always valid ([0ce7f92](https://github.com/lmc-eu/spirit-design-system/commit/0ce7f92)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)
- **form-validations:** Validate input types ([129fc12](https://github.com/lmc-eu/spirit-design-system/commit/129fc12)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)
- **form-validation:** Validate min/max of input type number ([ece9c6e](https://github.com/lmc-eu/spirit-design-system/commit/ece9c6e)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)

### Styles

- **form-validations:** Fix JSDoc comment ([dd4cb3e](https://github.com/lmc-eu/spirit-design-system/commit/dd4cb3e))
- **form-validations:** Fix types ([723cedb](https://github.com/lmc-eu/spirit-design-system/commit/723cedb)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)
- **form-validations:** Introduce ESlint configuration ([84c7ef6](https://github.com/lmc-eu/spirit-design-system/commit/84c7ef6)), closes [#DS-608](https://github.com/lmc-eu/spirit-design-system/issues/DS-608), [#366](https://github.com/lmc-eu/spirit-design-system/issues/366)

### Tests

- **form-validations:** Fix types ([bb6e458](https://github.com/lmc-eu/spirit-design-system/commit/bb6e458)), closes [#DS-667](https://github.com/lmc-eu/spirit-design-system/issues/DS-667)
- **form-validations:** Required validation ([6960deb](https://github.com/lmc-eu/spirit-design-system/commit/6960deb)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)
- **form-validations:** Setup unit tests using Jest ([f5df502](https://github.com/lmc-eu/spirit-design-system/commit/f5df502)), closes [#DS-665](https://github.com/lmc-eu/spirit-design-system/issues/DS-665)

**Note:** Version bump only for package @lmc-eu/spirit-form-validations
