# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

<a name="3.0.1"></a>

## [3.0.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@3.0.0...@lmc-eu/spirit-design-tokens@3.0.1) (2024-12-16)

### Styles

- **common, codemods, analytics, design-tokens:** Fix docs by markdown linter ([f5941f7](https://github.com/lmc-eu/spirit-design-system/commit/f5941f7))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="3.0.0"></a>

# [3.0.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@3.0.0-alpha.3...@lmc-eu/spirit-design-tokens@3.0.0) (2024-11-25)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="3.0.0-alpha.3"></a>

# [3.0.0-alpha.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@3.0.0-alpha.2...@lmc-eu/spirit-design-tokens@3.0.0-alpha.3) (2024-11-25)

### Chores

- **design-tokens:** Force Publish

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="3.0.0-alpha.2"></a>

# [3.0.0-alpha.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@3.0.0-alpha.1...@lmc-eu/spirit-design-tokens@3.0.0-alpha.2) (2024-11-13)

### Chores

- **design-tokens:** Force Publish

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="3.0.0-alpha.1"></a>

# [3.0.0-alpha.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@3.0.0-alpha.0...@lmc-eu/spirit-design-tokens@3.0.0-alpha.1) (2024-11-06)

### Chores

- **design-tokens:** Force Publish

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="3.0.0-alpha.0"></a>

# [3.0.0-alpha.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@2.1.2...@lmc-eu/spirit-design-tokens@3.0.0-alpha.0) (2024-10-17)

### BREAKING CHANGES

- **design-tokens:** Introduce new design tokens structure [#DS-1430](https://github.com/lmc-eu/spirit-design-system/issues/DS-1430) ([1cbfaf0](https://github.com/lmc-eu/spirit-design-system/commit/1cbfaf0))

<a name="2.1.3"></a>

## [2.1.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@2.1.2...@lmc-eu/spirit-design-tokens@2.1.3) (2024-11-22)

### Dependencies

- Update all non-major dependencies ([188c30d](https://github.com/lmc-eu/spirit-design-system/commit/188c30d))
- Update all non-major dependencies ([da33775](https://github.com/lmc-eu/spirit-design-system/commit/da33775))
- **web, web-react, web-twig:** Implement sass-embedded library ([07df504](https://github.com/lmc-eu/spirit-design-system/commit/07df504))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="2.1.2"></a>

## [2.1.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@2.1.1...@lmc-eu/spirit-design-tokens@2.1.2) (2024-10-17)

### Dependencies

- Update all non-major dependencies ([949b633](https://github.com/lmc-eu/spirit-design-system/commit/949b633))
- Update dependency vite-plugin-dts to v4 ([fa6a656](https://github.com/lmc-eu/spirit-design-system/commit/fa6a656))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="2.1.1"></a>

## [2.1.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@2.1.0...@lmc-eu/spirit-design-tokens@2.1.1) (2024-10-14)

### Bug Fixes

- **design-tokens:** Fix eslint configuration [#DS-1503](https://github.com/lmc-eu/spirit-design-system/issues/DS-1503) ([dd91257](https://github.com/lmc-eu/spirit-design-system/commit/dd91257))

### Dependencies

- Update all non-major dependencies ([97f71bd](https://github.com/lmc-eu/spirit-design-system/commit/97f71bd))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="2.1.0"></a>

# [2.1.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@2.0.3...@lmc-eu/spirit-design-tokens@2.1.0) (2024-09-09)

### Chores

- **design-tokens:** Rename Vite config to use mts extension becuase of deprecated api ([6b79588](https://github.com/lmc-eu/spirit-design-system/commit/6b79588))
- **design-tokens:** Use Node module resolution to fix the problem with Vite build ([083b245](https://github.com/lmc-eu/spirit-design-system/commit/083b245))

### Dependencies

- Update all non-major dependencies ([bca6b32](https://github.com/lmc-eu/spirit-design-system/commit/bca6b32))
- Update dependency stylelint to v16 ([e3b7ae6](https://github.com/lmc-eu/spirit-design-system/commit/e3b7ae6))

### Features

- **design-tokens:** Update JS Design Tokens manually [#DS-1394](https://github.com/lmc-eu/spirit-design-system/issues/DS-1394) ([217a330](https://github.com/lmc-eu/spirit-design-system/commit/217a330))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="2.0.3"></a>

## [2.0.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@2.0.2...@lmc-eu/spirit-design-tokens@2.0.3) (2024-07-24)

### Dependencies

- Update all non-major dependencies ([cca8e0a](https://github.com/lmc-eu/spirit-design-system/commit/cca8e0a))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="2.0.2"></a>

## [2.0.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@2.0.1...@lmc-eu/spirit-design-tokens@2.0.2) (2024-06-26)

### Chores

- **design-tokens:** Use sharable Stylelint configuratio ([d6f7f7f](https://github.com/lmc-eu/spirit-design-system/commit/d6f7f7f))

### Dependencies

- Update all non-major dependencies ([7876fb8](https://github.com/lmc-eu/spirit-design-system/commit/7876fb8))
- Update dependency npm-run-all2 to v6 ([1553070](https://github.com/lmc-eu/spirit-design-system/commit/1553070))
- Update dependency vite to v5 ([c6d2d93](https://github.com/lmc-eu/spirit-design-system/commit/c6d2d93))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="2.0.1"></a>

## [2.0.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@2.0.0...@lmc-eu/spirit-design-tokens@2.0.1) (2024-06-12)

### Styles

- **repo:** Reformat docs using Prettier v3 ([670757d](https://github.com/lmc-eu/spirit-design-system/commit/670757d))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="2.0.0"></a>

# [2.0.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@1.1.6...@lmc-eu/spirit-design-tokens@2.0.0) (2024-06-10)

### BREAKING CHANGES

- **design-tokens:** Rename Gradient token `--angle` var to `--gradient-angle` [#DS-1105](https://github.com/lmc-eu/spirit-design-system/issues/DS-1105) ([8705888](https://github.com/lmc-eu/spirit-design-system/commit/8705888))
- **repo:** Drop support for Node.js v16 ([08788be](https://github.com/lmc-eu/spirit-design-system/commit/08788be)), closes [#DS-466](https://github.com/lmc-eu/spirit-design-system/issues/DS-466)

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="1.1.6"></a>

## [1.1.6](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@1.1.5...@lmc-eu/spirit-design-tokens@1.1.6) (2024-05-20)

### Dependencies

- Update all non-major dependencies ([7b34614](https://github.com/lmc-eu/spirit-design-system/commit/7b34614))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="1.1.5"></a>

## [1.1.5](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@1.1.4...@lmc-eu/spirit-design-tokens@1.1.5) (2024-04-24)

### Code Refactoring

- **ci:** Yarn no longer supports `pre*` and `post*` scripts ([44b8f1c](https://github.com/lmc-eu/spirit-design-system/commit/44b8f1c))

### Dependencies

- **repo:** Switch from `npm-run-all` to `npm-run-all2` fork ([b857115](https://github.com/lmc-eu/spirit-design-system/commit/b857115))
- Update all non-major dependencies ([1a4adb6](https://github.com/lmc-eu/spirit-design-system/commit/1a4adb6))
- Update all non-major dependencies ([10774a2](https://github.com/lmc-eu/spirit-design-system/commit/10774a2))

### Styles

- **design-tokens:** Fix color hex length to `short` ([9a2c498](https://github.com/lmc-eu/spirit-design-system/commit/9a2c498))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="1.1.4"></a>

## [1.1.4](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@1.1.3...@lmc-eu/spirit-design-tokens@1.1.4) (2024-04-11)

### Dependencies

- Update all non-major dependencies ([b971d44](https://github.com/lmc-eu/spirit-design-system/commit/b971d44))

### Documentation

- **repo:** Rebrand to Alma Career ([4a9a28b](https://github.com/lmc-eu/spirit-design-system/commit/4a9a28b))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="1.1.3"></a>

## [1.1.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@1.1.2...@lmc-eu/spirit-design-tokens@1.1.3) (2024-01-12)

### Chores

- **design-tokens:** Fix subdirectory path while build from root ([f8992d4](https://github.com/lmc-eu/spirit-design-system/commit/f8992d4))

### Dependencies

- Update all non-major dependencies ([67f8357](https://github.com/lmc-eu/spirit-design-system/commit/67f8357))
- Update all non-major dependencies ([04252f1](https://github.com/lmc-eu/spirit-design-system/commit/04252f1))
- Update dependency typescript to v5 ([0d99d02](https://github.com/lmc-eu/spirit-design-system/commit/0d99d02))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="1.1.2"></a>

## [1.1.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@1.1.1...@lmc-eu/spirit-design-tokens@1.1.2) (2023-12-05)

### Bug Fixes

- **design-tokens:** Remove `exports` field block build on product applications ([4307f68](https://github.com/lmc-eu/spirit-design-system/commit/4307f68))

### Dependencies

- Pin dependencies ([c0ec4aa](https://github.com/lmc-eu/spirit-design-system/commit/c0ec4aa))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="1.1.1"></a>

## [1.1.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@1.1.0...@lmc-eu/spirit-design-tokens@1.1.1) (2023-11-18)

### Bug Fixes

- **design-tokens:** Use `sass` condition in `exports` field ([acc13ae](https://github.com/lmc-eu/spirit-design-system/commit/acc13ae))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="1.1.0"></a>

# [1.1.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@1.0.3...@lmc-eu/spirit-design-tokens@1.1.0) (2023-11-15)

### Chores

- **design-tokens:** Introduce distribution process for JS files ([af09f2f](https://github.com/lmc-eu/spirit-design-system/commit/af09f2f)), closes [#DS-1012](https://github.com/lmc-eu/spirit-design-system/issues/DS-1012)

### Features

- **design-tokens:** Introduce structure of exported tokens to JS ([529d27e](https://github.com/lmc-eu/spirit-design-system/commit/529d27e))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="1.0.3"></a>

## [1.0.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@1.0.2...@lmc-eu/spirit-design-tokens@1.0.3) (2023-10-25)

### Dependencies

- Update all non-major dependencies ([e7b6413](https://github.com/lmc-eu/spirit-design-system/commit/e7b6413))
- Update dependency @lmc-eu/stylelint-config to v7 ([ff26da7](https://github.com/lmc-eu/spirit-design-system/commit/ff26da7))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="1.0.2"></a>

## [1.0.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@1.0.1...@lmc-eu/spirit-design-tokens@1.0.2) (2023-09-06)

### Dependencies

- Update all non-major dependencies ([2ed3156](https://github.com/lmc-eu/spirit-design-system/commit/2ed3156))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="1.0.1"></a>

## [1.0.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@1.0.0...@lmc-eu/spirit-design-tokens@1.0.1) (2023-08-09)

### Dependencies

- Update all non-major dependencies ([19335a3](https://github.com/lmc-eu/spirit-design-system/commit/19335a3))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="1.0.0"></a>

# [1.0.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.25.5...@lmc-eu/spirit-design-tokens@1.0.0) (2023-07-21)

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.25.5"></a>

## [0.25.5](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.25.4...@lmc-eu/spirit-design-tokens@0.25.5) (2023-06-28)

### Dependencies

- Update all non-major dependencies ([ba23f3d](https://github.com/lmc-eu/spirit-design-system/commit/ba23f3d))
- Update all non-major dependencies ([c70b276](https://github.com/lmc-eu/spirit-design-system/commit/c70b276))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.25.4"></a>

## [0.25.4](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.25.3...@lmc-eu/spirit-design-tokens@0.25.4) (2023-05-18)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.25.3"></a>

## [0.25.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.25.2...@lmc-eu/spirit-design-tokens@0.25.3) (2023-04-17)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.25.2"></a>

## [0.25.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.25.1...@lmc-eu/spirit-design-tokens@0.25.2) (2023-02-13)

### Dependencies

- Update dependency @lmc-eu/stylelint-config to v6 ([32caf4a](https://github.com/lmc-eu/spirit-design-system/commit/32caf4a))
- Update dependency stylelint to v15 ([55f379a](https://github.com/lmc-eu/spirit-design-system/commit/55f379a))
- Update dependency stylelint-order to v6 ([91e09c1](https://github.com/lmc-eu/spirit-design-system/commit/91e09c1))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.25.1"></a>

## [0.25.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.25.0...@lmc-eu/spirit-design-tokens@0.25.1) (2023-02-09)

### Dependencies

- Update all non-major dependencies ([190529b](https://github.com/lmc-eu/spirit-design-system/commit/190529b))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.25.0"></a>

# [0.25.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.24.0...@lmc-eu/spirit-design-tokens@0.25.0) (2023-02-01)

### Features

- **design-tokens:** Introduce xlarge size token for body text ([5133ca9](https://github.com/lmc-eu/spirit-design-system/commit/5133ca9))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.24.0"></a>

# [0.24.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.23.0...@lmc-eu/spirit-design-tokens@0.24.0) (2022-12-16)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.23.0"></a>

# [0.23.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.22.0...@lmc-eu/spirit-design-tokens@0.23.0) (2022-11-07)

### Dependencies

- Update all non-major dependencies ([48cac89](https://github.com/lmc-eu/spirit-design-system/commit/48cac89))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.22.0"></a>

# [0.22.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.21.0...@lmc-eu/spirit-design-tokens@0.22.0) (2022-10-13)

### Dependencies

- Pin dependency @lmc-eu/stylelint-config to 5.0.0 ([674a405](https://github.com/lmc-eu/spirit-design-system/commit/674a405))

### Styles

- **web:** Upgrade stylelint config and fix errors [#DS-322](https://github.com/lmc-eu/spirit-design-system/issues/DS-322) ([4df87da](https://github.com/lmc-eu/spirit-design-system/commit/4df87da))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.21.0"></a>

# [0.21.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.20.0...@lmc-eu/spirit-design-tokens@0.21.0) (2022-09-22)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.20.0"></a>

# [0.20.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.19.0...@lmc-eu/spirit-design-tokens@0.20.0) (2022-08-31)

### Dependencies

- Update all non-major dependencies ([28d33a2](https://github.com/lmc-eu/spirit-design-system/commit/28d33a2))

### Features

- Add shx package to cross-platform commands ([9c358ef](https://github.com/lmc-eu/spirit-design-system/commit/9c358ef))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.19.0"></a>

# [0.19.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.18.0...@lmc-eu/spirit-design-tokens@0.19.0) (2022-07-30)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.18.0"></a>

# [0.18.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.17.0...@lmc-eu/spirit-design-tokens@0.18.0) (2022-06-23)

### Dependencies

- Update all non-major dependencies ([493b4d7](https://github.com/lmc-eu/spirit-design-system/commit/493b4d7))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.17.0"></a>

# [0.17.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.16.0...@lmc-eu/spirit-design-tokens@0.17.0) (2022-06-06)

### Dependencies

- Update all non-major dependencies ([2de1f66](https://github.com/lmc-eu/spirit-design-system/commit/2de1f66))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.16.0"></a>

# [0.16.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.15.0...@lmc-eu/spirit-design-tokens@0.16.0) (2022-05-19)

### Dependencies

- Update all non-major dependencies ([1cefb14](https://github.com/lmc-eu/spirit-design-system/commit/1cefb14))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.15.0"></a>

# [0.15.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.14.0...@lmc-eu/spirit-design-tokens@0.15.0) (2022-05-02)

### Dependencies

- Update all non-major dependencies ([d6efb47](https://github.com/lmc-eu/spirit-design-system/commit/d6efb47))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.14.0"></a>

# [0.14.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.13.0...@lmc-eu/spirit-design-tokens@0.14.0) (2022-04-25)

### Dependencies

- Update all non-major dependencies ([db90539](https://github.com/lmc-eu/spirit-design-system/commit/db90539))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.13.0"></a>

# [0.13.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.12.0...@lmc-eu/spirit-design-tokens@0.13.0) (2022-04-13)

### Documentation

- **design-tokens:** Add missing node_modules in sass loader configuration ([ddb40e7](https://github.com/lmc-eu/spirit-design-system/commit/ddb40e7))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.12.0"></a>

# [0.12.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.11.0...@lmc-eu/spirit-design-tokens@0.12.0) (2022-03-31)

### Dependencies

- Update all non-major dependencies ([211daef](https://github.com/lmc-eu/spirit-design-system/commit/211daef))
- Update dependency @lmc-eu/stylelint-config to v4 ([53c825b](https://github.com/lmc-eu/spirit-design-system/commit/53c825b))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.11.0"></a>

# [0.11.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.10.0...@lmc-eu/spirit-design-tokens@0.11.0) (2022-03-28)

### Features

- Updated styles and tokens ([ac3cc0c](https://github.com/lmc-eu/spirit-design-system/commit/ac3cc0c))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.10.0"></a>

# [0.10.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.9.0...@lmc-eu/spirit-design-tokens@0.10.0) (2022-03-22)

### Dependencies

- Update all non-major dependencies ([3fd178b](https://github.com/lmc-eu/spirit-design-system/commit/3fd178b))
- Update dependency @lmc-eu/stylelint-config to v3.0.1 ([f43d4f6](https://github.com/lmc-eu/spirit-design-system/commit/f43d4f6))
- Update dependency stylelint to v14 ([cf14c4b](https://github.com/lmc-eu/spirit-design-system/commit/cf14c4b))
- Update dependency stylelint-order to v5 ([97664aa](https://github.com/lmc-eu/spirit-design-system/commit/97664aa))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.9.0"></a>

# [0.9.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.8.0...@lmc-eu/spirit-design-tokens@0.9.0) (2022-03-11)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.8.0"></a>

# [0.8.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.7.0...@lmc-eu/spirit-design-tokens@0.8.0) (2022-02-26)

### Chores

- **release:** Publish [ci-skip] ([a11c055](https://github.com/lmc-eu/spirit-design-system/commit/a11c055))

### Dependencies

- Update dependency @lmc-eu/stylelint-config to v3 ([18cfc75](https://github.com/lmc-eu/spirit-design-system/commit/18cfc75))

### Features

- Implement Grid component to spirit-web and showcase it in demo ([329b28b](https://github.com/lmc-eu/spirit-design-system/commit/329b28b))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.7.0"></a>

# [0.7.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.6.0...@lmc-eu/spirit-design-tokens@0.7.0) (2022-02-18)

### Chores

- Prefer javascript for configuration if possible ([328d6f1](https://github.com/lmc-eu/spirit-design-system/commit/328d6f1))

### Dependencies

- Bump @lmc-eu/stylelint-config from 1.0.4 to 2.0.2 ([5989cd1](https://github.com/lmc-eu/spirit-design-system/commit/5989cd1))
- Pin dependencies ([dc33b40](https://github.com/lmc-eu/spirit-design-system/commit/dc33b40))
- Update all non-major dependencies ([a2289eb](https://github.com/lmc-eu/spirit-design-system/commit/a2289eb))

### Documentation

- Improve docs for both users and contributors ([2c37796](https://github.com/lmc-eu/spirit-design-system/commit/2c37796))

### Features

- Add background interactive color tokens and update disabled color ([15da8e2](https://github.com/lmc-eu/spirit-design-system/commit/15da8e2))
- Implement Container component to spirit-web and showcase it in demo ([e05b367](https://github.com/lmc-eu/spirit-design-system/commit/e05b367))

### Styles

- Reformat changelogs using Prettier ([2491f02](https://github.com/lmc-eu/spirit-design-system/commit/2491f02))

**Note:** Version bump only for package @lmc-eu/spirit-design-tokens

<a name="0.6.0"></a>

## [0.6.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.5.0...@lmc-eu/spirit-design-tokens@0.6.0) (2022-01-12)

### Documentation

- **design-tokens:** Include changelog ([de526ae](https://github.com/lmc-eu/spirit-design-system/commit/de526ae))
- **license:** Include license file ([8f0af0a](https://github.com/lmc-eu/spirit-design-system/commit/8f0af0a))

### Features

- Add background backdrop token ([9b5f0cd](https://github.com/lmc-eu/spirit-design-system/commit/9b5f0cd))
- Add breakpoints to tokens ([c4290c2](https://github.com/lmc-eu/spirit-design-system/commit/c4290c2))
- Split border tokens and subtract border width value from button paddings ([dfbf6ac](https://github.com/lmc-eu/spirit-design-system/commit/dfbf6ac))

### Styles

- Reformat codebase using code formatter ([a2abf71](https://github.com/lmc-eu/spirit-design-system/commit/a2abf71))

<a name="0.5.0"></a>

## [0.5.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.4.5...@lmc-eu/spirit-design-tokens@0.5.0) (2021-12-21)

### BREAKING CHANGES

- Remove `$border-main-selected` color ([d650659](https://github.com/lmc-eu/spirit-design-system/commit/d650659))

### Chores

- **web-react**: Instroduce `test` script ([7fe668c](https://github.com/lmc-eu/spirit-design-system/commit/7fe668c))
- Add eslint with its configuration to react package and add linters to GitHub workflow ([47b21c3](https://github.com/lmc-eu/spirit-design-system/commit/47b21c3))

### Features

- Synchronize color scales with designers ([42c2a30](https://github.com/lmc-eu/spirit-design-system/commit/42c2a30))

<a name="0.4.5"></a>

## [0.4.5](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.4.4...@lmc-eu/spirit-design-tokens@0.4.5) (2021-12-02)

### Bug Fixes

- **design-tokens:** Declare style even for hidden border so it's consistent with other border styles ([22047be](https://github.com/lmc-eu/spirit-design-system/commit/22047be))

### Features

- Update button style. Add new font-weight token ([c142c2e](https://github.com/lmc-eu/spirit-design-system/commit/c142c2e))
- Update color palette according to Figma and use same naming ([87266da](https://github.com/lmc-eu/spirit-design-system/commit/87266da))

<a name="0.4.4"></a>

## [0.4.4](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.4.3...@lmc-eu/spirit-design-tokens@0.4.4) (2021-11-24)

### Bug Fixes

- Render text with `sans-serif` when Inter font is not available ([9c64a16](https://github.com/lmc-eu/spirit-design-system/commit/9c64a16))

<a name="0.4.3"></a>

## [0.4.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.4.2...@lmc-eu/spirit-design-tokens@0.4.3) (2021-11-13)

### Chores

- Declare path to repository in package.json ([d337221](https://github.com/lmc-eu/spirit-design-system/commit/d337221))

<a name="0.4.2"></a>

## [0.4.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.4.1...@lmc-eu/spirit-design-tokens@0.4.2) (2021-10-21)

### Features

- Add border design tokens ([4791b5c](https://github.com/lmc-eu/spirit-design-system/commit/4791b5c))

<a name="0.4.1"></a>

## [0.4.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.4.0...@lmc-eu/spirit-design-tokens@0.4.1) (2021-10-20)

### BREAKING CHANGES

- Remove product specific design tokens and CSS from Spirit packages ([0767891](https://github.com/lmc-eu/spirit-design-system/commit/0767891))
  - They will be managed by product teams.
  - Change Jobs demo to custom branding example with overridden design tokens and a Sass pipeline.

### Bug Fixes

- Make all design token categories configurable by adding `!default` flag ([df67132](https://github.com/lmc-eu/spirit-design-system/commit/df67132))

<a name="0.4.0"></a>

## [0.4.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.3.0...@lmc-eu/spirit-design-tokens@0.4.0) (2021-10-07)

### Features

- Introduce `spirit-design-tokens` package with default branding in Sass ([930e07e](https://github.com/lmc-eu/spirit-design-system/commit/930e07e))

<a name="0.3.0"></a>

## [0.3.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.2.0...@lmc-eu/spirit-design-tokens@0.3.0) (2021-09-30)

### BREAKING CHANGES

- Prefix replaceable Sass modules with `@` to mark their special loading behavior ([ea775bd](https://github.com/lmc-eu/spirit-design-system/commit/ea775bd))

<a name="0.2.0"></a>

## [0.2.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-design-tokens@0.1.0...@lmc-eu/spirit-design-tokens@0.2.0) (2021-09-22)

### Code Refactoring

- Keep source for publishing in `dist` directory in all packages ([31cc3af](https://github.com/lmc-eu/spirit-design-system/commit/31cc3af))

### Features

- Extend Jobs design tokens ([b4d97aa](https://github.com/lmc-eu/spirit-design-system/commit/b4d97aa))
- Introduce branding to the `web` package ([c42bb53](https://github.com/lmc-eu/spirit-design-system/commit/c42bb53))
- Switch color config to color scales ([f302688](https://github.com/lmc-eu/spirit-design-system/commit/f302688))
- Update Design Tokens according to the current state of Figma tokens ([5c04041](https://github.com/lmc-eu/spirit-design-system/commit/5c04041))

<a name="0.1.0"></a>

## 0.1.0 (2021-09-20)

### Features

- Introduce `spirit-design-tokens` package with default branding in Sass ([bb999d1](https://github.com/lmc-eu/spirit-design-system/commit/bb999d1))
