import { TokenGroup, TokenType } from '@supernovaio/sdk-exporters';
import { TokenGroupRemoteModel } from '@supernovaio/sdk-exporters/build/sdk-typescript/src/model/groups/SDKTokenGroup';

export const groupFunctions = {
  addChild(): void {},
  addChildren(): void {},
  setParentGroupId(): void {},
  setPath(): void {},
  setSortOrder(): void {},
  toMutatedObject(): TokenGroup {
    return new TokenGroup({
      id: this.id,
      parentId: this.parentGroupId,
      brandId: this.brandId,
      tokenType: this.tokenType,
      designSystemVersionId: this.designSystemVersionId,
      isRoot: this.isRoot,
      meta: {
        name: this.name,
        description: this.description,
      },
      childrenIds: this.childrenIds,
    });
  },
  toWriteObject(): TokenGroupRemoteModel {
    return {
      id: this.id,
      brandId: this.brandId,
      designSystemVersionId: this.designSystemVersionId,
      isRoot: this.isRoot,
      tokenType: this.tokenType,
      childrenIds: this.childrenIds,
      createdAt: this.createdAt,
      updatedAt: this.updatedAt,
      meta: {
        name: this.name,
        description: this.description,
      },
    };
  },
};

export const exampleGroups: TokenGroup[] = [
  {
    ...groupFunctions,
    id: '1',
    idInVersion: 'idInVersionValue',
    brandId: 'brandIdValue',
    designSystemVersionId: 'designSystemVersionIdValue',
    name: 'spacing',
    description: '',
    isRoot: false,
    tokenType: TokenType.dimension,
    childrenIds: ['dimensionRef'],
    path: ['Grid'],
    tokenIds: ['dimensionRef'],
    subgroupIds: [],
    parentGroupId: 'parent1',
    sortOrder: -1,
    createdAt: null,
    updatedAt: null,
  },
  {
    ...groupFunctions,
    id: '2',
    idInVersion: 'idInVersionValue',
    brandId: 'brandIdValue',
    designSystemVersionId: 'designSystemVersionIdValue',
    name: 'Grid',
    description: '',
    isRoot: false,
    tokenType: TokenType.string,
    childrenIds: ['stringRef'],
    path: [],
    tokenIds: ['stringRef'],
    subgroupIds: [],
    parentGroupId: 'parent2',
    sortOrder: -1,
    createdAt: null,
    updatedAt: null,
  },
  {
    ...groupFunctions,
    id: '3',
    idInVersion: 'idInVersionValue',
    brandId: 'brandIdValue',
    designSystemVersionId: 'designSystemVersionIdValue',
    name: 'Typography',
    description: '',
    isRoot: false,
    tokenType: TokenType.typography,
    childrenIds: ['stringRef'],
    path: [],
    tokenIds: ['stringRef'],
    subgroupIds: [],
    parentGroupId: 'parent3',
    sortOrder: -1,
    createdAt: null,
    updatedAt: null,
  },
  {
    ...groupFunctions,
    id: '4',
    idInVersion: 'idInVersionValue',
    brandId: 'brandIdValue',
    designSystemVersionId: 'designSystemVersionIdValue',
    name: 'primary',
    description: '',
    isRoot: false,
    tokenType: TokenType.color,
    childrenIds: ['actionColorRef'],
    path: ['action', 'button'],
    tokenIds: ['actionColorRef'],
    subgroupIds: [],
    parentGroupId: 'parent1',
    sortOrder: -1,
    createdAt: null,
    updatedAt: null,
  },
  {
    ...groupFunctions,
    id: '5',
    idInVersion: 'idInVersionValue',
    brandId: 'brandIdValue',
    designSystemVersionId: 'designSystemVersionIdValue',
    name: 'background',
    description: '',
    isRoot: false,
    tokenType: TokenType.color,
    childrenIds: ['backgroundColorRef'],
    path: [],
    tokenIds: ['backgroundColorRef'],
    subgroupIds: [],
    parentGroupId: 'parent2',
    sortOrder: -1,
    createdAt: null,
    updatedAt: null,
  },
  {
    ...groupFunctions,
    id: '6',
    idInVersion: 'idInVersionValue',
    brandId: 'brandIdValue',
    designSystemVersionId: 'designSystemVersionIdValue',
    name: 'Heading',
    description: '',
    isRoot: false,
    tokenType: TokenType.typography,
    childrenIds: ['typographyRef1'],
    path: [],
    tokenIds: ['typographyRef1'],
    subgroupIds: [],
    parentGroupId: 'parent1',
    sortOrder: -1,
    createdAt: null,
    updatedAt: null,
  },
  {
    ...groupFunctions,
    id: '7',
    idInVersion: 'idInVersionValue',
    brandId: 'brandIdValue',
    designSystemVersionId: 'designSystemVersionIdValue',
    name: 'Heading',
    description: '',
    isRoot: false,
    tokenType: TokenType.typography,
    childrenIds: ['typographyRef2'],
    path: [],
    tokenIds: ['typographyRef2'],
    subgroupIds: [],
    parentGroupId: 'parent2',
    sortOrder: -1,
    createdAt: null,
    updatedAt: null,
  },
  {
    ...groupFunctions,
    id: '8',
    idInVersion: 'idInVersionValue',
    brandId: 'brandIdValue',
    designSystemVersionId: 'designSystemVersionIdValue',
    name: 'shadow-100',
    description: '',
    isRoot: false,
    tokenType: TokenType.shadow,
    childrenIds: ['shadowRef'],
    path: ['shadow'],
    tokenIds: ['shadowRef'],
    subgroupIds: [],
    parentGroupId: 'parent2',
    sortOrder: -1,
    createdAt: null,
    updatedAt: null,
  },
  {
    ...groupFunctions,
    id: '9',
    idInVersion: 'idInVersionValue',
    brandId: 'brandIdValue',
    designSystemVersionId: 'designSystemVersionIdValue',
    name: 'basic-overlay',
    description: '',
    isRoot: false,
    tokenType: TokenType.gradient,
    childrenIds: ['gradientRef'],
    path: [],
    tokenIds: ['gradientRef'],
    subgroupIds: [],
    parentGroupId: 'parent2',
    sortOrder: -1,
    createdAt: null,
    updatedAt: null,
  },
];
