# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

<a name="2.2.0"></a>

# [2.2.0](https://github.com/lmc-eu/spirit-design-system/compare/@almacareer/spirit-tokens-exporter@2.1.0...@almacareer/spirit-tokens-exporter@2.2.0) (2024-12-16)

### Bug Fixes

- **exporter-tokens:** Use correct casing in collections filter ([031061a](https://github.com/lmc-eu/spirit-design-system/commit/031061a))

### Features

- **exporter-tokens:** Sort typography tokens and remove unused parameters ([44981ec](https://github.com/lmc-eu/spirit-design-system/commit/44981ec))
- **web:** Add minimalistic footer demo [#DS-1574](https://github.com/lmc-eu/spirit-design-system/issues/DS-1574) ([e1751e2](https://github.com/lmc-eu/spirit-design-system/commit/e1751e2))

### Styles

- **exporters, docs, examples:** Fix docs by markdown linter ([1915a9f](https://github.com/lmc-eu/spirit-design-system/commit/1915a9f)), closes [#DS-1100](https://github.com/lmc-eu/spirit-design-system/issues/DS-1100)

**Note:** Version bump only for package @almacareer/spirit-tokens-exporter

<a name="2.1.0"></a>

# [2.1.0](https://github.com/lmc-eu/spirit-design-system/compare/@almacareer/spirit-tokens-exporter@2.0.0...@almacareer/spirit-tokens-exporter@2.1.0) (2024-11-22)

### Bug Fixes

- **exporter-tokens:** Pass all tokens to the `computeTokensByApplyingThemes` so references work ([1abf05c](https://github.com/lmc-eu/spirit-design-system/commit/1abf05c))
- **exporter-tokens:** Use css-variable-prefix token instead of token-prefix ([a4d33bd](https://github.com/lmc-eu/spirit-design-system/commit/a4d33bd))

### Dependencies

- Update @swc/core to 1.9.3 ([11d2829](https://github.com/lmc-eu/spirit-design-system/commit/11d2829))
- Update all non-major dependencies ([188c30d](https://github.com/lmc-eu/spirit-design-system/commit/188c30d))
- Update all non-major dependencies ([da33775](https://github.com/lmc-eu/spirit-design-system/commit/da33775))

### Documentation

- **exporter-tokens:** Document Themes naming rules [#DS-1497](https://github.com/lmc-eu/spirit-design-system/issues/DS-1497) ([ebc0414](https://github.com/lmc-eu/spirit-design-system/commit/ebc0414))

### Features

- **exporter-tokens:** Add `color` prefix to css-variables mixin ([d0c3e8e](https://github.com/lmc-eu/spirit-design-system/commit/d0c3e8e))
- **exporter-tokens:** Add mixin css-variables to theme colors [#DS-1542](https://github.com/lmc-eu/spirit-design-system/issues/DS-1542) ([6b79489](https://github.com/lmc-eu/spirit-design-system/commit/6b79489))
- **exporter-tokens:** Export only Theme tokens collection ([3f224f1](https://github.com/lmc-eu/spirit-design-system/commit/3f224f1)), closes [#DS-1543](https://github.com/lmc-eu/spirit-design-system/issues/DS-1543)
- **exporter-tokens:** Use variable prefix from tokens ([569036e](https://github.com/lmc-eu/spirit-design-system/commit/569036e))

**Note:** Version bump only for package @almacareer/spirit-tokens-exporter

<a name="2.0.0"></a>

# 2.0.0 (2024-10-17)

### BREAKING CHANGES

- **exporter-tokens:** Rename variables-scss exporter to exporter-tokens [#DS-1483](https://github.com/lmc-eu/spirit-design-system/issues/DS-1483) ([e695df8](https://github.com/lmc-eu/spirit-design-system/commit/e695df8))

**Note:** Version bump only for package @almacareer/spirit-tokens-exporter

<a name="1.2.0"></a>

# [1.2.0](https://github.com/lmc-eu/spirit-design-system/compare/@almacareer/spirit-exporters-variables-scss@1.1.0...@almacareer/spirit-exporters-variables-scss@1.2.0) (2024-10-14)

### Bug Fixes

- **spirit-tokens-exporter:** Export in JS barrel file [#DS-1503](https://github.com/lmc-eu/spirit-design-system/issues/DS-1503) ([a983b2a](https://github.com/lmc-eu/spirit-design-system/commit/a983b2a))
- **spirit-tokens-exporter:** Fix SCSS typography font family export ([0b45a68](https://github.com/lmc-eu/spirit-design-system/commit/0b45a68))

### Chores

- **spirit-tokens-exporter:** Enable unit test watch mode ([0553ae8](https://github.com/lmc-eu/spirit-design-system/commit/0553ae8))
- **spirit-tokens-exporter:** Make package private ([466995f](https://github.com/lmc-eu/spirit-design-system/commit/466995f))

### Code Refactoring

- **spirit-tokens-exporter:** Typography generator function use one object ([afe5319](https://github.com/lmc-eu/spirit-design-system/commit/afe5319))

### Dependencies

- Pin dependencies ([82dfcb6](https://github.com/lmc-eu/spirit-design-system/commit/82dfcb6))
- **repo:** Switch from deprecated rollup-plugin-terser to @rollup/plugin-terser ([2050811](https://github.com/lmc-eu/spirit-design-system/commit/2050811))
- Update all non-major dependencies ([529be6a](https://github.com/lmc-eu/spirit-design-system/commit/529be6a))
- Update all non-major dependencies ([97f71bd](https://github.com/lmc-eu/spirit-design-system/commit/97f71bd))

### Features

- **spirit-tokens-exporter:** Add debug option for exporter [#DS-1505](https://github.com/lmc-eu/spirit-design-system/issues/DS-1505) ([8aeab9a](https://github.com/lmc-eu/spirit-design-system/commit/8aeab9a))
- **spirit-tokens-exporter:** Add export for shadows, gradients and typography ([8ff987f](https://github.com/lmc-eu/spirit-design-system/commit/8ff987f))
- **spirit-tokens-exporter:** Add shadow and gradient color variables to the exporter ([460f31a](https://github.com/lmc-eu/spirit-design-system/commit/460f31a))
- **spirit-tokens-exporter:** Export to javascript [#DS-1437](https://github.com/lmc-eu/spirit-design-system/issues/DS-1437) ([0b8c0a6](https://github.com/lmc-eu/spirit-design-system/commit/0b8c0a6))
- **spirit-tokens-exporter:** Formatting color tokens [#DS-1461](https://github.com/lmc-eu/spirit-design-system/issues/DS-1461) ([b1e2061](https://github.com/lmc-eu/spirit-design-system/commit/b1e2061))
- **spirit-tokens-exporter:** Sort barrel files by alphabet ([e8b7bea](https://github.com/lmc-eu/spirit-design-system/commit/e8b7bea))
- **spirit-tokens-exporter:** Support for themes [#DS-1436](https://github.com/lmc-eu/spirit-design-system/issues/DS-1436) ([179aabc](https://github.com/lmc-eu/spirit-design-system/commit/179aabc))

### Styles

- **spirit-tokens-exporter:** Set quotes with better escaping ([d31fc5e](https://github.com/lmc-eu/spirit-design-system/commit/d31fc5e))

**Note:** Version bump only for package @almacareer/spirit-exporters-variables-scss

<a name="1.1.0"></a>

# 1.1.0 (2024-09-09)

### Chores

- **spirit-tokens-exporter:** Rename Vite config to use mts extension becuase of deprecated api ([823b4b2](https://github.com/lmc-eu/spirit-design-system/commit/823b4b2))

### Dependencies

- Pin dependencies ([8cdf0f3](https://github.com/lmc-eu/spirit-design-system/commit/8cdf0f3))
- Update all non-major dependencies ([bca6b32](https://github.com/lmc-eu/spirit-design-system/commit/bca6b32))

### Features

- **exporters:** Introduce variables-scss exporter [#DS-1412](https://github.com/lmc-eu/spirit-design-system/issues/DS-1412) ([09d1edb](https://github.com/lmc-eu/spirit-design-system/commit/09d1edb))
- **exporters:** Variables exporter export new token structure [#DS-1435](https://github.com/lmc-eu/spirit-design-system/issues/DS-1435) ([59f8021](https://github.com/lmc-eu/spirit-design-system/commit/59f8021))

**Note:** Version bump only for package @almacareer/spirit-exporters-variables-scss
