# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

<a name="2.0.8"></a>

## [2.0.8](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@2.0.7...@lmc-eu/spirit-exporters-scss@2.0.8) (2024-12-16)

### Styles

- **exporters, docs, examples:** Fix docs by markdown linter ([1915a9f](https://github.com/lmc-eu/spirit-design-system/commit/1915a9f)), closes [#DS-1100](https://github.com/lmc-eu/spirit-design-system/issues/DS-1100)

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="2.0.7"></a>

## [2.0.7](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@2.0.6...@lmc-eu/spirit-exporters-scss@2.0.7) (2024-11-22)

### Dependencies

- Update @swc/core to 1.9.3 ([11d2829](https://github.com/lmc-eu/spirit-design-system/commit/11d2829))
- Update all non-major dependencies ([188c30d](https://github.com/lmc-eu/spirit-design-system/commit/188c30d))
- Update all non-major dependencies ([da33775](https://github.com/lmc-eu/spirit-design-system/commit/da33775))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="2.0.6"></a>

## [2.0.6](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@2.0.5...@lmc-eu/spirit-exporters-scss@2.0.6) (2024-10-17)

### Dependencies

- Update all non-major dependencies ([949b633](https://github.com/lmc-eu/spirit-design-system/commit/949b633))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="2.0.5"></a>

## [2.0.5](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@2.0.4...@lmc-eu/spirit-exporters-scss@2.0.5) (2024-10-14)

### Dependencies

- Update all non-major dependencies ([529be6a](https://github.com/lmc-eu/spirit-design-system/commit/529be6a))
- Update all non-major dependencies ([97f71bd](https://github.com/lmc-eu/spirit-design-system/commit/97f71bd))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="2.0.4"></a>

## [2.0.4](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@2.0.3...@lmc-eu/spirit-exporters-scss@2.0.4) (2024-09-09)

### Chores

- **exporter-scss:** Rename Vite config to use mts extension becuase of deprecated api ([b8e3bad](https://github.com/lmc-eu/spirit-design-system/commit/b8e3bad))

### Dependencies

- Update all non-major dependencies ([bca6b32](https://github.com/lmc-eu/spirit-design-system/commit/bca6b32))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="2.0.3"></a>

## [2.0.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@2.0.2...@lmc-eu/spirit-exporters-scss@2.0.3) (2024-07-24)

### Bug Fixes

- **exporter-js,exporter-scss:** Refactor color normalization to make it actually work [#DS-1394](https://github.com/lmc-eu/spirit-design-system/issues/DS-1394) ([4388423](https://github.com/lmc-eu/spirit-design-system/commit/4388423))

### Chores

- **exporter-scss:** Rebuild exporter ([639b5ac](https://github.com/lmc-eu/spirit-design-system/commit/639b5ac))

### Dependencies

- Update all non-major dependencies ([cca8e0a](https://github.com/lmc-eu/spirit-design-system/commit/cca8e0a))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="2.0.2"></a>

## [2.0.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@2.0.1...@lmc-eu/spirit-exporters-scss@2.0.2) (2024-06-26)

### Dependencies

- Update all non-major dependencies ([7876fb8](https://github.com/lmc-eu/spirit-design-system/commit/7876fb8))
- Update all non-major dependencies ([2ece372](https://github.com/lmc-eu/spirit-design-system/commit/2ece372))
- Update dependency vite to v5 ([c6d2d93](https://github.com/lmc-eu/spirit-design-system/commit/c6d2d93))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="2.0.1"></a>

## [2.0.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@2.0.0...@lmc-eu/spirit-exporters-scss@2.0.1) (2024-06-12)

### Styles

- Apply import sorting ESLint rule [#DS-1101](https://github.com/lmc-eu/spirit-design-system/issues/DS-1101) ([79fee4d](https://github.com/lmc-eu/spirit-design-system/commit/79fee4d))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="2.0.0"></a>

# [2.0.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.8.1...@lmc-eu/spirit-exporters-scss@2.0.0) (2024-06-10)

### BREAKING CHANGES

- **exporter-scss:** Rename Gradient `--angle` variable to `--gradient-angle` [#DS-1105](https://github.com/lmc-eu/spirit-design-system/issues/DS-1105) ([3076b77](https://github.com/lmc-eu/spirit-design-system/commit/3076b77))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.8.1"></a>

## [1.8.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.8.0...@lmc-eu/spirit-exporters-scss@1.8.1) (2024-05-20)

### Dependencies

- Update all non-major dependencies ([7b34614](https://github.com/lmc-eu/spirit-design-system/commit/7b34614))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.8.0"></a>

# [1.8.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.7.9...@lmc-eu/spirit-exporters-scss@1.8.0) (2024-04-24)

### Chores

- **exporter-scss:** Add missing package dependencies ([a60e4f1](https://github.com/lmc-eu/spirit-design-system/commit/a60e4f1))

### Dependencies

- Update all non-major dependencies ([1a4adb6](https://github.com/lmc-eu/spirit-design-system/commit/1a4adb6))
- Update all non-major dependencies ([10774a2](https://github.com/lmc-eu/spirit-design-system/commit/10774a2))

### Features

- **exporter-scss:** Normalize color string to short hex ([d70573a](https://github.com/lmc-eu/spirit-design-system/commit/d70573a))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.7.9"></a>

## [1.7.9](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.7.8...@lmc-eu/spirit-exporters-scss@1.7.9) (2024-04-11)

### Dependencies

- Update all non-major dependencies ([b971d44](https://github.com/lmc-eu/spirit-design-system/commit/b971d44))

### Documentation

- **repo:** Rebrand to Alma Career ([4a9a28b](https://github.com/lmc-eu/spirit-design-system/commit/4a9a28b))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.7.8"></a>

## [1.7.8](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.7.7...@lmc-eu/spirit-exporters-scss@1.7.8) (2024-01-12)

### Dependencies

- Update all non-major dependencies ([67f8357](https://github.com/lmc-eu/spirit-design-system/commit/67f8357))
- Update all non-major dependencies ([04252f1](https://github.com/lmc-eu/spirit-design-system/commit/04252f1))
- Update dependency typescript to v5 ([0d99d02](https://github.com/lmc-eu/spirit-design-system/commit/0d99d02))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.7.7"></a>

## [1.7.7](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.7.6...@lmc-eu/spirit-exporters-scss@1.7.7) (2023-11-15)

### Dependencies

- Update all non-major dependencies ([828bc68](https://github.com/lmc-eu/spirit-design-system/commit/828bc68))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.7.6"></a>

## [1.7.6](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.7.5...@lmc-eu/spirit-exporters-scss@1.7.6) (2023-11-02)

### Bug Fixes

- **exporter-scss:** Allow negative numbers in unit printer ([9ff78de](https://github.com/lmc-eu/spirit-design-system/commit/9ff78de))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.7.5"></a>

## [1.7.5](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.7.4...@lmc-eu/spirit-exporters-scss@1.7.5) (2023-10-25)

### Bug Fixes

- **exporter-scss:** Fix exporter to make it work again after Supernova token changes [#DS-936](https://github.com/lmc-eu/spirit-design-system/issues/DS-936) ([05865fd](https://github.com/lmc-eu/spirit-design-system/commit/05865fd))

### Dependencies

- Update all non-major dependencies ([e7b6413](https://github.com/lmc-eu/spirit-design-system/commit/e7b6413))
- Update all non-major dependencies ([f8e1a11](https://github.com/lmc-eu/spirit-design-system/commit/f8e1a11))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.7.4"></a>

## [1.7.4](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.7.3...@lmc-eu/spirit-exporters-scss@1.7.4) (2023-09-06)

### Dependencies

- Update all non-major dependencies ([2ed3156](https://github.com/lmc-eu/spirit-design-system/commit/2ed3156))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.7.3"></a>

## [1.7.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.7.2...@lmc-eu/spirit-exporters-scss@1.7.3) (2023-08-23)

### Dependencies

- Update all non-major dependencies ([acba328](https://github.com/lmc-eu/spirit-design-system/commit/acba328))
- Update dependency @testing-library/jest-dom to v6 ([d21b678](https://github.com/lmc-eu/spirit-design-system/commit/d21b678))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.7.2"></a>

## [1.7.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.7.1...@lmc-eu/spirit-exporters-scss@1.7.2) (2023-08-09)

### Dependencies

- Update all non-major dependencies ([19335a3](https://github.com/lmc-eu/spirit-design-system/commit/19335a3))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.7.1"></a>

## [1.7.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.7.0...@lmc-eu/spirit-exporters-scss@1.7.1) (2023-06-28)

### Dependencies

- Update all non-major dependencies ([ba23f3d](https://github.com/lmc-eu/spirit-design-system/commit/ba23f3d))
- Update all non-major dependencies ([c70b276](https://github.com/lmc-eu/spirit-design-system/commit/c70b276))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.7.0"></a>

# [1.7.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.6.0...@lmc-eu/spirit-exporters-scss@1.7.0) (2023-05-18)

### Features

- **exporter-scss:** Improve Gradients, angle variable and unify naming, but leave JDS exception ([c9aadb7](https://github.com/lmc-eu/spirit-design-system/commit/c9aadb7))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.6.0"></a>

# [1.6.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.5.3...@lmc-eu/spirit-exporters-scss@1.6.0) (2023-03-08)

### Features

- **exporter-scss:** Return different font weight for Ebony [#DS-621](https://github.com/lmc-eu/spirit-design-system/issues/DS-621) ([d575050](https://github.com/lmc-eu/spirit-design-system/commit/d575050))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.5.3"></a>

## [1.5.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.5.2...@lmc-eu/spirit-exporters-scss@1.5.3) (2023-02-17)

### Chores

- **exporter-scss:** Rebuild generated functions with updated Vite ([cda8802](https://github.com/lmc-eu/spirit-design-system/commit/cda8802))

### Dependencies

- Update all non-major dependencies ([fa43a3a](https://github.com/lmc-eu/spirit-design-system/commit/fa43a3a))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.5.2"></a>

## [1.5.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.5.1...@lmc-eu/spirit-exporters-scss@1.5.2) (2023-02-13)

### Dependencies

- Update dependency vite to v4 ([7fa207c](https://github.com/lmc-eu/spirit-design-system/commit/7fa207c))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.5.1"></a>

## [1.5.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.5.0...@lmc-eu/spirit-exporters-scss@1.5.1) (2023-02-09)

### Dependencies

- Update all non-major dependencies ([190529b](https://github.com/lmc-eu/spirit-design-system/commit/190529b))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.5.0"></a>

# [1.5.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.4.0...@lmc-eu/spirit-exporters-scss@1.5.0) (2022-11-09)

### Features

- **exporter-scss:** Sort radii tokens by number in name ([ac391db](https://github.com/lmc-eu/spirit-design-system/commit/ac391db))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.4.0"></a>

# [1.4.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.3.0...@lmc-eu/spirit-exporters-scss@1.4.0) (2022-11-07)

### Dependencies

- Update all non-major dependencies ([48cac89](https://github.com/lmc-eu/spirit-design-system/commit/48cac89))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.3.0"></a>

# [1.3.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.2.0...@lmc-eu/spirit-exporters-scss@1.3.0) (2022-10-13)

### Bug Fixes

- **exporter-scss:** Fix generator when no line-height set and fix token properties API [#DS-407](https://github.com/lmc-eu/spirit-design-system/issues/DS-407) ([5768d40](https://github.com/lmc-eu/spirit-design-system/commit/5768d40))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.2.0"></a>

# [1.2.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-exporters-scss@1.1.0...@lmc-eu/spirit-exporters-scss@1.2.0) (2022-09-22)

### Features

- **exporter-scss:** Implement Unit less property and fix style property ([862788a](https://github.com/lmc-eu/spirit-design-system/commit/862788a))

### Styles

- **repo:** Reformat all changelogs using Prettier ([a2850cd](https://github.com/lmc-eu/spirit-design-system/commit/a2850cd))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss

<a name="1.1.0"></a>

# 1.1.0 (2022-09-15)

### Bug Fixes

- **exporter-scss:** Do not add properties when value is zero (refs ([0df83c6](https://github.com/lmc-eu/spirit-design-system/commit/0df83c6))
- **exporter-scss:** Fix font-family quotes ([5a16e8a](https://github.com/lmc-eu/spirit-design-system/commit/5a16e8a))
- **exporter-scss:** Tokens sorting ([dac802b](https://github.com/lmc-eu/spirit-design-system/commit/dac802b))
- **exporter-scss:** Typography optional parameters indentation ([c4506d3](https://github.com/lmc-eu/spirit-design-system/commit/c4506d3))
- **exporter-scss:** Typography trailling comma ([1c545e6](https://github.com/lmc-eu/spirit-design-system/commit/1c545e6))

### Code Refactoring

- **exporter-scss:** Add missing types (refs [#DS-295](https://github.com/lmc-eu/spirit-design-system/issues/DS-295)) ([a2ff018](https://github.com/lmc-eu/spirit-design-system/commit/a2ff018))
- **exporter-scss:** Breakpoint sorting with applied locale sort ([11d6adc](https://github.com/lmc-eu/spirit-design-system/commit/11d6adc)), closes [#DS-295](https://github.com/lmc-eu/spirit-design-system/issues/DS-295)
- **exporter-scss:** Build exporter functions using Vite and ESM ([f4c177e](https://github.com/lmc-eu/spirit-design-system/commit/f4c177e)), closes [#DS-295](https://github.com/lmc-eu/spirit-design-system/issues/DS-295)
- **exporter-scss:** Migrate codebase to Typescript (refs [#DS-295](https://github.com/lmc-eu/spirit-design-system/issues/DS-295)) ([426b3c8](https://github.com/lmc-eu/spirit-design-system/commit/426b3c8))

### Dependencies

- Pin dependencies ([81716ee](https://github.com/lmc-eu/spirit-design-system/commit/81716ee))

### Documentation

- **exporter-scss:** Introduce contribution documentation (refs [#DS-295](https://github.com/lmc-eu/spirit-design-system/issues/DS-295)) ([b860b1d](https://github.com/lmc-eu/spirit-design-system/commit/b860b1d))

### Features

- **exporter-scss:** Change order sorting and fix types grouping if single word name ([3e6795f](https://github.com/lmc-eu/spirit-design-system/commit/3e6795f))
- **exporter-scss:** Change shadows exporting and fix gradient naming ([f1b8354](https://github.com/lmc-eu/spirit-design-system/commit/f1b8354))
- **exporter-scss:** Change typography generation, based on breakpoints ([17781a4](https://github.com/lmc-eu/spirit-design-system/commit/17781a4))
- **exporter-scss:** Do not generate link typography tokens ([5b2ab20](https://github.com/lmc-eu/spirit-design-system/commit/5b2ab20))
- **exporter-scss:** Improve breakpoints sorting ([66ddb47](https://github.com/lmc-eu/spirit-design-system/commit/66ddb47))
- **exporter-scss:** Initial commit 🚀 ([eae509b](https://github.com/lmc-eu/spirit-design-system/commit/eae509b))
- **exporter-scss:** Print special typo conditionally ([74cdb44](https://github.com/lmc-eu/spirit-design-system/commit/74cdb44))
- **exporter-scss:** Update exporter-scss info ([a145519](https://github.com/lmc-eu/spirit-design-system/commit/a145519))

### Styles

- **exporter-scss:** Introduce ESLint config and reformat codebase ([a022e71](https://github.com/lmc-eu/spirit-design-system/commit/a022e71)), closes [#DS-295](https://github.com/lmc-eu/spirit-design-system/issues/DS-295)
- **exporter-scss:** Refactoring due to ES lint rules (refs [#DS-301](https://github.com/lmc-eu/spirit-design-system/issues/DS-301)) ([98a19c0](https://github.com/lmc-eu/spirit-design-system/commit/98a19c0))
- **exporter-scss:** Reformat code style using Prettier ([a7eca3b](https://github.com/lmc-eu/spirit-design-system/commit/a7eca3b))

### Tests

- **exporter-scss:** Introduce Jest tests (refs [#DS-295](https://github.com/lmc-eu/spirit-design-system/issues/DS-295)) ([0480c15](https://github.com/lmc-eu/spirit-design-system/commit/0480c15))

**Note:** Version bump only for package @lmc-eu/spirit-exporters-scss
