# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

<a name="1.1.0"></a>

# [1.1.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@1.0.0...@lmc-eu/spirit-demo-app@1.1.0) (2024-12-16)

### Chores

- **demo:** Hide elements in Supernova component preview ([f496c5a](https://github.com/lmc-eu/spirit-design-system/commit/f496c5a))
- **demo:** Hide elements in Supernova component preview - change allowed URLs [#DS-1577](https://github.com/lmc-eu/spirit-design-system/issues/DS-1577) ([cf62ead](https://github.com/lmc-eu/spirit-design-system/commit/cf62ead))
- Introduce New Favicon ([da38dbe](https://github.com/lmc-eu/spirit-design-system/commit/da38dbe))

### Documentation

- **web-react:** Move Container into DocsSection using `container` enum prop ([bddb842](https://github.com/lmc-eu/spirit-design-system/commit/bddb842))
- **web:** Move Container into Section in all components ([96e3bae](https://github.com/lmc-eu/spirit-design-system/commit/96e3bae))

### Features

- **web:** Introduce `Card` component [#DS-1397](https://github.com/lmc-eu/spirit-design-system/issues/DS-1397) ([ae879d0](https://github.com/lmc-eu/spirit-design-system/commit/ae879d0))

**Note:** Version bump only for package @lmc-eu/spirit-demo-app

<a name="1.0.0"></a>

# [1.0.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@1.0.0-alpha.1...@lmc-eu/spirit-demo-app@1.0.0) (2024-11-25)

Miscellaneous changes

**Note:** Version bump only for package @lmc-eu/spirit-demo-app

<a name="1.0.0-alpha.1"></a>

# [1.0.0-alpha.1](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@1.0.0-alpha.0...@lmc-eu/spirit-demo-app@1.0.0-alpha.1) (2024-11-06)

### Features

- **web:** Remove `spirit-` prefix from themes ([29ededb](https://github.com/lmc-eu/spirit-design-system/commit/29ededb))

**Note:** Version bump only for package @lmc-eu/spirit-demo-app

<a name="1.0.0-alpha.0"></a>

# [1.0.0-alpha.0](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@0.0.8...@lmc-eu/spirit-demo-app@1.0.0-alpha.0) (2024-10-17)

### BREAKING CHANGES

- **web:** Switch `Header` component to v3 design tokens [#DS-1453](https://github.com/lmc-eu/spirit-design-system/issues/DS-1453) ([840c28a](https://github.com/lmc-eu/spirit-design-system/commit/840c28a))

### Documentation

- **form-validations,web,web-react:** Add theme switcher to the demo app [#DS-1479](https://github.com/lmc-eu/spirit-design-system/issues/DS-1479) ([02381f2](https://github.com/lmc-eu/spirit-design-system/commit/02381f2))
- **form-validations,web,web-react:** Redesign the demo app [#DS-1479](https://github.com/lmc-eu/spirit-design-system/issues/DS-1479) ([2a2e309](https://github.com/lmc-eu/spirit-design-system/commit/2a2e309))
- Set default background color to main element in demos ([ed4d322](https://github.com/lmc-eu/spirit-design-system/commit/ed4d322))
- **web-twig:** Redesign the demo app [#DS-1479](https://github.com/lmc-eu/spirit-design-system/issues/DS-1479) ([18f7fe0](https://github.com/lmc-eu/spirit-design-system/commit/18f7fe0))

### Features

- **web:** Switch Demo styles to v3 design tokens structure [#DS-1430](https://github.com/lmc-eu/spirit-design-system/issues/DS-1430) ([8f27889](https://github.com/lmc-eu/spirit-design-system/commit/8f27889))

### Tests

- **web,web-react:** Update visual snapshots after demo apps redesign [#DS-1479](https://github.com/lmc-eu/spirit-design-system/issues/DS-1479) ([b9b23e5](https://github.com/lmc-eu/spirit-design-system/commit/b9b23e5))

<a name="0.0.9"></a>

## [0.0.9](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@0.0.8...@lmc-eu/spirit-demo-app@0.0.9) (2024-11-22)

### Chores

- Disable SASS deprecation warnings [#DS-1514](https://github.com/lmc-eu/spirit-design-system/issues/DS-1514) ([d691cc5](https://github.com/lmc-eu/spirit-design-system/commit/d691cc5))

### Code Refactoring

- **demo:** Use server settings directly from the common package ([c980fa0](https://github.com/lmc-eu/spirit-design-system/commit/c980fa0))

### Dependencies

- Update all non-major dependencies ([188c30d](https://github.com/lmc-eu/spirit-design-system/commit/188c30d))
- Update all non-major dependencies ([da33775](https://github.com/lmc-eu/spirit-design-system/commit/da33775))
- **web, web-react, web-twig:** Implement sass-embedded library ([07df504](https://github.com/lmc-eu/spirit-design-system/commit/07df504))

**Note:** Version bump only for package @lmc-eu/spirit-demo-app

<a name="0.0.8"></a>

## [0.0.8](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@0.0.7...@lmc-eu/spirit-demo-app@0.0.8) (2024-10-17)

### Dependencies

- Update all non-major dependencies ([949b633](https://github.com/lmc-eu/spirit-design-system/commit/949b633))
- Update dependency @rollup/plugin-typescript to v12 ([fb46f50](https://github.com/lmc-eu/spirit-design-system/commit/fb46f50))

**Note:** Version bump only for package @lmc-eu/spirit-demo-app

<a name="0.0.7"></a>

## [0.0.7](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@0.0.6...@lmc-eu/spirit-demo-app@0.0.7) (2024-10-14)

### Dependencies

- Pin dependencies ([8570d79](https://github.com/lmc-eu/spirit-design-system/commit/8570d79))
- **repo:** Add missing required dependencies by other packages ([2ae9e26](https://github.com/lmc-eu/spirit-design-system/commit/2ae9e26))
- **repo:** Switch from deprecated rollup-plugin-terser to @rollup/plugin-terser ([2050811](https://github.com/lmc-eu/spirit-design-system/commit/2050811))
- Update all non-major dependencies ([97f71bd](https://github.com/lmc-eu/spirit-design-system/commit/97f71bd))
- Update all non-major dependencies ([ec96d80](https://github.com/lmc-eu/spirit-design-system/commit/ec96d80))
- Update all non-major dependencies ([bca6b32](https://github.com/lmc-eu/spirit-design-system/commit/bca6b32))

### Styles

- **demo:** Apply TOML formatting rules ([d0fde3a](https://github.com/lmc-eu/spirit-design-system/commit/d0fde3a))

**Note:** Version bump only for package @lmc-eu/spirit-demo-app

<a name="0.0.6"></a>

## [0.0.6](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@0.0.5...@lmc-eu/spirit-demo-app@0.0.6) (2024-07-24)

### Code Refactoring

- **demo:** Switch from `docs-Section` to `UNSTABLE_Section` component ([44cfab9](https://github.com/lmc-eu/spirit-design-system/commit/44cfab9))

### Dependencies

- Update all non-major dependencies ([cca8e0a](https://github.com/lmc-eu/spirit-design-system/commit/cca8e0a))

**Note:** Version bump only for package @lmc-eu/spirit-demo-app

<a name="0.0.5"></a>

## [0.0.5](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@0.0.4...@lmc-eu/spirit-demo-app@0.0.5) (2024-06-26)

### Chores

- **demo:** Set demo app to be ESM only ([f5175e1](https://github.com/lmc-eu/spirit-design-system/commit/f5175e1))

### Dependencies

- Update all non-major dependencies ([7876fb8](https://github.com/lmc-eu/spirit-design-system/commit/7876fb8))
- Update all non-major dependencies ([2ece372](https://github.com/lmc-eu/spirit-design-system/commit/2ece372))
- Update dependency npm-run-all2 to v6 ([1553070](https://github.com/lmc-eu/spirit-design-system/commit/1553070))
- Update dependency rollup to v4 ([c611d09](https://github.com/lmc-eu/spirit-design-system/commit/c611d09))
- Update dependency sass-true to v8 ([62b8481](https://github.com/lmc-eu/spirit-design-system/commit/62b8481))
- Update dependency vite to v5 ([c6d2d93](https://github.com/lmc-eu/spirit-design-system/commit/c6d2d93))
- Update dependency vite-plugin-handlebars to v2 ([8a315b2](https://github.com/lmc-eu/spirit-design-system/commit/8a315b2))

**Note:** Version bump only for package @lmc-eu/spirit-demo-app

<a name="0.0.4"></a>

## [0.0.4](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@0.0.3...@lmc-eu/spirit-demo-app@0.0.4) (2024-06-03)

### Dependencies

- Update all non-major dependencies ([d0625a8](https://github.com/lmc-eu/spirit-design-system/commit/d0625a8))

**Note:** Version bump only for package @lmc-eu/spirit-demo-app

<a name="0.0.3"></a>

## [0.0.3](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@0.0.2...@lmc-eu/spirit-demo-app@0.0.3) (2024-05-20)

### Chores

- **repo:** Fix title package name check ([041e561](https://github.com/lmc-eu/spirit-design-system/commit/041e561))

### Code Refactoring

- **demo:** Introduce default layouts for `web` and `web-react` ([33fb119](https://github.com/lmc-eu/spirit-design-system/commit/33fb119))
- **demo:** Introduce form-validations package and pass title to header ([e752151](https://github.com/lmc-eu/spirit-design-system/commit/e752151))
- **demo:** Introduce new partials structure ([0ca834a](https://github.com/lmc-eu/spirit-design-system/commit/0ca834a))
- **demo:** Make configurable base layout ([61fcdb8](https://github.com/lmc-eu/spirit-design-system/commit/61fcdb8))
- **demo:** Make header template configurable ([9470044](https://github.com/lmc-eu/spirit-design-system/commit/9470044))
- **demo:** Make plain layout configurable ([714509b](https://github.com/lmc-eu/spirit-design-system/commit/714509b))
- **demo:** Make tabs part of the layout ([7391c4d](https://github.com/lmc-eu/spirit-design-system/commit/7391c4d))
- **demo:** Normalize templates for tile and box display ([db53baf](https://github.com/lmc-eu/spirit-design-system/commit/db53baf))
- **demo:** Normalize usage of the space at the of the template tags ([33ba6cf](https://github.com/lmc-eu/spirit-design-system/commit/33ba6cf))
- **demo:** Remove package partials from app configuration ([1ef3892](https://github.com/lmc-eu/spirit-design-system/commit/1ef3892))

### Dependencies

- Update all non-major dependencies ([7b34614](https://github.com/lmc-eu/spirit-design-system/commit/7b34614))

**Note:** Version bump only for package @lmc-eu/spirit-demo-app

<a name="0.0.2"></a>

## [0.0.2](https://github.com/lmc-eu/spirit-design-system/compare/@lmc-eu/spirit-demo-app@0.0.1...@lmc-eu/spirit-demo-app@0.0.2) (2024-04-24)

### Chores

- **demo:** Correctly resolve alias to the icons in demos ([68af8fb](https://github.com/lmc-eu/spirit-design-system/commit/68af8fb))

### Code Refactoring

- **ci:** Yarn no longer supports `pre*` and `post*` scripts ([44b8f1c](https://github.com/lmc-eu/spirit-design-system/commit/44b8f1c))

### Dependencies

- **repo:** Switch from `npm-run-all` to `npm-run-all2` fork ([b857115](https://github.com/lmc-eu/spirit-design-system/commit/b857115))
- Update all non-major dependencies ([1a4adb6](https://github.com/lmc-eu/spirit-design-system/commit/1a4adb6))
- Update all non-major dependencies ([10774a2](https://github.com/lmc-eu/spirit-design-system/commit/10774a2))

**Note:** Version bump only for package @lmc-eu/spirit-demo-app

<a name="0.0.1"></a>

## 0.0.1 (2024-04-11)

### Chores

- **ci:** Deploy preview also for GitHub workflows changes ([10e9282](https://github.com/lmc-eu/spirit-design-system/commit/10e9282))
- **demo:** Fix the name of the package based on the directory ([8c65e25](https://github.com/lmc-eu/spirit-design-system/commit/8c65e25))
- **demo:** Ignore deploy preview when there is no change in `src` ([2c624a3](https://github.com/lmc-eu/spirit-design-system/commit/2c624a3))
- **repo:** Introduce simplified Demo app for web and web-react packages ([273564c](https://github.com/lmc-eu/spirit-design-system/commit/273564c))
- **repo:** Set `apps/demo` workspace in the `package.json` ([e5d42cd](https://github.com/lmc-eu/spirit-design-system/commit/e5d42cd))

### Dependencies

- Pin dependency npm-run-all to 4.1.5 ([04d0fb1](https://github.com/lmc-eu/spirit-design-system/commit/04d0fb1))

### Documentation

- **repo:** Deploy Docs app to Netlify ([23d0455](https://github.com/lmc-eu/spirit-design-system/commit/23d0455))

**Note:** Version bump only for package @lmc-eu/spirit-demo-app
