<p align="center">
    <img src="docs/logo/dark.webp" width="400px" alt="EmbedJs Logo">
</p>

<p align="center">
    <a href="https://www.npmjs.com/package/@llm-tools/embedjs"  target="_blank"><img alt="License" src="https://img.shields.io/npm/l/%40llm-tools%2Fembedjs?style=for-the-badge"></a>
    <a href="https://www.npmjs.com/package/@llm-tools/embedjs"  target="_blank"><img alt="NPM Version" src="https://img.shields.io/npm/v/%40llm-tools/embedjs?style=for-the-badge"></a>
</p>

<hr />

## What is EmbedJs?

EmbedJs is an Open Source Framework for personalizing LLM responses. An ultimate toolkit for building powerful Retrieval-Augmented Generation (RAG) and Large Language Model (LLM) applications with ease in Node.js.

It segments data into manageable chunks, generates relevant embeddings, and stores them in a vector database for optimized retrieval. It enables users to extract contextual information, find precise answers, or engage in interactive chat conversations, all tailored to their own data.

## 📖 Documentation

Comprehensive guides and API documentation are available to help you get the most out of EmbedJs:

-   [Introduction](https://llm-tools.mintlify.app/get-started/introduction#what-is-embedjs)
-   [Getting Started](https://llm-tools.mintlify.app/get-started/quickstart)
-   [Supported data types](https://llm-tools.mintlify.app/components/data-sources/overview)
-   [Examples](https://llm-tools.mintlify.app/examples)

## 🌐 Contributing

Contributions are welcome! Please check out the issues on the repository, and feel free to open a pull request.
For more information, please see the [contributing guidelines](CONTRIBUTING.md).

<a href="https://github.com/llm-tools/embedjs/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=llm-tools/embedJs" />
</a>
