# 基础语法 - 条件查询 - 模糊查询

## 教程

模糊查询是一种特殊的条件查询，它允许我们根据模式匹配来查找符合特定条件的数据，可以使用 LIKE 关键字实现模糊查询。

在 LIKE 模糊查询中，我们使用通配符来代表零个或多个字符，从而能够快速地找到匹配的数据。

有如下 2 种通配符：
- 百分号（%）：表示任意长度的任意字符序列。
- 下划线（_）：表示任意单个字符。

模糊查询的应用场景：假设你是一名侦探，你需要根据目标人物的一部分线索信息来找到匹配的目标，比如你可以根据目标的名字中包含的关键字或字符来查找。



## 示例

假设有一张名为`employees`的数据表，它存储了员工信息，包括员工姓名（name）、年龄（age）、职位（position）等：

数据表`employees`：

|   name   | age | position       |
|----------|-----|----------------|
|   张三   |  25 | 软件工程师     |
|   李四   |  30 | 数据分析师     |
|   王五   |  28 | 产品经理       |
|   小明   |  22 | 软件测试工程师 |



现在，我们使用 LIKE 模糊查询来找出姓名（name）中包含关键字 "张" 的员工信息：

```sql
-- SQL查询语句
select name, age, position from employees where name like '%张%';
```



查询结果：

|   name   | age | position       |
|----------|-----|----------------|
|   张三   |  25 | 软件工程师     |



还可以使用模糊查询匹配开头和结尾：

```sql
-- 只查询以 "张" 开头的数据行
select name, age, position from employees where name like '张%';

-- 只查询以 "张" 结尾的数据行
select name, age, position from employees where name like '%张';
```



同理，可以使用 `not like` 来查询不包含某关键字的信息。 



## 题目

请编写一条 SQL 查询语句，从名为 `student` 的数据表中选择出所有学生的姓名（name）和成绩（score），要求姓名（name）不包含 "李" 这个字。
