# 基础语法 - 条件查询 - where

## 教程

在前面的教程中，我们每次都是对整个表的所有数据行进行查询。但有的时候，我们只想取表中的部分数据，怎么办呢？

这时，我们就可以使用条件查询语法。通过条件查询，你可以从数据库中筛选出 **满足特定条件** 的数据行，而不是返回表中的所有数据。

主要使用 where 子句在查询中设置过滤条件，只有满足这些条件的数据行才会被返回。

where 子句的语法如下：

```sql
SELECT 列1, 列2, ...
FROM 表名
WHERE 条件;
```

其中，`列1, 列2, ...`是你要选择的列，可以是具体的列名，也可以是`*`表示选择所有列。`表名`是你要从中查询数据的表名。`条件`是指定的查询条件，可以使用比较运算符（如`=`、`<`、`>`等）、逻辑运算符（如`AND`、`OR`等）、IN 操作符、LIKE 操作符等来设置条件。



## 示例

让我们来看一个具体的SQL代码和结果示例，假设有一张名为`products`的数据表，它存储了产品信息，包括产品名称（name）、单价（price）、库存（stock）等：

数据表`products`：

|   name   | price | stock |
|----------|-------|-------|
|   A      | 10.00 |   50  |
|   B      | 20.00 |   30  |
|   C      | 15.00 |   20  |
|   D      | 25.00 |   10  |

现在，我们使用 "WHERE" 来筛选出库存小于等于 20 的产品：

```sql
-- SQL查询语句
select name, price, stock from products where stock <= 20;
```



查询结果：

|   name   | price | stock |
|----------|-------|-------|
|   C      | 15.00 |   20  |
|   D      | 25.00 |   10  |



通过上述 SQL 查询语句，我们筛选出了库存小于等于 20 的产品，从而得到了符合条件的产品信息。



## 题目

请编写一条 SQL 查询语句，从名为`student` 的数据表中选择出所有学生的姓名（name）和成绩（score），要求学生姓名为 '鱼皮'。

