# 基础语法 - 查询 - 常量和运算

## 教程

"常量和运算" 是 SQL 中用于对数据进行计算和处理的重要概念。在 SQL 查询中，常量指的是固定的数值或文本（比如 "1"），而运算则是对这些常量进行数学运算或字符串操作。

通过常量和运算，我们可以在查询语句中对数据进行加减乘除、取平均值、连接文本等操作，从而得到我们想要的查询结果。



## 示例

让我们来看一个具体的 SQL 代码和结果示例，假设有一张名为 `orders` 的数据表，它存储了订单信息，包括订单编号（order_id）、商品单价（unit_price）、购买数量（quantity）等：

数据表`orders`：

|  order_id  | unit_price | quantity |
|------------|------------|----------|
|   1001     |   10.00    |   5      |
|   1002     |   20.00    |   3      |
|   1003     |   15.00    |   2      |
|   1004     |   25.00    |   4      |



现在，我们需要计算每个订单的总金额（total_amount），即商品单价（unit_price）乘以购买数量（quantity）。

SQL 查询语句如下：

```sql
select order_id, unit_price, quantity, unit_price * quantity as total_amount from orders;
```



查询结果如下，其中 total_amount 是计算出来的新列：

|  order_id  | unit_price | quantity | total_amount |
|------------|------------|----------|--------------|
|   1001     |   10.00    |   5      |   50.00      |
|   1002     |   20.00    |   3      |   60.00      |
|   1003     |   15.00    |   2      |   30.00      |
|   1004     |   25.00    |   4      |   100.00     |



此外，SQL 可以直接把常量作为列名，比如执行下列 SQL 语句：

```sql
select 200, '篮球' as hobby;
```



查询结果如下：

| 200  | hobby |
| :--- | :---- |
| 200  | 篮球  |



## 题目
请编写一条 SQL 查询语句，从名为`student`的数据表中选择出所有学生的姓名（name）和分数（score），并且额外计算出分数的 2 倍（double_score）。

