# 基础语法 - 查询 - 别名

## 教程

别名是为数据表的列或查询结果中的字段取一个临时的、可读性更高的名字，使得查询结果更加直观和易读。

让我们用一个形象的比喻来理解 "别名"：假设你是一名团队领导，你的团队有很多成员，每个成员都有自己的名字。为了更好地管理团队，你决定给每个成员都取一个昵称，让团队的交流更加便捷。这个昵称就是 "别名"。它并不改变成员的真实信息，只是提供了一个便于团队内部交流的称呼。

在 SQL 查询中，我们可以使用别名语法 `{原始字段名} as {别名}` 来为查询结果的列名取一个便于理解的名称。通过使用别名，我们可以更直观地知道查询结果中每一列的含义，方便阅读和使用。



## 示例

假设有一张名为 `employees` 的数据表，它存储了团队成员的信息，包括姓名（name）、年龄（age）、职位（position）等：

数据表 `employees`：

|   name   | age | position      |
|----------|-----|---------------|
|   John   | 30  | Project Manager|
|   Alice  | 28  | Software Engineer|
|   Bob    | 32  | Product Designer|
|   Kate   | 26  | Marketing Specialist|

现在，我们使用 "别名" 来获取所有团队成员的姓名（name）和职位（position）信息，并为它们取别名为 `员工姓名` 和 `职位名称`：

```sql
-- SQL查询语句
select name as 员工姓名, position as 职位名称 from employees;
```

> 上述代码中的 as 也可以省略，比如 `name 员工姓名` 也是 ok 的。



查询结果，注意表格头的列名从英文变为了中文：

|   员工姓名   | 职位名称            |
|---------------|-------------------|
|   John        | Project Manager    |
|   Alice       | Software Engineer  |
|   Bob         | Product Designer   |
|   Kate        | Marketing Specialist |



通过上述 SQL 查询语句，我们得到了团队成员名单表中所有成员的姓名和职位信息，并通过别名让查询结果更加易读和直观。



## 题目

请编写一条 SQL 查询语句，从名为 `student` 的数据表中选择出所有学生的姓名（name）和年龄（age）信息，并为它们取别名为 `学生姓名` 和 `学生年龄`。

