# 函数 - 时间函数

## 教程
在 SQL 中，时间函数是用于处理日期和时间的特殊函数。它们允许我们在查询中操作和处理日期、时间、日期时间数据，从而使得在数据库中进行时间相关的操作变得更加方便和灵活。

常用的时间函数有：

- DATE：获取当前日期
- DATETIME：获取当前日期时间
- TIME：获取当前时间



## 示例
假设有一个订单表 `orders`，包含以下字段：`order_id`（订单号）、`order_date`（下单日期）、`order_time`（下单时间）。数据如下：

| order_id | order_date  | order_time |
|---------|-------------|------------|
| 1       | 2023-08-01  | 12:30:45   |
| 2       | 2023-08-01  | 14:20:10   |
| 3       | 2023-08-02  | 09:15:00   |
| 4       | 2023-08-02  | 18:05:30   |



使用时间函数获取当前日期、当前日期时间和当前时间：

```sql
-- 获取当前日期
SELECT DATE() AS current_date;

-- 获取当前日期时间
SELECT DATETIME() AS current_datetime;

-- 获取当前时间
SELECT TIME() AS current_time;
```



查询结果：

> 为了方便对比，放到同一个表格

| current_date | current_datetime       | current_time |
|--------------|------------------------|--------------|
| 2023-08-01   | 2023-08-01 14:30:00    | 14:30:00     |



> 注意，这里的日期、日期时间和时间将根据当前的系统时间来生成，实际运行结果可能会因为当前时间而不同。



还有很多时间函数，比如计算两个日期的相差天数、获取当前日期对应的毫秒数等，实际运用时自行查阅即可，此处不做赘述。



## 题目

假设有一个学生表 `student`，包含以下字段：`name`（姓名）、`age`（年龄）。

请你编写一个 SQL 查询，展示所有学生的姓名（name）和当前日期（列名为 "当前日期"）。
