# 基础语法 - 条件分支

## 教程

条件分支 `case when` 是 SQL 中用于根据条件进行分支处理的语法。它类似于其他编程语言中的 if else 条件判断语句，允许我们根据不同的条件选择不同的结果返回。

使用 `case when` 可以在查询结果中根据特定的条件动态生成新的列或对现有的列进行转换。

举个例子：假设你是一位餐厅的服务员，客人点了不同的菜品，而你需要根据客人点的菜来确定服务的方式。如果客人点了鱼，你会用餐具和服务方式适合吃鱼的方式来招待他们；如果客人点了牛排，你会用适合牛排的餐具和服务方式。`case when` 就像你根据客人点的菜品来选择不同服务方式的过程。



## 示例
假设有一个学生表 `student`，包含以下字段：`name`（姓名）、`age`（年龄）。数据如下：

| name  | age |
|-------|-----|
| 小明  | 18  |
| 鸡哥  | 25  |
| 李华  | 30  |
| 王五  | 40  |



使用条件分支 `case when` ，根据 name 来判断学生是否会说 RAP，并起别名为 can_rap。

示例 SQL 如下：

```sql
SELECT
  name,
  CASE WHEN (name = '鸡哥') THEN '会' ELSE '不会' END AS can_rap
FROM
  student;
```



查询结果：

| name  | can_rap |
|-------|---------|
| 小明  | 不会    |
| 鸡哥  | 会      |
| 李华  | 不会    |
| 王五  | 不会    |



`case when` 支持同时指定多个分支，示例语法如下：

```sql
CASE WHEN (条件1) THEN 结果1
	   WHEN (条件2) THEN 结果2
	   ...
	   ELSE 其他结果 END
```



## 题目

假设有一个学生表 `student`，包含以下字段：`name`（姓名）、`age`（年龄）。请你编写一个 SQL 查询，将学生按照年龄划分为三个年龄等级（age_level）：60 岁以上为 "老同学"，20 岁以上（不包括 60 岁以上）为 "年轻"，20 岁及以下、以及没有年龄信息为 "小同学"。

返回结果应包含学生的姓名（name）和年龄等级（age_level），并按姓名升序排序。
